/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.Math;
import smile.math.kernel.MercerKernel;

public class HyperbolicTangentKernel
implements MercerKernel<double[]> {
    private static final long serialVersionUID = 1L;
    private double scale;
    private double offset;

    public HyperbolicTangentKernel() {
        this(1.0, 0.0);
    }

    public HyperbolicTangentKernel(double scale, double offset) {
        this.scale = scale;
        this.offset = offset;
    }

    public String toString() {
        return String.format("Hyperbolic Tangent Kernel (scale = %.4f, offset = %.4f)", this.scale, this.offset);
    }

    @Override
    public double k(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        double dot = Math.dot(x, y);
        return Math.tanh(this.scale * dot + this.offset);
    }
}

