/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.selection.statistic;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.OptionElement;
import com.google.gwt.dom.client.SelectElement;
import com.google.gwt.text.shared.AbstractRenderer;
import com.google.gwt.text.shared.Renderer;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.ValueListBox;
import com.sap.sse.datamining.ui.client.selection.statistic.AggregatorGroup;
import com.sap.sse.datamining.ui.client.selection.statistic.ExtractionFunctionWithContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class AggregatorListBox
extends ValueListBox<AggregatorGroup> {
    private static final String UnsupportedItemStyle = "unsupportedAggregatorListItem";
    private final Map<String, AggregatorGroup> aggregatorsByDisplayName = new HashMap<String, AggregatorGroup>();
    private AggregatorGroup value;
    private ValueChangeHandler valueChangeHandler;

    public AggregatorListBox(final String nullDisplayString) {
        super((Renderer)new AbstractRenderer<AggregatorGroup>(){

            public String render(AggregatorGroup aggregator) {
                return aggregator == null ? nullDisplayString : aggregator.getDisplayName();
            }
        });
        this.addValueChangeHandler(event -> {
            AggregatorGroup newValue = (AggregatorGroup)event.getValue();
            if (!Objects.equals(this.value, newValue)) {
                AggregatorGroup oldValue = this.value;
                this.value = newValue;
                if (this.valueChangeHandler != null) {
                    this.valueChangeHandler.valueChanged(oldValue, this.value);
                }
            }
        });
    }

    public void setValueChangeHandler(ValueChangeHandler valueChangeHandler) {
        this.valueChangeHandler = valueChangeHandler;
    }

    public void updateItemStyles(ExtractionFunctionWithContext extractionFunction) {
        ListBox listBox = (ListBox)this.getWidget();
        SelectElement selectElement = SelectElement.as((Element)listBox.getElement());
        NodeList options = selectElement.getOptions();
        int i = 0;
        while (i < options.getLength()) {
            OptionElement option = (OptionElement)options.getItem(i);
            AggregatorGroup aggregator = this.aggregatorsByDisplayName.get(option.getText());
            String className = aggregator == null || extractionFunction == null || aggregator.supportsFunction(extractionFunction) ? "" : UnsupportedItemStyle;
            option.setClassName(className);
            ++i;
        }
    }

    public void setAcceptableValues(Collection<AggregatorGroup> newValues) {
        ArrayList<AggregatorGroup> newValuesWithNull = new ArrayList<AggregatorGroup>();
        newValuesWithNull.add(null);
        this.aggregatorsByDisplayName.clear();
        for (AggregatorGroup aggregator : newValues) {
            if (aggregator == null) continue;
            this.aggregatorsByDisplayName.put(aggregator.getDisplayName(), aggregator);
            newValuesWithNull.add(aggregator);
        }
        super.setAcceptableValues(newValuesWithNull);
    }

    @FunctionalInterface
    public static interface ValueChangeHandler {
        public void valueChanged(AggregatorGroup var1, AggregatorGroup var2);
    }
}

