/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.presentation;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.settings.AbstractSettings;
import com.sap.sse.datamining.shared.impl.dto.DataRetrieverLevelDTO;
import com.sap.sse.datamining.shared.impl.dto.FunctionDTO;
import com.sap.sse.datamining.ui.client.FilterSelectionPresenter;
import com.sap.sse.datamining.ui.client.FilterSelectionProvider;
import com.sap.sse.datamining.ui.client.StringMessages;
import com.sap.sse.gwt.client.shared.components.AbstractComponent;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class PlainFilterSelectionPresenter
extends AbstractComponent<AbstractSettings>
implements FilterSelectionPresenter {
    private final FilterSelectionProvider filterSelectionProvider;
    private final HorizontalPanel mainPanel;
    private final VerticalPanel presentationPanel;

    public PlainFilterSelectionPresenter(Component<?> parent, ComponentContext<?> context, StringMessages stringMessages, FilterSelectionProvider filterSelectionProvider) {
        super(parent, context);
        this.filterSelectionProvider = filterSelectionProvider;
        this.filterSelectionProvider.addSelectionChangedListener(this);
        Label currentSelectionLabel = new Label(stringMessages.currentFilterSelection());
        currentSelectionLabel.setWidth("75px");
        currentSelectionLabel.addStyleName("emphasizedLabel");
        this.presentationPanel = new VerticalPanel();
        this.mainPanel = new HorizontalPanel();
        this.mainPanel.setStyleName("filterSelectionPresenter");
        this.mainPanel.add((Widget)currentSelectionLabel);
        this.mainPanel.add((Widget)this.presentationPanel);
    }

    @Override
    public void selectionChanged() {
        this.presentationPanel.clear();
        HashMap<DataRetrieverLevelDTO, HashMap<FunctionDTO, HashSet<? extends Serializable>>> selection = this.filterSelectionProvider.getSelection();
        ArrayList sortedLevels = new ArrayList(selection.keySet());
        Collections.sort(sortedLevels);
        for (DataRetrieverLevelDTO retrieverLevel : sortedLevels) {
            Map levelSelection = (Map)selection.get(retrieverLevel);
            RetrieverLevelFilterSelectionPresenter levelSelectionPresenter = new RetrieverLevelFilterSelectionPresenter(retrieverLevel, levelSelection);
            levelSelectionPresenter.getEntryWidget().addStyleName("dataMiningMarginBottom");
            this.presentationPanel.add(levelSelectionPresenter.getEntryWidget());
        }
    }

    public String getLocalizedShortName() {
        return this.getClass().getSimpleName();
    }

    public Widget getEntryWidget() {
        return this.mainPanel;
    }

    public boolean isVisible() {
        return this.mainPanel.isVisible();
    }

    public void setVisible(boolean visibility) {
        this.mainPanel.setVisible(visibility);
    }

    public String getDependentCssClassName() {
        return "filterSelectionPresenter";
    }

    public boolean hasSettings() {
        return false;
    }

    public SettingsDialogComponent<AbstractSettings> getSettingsDialogComponent(AbstractSettings settings) {
        return null;
    }

    public void updateSettings(AbstractSettings newSettings) {
    }

    public AbstractSettings getSettings() {
        return null;
    }

    public String getId() {
        return "PlainFilterSelectionPresenter";
    }

    private class DimensionFilterSelectionPresenter {
        private final HorizontalPanel mainPanel = new HorizontalPanel();

        public DimensionFilterSelectionPresenter(FunctionDTO dimension, Collection<? extends Serializable> dimensionSelection) {
            Label dimensionLabel = new Label(String.valueOf(dimension.getDisplayName()) + ":");
            dimensionLabel.addStyleName("dimensionLabel");
            this.mainPanel.add((Widget)dimensionLabel);
            StringBuilder selectionStringBuilder = new StringBuilder();
            boolean first = true;
            for (Serializable serializable : dimensionSelection) {
                if (!first) {
                    selectionStringBuilder.append(", ");
                }
                selectionStringBuilder.append(serializable.toString());
                first = false;
            }
            this.mainPanel.add((Widget)new Label(selectionStringBuilder.toString()));
        }

        public Widget getEntryWidget() {
            return this.mainPanel;
        }
    }

    private class RetrieverLevelFilterSelectionPresenter {
        private final HorizontalPanel mainPanel;

        public RetrieverLevelFilterSelectionPresenter(DataRetrieverLevelDTO retrieverLevel, Map<FunctionDTO, HashSet<? extends Serializable>> levelSelection) {
            Label levelLabel = new Label(retrieverLevel.getRetrievedDataType().getDisplayName());
            levelLabel.setWidth("100px");
            levelLabel.addStyleName("emphasizedLabel");
            VerticalPanel presentationPanel = new VerticalPanel();
            ArrayList<FunctionDTO> sortedDimensions = new ArrayList<FunctionDTO>(levelSelection.keySet());
            Collections.sort(sortedDimensions);
            boolean first = true;
            for (FunctionDTO dimension : sortedDimensions) {
                Collection dimensionSelection = levelSelection.get(dimension);
                DimensionFilterSelectionPresenter dimensionSelectionPresenter = new DimensionFilterSelectionPresenter(dimension, dimensionSelection);
                if (!first) {
                    dimensionSelectionPresenter.getEntryWidget().getElement().getStyle().setMarginTop(2.0, Style.Unit.PX);
                }
                presentationPanel.add(dimensionSelectionPresenter.getEntryWidget());
                first = false;
            }
            this.mainPanel = new HorizontalPanel();
            this.mainPanel.add((Widget)levelLabel);
            this.mainPanel.add((Widget)presentationPanel);
        }

        public Widget getEntryWidget() {
            return this.mainPanel;
        }
    }
}

