/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.developer;

import com.google.gwt.safehtml.shared.OnlyToBeUsedInGeneratedCodeStringBlessedAsSafeHtml;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.AggregationProcessorDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.ClusterDTO;
import com.sap.sse.datamining.shared.impl.dto.DataRetrieverChainDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.DataRetrieverLevelDTO;
import com.sap.sse.datamining.shared.impl.dto.FunctionDTO;
import com.sap.sse.datamining.shared.impl.dto.LocalizedTypeDTO;
import com.sap.sse.datamining.shared.impl.dto.ModifiableStatisticQueryDefinitionDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class QueryDefinitionParser {
    private static final String NullComponentText = "None selected";
    private static final String NullComponentCode = "UNDEFINED";
    private static final String HTML_LINE_BREAK = "<br />";
    private static final String HTML_TAB = "&emsp;";
    private static final String TEXT_LINE_BREAK = "\n";
    private static final String TEXT_TAB = "\t";

    public SafeHtml parseToDetailsAsSafeHtml(StatisticQueryDefinitionDTO queryDefinition) {
        String safeHtml = this.parseToDetails(queryDefinition, new HtmlBuilder());
        return new OnlyToBeUsedInGeneratedCodeStringBlessedAsSafeHtml(safeHtml);
    }

    public String parseToDetailsAsText(StatisticQueryDefinitionDTO queryDefinition) {
        return this.parseToDetails(queryDefinition, new TextBuilder());
    }

    private String parseToDetails(StatisticQueryDefinitionDTO queryDefinition, Builder builder) {
        HashMap filterSelection;
        if (queryDefinition == null) {
            return "";
        }
        builder.appendText("Locale: " + queryDefinition.getLocaleInfoName()).appendLineBreak().appendLineBreak();
        DataRetrieverChainDefinitionDTO chainDefinition = queryDefinition.getDataRetrieverChainDefinition();
        builder.appendText("Retrieval: ");
        if (chainDefinition != null) {
            builder.appendText(chainDefinition.toString()).appendLineBreak().appendTab(1).appendText("Levels: ").appendLineBreak();
            int levelIndex = 0;
            while (levelIndex < chainDefinition.getLevelAmount()) {
                builder.appendTab(2).appendText(String.valueOf(levelIndex) + ": " + chainDefinition.getRetrieverLevel(levelIndex)).appendLineBreak();
                ++levelIndex;
            }
        } else {
            builder.appendText(NullComponentText).appendLineBreak();
        }
        builder.appendLineBreak();
        HashMap retrieverSettings = queryDefinition.getRetrieverSettings();
        if (retrieverSettings != null) {
            retrieverSettings.isEmpty();
        }
        if ((filterSelection = queryDefinition.getFilterSelection()) != null && !filterSelection.isEmpty()) {
            builder.appendText("Filter Selection:").appendLineBreak();
            ArrayList retrieverLevels = new ArrayList(filterSelection.keySet());
            Collections.sort(retrieverLevels);
            for (DataRetrieverLevelDTO retrieveLevel : retrieverLevels) {
                builder.appendTab(1).appendText("Level " + retrieveLevel.getLevel() + ": ").appendLineBreak();
                HashMap levelFilterSelection = (HashMap)filterSelection.get(retrieveLevel);
                for (FunctionDTO dimension : levelFilterSelection.keySet()) {
                    builder.appendTab(2).appendText(dimension.toString()).appendLineBreak().appendTab(3).appendText("Values: ");
                    boolean first = true;
                    for (Serializable value : (HashSet)levelFilterSelection.get(dimension)) {
                        if (!first) {
                            builder.appendText(", ");
                        }
                        builder.appendText(value.toString());
                        first = false;
                    }
                    builder.appendLineBreak();
                }
            }
            builder.appendLineBreak();
        }
        ArrayList dimensionsToGroupBy = queryDefinition.getDimensionsToGroupBy();
        builder.appendText("Group By: ");
        if (dimensionsToGroupBy != null && !dimensionsToGroupBy.isEmpty()) {
            builder.appendLineBreak();
            int index = 0;
            while (index < dimensionsToGroupBy.size()) {
                builder.appendTab(1).appendText(String.valueOf(index) + ": " + dimensionsToGroupBy.get(index)).appendLineBreak();
                ++index;
            }
        } else {
            builder.appendText(NullComponentText).appendLineBreak();
        }
        builder.appendLineBreak();
        FunctionDTO statistic = queryDefinition.getStatisticToCalculate();
        builder.appendText("Statistic: " + (statistic == null ? NullComponentText : statistic)).appendLineBreak();
        AggregationProcessorDefinitionDTO aggregator = queryDefinition.getAggregatorDefinition();
        builder.appendText("Aggregator: " + (aggregator == null ? NullComponentText : aggregator));
        return builder.toString();
    }

    public SafeHtml parseToCodeAsSafeHtml(StatisticQueryDefinitionDTO queryDefinition, TypeToCodeStrategy typeStrategy) {
        String safeHtml = this.parseToCode(queryDefinition, typeStrategy, new HtmlBuilder());
        return new OnlyToBeUsedInGeneratedCodeStringBlessedAsSafeHtml(safeHtml);
    }

    public String parseToCodeAsText(StatisticQueryDefinitionDTO queryDefinition, TypeToCodeStrategy typeStrategy) {
        return this.parseToCode(queryDefinition, typeStrategy, new TextBuilder());
    }

    private String parseToCode(StatisticQueryDefinitionDTO queryDefinition, TypeToCodeStrategy typeStrategy, Builder builder) {
        ArrayList dimensionsToGroupBy;
        if (queryDefinition == null) {
            return "";
        }
        String functionClassName = FunctionDTO.class.getSimpleName();
        String aggregatorClassName = AggregationProcessorDefinitionDTO.class.getSimpleName();
        String retrieverLevelClassName = DataRetrieverLevelDTO.class.getSimpleName();
        String arrayListClassName = ArrayList.class.getSimpleName();
        String localizedTypeClassName = LocalizedTypeDTO.class.getSimpleName();
        String retrieverChainClassName = DataRetrieverChainDefinitionDTO.class.getSimpleName();
        String queryDefinitionClassName = ModifiableStatisticQueryDefinitionDTO.class.getSimpleName();
        String hashMapClassName = HashMap.class.getSimpleName();
        String hashSetClassName = HashSet.class.getSimpleName();
        String serializableClassName = Serializable.class.getSimpleName();
        String statisticVariable = "statistic";
        builder.appendText(this.functionToCode(statisticVariable, queryDefinition.getStatisticToCalculate(), typeStrategy));
        builder.appendLineBreak();
        String aggregatorVariable = "aggregator";
        AggregationProcessorDefinitionDTO aggregator = queryDefinition.getAggregatorDefinition();
        builder.appendText(String.valueOf(aggregatorClassName) + " " + aggregatorVariable + " = ");
        if (aggregator != null) {
            builder.appendText("new " + aggregatorClassName + "(" + QueryDefinitionParser.literal(aggregator.getMessageKey()) + ", " + typeStrategy.toCode(aggregator.getExtractedTypeName()) + ", " + typeStrategy.toCode(aggregator.getAggregatedTypeName()) + ", \"\")");
        } else {
            builder.appendText(NullComponentCode);
        }
        builder.appendText(";").appendLineBreak().appendLineBreak();
        DataRetrieverChainDefinitionDTO retrieverChain = queryDefinition.getDataRetrieverChainDefinition();
        String retrieverChainVariable = "retrieverChain";
        if (retrieverChain != null) {
            String retrieverLevelsVariable = "retrieverLevels";
            builder.appendText(String.valueOf(arrayListClassName) + "<" + retrieverLevelClassName + "> " + retrieverLevelsVariable + " = new " + arrayListClassName + "<>();").appendLineBreak();
            for (DataRetrieverLevelDTO retrieverLevel : retrieverChain.getRetrieverLevels()) {
                LocalizedTypeDTO retrievedType = retrieverLevel.getRetrievedDataType();
                String retrievedTypeAsCode = "new " + localizedTypeClassName + "(" + typeStrategy.toCode(retrievedType.getTypeName()) + ", \"\")";
                String retrieverSettingsAsCode = "null";
                builder.appendText(String.valueOf(retrieverLevelsVariable) + ".add(new " + retrieverLevelClassName + "(" + retrieverLevel.getLevel() + ", " + typeStrategy.toCode(retrieverLevel.getRetrieverTypeName()) + ", " + retrievedTypeAsCode + ", " + retrieverSettingsAsCode + "));").appendLineBreak();
            }
            builder.appendText(String.valueOf(retrieverChainClassName) + " " + retrieverChainVariable + " = new " + retrieverChainClassName + "(\"\", " + typeStrategy.toCode(retrieverChain.getDataSourceTypeName()) + ", " + retrieverLevelsVariable + ");");
        } else {
            builder.appendText(String.valueOf(retrieverChainClassName) + " " + retrieverChainVariable + " = " + NullComponentCode + ";");
        }
        builder.appendLineBreak().appendLineBreak();
        String queryDefinitionVariable = "queryDefinition";
        builder.appendText(String.valueOf(queryDefinitionClassName) + " " + queryDefinitionVariable + " = new " + queryDefinitionClassName + "(" + QueryDefinitionParser.literal(queryDefinition.getLocaleInfoName()) + ", " + statisticVariable + ", " + aggregatorVariable + ", " + retrieverChainVariable + ");").appendLineBreak().appendLineBreak();
        HashMap filterSelection = queryDefinition.getFilterSelection();
        if (filterSelection != null && retrieverChain != null) {
            for (DataRetrieverLevelDTO retrieverLevel : retrieverChain.getRetrieverLevels()) {
                HashMap levelFilterSelection = (HashMap)filterSelection.get(retrieverLevel);
                if (levelFilterSelection == null || levelFilterSelection.isEmpty()) continue;
                String levelFilterSelectionVariable = "retrieverlevel" + retrieverLevel.getLevel() + "_FilterSelection";
                builder.appendText(String.valueOf(hashMapClassName) + "<" + functionClassName + ", " + hashSetClassName + "<? extends " + serializableClassName + ">> " + levelFilterSelectionVariable + " = new " + hashMapClassName + "<>();").appendLineBreak();
                int filterDimensionCounter = 0;
                for (FunctionDTO filterDimension : levelFilterSelection.keySet()) {
                    String filterDimensionVariable = "filterDimension" + filterDimensionCounter;
                    builder.appendText(this.functionToCode(filterDimensionVariable, filterDimension, typeStrategy)).appendLineBreak();
                    String dimensionFilterSelectionVariable = String.valueOf(filterDimensionVariable) + "_Selection";
                    builder.appendText(String.valueOf(hashSetClassName) + "<" + serializableClassName + "> " + dimensionFilterSelectionVariable + " = new " + hashSetClassName + "<>();").appendLineBreak();
                    for (Serializable filterValue : (HashSet)levelFilterSelection.get(filterDimension)) {
                        builder.appendText(String.valueOf(dimensionFilterSelectionVariable) + ".add(" + QueryDefinitionParser.literal(filterValue) + ");").appendLineBreak();
                    }
                    builder.appendText(String.valueOf(levelFilterSelectionVariable) + ".put(" + filterDimensionVariable + ", " + dimensionFilterSelectionVariable + ");").appendLineBreak();
                    ++filterDimensionCounter;
                }
                builder.appendText(String.valueOf(queryDefinitionVariable) + ".setFilterSelectionFor(" + retrieverChainVariable + ".getRetrieverLevel(" + retrieverLevel.getLevel() + "), " + levelFilterSelectionVariable + ");").appendLineBreak().appendLineBreak();
            }
        }
        if ((dimensionsToGroupBy = queryDefinition.getDimensionsToGroupBy()) != null) {
            int dimensionToGroupByCounter = 0;
            boolean first = true;
            for (FunctionDTO dimensionToGroupBy : dimensionsToGroupBy) {
                if (!first) {
                    builder.appendLineBreak().appendLineBreak();
                }
                String dimensionToGroupByVariable = "dimensionToGroupBy" + dimensionToGroupByCounter;
                builder.appendText(this.functionToCode(dimensionToGroupByVariable, dimensionToGroupBy, typeStrategy)).appendLineBreak();
                builder.appendText(String.valueOf(queryDefinitionVariable) + ".appendDimensionToGroupBy(" + dimensionToGroupByVariable + ");");
                first = false;
                ++dimensionToGroupByCounter;
            }
        }
        return builder.toString();
    }

    private String functionToCode(String functionVariable, FunctionDTO function, TypeToCodeStrategy typeStrategy) {
        String functionClassName = FunctionDTO.class.getSimpleName();
        String functionConstruction = function != null ? "new " + functionClassName + "(" + function.isDimension() + ", " + QueryDefinitionParser.literal(function.getFunctionName()) + ", " + typeStrategy.toCode(function.getSourceTypeName()) + ", " + typeStrategy.toCode(function.getReturnTypeName()) + ", " + this.functionParametersToCode(function, typeStrategy) + ", \"\", 0)" : NullComponentCode;
        return String.valueOf(functionClassName) + " " + functionVariable + " = " + functionConstruction + ";";
    }

    private String functionParametersToCode(FunctionDTO function, TypeToCodeStrategy typeStrategy) {
        List parameterTypeNames = function.getParameterTypeNames();
        if (parameterTypeNames.isEmpty()) {
            return "new " + ArrayList.class.getSimpleName() + "<" + String.class.getSimpleName() + ">()";
        }
        StringBuilder builder = new StringBuilder(String.valueOf(Arrays.class.getSimpleName()) + ".asList(");
        boolean first = true;
        for (String parameterTypeName : parameterTypeNames) {
            if (!first) {
                builder.append(", ");
            }
            builder.append(typeStrategy.toCode(parameterTypeName));
            first = false;
        }
        builder.append(")");
        return builder.toString();
    }

    private static String literal(Serializable value) {
        if (value instanceof String) {
            return QueryDefinitionParser.literal((String)((Object)value));
        }
        if (value instanceof Integer) {
            return value.toString();
        }
        if (value instanceof Enum) {
            return String.valueOf(value.getClass().getName()) + ".valueOf(\"" + ((Enum)((Object)value)).name() + "\")";
        }
        if (value instanceof ClusterDTO) {
            ClusterDTO cluster = (ClusterDTO)value;
            StringBuilder builder = new StringBuilder();
            builder.append("new ").append(ClusterDTO.class.getSimpleName()).append("(").append("\"").append(cluster.getSignifier()).append("\"").append(", ").append("\"").append(cluster.getLocalizedName()).append("\"").append(")");
            return builder.toString();
        }
        throw new IllegalArgumentException("Can't create literal for values of type " + value.getClass().getName());
    }

    private static String literal(String value) {
        return "\"" + value + "\"";
    }

    private static String TAB(String tabCharacter, int tabAmount) {
        StringBuilder tabBuilder = new StringBuilder();
        int i = 0;
        while (i < tabAmount) {
            tabBuilder.append(tabCharacter);
            ++i;
        }
        return tabBuilder.toString();
    }

    private static interface Builder {
        public Builder appendText(String var1);

        public Builder appendLineBreak();

        public Builder appendTab(int var1);

        public String toString();
    }

    private class HtmlBuilder
    implements Builder {
        private final SafeHtmlBuilder builder = new SafeHtmlBuilder();

        @Override
        public Builder appendText(String text) {
            this.builder.appendEscaped(text);
            return this;
        }

        @Override
        public Builder appendLineBreak() {
            this.builder.appendHtmlConstant(QueryDefinitionParser.HTML_LINE_BREAK);
            return this;
        }

        @Override
        public Builder appendTab(int tabAmount) {
            this.builder.appendHtmlConstant(QueryDefinitionParser.TAB(QueryDefinitionParser.HTML_TAB, tabAmount));
            return this;
        }

        @Override
        public String toString() {
            return this.builder.toSafeHtml().asString();
        }
    }

    private class TextBuilder
    implements Builder {
        private final StringBuilder builder = new StringBuilder();

        @Override
        public Builder appendText(String text) {
            this.builder.append(text);
            return this;
        }

        @Override
        public Builder appendLineBreak() {
            this.builder.append(QueryDefinitionParser.TEXT_LINE_BREAK);
            return this;
        }

        @Override
        public Builder appendTab(int tabAmount) {
            this.builder.append(QueryDefinitionParser.TAB(QueryDefinitionParser.TEXT_TAB, tabAmount));
            return this;
        }

        @Override
        public String toString() {
            return this.builder.toString();
        }
    }

    public static enum TypeToCodeStrategy {
        CLASS_GET_NAME{

            @Override
            public String toCode(String fullQualifiedTypeName) {
                String[] splittedTypeName = fullQualifiedTypeName.split("[.]");
                String typeName = splittedTypeName[splittedTypeName.length - 1];
                return String.valueOf(typeName) + ".class.getName()";
            }
        }
        ,
        STRING_LITERALS{

            @Override
            public String toCode(String fullQualifiedTypeName) {
                return QueryDefinitionParser.literal(fullQualifiedTypeName);
            }
        };


        public abstract String toCode(String var1);
    }
}

