/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.datamining.ui.client.AbstractDataMiningComponent;
import com.sap.sse.datamining.ui.client.DataMiningSettingsControl;
import com.sap.sse.gwt.client.StringMessages;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.ComponentResources;
import com.sap.sse.gwt.client.shared.components.CompositeSettings;
import com.sap.sse.gwt.client.shared.components.CompositeTabbedSettingsDialogComponent;
import com.sap.sse.gwt.client.shared.components.SettingsDialog;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class AnchorDataMiningSettingsControl
extends AbstractDataMiningComponent<CompositeSettings>
implements DataMiningSettingsControl {
    public static final ComponentResources resources = (ComponentResources)GWT.create(ComponentResources.class);
    private final Collection<Component<?>> components = new LinkedHashSet();
    private final Anchor anchor = new Anchor(AbstractImagePrototype.create((ImageResource)resources.darkSettingsIcon()).getSafeHtml());

    public AnchorDataMiningSettingsControl(Component<?> parent, ComponentContext<?> context) {
        super(parent, context);
        this.anchor.addStyleName("settingsAnchor");
        this.anchor.setTitle(this.getDataMiningStringMessages().dataMiningSettings());
        this.anchor.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                new SettingsDialog((Component)AnchorDataMiningSettingsControl.this, (StringMessages)AnchorDataMiningSettingsControl.this.getDataMiningStringMessages()).show();
            }
        });
    }

    @Override
    public void addSettingsComponent(Component<?> component) {
        this.components.add(component);
    }

    @Override
    public void removeSettingsComponent(Component<?> component) {
        this.components.remove(component);
    }

    public String getLocalizedShortName() {
        return this.getDataMiningStringMessages().dataMiningSettings();
    }

    public Widget getEntryWidget() {
        return this.anchor;
    }

    public boolean isVisible() {
        return this.anchor.isVisible();
    }

    public void setVisible(boolean visibility) {
        this.anchor.setVisible(visibility);
    }

    public boolean hasSettings() {
        for (Component<?> component : this.components) {
            if (!component.hasSettings()) continue;
            return true;
        }
        return false;
    }

    public SettingsDialogComponent<CompositeSettings> getSettingsDialogComponent(CompositeSettings settings) {
        return new CompositeTabbedSettingsDialogComponent(this.components);
    }

    public void updateSettings(CompositeSettings newSettings) {
        for (Map.Entry componentAndSettings : newSettings.getSettingsPerComponentId().entrySet()) {
            this.updateSettings(componentAndSettings);
        }
    }

    public CompositeSettings getSettings() {
        HashMap<String, Settings> settings = new HashMap<String, Settings>();
        for (Component<?> component : this.components) {
            settings.put(component.getId(), component.hasSettings() ? component.getSettings() : null);
        }
        return new CompositeSettings(settings);
    }

    private <S extends Settings> void updateSettings(Map.Entry<String, S> componentIdAndSettings) {
        Component<?> component = this.findComponentById(componentIdAndSettings.getKey());
        if (component != null) {
            Settings settings = (Settings)componentIdAndSettings.getValue();
            component.updateSettings(settings);
        }
    }

    private Component<?> findComponentById(String componentId) {
        for (Component<?> component : this.components) {
            if (!component.getId().equals(componentId)) continue;
            return component;
        }
        return null;
    }

    public String getDependentCssClassName() {
        return "AnchorDataMiningSettingsControl";
    }

    public String getId() {
        return "AnchorDataMiningSettingsControl";
    }
}

