/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.trackfiles.impl;

import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.trackfiles.TrackFilesFormat;
import com.sap.sailing.domain.trackimport.FormatNotSupportedException;
import com.sap.sailing.domain.tracking.Track;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.server.trackfiles.impl.AbstractDataRetriever;
import com.sap.sailing.server.trackfiles.impl.NameReader;
import com.sap.sailing.server.trackfiles.impl.TrackReader;
import com.sap.sailing.server.trackfiles.impl.TrackReaderImpl;
import com.sap.sailing.server.trackfiles.impl.TrackReaderRetriever;
import com.sap.sailing.server.trackfiles.impl.WindToGpxPosition;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import slash.navigation.gpx.GpxRoute;

public class WindDataRetriever
extends AbstractDataRetriever {
    @Override
    public Collection<GpxRoute> getRoutes(TrackFilesFormat format, final TrackedRace race, boolean dataBeforeAfter, boolean rawFixes) throws FormatNotSupportedException, IOException {
        TrackReaderRetriever<WindSource, Wind> retriever = new TrackReaderRetriever<WindSource, Wind>(){

            @Override
            public TrackReader<WindSource, Wind> retrieveTrackReader(WindSource e) {
                return new TrackReaderImpl<WindSource, Wind>((Track<Wind>)race.getOrCreateWindTrack(e));
            }
        };
        HashSet windSources = new HashSet();
        windSources.addAll(race.getWindSources(WindSourceType.EXPEDITION));
        windSources.addAll(race.getWindSources(WindSourceType.RACECOMMITTEE));
        windSources.addAll(race.getWindSources(WindSourceType.WEB));
        windSources.addAll(race.getWindSources(WindSourceType.WINDFINDER));
        windSources.addAll(race.getWindSources(WindSourceType.COMBINED));
        return this.getRoutes(race, dataBeforeAfter, rawFixes, WindToGpxPosition.INSTANCE, windSources, new NameReader<WindSource>(){

            @Override
            public String getName(WindSource s) {
                return s.getTypeAndId();
            }
        }, retriever);
    }
}

