/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.trackfiles.impl;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Nationality;
import com.sap.sailing.domain.common.trackfiles.TrackFilesFormat;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.trackimport.FormatNotSupportedException;
import com.sap.sailing.domain.tracking.Track;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.server.trackfiles.impl.AbstractDataRetriever;
import com.sap.sailing.server.trackfiles.impl.GPSFixMovingToGpxPosition;
import com.sap.sailing.server.trackfiles.impl.NameReader;
import com.sap.sailing.server.trackfiles.impl.TrackReader;
import com.sap.sailing.server.trackfiles.impl.TrackReaderImpl;
import com.sap.sailing.server.trackfiles.impl.TrackReaderRetriever;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import slash.navigation.gpx.GpxRoute;

public class CompetitorDataRetriever
extends AbstractDataRetriever {
    @Override
    public Collection<GpxRoute> getRoutes(TrackFilesFormat format, final TrackedRace race, boolean dataBeforeAfter, boolean rawFixes) throws FormatNotSupportedException, IOException {
        TrackReaderRetriever<Map.Entry<Competitor, Boat>, GPSFixMoving> retriever = new TrackReaderRetriever<Map.Entry<Competitor, Boat>, GPSFixMoving>(){

            @Override
            public TrackReader<Map.Entry<Competitor, Boat>, GPSFixMoving> retrieveTrackReader(Map.Entry<Competitor, Boat> e) {
                return new TrackReaderImpl<Map.Entry<Competitor, Boat>, GPSFixMoving>((Track<GPSFixMoving>)race.getTrack(e.getKey()));
            }
        };
        return this.getRoutes(race, dataBeforeAfter, rawFixes, GPSFixMovingToGpxPosition.INSTANCE, race.getRace().getCompetitorsAndTheirBoats().entrySet(), new NameReader<Map.Entry<Competitor, Boat>>(){

            @Override
            public String getName(Map.Entry<Competitor, Boat> competitorAndBoat) {
                Competitor c = competitorAndBoat.getKey();
                Boat b = competitorAndBoat.getValue();
                Nationality nationality = c.getTeam().getNationality();
                return String.valueOf(c.getName()) + " - " + b.getSailID() + " - " + (nationality == null ? "" : nationality.getThreeLetterIOCAcronym());
            }
        }, retriever);
    }
}

