/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common;

import com.sap.sse.common.Named;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Timed;
import com.sap.sse.common.util.MappingIterable;
import com.sap.sse.common.util.MappingIterator;
import com.sap.sse.common.util.NaturalComparator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Util {
    public static <T> Collection<T> addAll(Iterable<? extends T> what, Collection<T> addTo) {
        if (what != null) {
            for (T t : what) {
                addTo.add(t);
            }
        }
        return addTo;
    }

    public static <T> Collection<T> retainAll(Iterable<? extends T> what, Collection<T> retainIn) {
        if (what == null || retainIn == null) {
            throw new NullPointerException();
        }
        if (what instanceof Collection) {
            retainIn.retainAll((Collection)what);
        } else {
            HashSet set = new HashSet();
            Util.addAll(what, set);
            retainIn.retainAll(set);
        }
        return retainIn;
    }

    public static <K, V> void add(Map<K, Set<V>> map, K k, V v) {
        Set<V> set = map.get(k);
        if (set == null) {
            set = new HashSet<V>();
            map.put(k, set);
        }
        set.add(v);
    }

    public static <T> Collection<T> removeAll(Iterable<T> what, Collection<T> removeFrom) {
        if (what != null) {
            for (T t : what) {
                removeFrom.remove(t);
            }
        }
        return removeFrom;
    }

    public static <T> T[] toArray(Iterable<? extends T> what, T[] arr) {
        ArrayList list = new ArrayList();
        Util.addAll(what, list);
        return list.toArray(arr);
    }

    public static <T> int size(Iterable<T> i) {
        if (i instanceof Collection) {
            return ((Collection)i).size();
        }
        int result = 0;
        Iterator<T> iter = i.iterator();
        while (iter.hasNext()) {
            ++result;
            iter.next();
        }
        return result;
    }

    public static <T> T nextOrNull(Iterator<T> iter) {
        T result = iter.hasNext() ? (T)iter.next() : null;
        return result;
    }

    public static <T> int indexOf(Iterable<? extends T> i, T t) {
        int result;
        if (i instanceof List) {
            List list = (List)i;
            result = list.indexOf(t);
        } else {
            boolean found = false;
            int counter = 0;
            for (T it : i) {
                if (it == null && t == null || it != null && it.equals(t)) {
                    result = counter;
                    found = true;
                    break;
                }
                ++counter;
            }
            result = found ? counter : -1;
        }
        return result;
    }

    public static <T> List<T> subList(Iterable<T> ts, int from, int toExclusive) {
        List<T> result;
        if (from < 0 || from > toExclusive) {
            throw new IndexOutOfBoundsException();
        }
        if (ts instanceof List) {
            result = ((List)ts).subList(from, toExclusive);
        } else {
            result = new LinkedList();
            int i = 0;
            for (T t : ts) {
                if (i >= from && i < toExclusive) {
                    result.add(t);
                }
                if (++i >= toExclusive) break;
            }
            if (i < toExclusive) {
                throw new IndexOutOfBoundsException("to-index " + toExclusive + " greater than collection size " + Util.size(ts));
            }
        }
        return result;
    }

    public static <T> boolean equals(Iterable<? extends T> a, Iterable<? extends T> b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return a == null;
        }
        Iterator<T> aIter = a.iterator();
        Iterator<T> bIter = b.iterator();
        while (aIter.hasNext() && bIter.hasNext()) {
            T bo;
            T ao = aIter.next();
            if (Util.equalsWithNull(ao, bo = bIter.next())) continue;
            return false;
        }
        return !aIter.hasNext() && !bIter.hasNext();
    }

    public static <T> T get(Iterable<T> iterable, int i) {
        if (iterable instanceof List) {
            List l = (List)iterable;
            return (T)l.get(i);
        }
        Iterator<T> iter = iterable.iterator();
        T result = iter.next();
        int j = 0;
        while (j < i) {
            result = iter.next();
            ++j;
        }
        return result;
    }

    public static <T> T first(Iterable<T> iterable) {
        Iterator<T> iter = iterable.iterator();
        T result = iter.hasNext() ? (T)iter.next() : null;
        return result;
    }

    public static <T> T last(Iterable<T> iterable) {
        T result = Util.isEmpty(iterable) ? null : (iterable instanceof SortedSet ? (T)((SortedSet)iterable).last() : (T)Util.get(iterable, Util.size(iterable) - 1));
        return result;
    }

    public static <S, T> Iterable<T> map(Iterable<S> iterable, MappingIterator.MapFunction<S, T> mapper) {
        return new MappingIterable<S, T>(iterable, mapper);
    }

    public static <S, T> ArrayList<T> mapToArrayList(Iterable<S> iterable, MappingIterator.MapFunction<S, T> mapper) {
        ArrayList result = new ArrayList();
        Util.addAll(Util.map(iterable, mapper), result);
        return result;
    }

    public static <T> Iterable<T> filter(Iterable<T> iterable, final UtilPredicate<T> predicate) {
        return () -> new Iterator<T>(iterable){
            private boolean hasNext = true;
            private Iterator<T> iterator;
            private T next;
            {
                this.iterator = iterable.iterator();
                this.next = this.advance();
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            private T advance() {
                while ((this.hasNext = this.iterator.hasNext()) && !predicate.test(this.next = this.iterator.next())) {
                }
                return this.next;
            }

            @Override
            public T next() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                Object result = this.next;
                this.advance();
                return result;
            }
        };
    }

    public static <T> Iterable<T> concat(final Iterable<Iterable<T>> iterables) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return (new Iterator<T>(iterables){
                    final Iterator<Iterable<T>> iterableIter;
                    Iterable<T> iterable;
                    Iterator<T> iter;
                    boolean nextValid;
                    T next;
                    {
                        this.iterableIter = iterable.iterator();
                        this.iterable = null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextValid;
                    }

                    @Override
                    public T next() {
                        Object result = this.next;
                        this.advance();
                        return result;
                    }

                    private Iterator<T> advance() {
                        while ((this.iterable == null || !this.iter.hasNext()) && this.iterableIter.hasNext()) {
                            this.iterable = this.iterableIter.next();
                            if (this.iterable == null) continue;
                            this.iter = this.iterable.iterator();
                        }
                        boolean bl = this.nextValid = this.iter != null && this.iter.hasNext();
                        if (this.nextValid) {
                            this.next = this.iter.next();
                        }
                        return this;
                    }
                }).advance();
            }
        };
    }

    public static <T> boolean contains(Iterable<T> ts, Object t) {
        if (ts == null) {
            return false;
        }
        if (ts instanceof Collection) {
            return ((Collection)ts).contains(t);
        }
        for (T t2 : ts) {
            if (!Util.equalsWithNull(t2, t)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsAny(Iterable<T> ts, Iterable<T> isAnyOfTheseContained) {
        if (isAnyOfTheseContained != null) {
            for (T t : isAnyOfTheseContained) {
                if (!Util.contains(ts, t)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> boolean containsAll(Iterable<T> ts, Iterable<T> what) {
        if (ts == null) {
            return false;
        }
        if (what == null) {
            return true;
        }
        for (T w : what) {
            if (Util.contains(ts, w)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isEmpty(Iterable<T> ts) {
        if (ts instanceof Collection) {
            return ((Collection)ts).isEmpty();
        }
        return !ts.iterator().hasNext();
    }

    public static boolean equalsWithNull(Object o1, Object o2) {
        boolean result = o1 == null ? o2 == null : (o2 == null ? false : o1.equals(o2));
        return result;
    }

    public static boolean equalsWithNull(String s1, String s2, boolean ignoreCase) {
        String s1LC;
        Object object = ignoreCase ? (s1 == null ? null : s1.toLowerCase()) : (s1LC = s1);
        String s2LC = ignoreCase ? (s2 == null ? null : s2.toLowerCase()) : s2;
        return Util.equalsWithNull(s1LC, s2LC);
    }

    public static <T extends Comparable<T>> int compareToWithNull(T o1, T o2, boolean nullIsLess) {
        int result = o1 == null ? (o2 == null ? 0 : (nullIsLess ? -1 : 1)) : (o2 == null ? (nullIsLess ? 1 : -1) : o1.compareTo(o2));
        return result;
    }

    public static <K, V> V get(Map<K, V> map, K key, V defaultVal) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return defaultVal;
    }

    public static <K, V> boolean addToValueSet(Map<K, Set<V>> map, K key, V value) {
        return Util.addToValueSet(map, key, value, HashSet::new);
    }

    public static <K, V, C extends Collection<V>> boolean addToValueSet(Map<K, C> map, K key, V value, ValueCollectionConstructor<V, C> setConstructor) {
        Collection<Object> coll = (Collection)map.get(key);
        if (coll == null) {
            coll = setConstructor.createValueCollection();
            map.put(key, coll);
        }
        return coll.add(value);
    }

    public static <K, V, S extends Set<V>> void removeFromAllValueSets(Map<K, S> map, V value) {
        Iterator<Map.Entry<K, S>> i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<K, S> e = i.next();
            ((Set)e.getValue()).remove(value);
            if (!((Set)e.getValue()).isEmpty()) continue;
            i.remove();
        }
    }

    public static <K, V, S extends Set<V>> boolean removeFromValueSet(Map<K, S> map, K key, V value) {
        boolean removed;
        Set valuesPerKey = (Set)map.get(key);
        if (valuesPerKey != null) {
            removed = valuesPerKey.remove(value);
            if (removed && valuesPerKey.isEmpty()) {
                map.remove(key);
            }
        } else {
            removed = false;
        }
        return removed;
    }

    public static String join(String separator, String ... strings) {
        return Util.joinStrings(separator, Arrays.asList(strings));
    }

    public static String joinStrings(String separator, Iterable<? extends Object> objects) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Object object : objects) {
            if (first) {
                first = false;
            } else {
                result.append(separator);
            }
            result.append(String.valueOf(object));
        }
        return result.toString();
    }

    public static String join(String separator, Iterable<? extends Named> nameds) {
        return Util.join(separator, Util.toArray(nameds, new Named[0]));
    }

    public static String join(String separator, Named ... nameds) {
        String[] strings = new String[nameds.length];
        int i = 0;
        while (i < nameds.length) {
            strings[i] = nameds[i].getName();
            ++i;
        }
        return Util.join(separator, strings);
    }

    public static Iterable<String> splitAlongWhitespaceRespectingDoubleQuotedPhrases(String s) {
        ArrayList<String> result;
        int ESCAPE_CHARACTER = 92;
        if (s == null) {
            result = null;
        } else {
            result = new ArrayList<String>();
            boolean escaped = false;
            StringBuilder phrase = null;
            boolean inQuotedPhrase = false;
            char[] cArray = s.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (escaped) {
                    if (phrase == null) {
                        phrase = new StringBuilder();
                    }
                    phrase.append(c);
                    escaped = false;
                } else if (c == '\\') {
                    escaped = true;
                } else if (c == '\"') {
                    if (inQuotedPhrase) {
                        result.add(phrase.toString());
                        inQuotedPhrase = false;
                        phrase = null;
                    } else {
                        inQuotedPhrase = true;
                        if (phrase != null) {
                            result.add(phrase.toString());
                        }
                        phrase = new StringBuilder();
                    }
                } else if (inQuotedPhrase) {
                    phrase.append(c);
                } else if (new String(new char[]{c}).matches("\\s")) {
                    if (phrase != null) {
                        result.add(phrase.toString());
                        phrase = null;
                    }
                } else {
                    if (phrase == null) {
                        phrase = new StringBuilder();
                    }
                    phrase.append(c);
                }
                ++n2;
            }
            if (escaped) {
                if (phrase == null) {
                    phrase = new StringBuilder();
                }
                phrase.append('\\');
            }
            if (phrase != null) {
                result.add(phrase.toString());
            }
        }
        return result;
    }

    @SafeVarargs
    public static <T> T getFirstNonNull(T ... objects) {
        T[] TArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (t != null) {
                return t;
            }
            ++n2;
        }
        return null;
    }

    public static TimePoint getEarliestOfTimePoints(TimePoint a, TimePoint b) {
        TimePoint result = null;
        result = a != null && b != null ? (a.before(b) ? a : b) : (a != null && b == null ? a : (a == null && b != null ? b : null));
        return result;
    }

    public static TimePoint getLatestOfTimePoints(TimePoint a, TimePoint b) {
        TimePoint result = null;
        result = a != null && b != null ? (a.after(b) ? a : b) : (a != null && b == null ? a : (a == null && b != null ? b : null));
        return result;
    }

    public static boolean isTimePointInRangeOfTimePointsAandB(TimePoint timePoint, TimePoint a, TimePoint b) {
        boolean result = false;
        if (timePoint != null && a != null && b != null) {
            result = timePoint.after(a) && timePoint.before(b);
        }
        return result;
    }

    public static <T> T getDominantObject(Iterable<T> objects) {
        T result = null;
        if (objects != null && objects.iterator().hasNext()) {
            HashMap<T, Integer> countPerObject = new HashMap<T, Integer>();
            int highestCount = 0;
            for (T it : objects) {
                Integer objectCount = (Integer)countPerObject.get(it);
                if (objectCount == null) {
                    objectCount = 0;
                }
                objectCount = objectCount + 1;
                countPerObject.put(it, objectCount);
                if (objectCount <= highestCount) continue;
                highestCount = objectCount;
                result = it;
            }
        }
        return result;
    }

    public static <T> List<T> asList(Iterable<T> iterable) {
        List list;
        if (iterable instanceof List && iterable instanceof Serializable) {
            list = (List)iterable;
        } else {
            list = new ArrayList();
            Util.addAll(iterable, list);
        }
        return list;
    }

    public static <T> Set<T> asNewSet(Iterable<T> iterable) {
        HashSet result = new HashSet();
        Util.addAll(iterable, result);
        return result;
    }

    public static <T> Set<T> asSet(Iterable<T> iterable) {
        Set<T> result = iterable instanceof Set ? (Set<T>)iterable : Util.asNewSet(iterable);
        return result;
    }

    public static <T> List<T> cloneListOrNull(List<T> list) {
        ArrayList<T> result = list == null ? null : new ArrayList<T>(list);
        return result;
    }

    public static <T extends Named> List<T> sortNamedCollection(Collection<T> collection) {
        return Util.sortNamedCollection(collection, true);
    }

    public static <T extends Named> List<T> sortNamedCollection(Collection<T> collection, boolean caseSensitive) {
        ArrayList<T> sortedCollection = new ArrayList<T>(collection);
        Collections.sort(sortedCollection, Util.naturalNamedComparator(caseSensitive));
        return sortedCollection;
    }

    public static <T extends Named> Comparator<T> naturalNamedComparator(final boolean caseSensitive) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return new NaturalComparator(caseSensitive).compare(o1.getName(), o2.getName());
            }
        };
    }

    public static <K, V> Map<K, Iterable<V>> group(Iterable<V> values, Function<V, K> mappingFunction, Supplier<? extends Collection<V>> newCollectionProvider) {
        HashMap<K, Collection<V>> result = new HashMap<K, Collection<V>>();
        for (V value : values) {
            K key = mappingFunction.apply(value);
            Collection<V> groupValues = (Collection<V>)result.get(key);
            if (groupValues == null) {
                groupValues = newCollectionProvider.get();
                result.put(key, groupValues);
            }
            groupValues.add(value);
        }
        return result;
    }

    @SafeVarargs
    public static <T extends Comparable<T>> T min(T ... elements) {
        return (T)((Comparable)Collections.min(Arrays.asList(elements)));
    }

    @SafeVarargs
    public static <T extends Comparable<T>> T max(T ... elements) {
        return (T)((Comparable)Collections.max(Arrays.asList(elements)));
    }

    public static <K, V> Map<K, V> nullToEmptyMap(Map<K, V> map) {
        Map result = map == null ? Collections.emptyMap() : map;
        return result;
    }

    public static String toStringOrNull(Object toStringOrNull) {
        String result = toStringOrNull == null ? null : toStringOrNull.toString();
        return result;
    }

    public static boolean equalStringsWithEmptyIsNull(String o1, String o2) {
        String effectiveO1 = o1 == null || o1.isEmpty() ? null : o1;
        String effectiveO2 = o2 == null || o2.isEmpty() ? null : o2;
        return Util.equalsWithNull(effectiveO1, effectiveO2);
    }

    public static String padPositiveValue(double value, int digitsLeftOfDecimal, int digitsRightOfDecimal, boolean round) {
        double scaledValue;
        assert (value >= 0.0);
        assert (digitsLeftOfDecimal >= 0);
        assert (digitsRightOfDecimal >= 0);
        StringBuilder sb = new StringBuilder();
        double scalePow = Math.pow(10.0, digitsRightOfDecimal);
        double remainder = scaledValue = round ? (double)Math.round(value * scalePow) : value * scalePow;
        if (digitsLeftOfDecimal == 0 && scaledValue >= scalePow) {
            sb.append(Math.round(remainder / scalePow));
            remainder %= scalePow;
        }
        int i = digitsLeftOfDecimal + digitsRightOfDecimal;
        while (i > 0) {
            if (i == digitsRightOfDecimal) {
                sb.append('.');
            }
            double pow = Math.pow(10.0, i - 1);
            sb.append((int)(remainder / pow));
            remainder %= pow;
            --i;
        }
        return sb.toString();
    }

    public static <T> Iterable<T> retainCopy(Iterable<T> toFilter, Iterable<T> toRetain) {
        List<T> returnValue = Util.asList(toFilter);
        returnValue.retainAll(Util.asList(toRetain));
        return returnValue;
    }

    public static <T extends Timed> T latest(Iterable<T> timedObjects) {
        Timed latest = null;
        for (Timed timedObject : timedObjects) {
            if (latest != null && !timedObject.getTimePoint().after(latest.getTimePoint())) continue;
            latest = timedObject;
        }
        return (T)latest;
    }

    public static void sort(double[] keys, double[] ... values) {
        ArrayList<double[]> arrays = new ArrayList<double[]>();
        int i = 0;
        while (i < keys.length) {
            double[] array = new double[values.length + 1];
            array[0] = keys[i];
            int j = 0;
            while (j < values.length) {
                array[j + 1] = values[j][i];
                ++j;
            }
            arrays.add(array);
            ++i;
        }
        Collections.sort(arrays, (a1, a2) -> Double.compare(a1[0], a2[0]));
        int c = 0;
        for (double[] array : arrays) {
            keys[c] = array[0];
            int i2 = 1;
            while (i2 < array.length) {
                values[i2 - 1][c] = array[i2];
                ++i2;
            }
            ++c;
        }
    }

    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static boolean hasLength(String str) {
        boolean result = str == null ? false : !str.isEmpty();
        return result;
    }

    public static <T> boolean setEquals(Iterable<T> a, Iterable<T> b) {
        return Util.asSet(a).equals(Util.asSet(b));
    }

    public static <K, V> MapBuilder<K, V> mapBuilder() {
        return new MapBuilderImpl();
    }

    public static <T> boolean isOnlyAdding(Iterable<T> newSequence, Iterable<T> oldSequence) {
        return Util.isOnlyAdding(newSequence, oldSequence, (a, b) -> Util.equalsWithNull(a, b));
    }

    public static <T> boolean isOnlyAdding(Iterable<T> newSequence, Iterable<T> oldSequence, BiFunction<T, T, Boolean> equivalenceRelation) {
        Iterator<T> nIter = newSequence.iterator();
        Iterator<T> oIter = oldSequence.iterator();
        boolean result = true;
        while (result && oIter.hasNext()) {
            T nextFromOld = oIter.next();
            result = false;
            while (!result && nIter.hasNext()) {
                if (!equivalenceRelation.apply(nIter.next(), nextFromOld).booleanValue()) continue;
                result = true;
            }
        }
        return result;
    }

    public static int getLengthOfLongestCommonSubsequence(String a, String b) {
        int[][] longestCommonSubstringStartingInAAndB = new int[a.length()][];
        int i = 0;
        while (i < a.length()) {
            longestCommonSubstringStartingInAAndB[i] = new int[b.length()];
            int j = 0;
            while (j < b.length()) {
                longestCommonSubstringStartingInAAndB[i][j] = -1;
                ++j;
            }
            ++i;
        }
        return Util.lcs(a, b, a.length(), b.length(), longestCommonSubstringStartingInAAndB);
    }

    private static int lcs(String a, String b, int endOfSubstringInA, int endOfSubstringInB, int[][] longestCommonSubstringStartingInAAndB) {
        int result;
        if (endOfSubstringInA == 0 || endOfSubstringInB == 0) {
            result = 0;
        } else if (longestCommonSubstringStartingInAAndB[endOfSubstringInA - 1][endOfSubstringInB - 1] != -1) {
            result = longestCommonSubstringStartingInAAndB[endOfSubstringInA - 1][endOfSubstringInB - 1];
        } else if (a.charAt(endOfSubstringInA - 1) == b.charAt(endOfSubstringInB - 1)) {
            longestCommonSubstringStartingInAAndB[endOfSubstringInA - 1][endOfSubstringInB - 1] = 1 + Util.lcs(a, b, endOfSubstringInA - 1, endOfSubstringInB - 1, longestCommonSubstringStartingInAAndB);
            result = longestCommonSubstringStartingInAAndB[endOfSubstringInA - 1][endOfSubstringInB - 1];
        } else {
            longestCommonSubstringStartingInAAndB[endOfSubstringInA - 1][endOfSubstringInB - 1] = Math.max(Util.lcs(a, b, endOfSubstringInA, endOfSubstringInB - 1, longestCommonSubstringStartingInAAndB), Util.lcs(a, b, endOfSubstringInA - 1, endOfSubstringInB, longestCommonSubstringStartingInAAndB));
            result = longestCommonSubstringStartingInAAndB[endOfSubstringInA - 1][endOfSubstringInB - 1];
        }
        return result;
    }

    public static int getLengthOfLongestCommonSubstring(String a, String b) {
        Iterable<String> longestCommonSubstrings = Util.getLongestCommonSubstring(a, b);
        return Util.isEmpty(longestCommonSubstrings) ? 0 : longestCommonSubstrings.iterator().next().length();
    }

    public static Iterable<String> getLongestCommonSubstring(String a, String b) {
        int[][] l = new int[a.length()][];
        int i = 0;
        while (i < a.length()) {
            l[i] = new int[b.length()];
            ++i;
        }
        int z = 0;
        HashSet<String> result = new HashSet<String>();
        String bestResultSoFar = null;
        int i2 = 0;
        while (i2 < a.length()) {
            int j = 0;
            while (j < b.length()) {
                if (a.charAt(i2) == b.charAt(j)) {
                    l[i2][j] = i2 == 0 || j == 0 ? 1 : l[i2 - 1][j - 1] + 1;
                    if (l[i2][j] > z) {
                        z = l[i2][j];
                        bestResultSoFar = a.substring(i2 - z + 1, i2 + 1);
                        result.clear();
                        result.add(bestResultSoFar);
                    } else if (l[i2][j] == z) {
                        bestResultSoFar = a.substring(i2 - z + 1, i2 + 1);
                        result.add(bestResultSoFar);
                    }
                } else {
                    l[i2][j] = 0;
                }
                ++j;
            }
            ++i2;
        }
        return result;
    }

    public static <T> Enumeration<T> getEnumerationFromIterable(Iterable<T> iterable) {
        return new Enumeration<T>(iterable){
            final Iterator<T> i;
            {
                this.i = iterable.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.i.hasNext();
            }

            @Override
            public T nextElement() {
                return this.i.next();
            }
        };
    }

    public static interface MapBuilder<K, V> {
        public static <K, V> MapBuilder<K, V> of(Map<K, V> other) {
            return new MapBuilderImpl<K, V>(other);
        }

        public MapBuilder<K, V> put(K var1, V var2);

        public Map<K, V> build();
    }

    private static class MapBuilderImpl<K, V>
    implements MapBuilder<K, V> {
        private final Map<K, V> result;

        public MapBuilderImpl() {
            this.result = new HashMap();
        }

        public MapBuilderImpl(Map<K, V> other) {
            this.result = new HashMap<K, V>(other);
        }

        @Override
        public Map<K, V> build() {
            return this.result;
        }

        @Override
        public MapBuilder<K, V> put(K key, V value) {
            this.result.put(key, value);
            return this;
        }
    }

    public static class Pair<A, B>
    implements Serializable {
        private static final long serialVersionUID = -7631774746419135931L;
        private A a;
        private B b;
        private transient int hashCode;

        @Deprecated
        protected Pair() {
        }

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
            this.hashCode = 0;
        }

        public A getA() {
            return this.a;
        }

        public B getB() {
            return this.b;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = 17;
                this.hashCode = 37 * this.hashCode + (this.a != null ? this.a.hashCode() : 0);
                this.hashCode = 37 * this.hashCode + (this.b != null ? this.b.hashCode() : 0);
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            boolean result;
            if (this == obj) {
                result = true;
            } else if (obj instanceof Pair) {
                Pair pair = (Pair)obj;
                result = (this.a != null && this.a.equals(pair.a) || this.a == null && pair.a == null) && (this.b != null && this.b.equals(pair.b) || this.b == null && pair.b == null);
            } else {
                result = false;
            }
            return result;
        }

        public String toString() {
            return "[" + (this.a == null ? "null" : this.a.toString()) + ", " + (this.b == null ? "null" : this.b.toString()) + "]";
        }
    }

    public static class Triple<A, B, C>
    implements Serializable {
        private static final long serialVersionUID = 6806146864367514601L;
        private A a;
        private B b;
        private C c;
        private transient int hashCode;

        private Triple() {
        }

        public Triple(A a, B b, C c) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.hashCode = 0;
        }

        public A getA() {
            return this.a;
        }

        public B getB() {
            return this.b;
        }

        public C getC() {
            return this.c;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = 17;
                this.hashCode = 37 * this.hashCode + (this.a != null ? this.a.hashCode() : 0);
                this.hashCode = 37 * this.hashCode + (this.b != null ? this.b.hashCode() : 0);
                this.hashCode = 37 * this.hashCode + (this.c != null ? this.c.hashCode() : 0);
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            boolean result;
            if (this == obj) {
                result = true;
            } else if (obj instanceof Triple) {
                Triple thrice = (Triple)obj;
                result = (this.a != null && this.a.equals(thrice.a) || this.a == null && thrice.a == null) && (this.b != null && this.b.equals(thrice.b) || this.b == null && thrice.b == null) && (this.c != null && this.c.equals(thrice.c) || this.c == null && thrice.c == null);
            } else {
                result = false;
            }
            return result;
        }

        public String toString() {
            return "[" + this.a + ", " + this.b + ", " + this.c + "]";
        }
    }

    @FunctionalInterface
    public static interface UtilPredicate<T> {
        public boolean test(T var1);
    }

    public static interface ValueCollectionConstructor<T, C extends Collection<T>> {
        public C createValueCollection();
    }
}

