/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common;

import com.sap.sse.common.Duration;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.Serializable;
import java.util.Date;

public interface TimePoint
extends Comparable<TimePoint>,
Serializable {
    public static final TimePoint BeginningOfTime = new MillisecondsTimePoint(-8640000000000L);
    public static final TimePoint EndOfTime = new MillisecondsTimePoint(8640000000000L);

    public long asMillis();

    public Date asDate();

    public static TimePoint of(Date date) {
        return date == null ? null : new MillisecondsTimePoint(date);
    }

    public static TimePoint of(Long millis) {
        return millis == null ? null : TimePoint.of((long)millis);
    }

    public static TimePoint of(long millis) {
        return new MillisecondsTimePoint(millis);
    }

    public static TimePoint now() {
        return MillisecondsTimePoint.now();
    }

    public TimePoint plus(long var1);

    public TimePoint plus(Duration var1);

    public TimePoint minus(long var1);

    public TimePoint minus(Duration var1);

    public Duration until(TimePoint var1);

    public boolean after(TimePoint var1);

    public boolean before(TimePoint var1);

    public TimePoint getNearestModuloOneMinute(TimePoint var1);
}

