/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common;

public class Base64Utils {
    private static final char[] base64Chars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] base64Values = new byte[128];

    static {
        int i = 0;
        while (i < base64Chars.length) {
            Base64Utils.base64Values[Base64Utils.base64Chars[i]] = (byte)i;
            ++i;
        }
    }

    public static byte[] fromBase64(String data) {
        if (data == null) {
            return null;
        }
        int len = data.length();
        assert (len % 4 == 0);
        if (len == 0) {
            return new byte[0];
        }
        char[] chars = new char[len];
        data.getChars(0, len, chars, 0);
        int olen = 3 * (len / 4);
        if (chars[len - 2] == '=') {
            --olen;
        }
        if (chars[len - 1] == '=') {
            --olen;
        }
        byte[] bytes = new byte[olen];
        int iidx = 0;
        int oidx = 0;
        while (iidx < len) {
            byte c0 = base64Values[chars[iidx++] & 0xFF];
            byte c1 = base64Values[chars[iidx++] & 0xFF];
            byte c2 = base64Values[chars[iidx++] & 0xFF];
            byte c3 = base64Values[chars[iidx++] & 0xFF];
            int c24 = c0 << 18 | c1 << 12 | c2 << 6 | c3;
            bytes[oidx++] = (byte)(c24 >> 16);
            if (oidx == olen) break;
            bytes[oidx++] = (byte)(c24 >> 8);
            if (oidx == olen) break;
            bytes[oidx++] = (byte)c24;
        }
        return bytes;
    }

    public static long longFromBase64(String value) {
        int pos = 0;
        long longVal = base64Values[value.charAt(pos++)];
        int len = value.length();
        while (pos < len) {
            longVal <<= 6;
            longVal |= (long)base64Values[value.charAt(pos++)];
        }
        return longVal;
    }

    public static String toBase64(byte[] data) {
        if (data == null) {
            return null;
        }
        int len = data.length;
        if (len == 0) {
            return "";
        }
        int olen = 4 * ((len + 2) / 3);
        char[] chars = new char[olen];
        int iidx = 0;
        int oidx = 0;
        int charsLeft = len;
        while (charsLeft > 0) {
            int b0 = data[iidx++] & 0xFF;
            int b1 = charsLeft > 1 ? data[iidx++] & 0xFF : 0;
            int b2 = charsLeft > 2 ? data[iidx++] & 0xFF : 0;
            int b24 = b0 << 16 | b1 << 8 | b2;
            int c0 = b24 >> 18 & 0x3F;
            int c1 = b24 >> 12 & 0x3F;
            int c2 = b24 >> 6 & 0x3F;
            int c3 = b24 & 0x3F;
            chars[oidx++] = base64Chars[c0];
            chars[oidx++] = base64Chars[c1];
            chars[oidx++] = charsLeft > 1 ? base64Chars[c2] : 61;
            chars[oidx++] = charsLeft > 2 ? base64Chars[c3] : 61;
            charsLeft -= 3;
        }
        return new String(chars);
    }

    public static String toBase64(long value) {
        int low = (int)(value & 0xFFFFFFFFFFFFFFFFL);
        int high = (int)(value >> 32);
        StringBuilder sb = new StringBuilder();
        boolean haveNonZero = Base64Utils.base64Append(sb, high >> 28 & 0xF, false);
        haveNonZero = Base64Utils.base64Append(sb, high >> 22 & 0x3F, haveNonZero);
        haveNonZero = Base64Utils.base64Append(sb, high >> 16 & 0x3F, haveNonZero);
        haveNonZero = Base64Utils.base64Append(sb, high >> 10 & 0x3F, haveNonZero);
        haveNonZero = Base64Utils.base64Append(sb, high >> 4 & 0x3F, haveNonZero);
        int v = (high & 0xF) << 2 | low >> 30 & 3;
        haveNonZero = Base64Utils.base64Append(sb, v, haveNonZero);
        haveNonZero = Base64Utils.base64Append(sb, low >> 24 & 0x3F, haveNonZero);
        haveNonZero = Base64Utils.base64Append(sb, low >> 18 & 0x3F, haveNonZero);
        haveNonZero = Base64Utils.base64Append(sb, low >> 12 & 0x3F, haveNonZero);
        Base64Utils.base64Append(sb, low >> 6 & 0x3F, haveNonZero);
        Base64Utils.base64Append(sb, low & 0x3F, true);
        return sb.toString();
    }

    private static boolean base64Append(StringBuilder sb, int digit, boolean haveNonZero) {
        if (digit > 0) {
            haveNonZero = true;
        }
        if (haveNonZero) {
            sb.append(base64Chars[digit]);
        }
        return haveNonZero;
    }
}

