/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.aiagent.impl;

import com.sap.sailing.aiagent.impl.AIAgentImpl;
import com.sap.sailing.aiagent.impl.rules.GoodStartRule;
import com.sap.sailing.aiagent.impl.rules.Rule;
import com.sap.sailing.aiagent.impl.rules.TopThreeMarkRoundingRule;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.TrackedRaceStatusEnum;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.common.tracking.SensorFix;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.tracking.AddResult;
import com.sap.sailing.domain.tracking.DynamicSensorFixTrack;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.RaceChangeListener;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRaceStatus;
import com.sap.sse.common.TimePoint;
import com.sap.sse.util.ThreadPoolUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public class RaceListener
implements RaceChangeListener {
    private static final Logger logger = Logger.getLogger(RaceListener.class.getName());
    private final TrackedRace trackedRace;
    private final Iterable<Rule> rules;
    private final ScheduledExecutorService backgroundExecutor;
    private final ConcurrentLinkedDeque<Runnable> tasksEnqueuedWhileRaceStillLoading;

    public RaceListener(AIAgentImpl aiAgent, Leaderboard leaderboard, RaceColumn raceColumn, Fleet fleet, TrackedRace trackedRace) {
        this.trackedRace = trackedRace;
        this.tasksEnqueuedWhileRaceStillLoading = new ConcurrentLinkedDeque();
        this.backgroundExecutor = ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor();
        ArrayList<Rule> myRules = new ArrayList<Rule>();
        myRules.add(new GoodStartRule(aiAgent, leaderboard, raceColumn, fleet, trackedRace));
        myRules.add(new TopThreeMarkRoundingRule(aiAgent, leaderboard, raceColumn, fleet, trackedRace));
        this.rules = myRules;
    }

    private boolean isTaskExecutionToBeSuspendedBasedOnRaceStatus(TrackedRaceStatusEnum status) {
        return status == TrackedRaceStatusEnum.PREPARED || status == TrackedRaceStatusEnum.LOADING;
    }

    private synchronized void executeInBackgroundWithCurrentSubject(Runnable runnable) {
        Subject subject = SecurityUtils.getSubject();
        Runnable taskWithSubject = subject.associateWith(runnable);
        if (this.isTaskExecutionToBeSuspendedBasedOnRaceStatus(this.trackedRace.getStatus().getStatus())) {
            this.enqueue(taskWithSubject);
        } else {
            this.backgroundExecutor.execute(taskWithSubject);
        }
    }

    private synchronized void enqueue(Runnable taskWithSubject) {
        logger.fine(() -> "Enqueuing task because tracked race " + this.trackedRace.getRaceIdentifier() + " is in status " + this.trackedRace.getStatus().getStatus());
        this.tasksEnqueuedWhileRaceStillLoading.add(taskWithSubject);
    }

    public void waypointAdded(int zeroBasedIndex, Waypoint waypointThatGotAdded) {
        this.executeInBackgroundWithCurrentSubject(() -> this.rules.forEach(r -> r.waypointAdded(zeroBasedIndex, waypointThatGotAdded)));
    }

    public void waypointRemoved(int zeroBasedIndex, Waypoint waypointThatGotRemoved) {
        this.executeInBackgroundWithCurrentSubject(() -> this.rules.forEach(r -> r.waypointRemoved(zeroBasedIndex, waypointThatGotRemoved)));
    }

    public void competitorPositionChanged(GPSFixMoving fix, Competitor competitor, AddResult addedOrReplaced) {
        this.executeInBackgroundWithCurrentSubject(() -> this.rules.forEach(r -> r.competitorPositionChanged(fix, competitor, addedOrReplaced)));
    }

    public void markPositionChanged(GPSFix fix, Mark mark, boolean firstInTrack, AddResult addedOrReplaced) {
        this.executeInBackgroundWithCurrentSubject(() -> this.rules.forEach(r -> r.markPositionChanged(fix, mark, firstInTrack, addedOrReplaced)));
    }

    public void firstGPSFixReceived() {
        this.executeInBackgroundWithCurrentSubject(() -> this.rules.forEach(r -> r.firstGPSFixReceived()));
    }

    public void markPassingReceived(Competitor competitor, Map<Waypoint, MarkPassing> oldMarkPassings, Iterable<MarkPassing> markPassings) {
        this.executeInBackgroundWithCurrentSubject(() -> this.rules.forEach(r -> r.markPassingReceived(competitor, oldMarkPassings, markPassings)));
    }

    public void speedAveragingChanged(long oldMillisecondsOverWhichToAverage, long newMillisecondsOverWhichToAverage) {
        this.executeInBackgroundWithCurrentSubject(() -> this.rules.forEach(r -> r.speedAveragingChanged(oldMillisecondsOverWhichToAverage, newMillisecondsOverWhichToAverage)));
    }

    public void windDataReceived(Wind wind, WindSource windSource) {
        this.executeInBackgroundWithCurrentSubject(() -> this.rules.forEach(r -> r.windDataReceived(wind, windSource)));
    }

    public void windDataRemoved(Wind wind, WindSource windSource) {
        this.executeInBackgroundWithCurrentSubject(() -> this.rules.forEach(r -> r.windDataRemoved(wind, windSource)));
    }

    public void windAveragingChanged(long oldMillisecondsOverWhichToAverage, long newMillisecondsOverWhichToAverage) {
        this.executeInBackgroundWithCurrentSubject(() -> this.rules.forEach(r -> r.windAveragingChanged(oldMillisecondsOverWhichToAverage, newMillisecondsOverWhichToAverage)));
    }

    public void startOfTrackingChanged(TimePoint oldStartOfTracking, TimePoint newStartOfTracking) {
        this.executeInBackgroundWithCurrentSubject(() -> this.rules.forEach(r -> r.startOfTrackingChanged(oldStartOfTracking, newStartOfTracking)));
    }

    public void endOfTrackingChanged(TimePoint oldEndOfTracking, TimePoint newEndOfTracking) {
        this.rules.forEach(r -> r.endOfTrackingChanged(oldEndOfTracking, newEndOfTracking));
    }

    public void startTimeReceivedChanged(TimePoint startTimeReceived) {
        this.executeInBackgroundWithCurrentSubject(() -> this.rules.forEach(r -> r.startTimeReceivedChanged(startTimeReceived)));
    }

    public void startOfRaceChanged(TimePoint oldStartOfRace, TimePoint newStartOfRace) {
        this.executeInBackgroundWithCurrentSubject(() -> this.rules.forEach(r -> r.startOfRaceChanged(oldStartOfRace, newStartOfRace)));
    }

    public void finishingTimeChanged(TimePoint oldFinishingTime, TimePoint newFinishingTime) {
        this.executeInBackgroundWithCurrentSubject(() -> this.rules.forEach(r -> r.finishingTimeChanged(oldFinishingTime, newFinishingTime)));
    }

    public void finishedTimeChanged(TimePoint oldFinishedTime, TimePoint newFinishedTime) {
        this.executeInBackgroundWithCurrentSubject(() -> this.rules.forEach(r -> r.finishedTimeChanged(oldFinishedTime, newFinishedTime)));
    }

    public void delayToLiveChanged(long delayToLiveInMillis) {
        this.executeInBackgroundWithCurrentSubject(() -> this.rules.forEach(r -> r.delayToLiveChanged(delayToLiveInMillis)));
    }

    public void windSourcesToExcludeChanged(Iterable<? extends WindSource> windSourcesToExclude) {
        this.executeInBackgroundWithCurrentSubject(() -> this.rules.forEach(r -> r.windSourcesToExcludeChanged(windSourcesToExclude)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statusChanged(TrackedRaceStatus newStatus, TrackedRaceStatus oldStatus) {
        RaceListener raceListener = this;
        synchronized (raceListener) {
            if (this.isTaskExecutionToBeSuspendedBasedOnRaceStatus(oldStatus.getStatus()) && !this.isTaskExecutionToBeSuspendedBasedOnRaceStatus(newStatus.getStatus())) {
                logger.info("Executing " + this.tasksEnqueuedWhileRaceStillLoading.size() + " enqueued tasks for " + this.trackedRace.getRaceIdentifier());
                while (!this.tasksEnqueuedWhileRaceStillLoading.isEmpty()) {
                    this.backgroundExecutor.submit(this.tasksEnqueuedWhileRaceStillLoading.pop());
                }
            }
        }
        this.executeInBackgroundWithCurrentSubject(() -> this.rules.forEach(r -> r.statusChanged(newStatus, oldStatus)));
    }

    public void competitorSensorTrackAdded(DynamicSensorFixTrack<Competitor, ?> track) {
        this.executeInBackgroundWithCurrentSubject(() -> this.rules.forEach(r -> r.competitorSensorTrackAdded(track)));
    }

    public void competitorSensorFixAdded(Competitor competitor, String trackName, SensorFix fix, AddResult addedOrReplaced) {
        this.executeInBackgroundWithCurrentSubject(() -> this.rules.forEach(r -> r.competitorSensorFixAdded(competitor, trackName, fix, addedOrReplaced)));
    }

    public void regattaLogAttached(RegattaLog regattaLog) {
        this.executeInBackgroundWithCurrentSubject(() -> this.rules.forEach(r -> r.regattaLogAttached(regattaLog)));
    }

    public void raceLogAttached(RaceLog raceLog) {
        this.executeInBackgroundWithCurrentSubject(() -> this.rules.forEach(r -> r.raceLogAttached(raceLog)));
    }

    public void raceLogDetached(RaceLog raceLog) {
        this.executeInBackgroundWithCurrentSubject(() -> this.rules.forEach(r -> r.raceLogDetached(raceLog)));
    }
}

