/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.aiagent.impl;

import com.sap.sailing.aiagent.impl.LeaderboardGroupListenerImpl;
import com.sap.sailing.aiagent.impl.RaceColumnListener;
import com.sap.sailing.aiagent.interfaces.AIAgent;
import com.sap.sailing.aiagent.interfaces.AIAgentListener;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.domain.base.EventListener;
import com.sap.sailing.domain.common.tagging.RaceLogNotFoundException;
import com.sap.sailing.domain.common.tagging.ServiceNotFoundException;
import com.sap.sailing.domain.common.tagging.TagAlreadyExistsException;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.aicore.AICore;
import com.sap.sse.aicore.ChatSession;
import com.sap.sse.aicore.Credentials;
import com.sap.sse.aicore.Deployment;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import com.sap.sse.shared.util.WeakValueCache;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.ClientProtocolException;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.AuthorizationException;
import org.json.simple.parser.ParseException;
import org.osgi.util.tracker.ServiceTracker;

public class AIAgentImpl
implements AIAgent {
    private static final Logger logger = Logger.getLogger(AIAgentImpl.class.getName());
    private static final String DEFAULT_MODEL_NAME = "gpt-4o-mini";
    private static final String SAP_AI_CORE_TAG = "SAP AI Core on %s";
    private final ServiceTracker<RacingEventService, RacingEventService> racingEventServiceTracker;
    private final String desiredModelName;
    private String modelName;
    private final String systemPrompt;
    private ChatSession chatSession;
    private final ConcurrentMap<Leaderboard, RaceColumnListener> raceColumnListeners;
    private final ConcurrentMap<Event, EventListener> eventListeners;
    private final Set<AIAgentListener> listeners;
    private final ConcurrentMap<Util.Triple<String, String, String>, Set<String>> tagIdentifiersCurrentlyBeingAddedToRace;
    private final WeakValueCache<Util.Triple<String, String, String>, NamedReentrantReadWriteLock> locks;
    private final AICore aiCore;

    public AIAgentImpl(ServiceTracker<RacingEventService, RacingEventService> racingEventServiceTracker, AICore aiCore, String desiredModelName, String systemPrompt) throws UnsupportedOperationException, ClientProtocolException, URISyntaxException, IOException, ParseException {
        this.aiCore = aiCore;
        this.desiredModelName = desiredModelName;
        this.systemPrompt = systemPrompt;
        this.tagIdentifiersCurrentlyBeingAddedToRace = new ConcurrentHashMap<Util.Triple<String, String, String>, Set<String>>();
        this.raceColumnListeners = new ConcurrentHashMap<Leaderboard, RaceColumnListener>();
        this.eventListeners = new ConcurrentHashMap<Event, EventListener>();
        this.racingEventServiceTracker = racingEventServiceTracker;
        this.chatSession = this.createChatSession();
        this.locks = new WeakValueCache(new HashMap());
        this.listeners = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    private ChatSession createChatSession() throws UnsupportedOperationException, ClientProtocolException, URISyntaxException, IOException, ParseException {
        ChatSession result;
        if (this.aiCore.hasCredentials()) {
            HashMap deploymentsByModelName = new HashMap();
            this.aiCore.getDeployments().forEach(d -> {
                boolean bl = Util.addToValueSet((Map)deploymentsByModelName, (Object)d.getModelName(), (Object)d);
            });
            logger.info("Found AI models " + deploymentsByModelName.keySet());
            if (this.desiredModelName == null || deploymentsByModelName.get(this.desiredModelName) == null || ((Set)deploymentsByModelName.get(this.desiredModelName)).isEmpty()) {
                logger.warning("Couldn't find model " + this.desiredModelName + "; defaulting to " + DEFAULT_MODEL_NAME);
                this.modelName = DEFAULT_MODEL_NAME;
            } else {
                logger.info("Found model " + this.desiredModelName);
                this.modelName = this.desiredModelName;
            }
            Set deployments = (Set)deploymentsByModelName.get(this.modelName);
            Deployment deployment = (Deployment)deployments.iterator().next();
            result = this.aiCore.createChatSession(deployment);
        } else {
            result = null;
        }
        return result;
    }

    public boolean hasCredentials() {
        return this.aiCore.hasCredentials();
    }

    public void setCredentials(Credentials credentials) {
        this.aiCore.setCredentials(credentials);
        if (credentials != null) {
            try {
                this.chatSession = this.createChatSession();
            }
            catch (IOException | UnsupportedOperationException | URISyntaxException | ParseException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.chatSession = null;
            this.modelName = null;
        }
        this.listeners.forEach(l -> l.credentialsUpdated(credentials));
    }

    private RacingEventService getRacingEventService() {
        return (RacingEventService)this.racingEventServiceTracker.getService();
    }

    public void addListener(AIAgentListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(AIAgentListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void produceCommentFromPrompt(String tag, String prompt, String leaderboardName, String raceColumnName, String fleetName, TimePoint raceTimepoint, String tagIdentifier) throws UnsupportedOperationException, ClientProtocolException, URISyntaxException, IOException, ParseException, RaceLogNotFoundException, ServiceNotFoundException {
        if (this.chatSession != null && this.hasCredentials()) {
            NamedReentrantReadWriteLock lock = this.lockRaceForCommenting(leaderboardName, raceColumnName, fleetName);
            try {
                if (this.raceHasOrIsAboutToGetTag(leaderboardName, raceColumnName, fleetName, tagIdentifier)) return;
                this.raceIsAboutToGetTag(leaderboardName, raceColumnName, fleetName, tagIdentifier);
                this.chatSession.addSystemPrompt(this.systemPrompt).addPrompt(prompt).setTemperature(Double.valueOf(0.2)).submit(response -> {
                    try {
                        try {
                            this.getRacingEventService().getTaggingService().addTag(leaderboardName, raceColumnName, fleetName, String.format(SAP_AI_CORE_TAG, tag), response, tagIdentifier, "/images/AI_generated_R_blk.png", null, true, raceTimepoint);
                        }
                        catch (RaceLogNotFoundException | ServiceNotFoundException | TagAlreadyExistsException | IllegalArgumentException | AuthorizationException e) {
                            logger.log(Level.SEVERE, "Error trying to add AI comment to leaderboard " + leaderboardName + ", race column " + raceColumnName + ", fleet " + fleetName, e);
                            NamedReentrantReadWriteLock lock2 = this.lockRaceForCommenting(leaderboardName, raceColumnName, fleetName);
                            try {
                                this.raceIsNoLongerAboutToGetTag(leaderboardName, raceColumnName, fleetName, tagIdentifier);
                            }
                            finally {
                                this.unlockRaceAfterCommenting(lock2, leaderboardName, raceColumnName, fleetName);
                            }
                        }
                    }
                    finally {
                        NamedReentrantReadWriteLock lock2 = this.lockRaceForCommenting(leaderboardName, raceColumnName, fleetName);
                        try {
                            this.raceIsNoLongerAboutToGetTag(leaderboardName, raceColumnName, fleetName, tagIdentifier);
                        }
                        finally {
                            this.unlockRaceAfterCommenting(lock2, leaderboardName, raceColumnName, fleetName);
                        }
                    }
                }, Optional.of(ex -> {
                    NamedReentrantReadWriteLock lock3 = this.lockRaceForCommenting(leaderboardName, raceColumnName, fleetName);
                    try {
                        this.raceIsNoLongerAboutToGetTag(leaderboardName, raceColumnName, fleetName, tagIdentifier);
                    }
                    finally {
                        this.unlockRaceAfterCommenting(lock3, leaderboardName, raceColumnName, fleetName);
                    }
                    logger.log(Level.SEVERE, "Error trying to generate AI comment", (Throwable)ex);
                }));
                return;
            }
            finally {
                this.unlockRaceAfterCommenting(lock, leaderboardName, raceColumnName, fleetName);
            }
        } else {
            logger.fine(() -> "Trying to produce a comment skipped due to missing AI Core credentials");
        }
    }

    private void raceIsAboutToGetTag(String leaderboardName, String raceColumnName, String fleetName, String tagIdentifier) {
        Util.addToValueSet(this.tagIdentifiersCurrentlyBeingAddedToRace, (Object)new Util.Triple((Object)leaderboardName, (Object)raceColumnName, (Object)fleetName), (Object)tagIdentifier);
    }

    private void raceIsNoLongerAboutToGetTag(String leaderboardName, String raceColumnName, String fleetName, String tagIdentifier) {
        Util.removeFromValueSet(this.tagIdentifiersCurrentlyBeingAddedToRace, (Object)new Util.Triple((Object)leaderboardName, (Object)raceColumnName, (Object)fleetName), (Object)tagIdentifier);
    }

    private boolean raceHasOrIsAboutToGetTag(String leaderboardName, String raceColumnName, String fleetName, String tagIdentifier) throws RaceLogNotFoundException, ServiceNotFoundException {
        Util.Triple key = new Util.Triple((Object)leaderboardName, (Object)raceColumnName, (Object)fleetName);
        return this.tagIdentifiersCurrentlyBeingAddedToRace.containsKey(key) && ((Set)this.tagIdentifiersCurrentlyBeingAddedToRace.get(key)).contains(tagIdentifier) || this.getRacingEventService().getTaggingService().getTags(leaderboardName, raceColumnName, fleetName, null, false).stream().anyMatch(existingTag -> Util.equalsWithNull((Object)existingTag.getHiddenInfo(), (Object)tagIdentifier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamedReentrantReadWriteLock lockRaceForCommenting(String leaderboardName, String raceColumnName, String fleetName) {
        NamedReentrantReadWriteLock lock;
        Util.Triple<String, String, String> lockKey = this.getLockKey(leaderboardName, raceColumnName, fleetName);
        AIAgentImpl aIAgentImpl = this;
        synchronized (aIAgentImpl) {
            NamedReentrantReadWriteLock existingLock = (NamedReentrantReadWriteLock)this.locks.get(lockKey);
            if (existingLock == null) {
                lock = new NamedReentrantReadWriteLock("AI comments for " + leaderboardName + "/" + raceColumnName + "/" + fleetName, false);
                this.locks.put(lockKey, (Object)lock);
            } else {
                lock = existingLock;
            }
            logger.fine(() -> "Locking " + lock.writeLock() + " in thread " + Thread.currentThread() + " for key " + lockKey);
        }
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)lock);
        return lock;
    }

    private Util.Triple<String, String, String> getLockKey(String leaderboardName, String raceColumnName, String fleetName) {
        return new Util.Triple((Object)leaderboardName, (Object)raceColumnName, (Object)fleetName);
    }

    private synchronized void unlockRaceAfterCommenting(NamedReentrantReadWriteLock lock, String leaderboardName, String raceColumnName, String fleetName) {
        Util.Triple<String, String, String> lockKey = this.getLockKey(leaderboardName, raceColumnName, fleetName);
        logger.fine(() -> "Unlocking " + lock.writeLock() + " in thread " + Thread.currentThread() + " for key " + lockKey);
        LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)lock);
    }

    public void startCommentingOnEvent(Event event) {
        final LeaderboardGroupListenerImpl lgListener = new LeaderboardGroupListenerImpl(this);
        EventListener eventListener = new EventListener(){

            public void leaderboardGroupAdded(Event event, LeaderboardGroup leaderboardGroup) {
                for (Leaderboard leaderboard : leaderboardGroup.getLeaderboards()) {
                    if (!leaderboard.isPartOfEvent((EventBase)event)) continue;
                    AIAgentImpl.this.addNewRaceColumnListenerToLeaderboard(leaderboard);
                }
                leaderboardGroup.addLeaderboardGroupListener(lgListener);
            }

            public void leaderboardGroupRemoved(Event event, LeaderboardGroup leaderboardGroup) {
                leaderboardGroup.removeLeaderboardGroupListener(lgListener);
                for (Leaderboard leaderboard : leaderboardGroup.getLeaderboards()) {
                    AIAgentImpl.this.removeRaceColumnListenerFromLeaderboard(leaderboard);
                }
            }
        };
        event.addEventListener(eventListener);
        this.eventListeners.put(event, eventListener);
        for (Leaderboard leaderboard : event.getLeaderboards()) {
            this.addNewRaceColumnListenerToLeaderboard(leaderboard);
        }
        logger.info("User " + SecurityUtils.getSubject().getPrincipal() + " activated AI comments for event " + event.getName() + " with ID " + event.getId());
        this.listeners.forEach(l -> l.startedCommentingOnEvent(event));
    }

    void addNewRaceColumnListenerToLeaderboard(Leaderboard leaderboard) {
        RaceColumnListener raceColumnListenerForLeaderboard = new RaceColumnListener(leaderboard, this);
        this.raceColumnListeners.put(leaderboard, raceColumnListenerForLeaderboard);
        leaderboard.addRaceColumnListener((com.sap.sailing.domain.base.RaceColumnListener)raceColumnListenerForLeaderboard);
    }

    void removeRaceColumnListenerFromLeaderboard(Leaderboard leaderboard) {
        RaceColumnListener listener = (RaceColumnListener)this.raceColumnListeners.remove(leaderboard);
        if (listener != null) {
            listener.removeListener();
        }
    }

    public void stopCommentingOnEvent(Event event) {
        EventListener eventListener = (EventListener)this.eventListeners.remove(event);
        if (eventListener != null) {
            event.removeEventListener(eventListener);
            for (Leaderboard leaderboard : event.getLeaderboards()) {
                RaceColumnListener raceColumnListener = (RaceColumnListener)this.raceColumnListeners.get(leaderboard);
                if (raceColumnListener == null) continue;
                raceColumnListener.removeListener();
            }
        }
        logger.info("User " + SecurityUtils.getSubject().getPrincipal() + " de-activated AI comments for event " + event.getName() + " with ID " + event.getId());
        this.listeners.forEach(l -> l.stoppedCommentingOnEvent(event));
    }

    public void stopCommentingOnAllEvents() {
        for (Event event : new HashSet(this.eventListeners.keySet())) {
            this.stopCommentingOnEvent(event);
        }
    }

    public Iterable<Event> getCommentingOnEvents() {
        return Collections.unmodifiableCollection(this.eventListeners.keySet());
    }

    public String getModelName() {
        return this.modelName;
    }
}

