/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.monitoring.sysinfo;

import com.sap.sailing.monitoring.sysinfo.ProcessInformation;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.ProcFd;
import org.hyperic.sigar.ProcMem;
import org.hyperic.sigar.ProcState;
import org.hyperic.sigar.Sigar;

public class ProcessInformationImpl
implements ProcessInformation {
    private long pid = -1L;
    private String name = "";
    private long max_open_files = -1L;
    private long current_open_file_count = -1L;
    private long current_thread_count = -1L;
    private long virtual_memory_size = -1L;
    private long resident_memory_size = -1L;
    private long shared_memory_size = -1L;
    private long kernel_cpu_time = -1L;
    private long user_cpu_time = -1L;

    public ProcessInformationImpl(long pid, Sigar sigar) {
        this.pid = pid;
        try {
            this.name = sigar.getProcExe(pid).getName();
            ProcCpu cpu = sigar.getProcCpu(pid);
            this.kernel_cpu_time = cpu.getSys();
            this.user_cpu_time = cpu.getUser();
            ProcMem mem = sigar.getProcMem(pid);
            this.virtual_memory_size = mem.getSize();
            this.resident_memory_size = mem.getResident();
            this.shared_memory_size = mem.getShare();
            ProcFd fd = sigar.getProcFd(pid);
            this.current_open_file_count = fd.getTotal();
            ProcState state = sigar.getProcState(pid);
            this.current_thread_count = state.getThreads();
            if (!System.getProperty("os.name").startsWith("Windows")) {
                this.parseLimits();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected String[] readProc(String path) {
        BufferedReader reader = null;
        StringBuffer buf = new StringBuffer("");
        try {
            try {
                reader = new BufferedReader(new FileReader(path));
                String line = "";
                while ((line = reader.readLine()) != null) {
                    buf.append(line).append("\n");
                }
            }
            catch (Exception ex) {
                String[] stringArray = new String[]{};
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        return new String[0];
                    }
                }
                return stringArray;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    return new String[0];
                }
            }
        }
        return buf.toString().split("\\n");
    }

    protected void parseLimits() {
        String[] limits = new String[]{};
        String[] stringArray = limits = this.readProc("/proc/" + this.getPid() + "/limits");
        int n = limits.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] parts = line.split(" ");
            if (parts[1].equalsIgnoreCase("open") && parts[2].equalsIgnoreCase("files")) {
                this.max_open_files = Long.parseLong(parts[14].trim());
            }
            ++n2;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getPid() {
        return this.pid;
    }

    @Override
    public long getMaxOpenFiles() {
        return this.max_open_files;
    }

    @Override
    public long getCurrentThreadCount() {
        return this.current_thread_count;
    }

    @Override
    public long getCurrentOpenFileCount() {
        return this.current_open_file_count;
    }

    @Override
    public long getVirtualMemorySize() {
        return this.virtual_memory_size;
    }

    @Override
    public long getSharedMemorySize() {
        return this.shared_memory_size;
    }

    @Override
    public long getResidentMemorySize() {
        return this.resident_memory_size;
    }

    @Override
    public long getKernelCPUTime() {
        return this.kernel_cpu_time;
    }

    @Override
    public long getUserCPUTime() {
        return this.user_cpu_time;
    }

    public String toString() {
        return new StringBuffer().append(String.valueOf(this.getName()) + " PID: " + this.getPid()).append("\n").append("CPU: " + (double)this.getKernelCPUTime() * 0.001 + " (Kernel) " + (double)this.getUserCPUTime() * 0.001 + " (User)").append("\n").append("Mem: " + this.getResidentMemorySize() / 1000L + "kb (Resident) " + this.getVirtualMemorySize() / 1000L + "kb (Virtual) " + this.getSharedMemorySize() / 1000L + "kb (shared)").append("\n").append("Thread Count: " + this.getCurrentThreadCount() + " Open Files: " + this.getCurrentOpenFileCount() + " Max Open Files: " + this.getMaxOpenFiles()).toString();
    }
}

