/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.statistics;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.tracking.AbstractTrackedRegattaAndRaceObserver;
import com.sap.sailing.domain.tracking.AddResult;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.RaceChangeListener;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRaceStatus;
import com.sap.sailing.domain.tracking.impl.AbstractRaceChangeListener;
import com.sap.sailing.server.statistics.TrackedRaceStatistics;
import com.sap.sailing.server.statistics.TrackedRaceStatisticsCache;
import com.sap.sailing.server.statistics.TrackedRaceStatisticsCalculator;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.util.SmartFutureCache;
import com.sap.sse.util.ThreadPoolUtil;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TrackedRaceStatisticsCacheImpl
extends AbstractTrackedRegattaAndRaceObserver
implements TrackedRaceStatisticsCache {
    private static final Logger logger = Logger.getLogger(TrackedRaceStatisticsCacheImpl.class.getName());
    private static final Duration MINIMUM_DELAY_FOR_CACHE_RECALCULATION = Duration.ONE_SECOND.times(10L);
    private final Map<TrackedRace, Listener> listeners;
    private final SmartFutureCache<TrackedRace, TrackedRaceStatistics, ?> cache;
    private final ScheduledExecutorService executor = ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor();
    private final WeakHashMap<TrackedRace, Future<?>> scheduledTriggers = new WeakHashMap();

    public TrackedRaceStatisticsCacheImpl() {
        this.listeners = new ConcurrentHashMap<TrackedRace, Listener>();
        this.cache = new SmartFutureCache((SmartFutureCache.CacheUpdater)new Updater(), TrackedRaceStatisticsCacheImpl.class.getSimpleName());
    }

    @Override
    public TrackedRaceStatistics getStatistics(TrackedRace trackedRace) {
        return (TrackedRaceStatistics)this.cache.get((Object)trackedRace, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrackedRaceStatistics getStatisticsWaitingForLatest(TrackedRace trackedRace) throws InterruptedException {
        Map<TrackedRace, Listener> map = this.listeners;
        synchronized (map) {
            while (!this.listeners.containsKey(trackedRace)) {
                this.listeners.wait();
            }
        }
        return (TrackedRaceStatistics)this.cache.get((Object)trackedRace, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onRaceAdded(RegattaAndRaceIdentifier raceIdentifier, DynamicTrackedRegatta trackedRegatta, DynamicTrackedRace trackedRace) {
        Listener listener = new Listener(trackedRace);
        Map<TrackedRace, Listener> map = this.listeners;
        synchronized (map) {
            this.listeners.put((TrackedRace)trackedRace, listener);
            trackedRace.addListener((RaceChangeListener)listener);
            this.triggerUpdateDirect(trackedRace);
            this.listeners.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerUpdateScheduled(DynamicTrackedRace trackedRace) {
        WeakHashMap<TrackedRace, Future<?>> weakHashMap = this.scheduledTriggers;
        synchronized (weakHashMap) {
            if (this.scheduledTriggers.get(trackedRace) == null) {
                long delay = MINIMUM_DELAY_FOR_CACHE_RECALCULATION.asMillis();
                logger.log(Level.FINEST, () -> "Scheduling statistics update trigger for race " + trackedRace.getRaceIdentifier() + " in " + delay + "ms");
                this.scheduledTriggers.put((TrackedRace)trackedRace, this.executor.schedule(() -> {
                    WeakHashMap<TrackedRace, Future<?>> weakHashMap = this.scheduledTriggers;
                    synchronized (weakHashMap) {
                        this.scheduledTriggers.remove(trackedRace);
                        this.triggerUpdateDirect(trackedRace);
                    }
                }, delay, TimeUnit.MILLISECONDS));
            }
        }
    }

    private void triggerUpdateDirect(DynamicTrackedRace trackedRace) {
        this.cache.triggerUpdate((Object)trackedRace, null);
        logger.log(Level.FINEST, () -> "Triggering statistics update for race " + trackedRace.getRaceIdentifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onRaceRemoved(DynamicTrackedRace trackedRace) {
        Object listener;
        Map<TrackedRace, Listener> map = this.listeners;
        synchronized (map) {
            listener = this.listeners.remove(trackedRace);
            if (listener != null) {
                trackedRace.removeListener((RaceChangeListener)listener);
            }
            this.listeners.notifyAll();
        }
        Future<?> updateFuture = null;
        listener = this.scheduledTriggers;
        synchronized (listener) {
            updateFuture = this.scheduledTriggers.remove(trackedRace);
        }
        if (updateFuture != null && !updateFuture.cancel(false)) {
            try {
                updateFuture.get();
            }
            catch (Exception e) {
                logger.log(Level.FINEST, () -> "Error while waiting for statistics cache update to finish for race: " + trackedRace.getRaceIdentifier());
            }
        }
        Thread t = new Thread(() -> {
            this.cache.get((Object)trackedRace, true);
            this.cache.remove((Object)trackedRace);
        }, "Cache cleaner for tracked race " + trackedRace.getRace().getName());
        t.setDaemon(true);
        t.start();
    }

    private class Listener
    extends AbstractRaceChangeListener {
        private final DynamicTrackedRace trackedRace;

        public Listener(DynamicTrackedRace trackedRace) {
            this.trackedRace = trackedRace;
        }

        public void competitorPositionChanged(GPSFixMoving fix, Competitor item, AddResult addedOrReplaced) {
            TrackedRaceStatisticsCacheImpl.this.triggerUpdateScheduled(this.trackedRace);
        }

        public void markPositionChanged(GPSFix fix, Mark mark, boolean firstInTrack, AddResult addedOrReplaced) {
            TrackedRaceStatisticsCacheImpl.this.triggerUpdateScheduled(this.trackedRace);
        }

        public void windDataReceived(Wind wind, WindSource windSource) {
            TrackedRaceStatisticsCacheImpl.this.triggerUpdateScheduled(this.trackedRace);
        }

        public void windDataRemoved(Wind wind, WindSource windSource) {
            TrackedRaceStatisticsCacheImpl.this.triggerUpdateScheduled(this.trackedRace);
        }

        public void startOfRaceChanged(TimePoint oldStartOfRace, TimePoint newStartOfRace) {
            TrackedRaceStatisticsCacheImpl.this.triggerUpdateScheduled(this.trackedRace);
        }

        public void finishedTimeChanged(TimePoint oldFinishedTime, TimePoint newFinishedTime) {
            TrackedRaceStatisticsCacheImpl.this.triggerUpdateScheduled(this.trackedRace);
        }

        public void waypointAdded(int zeroBasedIndex, Waypoint waypointThatGotAdded) {
            TrackedRaceStatisticsCacheImpl.this.triggerUpdateScheduled(this.trackedRace);
        }

        public void waypointRemoved(int zeroBasedIndex, Waypoint waypointThatGotRemoved) {
            TrackedRaceStatisticsCacheImpl.this.triggerUpdateScheduled(this.trackedRace);
        }

        public void statusChanged(TrackedRaceStatus newStatus, TrackedRaceStatus oldStatus) {
            TrackedRaceStatisticsCacheImpl.this.triggerUpdateScheduled(this.trackedRace);
        }
    }

    private class Updater
    extends SmartFutureCache.AbstractCacheUpdater<TrackedRace, TrackedRaceStatistics, SmartFutureCache.EmptyUpdateInterval> {
        private Updater() {
        }

        public TrackedRaceStatistics computeCacheUpdate(TrackedRace trackedRace, SmartFutureCache.EmptyUpdateInterval updateInterval) throws Exception {
            logger.log(Level.FINE, () -> "Updating statistics for race " + trackedRace.getRaceIdentifier());
            return new TrackedRaceStatisticsCalculator(trackedRace, true, true).getStatistics();
        }
    }
}

