/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.simulation;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.CPUMeteringType;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.LegIdentifier;
import com.sap.sailing.domain.common.LegIdentifierImpl;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.PathType;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.domain.tracking.AddResult;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.RaceChangeListener;
import com.sap.sailing.domain.tracking.RaceListener;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRegatta;
import com.sap.sailing.domain.tracking.TrackedRegattaListener;
import com.sap.sailing.domain.tracking.impl.AbstractRaceChangeListener;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.SimulationService;
import com.sap.sailing.simulator.Path;
import com.sap.sailing.simulator.PolarDiagram;
import com.sap.sailing.simulator.SimulationParameters;
import com.sap.sailing.simulator.SimulationResults;
import com.sap.sailing.simulator.Simulator;
import com.sap.sailing.simulator.impl.PolarDiagramGPS;
import com.sap.sailing.simulator.impl.SimulationParametersImpl;
import com.sap.sailing.simulator.impl.SimulatorImpl;
import com.sap.sailing.simulator.impl.SparseSimulationDataException;
import com.sap.sailing.simulator.windfield.WindFieldGenerator;
import com.sap.sailing.simulator.windfield.impl.WindFieldTrackedRaceImpl;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.util.SmartFutureCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class SimulationServiceImpl
implements SimulationService {
    private static final Logger logger = Logger.getLogger(SimulationService.class.getName());
    private final ScheduledExecutorService executor;
    private final SmartFutureCache<LegIdentifier, SimulationResults, SmartFutureCache.EmptyUpdateInterval> cache;
    private final ConcurrentMap<LegIdentifier, TimePoint> cacheReadTimePoints;
    private final RacingEventService racingEventService;
    private final ScheduledExecutorService scheduler;
    private final Duration CACHE_ENTRY_EXPIRY_DURATION = Duration.ONE_MINUTE.times(10L);
    private final HashMap<String, SimulationRaceListener> raceListeners;
    private final HashMap<RaceIdentifier, LegChangeListener> legListeners;
    private final long WAIT_MILLIS = 20000L;

    public SimulationServiceImpl(ScheduledExecutorService executor, final RacingEventService racingEventService) {
        this.cacheReadTimePoints = new ConcurrentHashMap<LegIdentifier, TimePoint>();
        this.executor = executor;
        this.scheduler = executor;
        this.racingEventService = racingEventService;
        if (racingEventService != null) {
            this.raceListeners = new HashMap();
            this.legListeners = new HashMap();
            this.cache = new SmartFutureCache((SmartFutureCache.CacheUpdater)new SmartFutureCache.AbstractCacheUpdater<LegIdentifier, SimulationResults, SmartFutureCache.EmptyUpdateInterval>(){

                public SimulationResults computeCacheUpdate(LegIdentifier key, SmartFutureCache.EmptyUpdateInterval updateInterval) throws Exception {
                    return (SimulationResults)racingEventService.getTrackedRace((RegattaAndRaceIdentifier)key).getTrackedRegatta().callWithCPUMeterWithException(() -> {
                        logger.info("Simulation Started: \"" + key.toString() + "\"");
                        SimulationResults results = SimulationServiceImpl.this.computeSimulationResults(key);
                        logger.info("Simulation Finished: \"" + key.toString() + "\", Results-Version: " + (results == null ? 0L : results.getVersion().asMillis()));
                        return results;
                    }, CPUMeteringType.SIMULATOR.name());
                }
            }, "SmartFutureCache.simulationService (" + racingEventService.toString() + ")");
            this.scheduler.scheduleAtFixedRate(() -> this.expireCacheEntries(), this.CACHE_ENTRY_EXPIRY_DURATION.asMillis(), this.CACHE_ENTRY_EXPIRY_DURATION.asMillis(), TimeUnit.MILLISECONDS);
        } else {
            this.raceListeners = null;
            this.legListeners = null;
            this.cache = null;
        }
    }

    public Iterable<BoatClass> getBoatClassesWithPolarData() {
        return this.racingEventService.getPolarDataService().getAllBoatClassesWithPolarSheetsAvailable();
    }

    public BoatClass getBoatClass(String name) {
        return this.racingEventService.getBaseDomainFactory().getBoatClass(name);
    }

    public PolarDiagram getPolarDiagram(BoatClass boatClass) {
        try {
            return new PolarDiagramGPS(boatClass, this.racingEventService.getPolarDataService());
        }
        catch (SparseSimulationDataException e) {
            logger.warning("Request for polar diagram of boat class " + boatClass.getName() + " failed due to sparse polar data. Was it really returned by getBoatClassesWithPolarData()?");
            return null;
        }
    }

    private void expireCacheEntries() {
        TimePoint expireAllOlderThan = TimePoint.now().minus(this.CACHE_ENTRY_EXPIRY_DURATION);
        Iterator cacheReadTimePointsIterator = this.cacheReadTimePoints.entrySet().iterator();
        while (cacheReadTimePointsIterator.hasNext()) {
            Map.Entry cacheReadTimePointsEntry = cacheReadTimePointsIterator.next();
            if (!((TimePoint)cacheReadTimePointsEntry.getValue()).before(expireAllOlderThan)) continue;
            logger.info("Removing expired simulator result for leg " + cacheReadTimePointsEntry.getKey() + " because it was last accessed at " + cacheReadTimePointsEntry.getValue() + " which is more than " + this.CACHE_ENTRY_EXPIRY_DURATION + " before now.");
            cacheReadTimePointsIterator.remove();
            this.cache.remove((Object)((LegIdentifier)cacheReadTimePointsEntry.getKey()));
        }
    }

    public long getSimulationResultsVersion(LegIdentifier legIdentifier) {
        SimulationResults result = (SimulationResults)this.cache.get((Object)legIdentifier, false);
        long version = result == null ? 0L : result.getVersion().asMillis();
        logger.fine("Simulation Results-Version: " + version);
        return version;
    }

    public SimulationResults getSimulationResults(LegIdentifier legIdentifier) {
        SimulationResults result = (SimulationResults)this.cache.get((Object)legIdentifier, false);
        if (result == null) {
            DynamicTrackedRace trackedRace;
            logger.fine("Simulation Get: Cache Empty: \"" + legIdentifier.toString() + "\"");
            if (!this.raceListeners.containsKey(legIdentifier.getRegattaName())) {
                Regatta regatta = this.racingEventService.getRegattaByName(legIdentifier.getRegattaName());
                final DynamicTrackedRegatta trackedRegatta = this.racingEventService.getTrackedRegatta(regatta);
                final SimulationRaceListener raceListener = new SimulationRaceListener();
                this.raceListeners.put(legIdentifier.getRegattaName(), raceListener);
                trackedRegatta.addRaceListener((RaceListener)raceListener, Optional.empty(), false);
                this.racingEventService.addTrackedRegattaListener(new TrackedRegattaListener(){

                    public void regattaAdded(TrackedRegatta trackedRegatta2) {
                    }

                    public void regattaRemoved(TrackedRegatta tr) {
                        if (trackedRegatta == tr) {
                            tr.removeRaceListener((RaceListener)raceListener);
                        }
                    }
                });
            }
            if (!this.legListeners.containsKey(legIdentifier.getRaceIdentifier()) && (trackedRace = this.racingEventService.getTrackedRace((RegattaAndRaceIdentifier)legIdentifier)) != null) {
                LegChangeListener listener = new LegChangeListener((TrackedRace)trackedRace);
                this.legListeners.put((RaceIdentifier)legIdentifier.getRaceIdentifier(), listener);
                trackedRace.addListener((RaceChangeListener)listener);
            }
            logger.info("Simulation Get: Update Triggered: \"" + legIdentifier.toString() + "\"");
            this.cache.triggerUpdate((Object)legIdentifier, null);
            result = (SimulationResults)this.cache.get((Object)legIdentifier, true);
        }
        if (result == null) {
            logger.fine("Simulation Get: Null-Result: \"" + legIdentifier.toString() + "\"");
        } else {
            this.recordCacheHit(legIdentifier);
        }
        return result;
    }

    private void recordCacheHit(LegIdentifier legIdentifier) {
        this.cacheReadTimePoints.put(legIdentifier, TimePoint.now());
    }

    private List<Position> getLinePositions(Waypoint wayPoint, TimePoint at, TrackedRace trackedRace) {
        ArrayList<Position> line = new ArrayList<Position>();
        if (wayPoint != null) {
            for (Mark lineMark : wayPoint.getMarks()) {
                Position estimatedMarkPosition = trackedRace.getOrCreateTrack(lineMark).getEstimatedPosition(at, false);
                if (estimatedMarkPosition == null) continue;
                line.add(estimatedMarkPosition);
            }
        }
        return line;
    }

    private SimulationResults computeSimulationResults(LegIdentifier legIdentifier) throws InterruptedException, ExecutionException {
        TimePoint simulationStartTime = TimePoint.now();
        DynamicTrackedRace trackedRace = this.racingEventService.getTrackedRace((RegattaAndRaceIdentifier)legIdentifier);
        SimulationResults result = trackedRace != null ? (SimulationResults)trackedRace.getTrackedRegatta().callWithCPUMeterWithException(() -> this.lambda$1((TrackedRace)trackedRace, simulationStartTime, legIdentifier), CPUMeteringType.SIMULATOR.name()) : null;
        return result;
    }

    private PolarDataService getPolarDataService() {
        return this.racingEventService.getPolarDataService();
    }

    public Map<PathType, Path> getAllPaths(SimulationParameters simulationParameters) throws InterruptedException, ExecutionException {
        HashMap<PathType, Path> result = new HashMap<PathType, Path>();
        if (simulationParameters.getBoatPolarDiagram() != null) {
            SimulatorImpl simulator = new SimulatorImpl(simulationParameters);
            Future<Path> taskOmniscient = null;
            if (simulationParameters.showOmniscient()) {
                taskOmniscient = this.executor.submit(() -> SimulationServiceImpl.lambda$3((Simulator)simulator));
            }
            Future<Path> task1TurnerLeft = null;
            Future<Path> task1TurnerRight = null;
            if (simulationParameters.getLegType() != LegType.REACHING) {
                task1TurnerLeft = this.executor.submit(() -> SimulationServiceImpl.lambda$4((Simulator)simulator));
                task1TurnerRight = this.executor.submit(() -> SimulationServiceImpl.lambda$5((Simulator)simulator));
            }
            Future<Path> taskOpportunistLeft = null;
            Future<Path> taskOpportunistRight = null;
            if (simulationParameters.showOpportunist()) {
                taskOpportunistLeft = this.executor.submit(() -> SimulationServiceImpl.lambda$6((Simulator)simulator));
                taskOpportunistRight = this.executor.submit(() -> SimulationServiceImpl.lambda$7((Simulator)simulator));
            }
            Path path1TurnerLeft = null;
            Path path1TurnerRight = null;
            if (simulationParameters.getLegType() != LegType.REACHING) {
                path1TurnerLeft = task1TurnerLeft.get();
                result.put(PathType.ONE_TURNER_LEFT, path1TurnerLeft);
                path1TurnerRight = task1TurnerRight.get();
                result.put(PathType.ONE_TURNER_RIGHT, path1TurnerRight);
            }
            Path pathOpportunistLeft = null;
            Path pathOpportunistRight = null;
            if (simulationParameters.showOpportunist()) {
                pathOpportunistLeft = taskOpportunistLeft.get();
                if (path1TurnerLeft != null && !path1TurnerLeft.getAlgorithmTimedOut() && pathOpportunistLeft.getTurnCount() == 1) {
                    pathOpportunistLeft = path1TurnerLeft;
                }
                result.put(PathType.OPPORTUNIST_LEFT, pathOpportunistLeft);
                pathOpportunistRight = taskOpportunistRight.get();
                if (path1TurnerRight != null && !path1TurnerRight.getAlgorithmTimedOut() && pathOpportunistRight.getTurnCount() == 1) {
                    pathOpportunistRight = path1TurnerRight;
                }
                result.put(PathType.OPPORTUNIST_RIGHT, pathOpportunistRight);
            }
            if (simulationParameters.showOmniscient()) {
                Path pathOmniscient = taskOmniscient.get();
                if (path1TurnerLeft != null && !path1TurnerLeft.getAlgorithmTimedOut() && pathOmniscient.getFinalTime().after(path1TurnerLeft.getFinalTime())) {
                    pathOmniscient = path1TurnerLeft;
                }
                if (path1TurnerRight != null && !path1TurnerRight.getAlgorithmTimedOut() && pathOmniscient.getFinalTime().after(path1TurnerRight.getFinalTime())) {
                    pathOmniscient = path1TurnerRight;
                }
                if (pathOpportunistLeft != null && !pathOpportunistLeft.getAlgorithmTimedOut() && pathOmniscient.getFinalTime().after(pathOpportunistLeft.getFinalTime())) {
                    pathOmniscient = pathOpportunistLeft;
                }
                if (pathOpportunistRight != null && !pathOpportunistRight.getAlgorithmTimedOut() && pathOmniscient.getFinalTime().after(pathOpportunistRight.getFinalTime())) {
                    pathOmniscient = pathOpportunistRight;
                }
                result.put(PathType.OMNISCIENT, pathOmniscient);
            }
        }
        return result;
    }

    public Map<PathType, Path> getAllPathsEvenTimed(SimulationParameters simuPars, long millisecondsStep) throws InterruptedException, ExecutionException {
        TreeMap<PathType, Path> allTimedPaths = new TreeMap<PathType, Path>();
        Map<PathType, Path> allPaths = this.getAllPaths(simuPars);
        for (Map.Entry<PathType, Path> entry : allPaths.entrySet()) {
            PathType pathType = entry.getKey();
            Path pathValue = entry.getValue();
            if (pathValue == null) continue;
            allTimedPaths.put(pathType, pathValue.getEvenTimedPath(millisecondsStep));
        }
        return allTimedPaths;
    }

    private /* synthetic */ SimulationResults lambda$1(TrackedRace trackedRace, TimePoint timePoint, LegIdentifier legIdentifier) throws ExecutionException {
        PolarDiagramGPS polarDiagram;
        List<Position> line;
        Duration legDuration;
        TimePoint endTimePoint;
        TimePoint startTimePoint;
        boolean isLive = trackedRace.isLive(timePoint);
        int zeroBasedlegNumber = legIdentifier.getOneBasedLegIndex() - 1;
        Course raceCourse = trackedRace.getRace().getCourse();
        Leg leg = (Leg)raceCourse.getLegs().get(zeroBasedlegNumber);
        Waypoint fromWaypoint = leg.getFrom();
        Waypoint toWaypoint = leg.getTo();
        MarkPassing toMarkPassing = (MarkPassing)Util.first((Iterable)trackedRace.getMarkPassingsInOrder(toWaypoint));
        if (toMarkPassing != null) {
            Optional<MarkPassing> fromMarkPassing = trackedRace.getMarkPassings(toMarkPassing.getCompetitor()).stream().filter(mp -> mp.getWaypoint() == fromWaypoint).findAny();
            if (fromMarkPassing.isPresent()) {
                startTimePoint = fromMarkPassing.get().getTimePoint();
                endTimePoint = toMarkPassing.getTimePoint();
                legDuration = startTimePoint.until(endTimePoint);
            } else {
                legDuration = Duration.NULL;
                if (isLive && zeroBasedlegNumber == 0) {
                    endTimePoint = timePoint;
                    startTimePoint = timePoint;
                } else {
                    startTimePoint = null;
                    endTimePoint = null;
                }
            }
        } else {
            legDuration = Duration.NULL;
            startTimePoint = timePoint;
            endTimePoint = timePoint;
        }
        Position startPosition = null;
        List<Position> startLine = null;
        Position endPosition = null;
        List<Position> endLine = null;
        if (startTimePoint != null) {
            startPosition = trackedRace.getApproximatePosition(fromWaypoint, startTimePoint);
            line = this.getLinePositions(fromWaypoint, startTimePoint, trackedRace);
            if (line.size() == 2) {
                startLine = line;
            }
        }
        if (endTimePoint != null) {
            endPosition = trackedRace.getApproximatePosition(toWaypoint, endTimePoint);
            line = this.getLinePositions(toWaypoint, endTimePoint, trackedRace);
            if (line.size() == 2) {
                endLine = line;
            }
        } else if (startTimePoint != null) {
            endPosition = trackedRace.getApproximatePosition(toWaypoint, startTimePoint);
        }
        LegType legType = null;
        if (startTimePoint != null) {
            try {
                legType = trackedRace.getTrackedLeg(leg).getLegType(startTimePoint);
            }
            catch (NoWindException e) {
                return null;
            }
        } else {
            return null;
        }
        WindFieldTrackedRaceImpl windField = new WindFieldTrackedRaceImpl(trackedRace);
        MillisecondsDurationImpl timeStep = new MillisecondsDurationImpl(15000L);
        windField.generate(startTimePoint, null, (Duration)timeStep);
        ArrayList<Position> course = new ArrayList<Position>();
        course.add(startPosition);
        course.add(endPosition);
        BoatClass boatClass = trackedRace.getRace().getBoatClass();
        PolarDataService polarDataService = this.getPolarDataService();
        try {
            polarDiagram = new PolarDiagramGPS(boatClass, polarDataService);
        }
        catch (SparseSimulationDataException e) {
            polarDiagram = null;
        }
        Map<PathType, Path> paths = null;
        if (polarDiagram != null) {
            double simuStepSeconds = startPosition.getDistance(endPosition).getNauticalMiles() / polarDiagram.getAvgSpeedInKnots() * 3600.0 / 100.0;
            MillisecondsDurationImpl simuStep = new MillisecondsDurationImpl(Math.round(simuStepSeconds) * 1000L);
            SimulationParametersImpl simulationPars = new SimulationParametersImpl(course, startLine, endLine, (PolarDiagram)polarDiagram, (WindFieldGenerator)windField, (Duration)simuStep, 'e', true, true, legType);
            try {
                paths = this.getAllPathsEvenTimed((SimulationParameters)simulationPars, timeStep.asMillis());
            }
            catch (InterruptedException e) {
                throw new ExecutionException(e);
            }
        }
        return new SimulationResults(startTimePoint, (Duration)timeStep, legDuration, startPosition, endPosition, paths, null, TimePoint.now());
    }

    private static /* synthetic */ Path lambda$3(Simulator simulator) throws Exception {
        return simulator.getPath(PathType.OMNISCIENT);
    }

    private static /* synthetic */ Path lambda$4(Simulator simulator) throws Exception {
        return simulator.getPath(PathType.ONE_TURNER_LEFT);
    }

    private static /* synthetic */ Path lambda$5(Simulator simulator) throws Exception {
        return simulator.getPath(PathType.ONE_TURNER_RIGHT);
    }

    private static /* synthetic */ Path lambda$6(Simulator simulator) throws Exception {
        return simulator.getPath(PathType.OPPORTUNIST_LEFT);
    }

    private static /* synthetic */ Path lambda$7(Simulator simulator) throws Exception {
        return simulator.getPath(PathType.OPPORTUNIST_RIGHT);
    }

    private class LegChangeListener
    extends AbstractRaceChangeListener {
        private final TrackedRace trackedRace;
        private final ConcurrentMap<LegIdentifier, Boolean> cacheUpdateTriggerScheduledForLeg;

        public LegChangeListener(TrackedRace trackedRace) {
            this.trackedRace = trackedRace;
            this.cacheUpdateTriggerScheduledForLeg = new ConcurrentHashMap<LegIdentifier, Boolean>();
        }

        public void startOfRaceChanged(TimePoint oldStartOfRace, TimePoint newStartOfRace) {
            this.scheduleUpdateTriggerForLegIfCachedAndNoUpdateScheduled(0, 0L);
        }

        public void finishedTimeChanged(TimePoint oldFinishedTime, TimePoint newFinishedTime) {
        }

        public void windSourcesToExcludeChanged(Iterable<? extends WindSource> windSourcesToExclude) {
            this.scheduleUpdateTriggerForLegIfCachedAndNoUpdateScheduled(0, 0L);
        }

        public void startOfTrackingChanged(TimePoint oldStartOfTracking, TimePoint newStartOfTracking) {
        }

        public void endOfTrackingChanged(TimePoint oldEndOfTracking, TimePoint newEndOfTracking) {
        }

        public void startTimeReceivedChanged(TimePoint startTimeReceived) {
        }

        public void markPositionChanged(GPSFix fix, Mark mark, boolean firstInTrack, AddResult addedOrReplaced) {
            this.defaultAction();
        }

        public void windDataReceived(Wind wind, WindSource windSource) {
            this.defaultAction();
        }

        public void windDataRemoved(Wind wind, WindSource windSource) {
            this.defaultAction();
        }

        public void windAveragingChanged(long oldMillisecondsOverWhichToAverage, long newMillisecondsOverWhichToAverage) {
            this.defaultAction();
        }

        public void competitorPositionChanged(GPSFixMoving fix, Competitor item, AddResult addedOrReplaced) {
        }

        public void markPassingReceived(Competitor competitor, Map<Waypoint, MarkPassing> oldMarkPassings, Iterable<MarkPassing> markPassings) {
            Util.Pair<Integer, Integer> firstAndLastZeroBasedNumberOfLegWithChangedAdjacendMarkPassing = this.getFirstAndLastZeroBasedNumberOfLegWithChangedAdjacendMarkPassing(oldMarkPassings, markPassings);
            if (firstAndLastZeroBasedNumberOfLegWithChangedAdjacendMarkPassing != null) {
                this.scheduleUpdateTriggerForLegIfCachedAndNoUpdateScheduled((Integer)firstAndLastZeroBasedNumberOfLegWithChangedAdjacendMarkPassing.getA(), (Integer)firstAndLastZeroBasedNumberOfLegWithChangedAdjacendMarkPassing.getB(), 20000L);
            }
        }

        private Util.Pair<Integer, Integer> getFirstAndLastZeroBasedNumberOfLegWithChangedAdjacendMarkPassing(Map<Waypoint, MarkPassing> oldMarkPassings, Iterable<MarkPassing> markPassings) {
            Util.Pair result;
            Course course = this.trackedRace.getRace().getCourse();
            HashSet<Integer> affectedZeroBasedWaypointIndexes = new HashSet<Integer>();
            HashSet<Waypoint> removed = new HashSet<Waypoint>(oldMarkPassings.keySet());
            for (MarkPassing newMarkPassing : markPassings) {
                removed.remove(newMarkPassing.getWaypoint());
                MarkPassing oldMarkPassing = oldMarkPassings.get(newMarkPassing.getWaypoint());
                if (oldMarkPassing != null && oldMarkPassing.getTimePoint().equals(newMarkPassing.getTimePoint())) continue;
                affectedZeroBasedWaypointIndexes.add(course.getIndexOfWaypoint(newMarkPassing.getWaypoint()));
            }
            removed.forEach(waypointWithMarkPassingRemoved -> {
                boolean bl = affectedZeroBasedWaypointIndexes.add(course.getIndexOfWaypoint(waypointWithMarkPassingRemoved));
            });
            if (affectedZeroBasedWaypointIndexes.isEmpty()) {
                result = null;
            } else {
                int min = (Integer)Collections.min(affectedZeroBasedWaypointIndexes);
                int max = (Integer)Collections.max(affectedZeroBasedWaypointIndexes);
                result = new Util.Pair((Object)(min == 0 ? 0 : min - 1), (Object)(max == course.getNumberOfWaypoints() - 1 ? max : max + 1));
            }
            return result;
        }

        public void speedAveragingChanged(long oldMillisecondsOverWhichToAverage, long newMillisecondsOverWhichToAverage) {
        }

        public void delayToLiveChanged(long delayToLiveInMillis) {
        }

        public void waypointAdded(int zeroBasedIndex, Waypoint waypointThatGotAdded) {
            int numberOfWaypoints = this.trackedRace.getRace().getCourse().getNumberOfWaypoints();
            this.scheduleUpdateTriggerForLegIfCachedAndNoUpdateScheduled(zeroBasedIndex, numberOfWaypoints, 0L);
        }

        public void waypointRemoved(int zeroBasedIndex, Waypoint waypointThatGotRemoved) {
            int numberOfWaypoints = this.trackedRace.getRace().getCourse().getNumberOfWaypoints();
            this.scheduleUpdateTriggerForLegIfCachedAndNoUpdateScheduled(zeroBasedIndex, numberOfWaypoints, 0L);
        }

        protected void defaultAction() {
            this.scheduleUpdateTriggerForLegIfCachedAndNoUpdateScheduled(0, this.trackedRace.getRace().getCourse().getNumberOfWaypoints(), 20000L);
        }

        private void scheduleUpdateTriggerForLegIfCachedAndNoUpdateScheduled(int fromZeroBasedLegIndex, int toZeroBasedLegIndexExclusive, long schedulingDelayMillis) {
            int zeroBasedLegNumber = fromZeroBasedLegIndex;
            while (zeroBasedLegNumber < toZeroBasedLegIndexExclusive) {
                this.scheduleUpdateTriggerForLegIfCachedAndNoUpdateScheduled(zeroBasedLegNumber, 20000L);
                ++zeroBasedLegNumber;
            }
        }

        private void scheduleUpdateTriggerForLegIfCachedAndNoUpdateScheduled(int zeroBasedLegNumber, long schedulingDelayMillis) {
            LegIdentifierImpl key = new LegIdentifierImpl(this.trackedRace.getRaceIdentifier(), zeroBasedLegNumber + 1);
            this.scheduleUpdateTriggerForLegIfCachedAndNoUpdateScheduledYet((LegIdentifier)key, 20000L);
        }

        private void scheduleUpdateTriggerForLegIfCachedAndNoUpdateScheduledYet(LegIdentifier cacheKey, long schedulingDelayMillis) {
            this.cacheUpdateTriggerScheduledForLeg.computeIfAbsent(cacheKey, ck -> {
                Boolean result;
                if (SimulationServiceImpl.this.cache.get((Object)cacheKey, false) != null) {
                    SimulationServiceImpl.this.scheduler.schedule(() -> this.triggerUpdate(cacheKey), schedulingDelayMillis, TimeUnit.MILLISECONDS);
                    result = true;
                } else {
                    result = null;
                }
                return result;
            });
        }

        private void triggerUpdate(LegIdentifier legIdentifier) {
            this.cacheUpdateTriggerScheduledForLeg.remove(legIdentifier);
            logger.info("Simulation Scheduled Update Triggered: \"" + legIdentifier.toString() + "\"");
            SimulationServiceImpl.this.cache.triggerUpdate((Object)legIdentifier, null);
        }
    }

    private class SimulationRaceListener
    implements RaceListener {
        private SimulationRaceListener() {
        }

        public void raceAdded(TrackedRace trackedRace) {
        }

        public void raceRemoved(TrackedRace trackedRace) {
            RegattaAndRaceIdentifier raceIdentifier = trackedRace.getRaceIdentifier();
            LegChangeListener listener = (LegChangeListener)((Object)SimulationServiceImpl.this.legListeners.get(raceIdentifier));
            if (listener != null) {
                trackedRace.removeListener((RaceChangeListener)listener);
            }
            int legNumber = 1;
            Iterator iterator = trackedRace.getTrackedLegs().iterator();
            while (iterator.hasNext()) {
                LegIdentifierImpl key = new LegIdentifierImpl(raceIdentifier, legNumber);
                SimulationServiceImpl.this.cache.remove((Object)key);
                ++legNumber;
                iterator.next();
            }
            SimulationServiceImpl.this.legListeners.remove(raceIdentifier);
        }
    }
}

