/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.security;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorAndBoatStore;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Sideline;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.domain.base.impl.DynamicCompetitorWithBoat;
import com.sap.sailing.domain.base.impl.DynamicTeam;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaNameAndRaceName;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprintRegistry;
import com.sap.sailing.domain.racelog.RaceLogAndTrackedRaceResolver;
import com.sap.sailing.domain.tracking.DynamicRaceDefinitionSet;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.RaceTrackingHandler;
import com.sap.sailing.domain.tracking.TrackedRegatta;
import com.sap.sailing.domain.tracking.TrackingConnectorInfo;
import com.sap.sailing.domain.tracking.WindStore;
import com.sap.sse.common.Color;
import com.sap.sse.common.Duration;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.UserGroup;
import com.sap.sse.util.ThreadLocalTransporter;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.SubjectThreadState;

public class PermissionAwareRaceTrackingHandler
extends RaceTrackingHandler.DefaultRaceTrackingHandler {
    private final Subject subject;
    private final UserGroup defaultTenant;
    private final SecurityService securityService;

    public PermissionAwareRaceTrackingHandler(SecurityService securityService) {
        this.securityService = securityService;
        this.subject = SecurityUtils.getSubject();
        this.defaultTenant = securityService.getDefaultTenantForCurrentUser();
    }

    private <T> T setOwnershipForRace(RegattaAndRaceIdentifier regattaAndRaceIdentifier, Callable<T> raceCreationAction) {
        SubjectThreadState subjectThreadState = new SubjectThreadState(this.subject);
        subjectThreadState.bind();
        try {
            Object object = this.securityService.doWithTemporaryDefaultTenant(this.defaultTenant, () -> this.securityService.setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.TRACKED_RACE, regattaAndRaceIdentifier.getTypeRelativeObjectIdentifier(), regattaAndRaceIdentifier.toString(), raceCreationAction));
            return (T)object;
        }
        finally {
            subjectThreadState.restore();
        }
    }

    private void createOwnershipIfMissing(QualifiedObjectIdentifier identifier) {
        if (this.securityService.getOwnership(identifier) == null) {
            SubjectThreadState subjectThreadState = new SubjectThreadState(this.subject);
            subjectThreadState.bind();
            try {
                this.securityService.setOwnership(identifier, this.securityService.getCurrentUser(), this.defaultTenant);
            }
            finally {
                subjectThreadState.restore();
            }
        }
    }

    public DynamicTrackedRace createTrackedRace(TrackedRegatta trackedRegatta, RaceDefinition raceDefinition, Iterable<Sideline> sidelines, WindStore windStore, long delayToLiveInMillis, long millisecondsOverWhichToAverageWind, long millisecondsOverWhichToAverageSpeed, DynamicRaceDefinitionSet raceDefinitionSetToUpdate, boolean useMarkPassingCalculator, RaceLogAndTrackedRaceResolver raceLogResolver, Optional<ThreadLocalTransporter> threadLocalTransporter, TrackingConnectorInfo trackingConnectorInfo, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry) {
        return this.setOwnershipForRace((RegattaAndRaceIdentifier)new RegattaNameAndRaceName(trackedRegatta.getRegatta().getName(), raceDefinition.getName()), () -> super.createTrackedRace(trackedRegatta, raceDefinition, sidelines, windStore, delayToLiveInMillis, millisecondsOverWhichToAverageWind, millisecondsOverWhichToAverageSpeed, raceDefinitionSetToUpdate, useMarkPassingCalculator, raceLogResolver, threadLocalTransporter, trackingConnectorInfo, markPassingRaceFingerprintRegistry));
    }

    public RaceDefinition createRaceDefinition(Regatta regatta, String name, Course course, BoatClass boatClass, Map<Competitor, Boat> competitorsAndTheirBoats, Serializable id) {
        return this.setOwnershipForRace((RegattaAndRaceIdentifier)new RegattaNameAndRaceName(regatta.getName(), name), () -> super.createRaceDefinition(regatta, name, course, boatClass, competitorsAndTheirBoats, id));
    }

    public DynamicCompetitor getOrCreateCompetitor(CompetitorAndBoatStore competitorStore, Serializable competitorId, String name, String shortName, Color displayColor, String email, URI flagImageURI, DynamicTeam team, Double timeOnTimeFactor, Duration timeOnDistanceAllowancePerNauticalMile, String searchTag) {
        DynamicCompetitor competitor = competitorStore.getOrCreateCompetitor(competitorId, name, shortName, displayColor, email, flagImageURI, team, timeOnTimeFactor, timeOnDistanceAllowancePerNauticalMile, searchTag, true);
        this.createOwnershipIfMissing(competitor.getIdentifier());
        return competitor;
    }

    public DynamicCompetitorWithBoat getOrCreateCompetitorWithBoat(CompetitorAndBoatStore competitorStore, Serializable competitorId, String name, String shortName, Color displayColor, String email, URI flagImageURI, DynamicTeam team, Double timeOnTimeFactor, Duration timeOnDistanceAllowancePerNauticalMile, String searchTag, DynamicBoat boat) {
        DynamicCompetitorWithBoat competitorWithBoat = competitorStore.getOrCreateCompetitorWithBoat(competitorId, name, shortName, displayColor, email, flagImageURI, team, timeOnTimeFactor, timeOnDistanceAllowancePerNauticalMile, searchTag, boat, true);
        this.createOwnershipIfMissing(competitorWithBoat.getIdentifier());
        this.createOwnershipIfMissing(competitorWithBoat.getBoat().getIdentifier());
        return competitorWithBoat;
    }

    public DynamicBoat getOrCreateBoat(CompetitorAndBoatStore competitorAndBoatStore, Serializable id, String name, BoatClass boatClass, String sailId, Color color) {
        DynamicBoat boat = competitorAndBoatStore.getOrCreateBoat(id, name, boatClass, sailId, color, true);
        this.createOwnershipIfMissing(boat.getIdentifier());
        return boat;
    }
}

