/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.impl;

import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.media.MediaTrack;
import com.sap.sse.common.TimePoint;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class MediaLibrary {
    private final Map<MediaTrack, MediaTrack> mediaTracksByDbId = new HashMap<MediaTrack, MediaTrack>();
    private final ConcurrentMap<RegattaAndRaceIdentifier, Set<MediaTrack>> mediaTracksByRace = new ConcurrentHashMap<RegattaAndRaceIdentifier, Set<MediaTrack>>();
    private final NamedReentrantReadWriteLock lock = new NamedReentrantReadWriteLock(MediaLibrary.class.getName(), false);

    MediaLibrary() {
    }

    Collection<MediaTrack> findMediaTracksForRace(RegattaAndRaceIdentifier race) {
        if (race != null) {
            LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
            try {
                Set mediaTracksForRace = (Set)this.mediaTracksByRace.get(race);
                if (mediaTracksForRace == null) {
                    List<MediaTrack> list = Collections.emptyList();
                    return list;
                }
                ArrayList<MediaTrack> arrayList = new ArrayList<MediaTrack>(mediaTracksForRace);
                return arrayList;
            }
            finally {
                LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
            }
        }
        return Collections.emptySet();
    }

    Collection<MediaTrack> findMediaTracksInTimeRange(TimePoint startTime, TimePoint endTime) {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        try {
            ArrayList<MediaTrack> result = new ArrayList<MediaTrack>();
            for (MediaTrack mediaTrack : this.mediaTracksByDbId.values()) {
                if (!mediaTrack.overlapsWith(startTime, endTime)) continue;
                result.add(mediaTrack);
            }
            ArrayList<MediaTrack> arrayList = result;
            return arrayList;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }
    }

    public Collection<MediaTrack> findLiveMediaTracks() {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        try {
            ArrayList<MediaTrack> result = new ArrayList<MediaTrack>();
            for (MediaTrack mediaTrack : this.mediaTracksByDbId.values()) {
                if (mediaTrack.duration != null) continue;
                result.add(mediaTrack);
            }
            ArrayList<MediaTrack> arrayList = result;
            return arrayList;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }
    }

    void addMediaTrack(MediaTrack mediaTrack) {
        this.addMediaTracks(Collections.singleton(mediaTrack));
    }

    void addMediaTracks(Iterable<MediaTrack> mediaTracks) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            for (MediaTrack mediaTrack : mediaTracks) {
                this.mediaTracksByDbId.put(mediaTrack, mediaTrack);
                this.updateMapByRace_Add(mediaTrack);
            }
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
    }

    void deleteMediaTrack(MediaTrack mediaTrackToBeDeleted) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            MediaTrack deletedMediaTrack = this.resolveClone(mediaTrackToBeDeleted);
            this.mediaTracksByDbId.remove(deletedMediaTrack);
            this.updateMapByRace_Remove(deletedMediaTrack);
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
    }

    void titleChanged(MediaTrack changedMediaTrack) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            MediaTrack mediaTrack = this.resolveClone(changedMediaTrack);
            if (mediaTrack != null) {
                mediaTrack.title = changedMediaTrack.title;
            }
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
    }

    void urlChanged(MediaTrack changedMediaTrack) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            MediaTrack mediaTrack = this.resolveClone(changedMediaTrack);
            if (mediaTrack != null) {
                mediaTrack.url = changedMediaTrack.url;
            }
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
    }

    void mimeTypeChanged(MediaTrack changedMediaTrack) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            MediaTrack mediaTrack = this.resolveClone(changedMediaTrack);
            if (mediaTrack != null) {
                mediaTrack.mimeType = changedMediaTrack.mimeType;
            }
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
    }

    void startTimeChanged(MediaTrack changedMediaTrack) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            MediaTrack mediaTrack = this.resolveClone(changedMediaTrack);
            if (mediaTrack != null) {
                mediaTrack.startTime = changedMediaTrack.startTime;
            }
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
    }

    void durationChanged(MediaTrack changedMediaTrack) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            MediaTrack mediaTrack = this.resolveClone(changedMediaTrack);
            if (mediaTrack != null) {
                mediaTrack.duration = changedMediaTrack.duration;
            }
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
    }

    void assignedRacesChanged(MediaTrack changedMediaTrack) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            MediaTrack mediaTrack = this.resolveClone(changedMediaTrack);
            if (mediaTrack != null) {
                this.updateMapByRace_Remove(mediaTrack);
                mediaTrack.assignedRaces.clear();
                if (changedMediaTrack.assignedRaces != null) {
                    mediaTrack.assignedRaces.addAll(changedMediaTrack.assignedRaces);
                }
                this.updateMapByRace_Add(mediaTrack);
            }
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
    }

    private MediaTrack resolveClone(MediaTrack mediaTrackClone) {
        MediaTrack mediaTrack = this.mediaTracksByDbId.get(mediaTrackClone);
        return mediaTrack;
    }

    private void updateMapByRace_Add(MediaTrack mediaTrack) {
        assert (this.lock.isWriteLocked());
        if (mediaTrack.assignedRaces != null) {
            for (RegattaAndRaceIdentifier assignedRace : mediaTrack.assignedRaces) {
                HashSet<MediaTrack> mediaTracks = (HashSet<MediaTrack>)this.mediaTracksByRace.get(assignedRace);
                if (mediaTracks == null) {
                    mediaTracks = new HashSet<MediaTrack>();
                    this.mediaTracksByRace.put(assignedRace, mediaTracks);
                }
                mediaTracks.add(mediaTrack);
            }
        }
    }

    private void updateMapByRace_Remove(MediaTrack mediaTrack) {
        assert (this.lock.isWriteLocked());
        for (RegattaAndRaceIdentifier assignedRace : mediaTrack.assignedRaces) {
            Set mediaTracks = (Set)this.mediaTracksByRace.get(assignedRace);
            if (mediaTracks == null) continue;
            mediaTracks.remove(mediaTrack);
            if (mediaTracks.size() != 0) continue;
            this.mediaTracksByRace.remove(assignedRace);
        }
    }

    Collection<MediaTrack> allTracks() {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        try {
            ArrayList<MediaTrack> arrayList = new ArrayList<MediaTrack>(this.mediaTracksByDbId.values());
            return arrayList;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }
    }

    void serialize(ObjectOutputStream stream) throws IOException {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        try {
            stream.writeObject(new ArrayList<MediaTrack>(this.mediaTracksByDbId.values()));
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }
    }

    void deserialize(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        this.addMediaTracks((Collection)stream.readObject());
    }

    public void clear() {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            this.mediaTracksByDbId.clear();
            this.mediaTracksByRace.clear();
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
    }

    public MediaTrack lookupMediaTrack(MediaTrack mediaTrack) {
        return this.resolveClone(mediaTrack);
    }
}

