/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.impl;

import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;

public class ExtenderBundleTracker
extends BundleTracker<Bundle> {
    private final Logger logger = Logger.getLogger(ExtenderBundleTracker.class.getName());
    private static int allBundleStatesMask = 63;

    public ExtenderBundleTracker(BundleContext context) {
        super(context, allBundleStatesMask, null);
    }

    public Bundle addingBundle(Bundle bundle, BundleEvent event) {
        String symbolicName = bundle.getSymbolicName();
        this.logger.info(String.valueOf(symbolicName) + " " + this.getBundleStateAsText(event));
        return bundle;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Bundle object) {
        String trackManifestEntry;
        String symbolicName = bundle.getSymbolicName();
        this.logger.info(String.valueOf(symbolicName) + " " + this.getBundleStateAsText(event));
        if (event != null && event.getType() == 256) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            StringBuffer b = new StringBuffer();
            StackTraceElement[] stackTraceElementArray = stackTrace;
            int n = stackTrace.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement traceElement = stackTraceElementArray[n2];
                b.append(String.valueOf(traceElement.toString()) + "\n");
                ++n2;
            }
            this.logger.severe(b.toString());
        }
        if ((trackManifestEntry = (String)bundle.getHeaders().get("TrackLifecycle")) != null) {
            this.trackLifecycle(bundle, event);
        }
    }

    private void trackLifecycle(Bundle bundle, BundleEvent event) {
        if (event != null) {
            switch (event.getType()) {
                case 256: {
                    this.logger.severe("Bundle " + bundle.getSymbolicName() + " STOPPING");
                    this.logger.severe("--- " + event);
                    break;
                }
                case 4: {
                    this.logger.severe("Bundle " + bundle.getSymbolicName() + " STOPPED");
                    this.logger.severe("--- " + event);
                }
            }
        }
    }

    private String getBundleStateAsText(BundleEvent event) {
        String bundleState = "";
        if (event != null) {
            switch (event.getType()) {
                case 1: {
                    bundleState = "INSTALLED";
                    break;
                }
                case 32: {
                    bundleState = "RESOLVED";
                    break;
                }
                case 512: {
                    bundleState = "LAZY_ACTIVATION";
                    break;
                }
                case 128: {
                    bundleState = "STARTING";
                    break;
                }
                case 2: {
                    bundleState = "STARTED";
                    break;
                }
                case 256: {
                    bundleState = "STOPPING";
                    break;
                }
                case 4: {
                    bundleState = "STOPPED";
                    break;
                }
                case 8: {
                    bundleState = "UPDATED";
                    break;
                }
                case 64: {
                    bundleState = "UNRESOLVED";
                    break;
                }
                case 16: {
                    bundleState = "UNINSTALLED";
                }
            }
        }
        return bundleState;
    }
}

