/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tractracadapter.persistence.impl;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.sap.sailing.domain.tractracadapter.DomainFactory;
import com.sap.sailing.domain.tractracadapter.TracTracConfiguration;
import com.sap.sailing.domain.tractracadapter.persistence.DomainObjectFactory;
import com.sap.sailing.domain.tractracadapter.persistence.impl.CollectionNames;
import com.sap.sailing.domain.tractracadapter.persistence.impl.FieldNames;
import com.sap.sailing.domain.tractracadapter.persistence.impl.MongoObjectFactoryImpl;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;

public class DomainObjectFactoryImpl
implements DomainObjectFactory {
    private static final Logger logger = Logger.getLogger(DomainObjectFactoryImpl.class.getName());
    private final MongoDatabase database;
    private final DomainFactory tracTracDomainFactory;

    public DomainObjectFactoryImpl(MongoDatabase db, DomainFactory tracTracDomainFactory) {
        this.database = db;
        this.tracTracDomainFactory = tracTracDomainFactory;
    }

    @Override
    public Iterable<TracTracConfiguration> getTracTracConfigurations() {
        ArrayList<TracTracConfiguration> result = new ArrayList<TracTracConfiguration>();
        try {
            MongoCollection ttConfigs = this.database.getCollection(CollectionNames.TRACTRAC_CONFIGURATIONS.name());
            for (Document o : ttConfigs.find()) {
                TracTracConfiguration ttConfig = this.loadTracTracConfiguration(o);
                result.add(ttConfig);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load recorded TracTrac configurations. Check MongoDB settings.");
            logger.log(Level.SEVERE, "getTracTracConfigurations", e);
        }
        return result;
    }

    @Override
    public TracTracConfiguration getTracTracConfiguration(String jsonUrl) {
        MongoCollection ttConfigs = this.database.getCollection(CollectionNames.TRACTRAC_CONFIGURATIONS.name());
        return this.loadTracTracConfiguration((Document)ttConfigs.find((Bson)MongoObjectFactoryImpl.getMongoQueryForJsonUrl(jsonUrl)).first());
    }

    private TracTracConfiguration loadTracTracConfiguration(Document object) {
        boolean needsUpdate;
        Object courseDesignUpdateUriObject = object.get((Object)FieldNames.TT_CONFIG_COURSE_DESIGN_UPDATE_URI.name());
        Object tracTracUsernameObject = object.get((Object)FieldNames.TT_CONFIG_TRACTRAC_USERNAME.name());
        Object tracTracPasswordObject = object.get((Object)FieldNames.TT_CONFIG_TRACTRAC_PASSWORD.name());
        String courseDesignUpdateUri = courseDesignUpdateUriObject == null ? "" : (String)courseDesignUpdateUriObject;
        String tracTracUsername = tracTracUsernameObject == null ? "" : (String)tracTracUsernameObject;
        String tracTracPassword = tracTracPasswordObject == null ? "" : (String)tracTracPasswordObject;
        String creatorName = (String)object.get((Object)FieldNames.TT_CONFIG_CREATOR_NAME.name());
        String jsonURL = (String)object.get((Object)FieldNames.TT_CONFIG_JSON_URL.name());
        boolean bl = needsUpdate = creatorName == null;
        if (needsUpdate) {
            creatorName = "admin";
        }
        TracTracConfiguration loadedTracTracConfiguration = this.tracTracDomainFactory.createTracTracConfiguration(creatorName, (String)object.get((Object)FieldNames.TT_CONFIG_NAME.name()), jsonURL, (String)object.get((Object)FieldNames.TT_CONFIG_LIVE_DATA_URI.name()), (String)object.get((Object)FieldNames.TT_CONFIG_STORED_DATA_URI.name()), courseDesignUpdateUri, tracTracUsername, tracTracPassword);
        if (needsUpdate) {
            new MongoObjectFactoryImpl(this.database).deleteTracTracConfiguration(null, jsonURL);
            new MongoObjectFactoryImpl(this.database).createTracTracConfiguration(loadedTracTracConfiguration);
        }
        return loadedTracTracConfiguration;
    }
}

