/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.preprocessing;

import com.sap.sailing.domain.maneuverdetection.CompleteManeuverCurveWithEstimationData;
import com.sap.sailing.windestimation.data.CompetitorTrackWithEstimationData;
import com.sap.sailing.windestimation.data.ManeuverForEstimation;
import com.sap.sailing.windestimation.data.RaceWithEstimationData;
import com.sap.sailing.windestimation.data.transformer.CompetitorTrackTransformer;
import com.sap.sailing.windestimation.preprocessing.CompetitorTrackFilteringImpl;
import com.sap.sailing.windestimation.preprocessing.ManeuverFilteringImpl;
import com.sap.sailing.windestimation.preprocessing.RacePreprocessingPipeline;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RaceElementsFilteringPreprocessingPipelineImpl
implements RacePreprocessingPipeline<CompleteManeuverCurveWithEstimationData, ManeuverForEstimation> {
    private final CompetitorTrackTransformer<CompleteManeuverCurveWithEstimationData, ManeuverForEstimation> maneuverForEstimationTransformer;
    private final CompetitorTrackFilteringImpl competitorTrackFiltering = new CompetitorTrackFilteringImpl();
    private final ManeuverFilteringImpl maneuverFiltering = new ManeuverFilteringImpl();
    private final boolean enableCompetitorTrackFiltering;

    public RaceElementsFilteringPreprocessingPipelineImpl(CompetitorTrackTransformer<CompleteManeuverCurveWithEstimationData, ManeuverForEstimation> maneuverForEstimationTransformer) {
        this(true, maneuverForEstimationTransformer);
    }

    public RaceElementsFilteringPreprocessingPipelineImpl(boolean enableCompetitorTrackFiltering, CompetitorTrackTransformer<CompleteManeuverCurveWithEstimationData, ManeuverForEstimation> maneuverForEstimationTransformer) {
        this.enableCompetitorTrackFiltering = enableCompetitorTrackFiltering;
        this.maneuverForEstimationTransformer = maneuverForEstimationTransformer;
    }

    @Override
    public RaceWithEstimationData<ManeuverForEstimation> preprocessInput(RaceWithEstimationData<CompleteManeuverCurveWithEstimationData> race) {
        Stream stream = race.getCompetitorTracks().stream();
        if (this.enableCompetitorTrackFiltering) {
            stream = stream.filter(this.competitorTrackFiltering);
        }
        List competitorTracks = stream.map(competitorTrack -> competitorTrack.constructWithElements(this.maneuverForEstimationTransformer.apply((CompetitorTrackWithEstimationData<CompleteManeuverCurveWithEstimationData>)competitorTrack).getElements().stream().filter(this.maneuverFiltering).collect(Collectors.toList()))).collect(Collectors.toList());
        RaceWithEstimationData<ManeuverForEstimation> newRace = race.constructWithElements(competitorTracks);
        return newRace;
    }
}

