/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.model.store;

import com.sap.sailing.windestimation.model.ModelContext;
import com.sap.sailing.windestimation.model.exception.ModelPersistenceException;
import com.sap.sailing.windestimation.model.store.ModelDomainType;
import com.sap.sailing.windestimation.model.store.ModelSerializationStrategy;
import com.sap.sailing.windestimation.model.store.ModelSerializationStrategyType;
import com.sap.sailing.windestimation.model.store.ModelStore;
import com.sap.sailing.windestimation.model.store.PersistableModel;

public abstract class AbstractModelStoreImpl
implements ModelStore {
    private static final String NAME_PART_DELIMITER = ".";
    protected static final String CONTEXT_NAME_PREFIX = "modelFor";
    protected static final String PERSISTENCE_KEY_SUFFIX = ".clf";

    protected <T extends PersistableModel<?, ?>> ModelSerializationStrategy checkAndGetModelSerializationStrategy(T trainedModel) throws ModelPersistenceException {
        ModelSerializationStrategy modelSerializationStrategy = trainedModel.getModelSerializationStrategyType().getModelSerializationStrategy();
        if (modelSerializationStrategy == null) {
            throw new ModelPersistenceException("Model of type " + trainedModel.getClass().getSimpleName() + " has no serialization strategy");
        }
        return modelSerializationStrategy;
    }

    protected String getPersistenceKey(PersistableModel<?, ?> persistableModel) {
        StringBuilder fileName = new StringBuilder();
        fileName.append(this.getPersistenceKeyPartOfModelSerializationType(persistableModel.getModelSerializationStrategyType()));
        ModelDomainType domainType = ((ModelContext)persistableModel.getModelContext()).getDomainType();
        fileName.append(this.getPersistenceKeyPartOfModelDomain(domainType));
        fileName.append(persistableModel.getClass().getSimpleName());
        fileName.append(NAME_PART_DELIMITER);
        fileName.append(((ModelContext)persistableModel.getModelContext()).getId());
        fileName.append(PERSISTENCE_KEY_SUFFIX);
        String finalFileName = this.replaceSystemChars(fileName.toString());
        return finalFileName;
    }

    private String replaceSystemChars(String str) {
        return str.replaceAll("[\\\\\\/\\\"\\:\\|\\<\\>\\*\\?]", "__");
    }

    protected String getPersistenceKeyPartOfModelDomain(ModelDomainType modelDomainType) {
        return CONTEXT_NAME_PREFIX + modelDomainType.getDomainName() + NAME_PART_DELIMITER;
    }

    protected String getPersistenceKeyPartOfModelSerializationType(ModelSerializationStrategyType modelSerializationStrategyType) {
        return String.valueOf(modelSerializationStrategyType.name()) + NAME_PART_DELIMITER;
    }

    protected ModelSerializationStrategy getModelSerializationStrategyFromPersistenceKey(String persistenceKey) {
        ModelSerializationStrategyType[] modelSerializationStrategyTypeArray = ModelSerializationStrategyType.values();
        int n = modelSerializationStrategyTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModelSerializationStrategyType serializationType = modelSerializationStrategyTypeArray[n2];
            if (serializationType != ModelSerializationStrategyType.NONE && persistenceKey.startsWith(this.getPersistenceKeyPartOfModelSerializationType(serializationType))) {
                return serializationType.getModelSerializationStrategy();
            }
            ++n2;
        }
        return null;
    }

    protected boolean isPersistenceKeyBelongingToModelDomain(String persistenceKey, ModelDomainType modelDomainType) {
        return persistenceKey.endsWith(PERSISTENCE_KEY_SUFFIX) && persistenceKey.substring(persistenceKey.indexOf(NAME_PART_DELIMITER)).startsWith(NAME_PART_DELIMITER + this.getPersistenceKeyPartOfModelDomain(modelDomainType));
    }

    protected <InstanceType> void verifyRequestedModelContextIsLoaded(ModelContext<?> requestedModelContext, ModelContext<InstanceType> loadedModelContext) throws ModelPersistenceException {
        if (!requestedModelContext.equals(loadedModelContext)) {
            throw new ModelPersistenceException("The context of the loaded model is: " + loadedModelContext + ". \nExpected: " + requestedModelContext);
        }
    }
}

