/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.integration;

import com.sap.sailing.domain.windestimation.WindEstimationFactoryService;
import com.sap.sailing.windestimation.integration.WindEstimationFactoryServiceImpl;
import com.sap.sailing.windestimation.jaxrs.client.WindEstimationDataClient;
import com.sap.sailing.windestimation.model.exception.ModelLoadingException;
import com.sap.sailing.windestimation.model.exception.ModelPersistenceException;
import com.sap.sailing.windestimation.model.store.FileSystemModelStoreImpl;
import com.sap.sailing.windestimation.model.store.ModelDomainType;
import com.sap.sailing.windestimation.model.store.MongoDbModelStoreImpl;
import com.sap.sse.mongodb.AlreadyRegisteredException;
import com.sap.sse.mongodb.MongoDBService;
import com.sap.sse.replication.Replicable;
import com.sap.sse.util.ClearStateTestSupport;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(Activator.class.getName());
    private static final String WIND_ESTIMATION_MODEL_DATA_SOURCE_URL_PROPERTY_NAME = "windestimation.source.url";
    private static final String WIND_ESTIMATION_MODEL_DATA_SOURCE_ALWAYS_URL_PROPERTY_NAME = "windestimation.source.always.url";
    private static final String WIND_ESTIMATION_MODEL_DATA_SOURCE_FOLDER_PROPERTY_NAME = "windestimation.source.folder";
    private static final String WIND_ESTIMATION_MODEL_BEARER_TOKEN_PROPERTY_NAME = "windestimation.source.bearertoken";
    private final Set<ServiceRegistration<?>> registrations = new HashSet();
    private WindEstimationFactoryServiceImpl service;

    public void start(BundleContext context) throws Exception {
        logger.info("Registering WindEstimationFactoryService");
        this.registerIncorporatedMongoDbCollectionsExclusively();
        this.service = new WindEstimationFactoryServiceImpl();
        String windEstimationModelDataSourceURL = System.getProperty(WIND_ESTIMATION_MODEL_DATA_SOURCE_URL_PROPERTY_NAME);
        String windEstimationModelDataSourceAlwaysURL = System.getProperty(WIND_ESTIMATION_MODEL_DATA_SOURCE_ALWAYS_URL_PROPERTY_NAME);
        String windEstimationModelDataSourceFolder = System.getProperty(WIND_ESTIMATION_MODEL_DATA_SOURCE_FOLDER_PROPERTY_NAME);
        String windEstimationModelBearerToken = System.getProperty(WIND_ESTIMATION_MODEL_BEARER_TOKEN_PROPERTY_NAME);
        int loadFromCount = (windEstimationModelDataSourceURL != null ? 1 : 0) + (windEstimationModelDataSourceAlwaysURL != null ? 1 : 0) + (windEstimationModelDataSourceFolder != null ? 1 : 0);
        if (loadFromCount > 1) {
            throw new ModelLoadingException("At most one of the three parameters may be provided: \"windestimation.source.url\" or \"windestimation.source.always.url\" or \"windestimation.source.folder\"");
        }
        if (windEstimationModelDataSourceURL != null && !this.service.isReady()) {
            this.importWindEstimationModelsFromUrl(windEstimationModelDataSourceURL, Optional.ofNullable(windEstimationModelBearerToken));
        } else if (windEstimationModelDataSourceAlwaysURL != null) {
            this.importWindEstimationModelsFromUrl(windEstimationModelDataSourceAlwaysURL, Optional.ofNullable(windEstimationModelBearerToken));
        } else if (windEstimationModelDataSourceFolder != null) {
            this.importWindEstimationModelsFromFolder(windEstimationModelDataSourceFolder);
        }
        ServiceRegistration serviceRegistration = context.registerService(WindEstimationFactoryService.class, (Object)this.service, null);
        this.registrations.add(serviceRegistration);
        Hashtable<String, String> replicableServiceProperties = new Hashtable<String, String>();
        ((Dictionary)replicableServiceProperties).put("ID", this.service.getId().toString());
        this.registrations.add(context.registerService(Replicable.class.getName(), (Object)this.service, replicableServiceProperties));
        this.registrations.add(context.registerService(ClearStateTestSupport.class.getName(), (Object)this.service, null));
    }

    private void registerIncorporatedMongoDbCollectionsExclusively() throws AlreadyRegisteredException {
        MongoDBService mongoDBService = MongoDBService.INSTANCE;
        ModelDomainType[] modelDomainTypeArray = ModelDomainType.values();
        int n = modelDomainTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModelDomainType domainType = modelDomainTypeArray[n2];
            String collectionName = MongoDbModelStoreImpl.getCollectionName(domainType);
            mongoDBService.registerExclusively(MongoDbModelStoreImpl.class, collectionName);
            mongoDBService.registerExclusively(MongoDbModelStoreImpl.class, String.valueOf(collectionName) + ".files");
            mongoDBService.registerExclusively(MongoDbModelStoreImpl.class, String.valueOf(collectionName) + ".chunks");
            ++n2;
        }
    }

    private void importWindEstimationModelsFromFolder(String windEstimationModelDataSourceFolder) {
        FileSystemModelStoreImpl modelStore = new FileSystemModelStoreImpl(windEstimationModelDataSourceFolder);
        try {
            this.service.importAllModelsFromModelStore(modelStore);
        }
        catch (ModelPersistenceException e) {
            throw new ModelLoadingException("Could not import wind estimation models from folder :" + windEstimationModelDataSourceFolder, e);
        }
    }

    private void importWindEstimationModelsFromUrl(String windEstimationModelDataSourceURL, Optional<String> windEstimationModelBearerToken) {
        logger.info("Importing wind estimation data from URL: " + windEstimationModelDataSourceURL);
        WindEstimationDataClient windEstimationDataClient = new WindEstimationDataClient(windEstimationModelDataSourceURL, this.service, windEstimationModelBearerToken);
        try {
            windEstimationDataClient.updateWindEstimationModels();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception while trying to import wind estimation model data from " + windEstimationModelDataSourceURL, e);
        }
        logger.info("Import of wind estimation data finished successfully ");
    }

    public void stop(BundleContext context) throws Exception {
        this.service.shutdown();
        logger.info("Unregistering WindEstimationFactoryService");
        for (ServiceRegistration<?> reg : this.registrations) {
            reg.unregister();
        }
        this.registrations.clear();
    }
}

