/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.windestimation.aggregator.ManeuverClassificationsAggregator;
import com.sap.sailing.windestimation.aggregator.clustering.ManeuverClassificationForClusteringImpl;
import com.sap.sailing.windestimation.aggregator.clustering.ManeuverClusteringBasedWindEstimationTrackImpl;
import com.sap.sailing.windestimation.aggregator.hmm.BestPathsCalculator;
import com.sap.sailing.windestimation.aggregator.hmm.GraphLevel;
import com.sap.sailing.windestimation.aggregator.hmm.IntersectedWindRangeBasedTransitionProbabilitiesCalculator;
import com.sap.sailing.windestimation.aggregator.hmm.ManeuverSequenceGraph;
import com.sap.sailing.windestimation.aggregator.hmm.SimpleIntersectedWindRangeBasedTransitionProbabilitiesCalculator;
import com.sap.sailing.windestimation.aggregator.hmm.TwdTransitionClassifierBasedTransitionProbabilitiesCalculator;
import com.sap.sailing.windestimation.aggregator.msthmm.DistanceAndDurationAwareWindTransitionProbabilitiesCalculator;
import com.sap.sailing.windestimation.aggregator.msthmm.MstBestPathsCalculatorImpl;
import com.sap.sailing.windestimation.aggregator.msthmm.MstManeuverGraph;
import com.sap.sailing.windestimation.aggregator.outlierremoval.MeanBasedOutlierRemovalWindEstimator;
import com.sap.sailing.windestimation.aggregator.outlierremoval.NeighborBasedOutlierRemovalWindEstimator;
import com.sap.sailing.windestimation.data.ManeuverTypeForClassification;
import com.sap.sailing.windestimation.data.ManeuverWithEstimatedType;
import com.sap.sailing.windestimation.data.RaceWithEstimationData;
import com.sap.sailing.windestimation.model.classifier.maneuver.ManeuverWithProbabilisticTypeClassification;
import com.sap.sailing.windestimation.model.classifier.twdtransition.TwdTransitionClassifiersCache;
import com.sap.sailing.windestimation.model.regressor.twdtransition.GaussianBasedTwdTransitionDistributionCache;
import com.sap.sailing.windestimation.model.store.ModelStore;
import com.sap.sailing.windestimation.windinference.MiddleCourseBasedTwdCalculatorImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ManeuverClassificationsAggregatorFactory {
    private final PolarDataService polarDataService;
    private final ModelStore modelStore;
    private final long modelCacheKeepAliveMillis;
    private final boolean preloadAllModels;

    public ManeuverClassificationsAggregatorFactory(PolarDataService polarDataService, ModelStore modelStore, boolean preloadAllModels, long modelCacheKeepAliveMillis) {
        this.polarDataService = polarDataService;
        this.modelStore = modelStore;
        this.preloadAllModels = preloadAllModels;
        this.modelCacheKeepAliveMillis = modelCacheKeepAliveMillis;
    }

    public ManeuverClassificationsAggregator hmm(HmmTransitionProbabilitiesCalculator transitionProbabilitiesCalculatorType, boolean propagateIntersectedWindRangeOfHeadupAndBearAway) {
        SimpleIntersectedWindRangeBasedTransitionProbabilitiesCalculator<GraphLevel> transitionProbabilitiesCalculator = null;
        switch (transitionProbabilitiesCalculatorType) {
            case SIMPLE: {
                transitionProbabilitiesCalculator = new SimpleIntersectedWindRangeBasedTransitionProbabilitiesCalculator(propagateIntersectedWindRangeOfHeadupAndBearAway);
                break;
            }
            case INTERSECTED: {
                transitionProbabilitiesCalculator = new IntersectedWindRangeBasedTransitionProbabilitiesCalculator(propagateIntersectedWindRangeOfHeadupAndBearAway);
                break;
            }
            case CLASSIFIER: {
                transitionProbabilitiesCalculator = new TwdTransitionClassifierBasedTransitionProbabilitiesCalculator(new TwdTransitionClassifiersCache(this.modelStore, this.preloadAllModels, this.modelCacheKeepAliveMillis), propagateIntersectedWindRangeOfHeadupAndBearAway);
                break;
            }
            case GAUSSIAN_REGRESSOR: {
                throw new IllegalArgumentException((Object)((Object)transitionProbabilitiesCalculatorType) + " not supported for regular non-MST HMM");
            }
        }
        return new ManeuverSequenceGraph(new BestPathsCalculator(transitionProbabilitiesCalculator));
    }

    public ManeuverClassificationsAggregator clustering() {
        return new ManeuverClassificationsAggregator(){

            @Override
            public List<ManeuverWithEstimatedType> aggregateManeuverClassifications(RaceWithEstimationData<ManeuverWithProbabilisticTypeClassification> race) {
                BoatClass boatClass = race.getCompetitorTracks().isEmpty() ? null : race.getCompetitorTracks().get(0).getBoatClass();
                ManeuverClusteringBasedWindEstimationTrackImpl windEstimator = new ManeuverClusteringBasedWindEstimationTrackImpl(race, boatClass, ManeuverClassificationsAggregatorFactory.this.polarDataService, 30000L);
                try {
                    windEstimator.initialize();
                    List tackManeuvers = windEstimator.getTackClusters().stream().flatMap(cluster -> cluster.stream()).map(maneuverClassification -> new ManeuverWithEstimatedType(((ManeuverClassificationForClusteringImpl)((Object)maneuverClassification)).getManeuver(), ManeuverTypeForClassification.TACK, maneuverClassification.getLikelihoodForManeuverType(ManeuverType.TACK))).collect(Collectors.toList());
                    List jibeManeuvers = windEstimator.getJibeClusters().stream().flatMap(cluster -> cluster.stream()).map(maneuverClassification -> new ManeuverWithEstimatedType(((ManeuverClassificationForClusteringImpl)((Object)maneuverClassification)).getManeuver(), ManeuverTypeForClassification.JIBE, maneuverClassification.getLikelihoodForManeuverType(ManeuverType.JIBE))).collect(Collectors.toList());
                    ArrayList<ManeuverWithEstimatedType> result = new ArrayList<ManeuverWithEstimatedType>();
                    result.addAll(tackManeuvers);
                    result.addAll(jibeManeuvers);
                    Collections.sort(result, (one, two) -> one.getManeuver().getManeuverTimePoint().compareTo((Object)two.getManeuver().getManeuverTimePoint()));
                    return result;
                }
                catch (NotEnoughDataHasBeenAddedException e) {
                    return Collections.emptyList();
                }
            }
        };
    }

    public ManeuverClassificationsAggregator meanOutlier() {
        return new MeanBasedOutlierRemovalWindEstimator(new MiddleCourseBasedTwdCalculatorImpl());
    }

    public ManeuverClassificationsAggregator neighborOutlier() {
        return new NeighborBasedOutlierRemovalWindEstimator(new MiddleCourseBasedTwdCalculatorImpl());
    }

    public ManeuverClassificationsAggregator mstHmm(boolean propagateIntersectedWindRangeOfHeadupAndBearAway) {
        return new MstManeuverGraph(new MstBestPathsCalculatorImpl(new DistanceAndDurationAwareWindTransitionProbabilitiesCalculator(new GaussianBasedTwdTransitionDistributionCache(this.modelStore, this.preloadAllModels, this.modelCacheKeepAliveMillis), propagateIntersectedWindRangeOfHeadupAndBearAway)));
    }

    public static enum HmmTransitionProbabilitiesCalculator {
        INTERSECTED,
        SIMPLE,
        CLASSIFIER,
        GAUSSIAN_REGRESSOR;

    }
}

