/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter.websocket;

import com.google.protobuf.InvalidProtocolBufferException;
import com.igtimi.IgtimiStream;
import com.sap.sailing.domain.igtimiadapter.BulkFixReceiver;
import com.sap.sailing.domain.igtimiadapter.FixFactory;
import com.sap.sailing.domain.igtimiadapter.IgtimiConnection;
import com.sap.sailing.domain.igtimiadapter.LiveDataConnection;
import com.sap.sailing.domain.igtimiadapter.datatypes.Fix;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class WebSocketConnectionManager
implements LiveDataConnection {
    private static final long TIMEOUT_AFTER_NOT_RECEIVING_HEARTBEAT_IN_MILLIS = 45000L;
    private static final long DURATION_BETWEEN_HEARTBEAT_SENDS_IN_MILLIS = 15000L;
    private static final Logger logger = Logger.getLogger(WebSocketConnectionManager.class.getName());
    private final IgtimiConnection connection;
    private TargetState targetState;
    private WebSocketClient client;
    private final JSONObject configurationMessage;
    private static final Timer timer = new Timer("Timer for WebSocketConnectionManager", true);
    private final TimerTask heartbeatTask;
    private final TimerTask serverHeartbeatTask;
    private final Iterable<String> deviceIds;
    private final FixFactory fixFactory;
    private boolean receivedServerHeartbeatInInterval;
    private final ConcurrentMap<BulkFixReceiver, BulkFixReceiver> listeners;
    private TimePoint igtimiServerTimepoint;
    private TimePoint localTimepointWhenServerTimepointWasReceived;
    private WebSocket currentSocket;
    private int messageCount;
    private static final int LOG_EVERY_SO_MANY_MESSAGES = 100;
    private static final long CONNECTION_TIMEOUT_IN_MILLIS = 5000L;

    public WebSocketConnectionManager(IgtimiConnection connection, Iterable<String> deviceSerialNumbers) throws Exception {
        this.deviceIds = deviceSerialNumbers;
        this.fixFactory = new FixFactory();
        this.connection = connection;
        this.listeners = new ConcurrentHashMap<BulkFixReceiver, BulkFixReceiver>();
        this.configurationMessage = connection.getWebSocketConfigurationMessage(deviceSerialNumbers);
        this.reconnect();
        this.heartbeatTask = this.startClientHeartbeat();
        this.serverHeartbeatTask = this.startListeningForServerHeartbeat();
    }

    private Session getSession() {
        return this.currentSocket == null ? null : this.currentSocket.getSession();
    }

    private RemoteEndpoint getRemote() {
        Session session = this.getSession();
        return session == null ? null : session.getRemote();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForConnection(long timeoutInMillis) throws InterruptedException {
        long startedToWait = System.currentTimeMillis();
        WebSocketConnectionManager webSocketConnectionManager = this;
        synchronized (webSocketConnectionManager) {
            while (this.igtimiServerTimepoint == null && System.currentTimeMillis() - startedToWait < timeoutInMillis) {
                this.wait(timeoutInMillis);
            }
            return this.igtimiServerTimepoint != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        logger.info("Stopping connection mananager " + this);
        this.targetState = TargetState.CLOSED;
        this.heartbeatTask.cancel();
        this.serverHeartbeatTask.cancel();
        Session session = this.getSession();
        if (session != null) {
            session.disconnect();
        }
        WebSocketConnectionManager webSocketConnectionManager = this;
        synchronized (webSocketConnectionManager) {
            if (this.client != null) {
                this.client.stop();
            }
        }
    }

    public Util.Pair<TimePoint, TimePoint> getIgtimiServerTimePointAndWhenItWasReceived() {
        return new Util.Pair((Object)this.igtimiServerTimepoint, (Object)this.localTimepointWhenServerTimepointWasReceived);
    }

    @Override
    public void addListener(BulkFixReceiver listener) {
        this.listeners.put(listener, listener);
    }

    @Override
    public void removeListener(BulkFixReceiver listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(Iterable<Fix> fixes) {
        for (BulkFixReceiver listener : this.listeners.keySet()) {
            try {
                listener.received(fixes);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error notifying listener " + listener + " of Igtimi fixes " + fixes, e);
            }
        }
    }

    public String toString() {
        return "Web Socket Connection Manager for devices " + this.deviceIds + " with web socket session " + this.getSession();
    }

    private TimerTask startListeningForServerHeartbeat() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    if (!WebSocketConnectionManager.this.receivedServerHeartbeatInInterval) {
                        logger.info("Didn't receive server heartbeat in interval for " + WebSocketConnectionManager.this + ". Reconnecting...");
                        WebSocketConnectionManager.this.reconnect();
                    } else {
                        WebSocketConnectionManager.this.receivedServerHeartbeatInInterval = false;
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Error with server heartbeat in " + this, e);
                }
            }
        };
        timer.scheduleAtFixedRate(task, 45000L, 45000L);
        return task;
    }

    private TimerTask startClientHeartbeat() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    if (WebSocketConnectionManager.this.getRemote() != null) {
                        logger.fine("Sending client heartbeat for " + WebSocketConnectionManager.this);
                        WebSocketConnectionManager.this.getRemote().sendStringByFuture("1");
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Couldn't send heartbeat to Igtimi web socket session in " + WebSocketConnectionManager.this + ". Will continue to try...", e);
                }
            }
        };
        timer.scheduleAtFixedRate(task, 0L, 15000L);
        return task;
    }

    private synchronized void reconnect() throws Exception {
        if (this.currentSocket != null) {
            this.currentSocket.close();
        }
        if (this.client != null) {
            this.client.stop();
            this.client.destroy();
        }
        IOException lastException = null;
        for (URI uri : this.connection.getWebsocketServers()) {
            try {
                if (!uri.getScheme().equals("ws") && !uri.getScheme().equals("wss")) continue;
                logger.log(Level.INFO, "Trying to connect to " + uri + " for " + this);
                this.client = new WebSocketClient();
                this.client.start();
                this.currentSocket = new WebSocket();
                this.igtimiServerTimepoint = null;
                ClientUpgradeRequest clientUpgradeRequest = new ClientUpgradeRequest();
                this.connection.authenticate(clientUpgradeRequest);
                this.client.connect((Object)this.currentSocket, uri, clientUpgradeRequest);
                if (this.waitForConnection(5000L)) {
                    logger.log(Level.INFO, "Successfully connected to " + uri + " for " + this);
                    lastException = null;
                    break;
                }
                this.client.stop();
                this.client.destroy();
                this.client = null;
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Couldn't connect to " + uri + " for " + this, e);
                lastException = e;
            }
        }
        this.targetState = TargetState.OPEN;
        if (lastException != null) {
            throw lastException;
        }
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.getSession() == null ? null : this.getSession().getRemoteAddress();
    }

    private void warnUnknownDeviceId(Object message, Fix fix) {
        if (!Util.contains(this.deviceIds, (Object)fix.getSensor().getDeviceSerialNumber())) {
            logger.warning("Received fix " + fix + " in message " + message + " which is from device " + fix.getSensor().getDeviceSerialNumber() + " which this connection is not configured for: " + this.deviceIds);
        }
    }

    private static enum TargetState {
        OPEN,
        CLOSED;

    }

    private class WebSocket
    extends WebSocketAdapter {
        private boolean reconnectWhenClosed = true;

        private WebSocket() {
        }

        public synchronized void onWebSocketClose(int statusCode, String reason) {
            if (this.reconnectWhenClosed) {
                this.reconnectWhenClosed = false;
                Session session = this.getSession();
                if (session != null) {
                    session.close();
                    try {
                        session.disconnect();
                    }
                    catch (IOException e) {
                        logger.info("Couldn't disconnect web socket session " + session + " after having closed it");
                    }
                }
                super.onWebSocketClose(statusCode, reason);
                if (WebSocketConnectionManager.this.targetState == TargetState.OPEN) {
                    try {
                        WebSocketConnectionManager.this.reconnect();
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Couldn't reconnect to Igtimi web socket in " + (Object)((Object)this), e);
                    }
                }
            }
        }

        public void onWebSocketError(Throwable cause) {
            logger.log(Level.SEVERE, "Error trying to open Igtimi web socket in " + (Object)((Object)this), cause);
        }

        public void onWebSocketConnect(Session session) {
            super.onWebSocketConnect(session);
            logger.info("received connection " + session + " for " + (Object)((Object)this));
            WebSocketConnectionManager.this.receivedServerHeartbeatInInterval = true;
            try {
                this.getRemote().sendString(WebSocketConnectionManager.this.configurationMessage.toString());
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Could not send configuration package to Igtimi web socket server in " + (Object)((Object)this), e);
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWebSocketText(String message) {
            logger.finest(() -> "Received " + message + " in " + (Object)((Object)this));
            if (message.equals("1")) {
                logger.fine("Received server heartbeat for " + (Object)((Object)this));
                WebSocketConnectionManager.this.receivedServerHeartbeatInInterval = true;
            } else if (message.startsWith("[")) {
                WebSocketConnectionManager webSocketConnectionManager = WebSocketConnectionManager.this;
                webSocketConnectionManager.messageCount = webSocketConnectionManager.messageCount + 1;
                if (WebSocketConnectionManager.this.messageCount % 100 == 0) {
                    logger.info("Received another 100 Igtimi messages. Last message was: " + message);
                }
                ArrayList<Fix> fixes = new ArrayList<Fix>();
                try {
                    JSONArray jsonArray = (JSONArray)new JSONParser().parse(message);
                    for (Object o : jsonArray) {
                        for (Fix fix : WebSocketConnectionManager.this.fixFactory.createFixes((JSONObject)o)) {
                            fixes.add(fix);
                            WebSocketConnectionManager.this.warnUnknownDeviceId(message, fix);
                        }
                    }
                    logger.finest(() -> "Received fixes" + fixes + " for " + (Object)((Object)this));
                    WebSocketConnectionManager.this.notifyListeners(fixes);
                }
                catch (InvalidProtocolBufferException | ParseException e) {
                    logger.log(Level.SEVERE, "Error trying to parse a web socket data package coming from Igtimi " + (Object)((Object)this), e);
                }
            } else {
                WebSocketConnectionManager webSocketConnectionManager = WebSocketConnectionManager.this;
                synchronized (webSocketConnectionManager) {
                    WebSocketConnectionManager.this.igtimiServerTimepoint = (TimePoint)new MillisecondsTimePoint(Long.valueOf(message).longValue());
                    WebSocketConnectionManager.this.localTimepointWhenServerTimepointWasReceived = MillisecondsTimePoint.now();
                    logger.info("Received server timestamp " + WebSocketConnectionManager.this.igtimiServerTimepoint);
                    WebSocketConnectionManager.this.notifyAll();
                }
            }
        }

        public void onWebSocketBinary(byte[] payload, int offset, int len) {
            ByteBuffer bb = ByteBuffer.wrap(payload, offset, len);
            try {
                IgtimiStream.Msg msg = IgtimiStream.Msg.parseFrom(bb);
                Iterable<Fix> fixes = WebSocketConnectionManager.this.fixFactory.createFixes(msg);
                fixes.forEach(fix -> WebSocketConnectionManager.this.warnUnknownDeviceId(msg, fix));
                WebSocketConnectionManager.this.notifyListeners(fixes);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error trying to parse or send bytes received on web socket", e);
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ", " + WebSocketConnectionManager.this.toString();
        }

        public void close() {
            this.reconnectWhenClosed = false;
            Session session = this.getSession();
            if (session != null) {
                session.close();
            }
        }
    }
}

