/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter.shared;

import com.sap.sailing.declination.Declination;
import com.sap.sailing.declination.DeclinationService;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.domain.common.scalablevalue.impl.ScalableBearing;
import com.sap.sailing.domain.common.scalablevalue.impl.ScalablePosition;
import com.sap.sailing.domain.common.scalablevalue.impl.ScalableSpeed;
import com.sap.sailing.domain.igtimiadapter.BulkFixReceiver;
import com.sap.sailing.domain.igtimiadapter.IgtimiFixReceiverAdapter;
import com.sap.sailing.domain.igtimiadapter.IgtimiWindListener;
import com.sap.sailing.domain.igtimiadapter.datatypes.AWA;
import com.sap.sailing.domain.igtimiadapter.datatypes.AWS;
import com.sap.sailing.domain.igtimiadapter.datatypes.BatteryLevel;
import com.sap.sailing.domain.igtimiadapter.datatypes.COG;
import com.sap.sailing.domain.igtimiadapter.datatypes.Fix;
import com.sap.sailing.domain.igtimiadapter.datatypes.GpsLatLong;
import com.sap.sailing.domain.igtimiadapter.datatypes.HDG;
import com.sap.sailing.domain.igtimiadapter.datatypes.HDGM;
import com.sap.sailing.domain.igtimiadapter.datatypes.SOG;
import com.sap.sailing.domain.igtimiadapter.datatypes.Type;
import com.sap.sailing.domain.tracking.DynamicTrack;
import com.sap.sailing.domain.tracking.impl.DynamicTrackImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Timed;
import com.sap.sse.common.Util;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IgtimiWindReceiver
implements BulkFixReceiver {
    private static final Logger logger = Logger.getLogger(IgtimiWindReceiver.class.getName());
    private final Map<String, DynamicTrack<AWA>> awaTracks;
    private final Map<String, DynamicTrack<AWS>> awsTracks;
    private final Map<String, DynamicTrack<GpsLatLong>> gpsTracks;
    private final Map<String, DynamicTrack<COG>> cogTracks;
    private final Map<String, DynamicTrack<SOG>> sogTracks;
    private final Map<String, DynamicTrack<HDG>> hdgTracks;
    private final Map<String, DynamicTrack<HDGM>> hdgmTracks;
    private final Map<String, DynamicTrack<BatteryLevel>> batteryLevelTracks;
    private final FixReceiver receiver = new FixReceiver();
    private final DeclinationService declinationService;
    private final ConcurrentMap<IgtimiWindListener, IgtimiWindListener> listeners;

    public IgtimiWindReceiver(DeclinationService declinationService) {
        this.declinationService = declinationService;
        this.listeners = new ConcurrentHashMap<IgtimiWindListener, IgtimiWindListener>();
        this.awaTracks = new HashMap<String, DynamicTrack<AWA>>();
        this.awsTracks = new HashMap<String, DynamicTrack<AWS>>();
        this.gpsTracks = new HashMap<String, DynamicTrack<GpsLatLong>>();
        this.cogTracks = new HashMap<String, DynamicTrack<COG>>();
        this.sogTracks = new HashMap<String, DynamicTrack<SOG>>();
        this.hdgTracks = new HashMap<String, DynamicTrack<HDG>>();
        this.hdgmTracks = new HashMap<String, DynamicTrack<HDGM>>();
        this.batteryLevelTracks = new HashMap<String, DynamicTrack<BatteryLevel>>();
    }

    private <T extends Fix> DynamicTrack<T> getTrack(String deviceSerialNumber, Map<String, DynamicTrack<T>> tracksByDeviceSerialNumber) {
        DynamicTrackImpl result = tracksByDeviceSerialNumber.get(deviceSerialNumber);
        if (result == null) {
            result = new DynamicTrackImpl("Track for Igtimi wind track for device " + deviceSerialNumber);
            tracksByDeviceSerialNumber.put(deviceSerialNumber, (DynamicTrack<T>)result);
        }
        return result;
    }

    @Override
    public void received(Iterable<Fix> fixes) {
        final ArrayList awsFixes = new ArrayList();
        for (Fix fix : fixes) {
            fix.notify(this.receiver);
            fix.notify(new IgtimiFixReceiverAdapter(){

                @Override
                public void received(AWS fix) {
                    awsFixes.add(fix);
                }
            });
        }
        logger.finest("Received " + Util.size(awsFixes) + " wind fixes");
        boolean loggedWindFixGenerationProblem = false;
        for (AWS aws : awsFixes) {
            try {
                Util.Pair<Wind, Set<Fix>> windAndFixesUsed = this.getWind(aws.getTimePoint(), aws.getSensor().getDeviceSerialNumber());
                if (windAndFixesUsed.getA() != null) {
                    this.notifyListeners((Wind)windAndFixesUsed.getA(), (Set)windAndFixesUsed.getB(), aws.getSensor().getDeviceSerialNumber());
                    continue;
                }
                if (loggedWindFixGenerationProblem) continue;
                logger.info("Not enough information to build a Wind fix out of data provided by sensor " + aws.getSensor() + ". AWS received but most probably HDG or HDGM not received (yet) - check your compass.");
                loggedWindFixGenerationProblem = true;
            }
            catch (IOException | ClassNotFoundException | ParseException e) {
                logger.log(Level.INFO, "Exception while trying to construct Wind fix from Igtimi fix " + aws, e);
            }
        }
    }

    public void addListener(IgtimiWindListener listener) {
        this.listeners.put(listener, listener);
    }

    private void notifyListeners(Wind wind, Set<Fix> fixesUsed, String deviceSerialNumber) {
        for (IgtimiWindListener listener : this.listeners.keySet()) {
            listener.windDataReceived(wind, fixesUsed, deviceSerialNumber);
        }
    }

    private Util.Pair<Wind, Set<Fix>> getWind(TimePoint timePoint, String deviceSerialNumber) throws ClassNotFoundException, IOException, ParseException {
        WindImpl result;
        HashSet<Fix> fixesUsed = new HashSet<Fix>();
        DynamicTrack<BatteryLevel> batteryLevelTrack = this.getBatteryLevelTrack(deviceSerialNumber);
        BatteryLevel lastBatteryLevel = (BatteryLevel)batteryLevelTrack.getLastFixAtOrBefore(timePoint);
        if (lastBatteryLevel != null) {
            fixesUsed.add(lastBatteryLevel);
        }
        DynamicTrack<AWA> awaTrack = this.getAwaTrack(deviceSerialNumber);
        Bearing awaFrom = (Bearing)awaTrack.getInterpolatedValue(timePoint, a -> new ScalableBearing(a.getApparentWindAngle()));
        this.addFixUsedIfNotNull((Fix)awaTrack.getLastFixAtOrBefore(timePoint), fixesUsed);
        Bearing awa = awaFrom == null ? null : awaFrom.reverse();
        DynamicTrack<AWS> awsTrack = this.getAwsTrack(deviceSerialNumber);
        Speed aws = (Speed)awsTrack.getInterpolatedValue(timePoint, a -> new ScalableSpeed(a.getApparentWindSpeed()));
        this.addFixUsedIfNotNull((Fix)awsTrack.getLastFixAtOrBefore(timePoint), fixesUsed);
        DynamicTrack<GpsLatLong> gpsTrack = this.getGpsTrack(deviceSerialNumber);
        Position pos = (Position)gpsTrack.getInterpolatedValue(timePoint, g -> new ScalablePosition(g.getPosition()));
        this.addFixUsedIfNotNull((Fix)gpsTrack.getLastFixAtOrBefore(timePoint), fixesUsed);
        if (pos != null) {
            Bearing heading = this.getHeading(timePoint, deviceSerialNumber, pos, fixesUsed);
            if (awa != null && aws != null && heading != null) {
                Bearing apparentWindDirection = heading.add(awa);
                KnotSpeedWithBearingImpl apparentWindSpeedWithDirection = new KnotSpeedWithBearingImpl(aws.getKnots(), apparentWindDirection);
                DynamicTrack<SOG> sogTrack = this.getSogTrack(deviceSerialNumber);
                Speed sog = (Speed)sogTrack.getInterpolatedValue(timePoint, s -> new ScalableSpeed(s.getSpeedOverGround()));
                this.addFixUsedIfNotNull((Fix)sogTrack.getLastFixAtOrBefore(timePoint), fixesUsed);
                DynamicTrack<COG> cogTrack = this.getCogTrack(deviceSerialNumber);
                Bearing cog = (Bearing)cogTrack.getInterpolatedValue(timePoint, c -> new ScalableBearing(c.getCourseOverGround()));
                this.addFixUsedIfNotNull((Fix)cogTrack.getLastFixAtOrBefore(timePoint), fixesUsed);
                if (sog != null && cog != null) {
                    KnotSpeedWithBearingImpl sogCog = new KnotSpeedWithBearingImpl(sog.getKnots(), cog);
                    SpeedWithBearing trueWindSpeedAndDirection = apparentWindSpeedWithDirection.add((SpeedWithBearing)sogCog);
                    result = new WindImpl(pos, timePoint, trueWindSpeedAndDirection);
                } else {
                    result = null;
                }
            } else {
                result = null;
            }
        } else {
            result = null;
        }
        return new Util.Pair(result, fixesUsed);
    }

    private void addFixUsedIfNotNull(Fix fix, Set<Fix> fixesUsed) {
        if (fix != null) {
            fixesUsed.add(fix);
        }
    }

    private Bearing getHeading(TimePoint timePoint, String deviceSerialNumber, Position position, Set<Fix> fixesUsed) throws ClassNotFoundException, IOException, ParseException {
        Bearing trueHeading;
        DynamicTrack<HDG> hdgTrack = this.getHdgTrack(deviceSerialNumber);
        DynamicTrack<HDGM> hdgmTrack = this.getHdgmTrack(deviceSerialNumber);
        Bearing hdg = (Bearing)hdgTrack.getInterpolatedValue(timePoint, h -> new ScalableBearing(h.getTrueHeading()));
        if (hdg != null) {
            trueHeading = hdg;
        } else {
            Bearing hdgm = (Bearing)hdgmTrack.getInterpolatedValue(timePoint, h -> new ScalableBearing(h.getMagneticHeading()));
            if (hdgm != null) {
                if (this.declinationService == null) {
                    trueHeading = hdgm;
                } else {
                    try {
                        Declination declination = this.declinationService.getDeclination(timePoint, position, 5000L);
                        trueHeading = hdgm.add(declination.getBearingCorrectedTo(timePoint));
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Correction of declination was requested but unsuccessful. Can't correct heading " + hdgm + "@" + timePoint + " by declination. Forwarding exception.");
                        throw e;
                    }
                }
            } else {
                trueHeading = null;
            }
        }
        this.addFixUsedIfNotNull((Fix)hdgTrack.getLastFixAtOrBefore(timePoint), fixesUsed);
        this.addFixUsedIfNotNull((Fix)hdgmTrack.getLastFixAtOrBefore(timePoint), fixesUsed);
        return trueHeading;
    }

    private DynamicTrack<AWA> getAwaTrack(String deviceSerialNumber) {
        return this.getTrack(deviceSerialNumber, this.awaTracks);
    }

    private DynamicTrack<AWS> getAwsTrack(String deviceSerialNumber) {
        return this.getTrack(deviceSerialNumber, this.awsTracks);
    }

    private DynamicTrack<GpsLatLong> getGpsTrack(String deviceSerialNumber) {
        return this.getTrack(deviceSerialNumber, this.gpsTracks);
    }

    private DynamicTrack<COG> getCogTrack(String deviceSerialNumber) {
        return this.getTrack(deviceSerialNumber, this.cogTracks);
    }

    private DynamicTrack<SOG> getSogTrack(String deviceSerialNumber) {
        return this.getTrack(deviceSerialNumber, this.sogTracks);
    }

    private DynamicTrack<HDG> getHdgTrack(String deviceSerialNumber) {
        return this.getTrack(deviceSerialNumber, this.hdgTracks);
    }

    private DynamicTrack<HDGM> getHdgmTrack(String deviceSerialNumber) {
        return this.getTrack(deviceSerialNumber, this.hdgmTracks);
    }

    private DynamicTrack<BatteryLevel> getBatteryLevelTrack(String deviceSerialNumber) {
        return this.getTrack(deviceSerialNumber, this.batteryLevelTracks);
    }

    public Type[] getFixTypes() {
        return new Type[]{Type.AWA, Type.AWS, Type.HDG, Type.HDGM, Type.gps_latlong, Type.COG, Type.SOG};
    }

    private class FixReceiver
    extends IgtimiFixReceiverAdapter {
        private FixReceiver() {
        }

        @Override
        public void received(AWA fix) {
            IgtimiWindReceiver.this.getAwaTrack(fix.getSensor().getDeviceSerialNumber()).add((Timed)fix);
        }

        @Override
        public void received(AWS fix) {
            IgtimiWindReceiver.this.getAwsTrack(fix.getSensor().getDeviceSerialNumber()).add((Timed)fix);
        }

        @Override
        public void received(GpsLatLong fix) {
            IgtimiWindReceiver.this.getGpsTrack(fix.getSensor().getDeviceSerialNumber()).add((Timed)fix);
        }

        @Override
        public void received(COG fix) {
            IgtimiWindReceiver.this.getCogTrack(fix.getSensor().getDeviceSerialNumber()).add((Timed)fix);
        }

        @Override
        public void received(SOG fix) {
            IgtimiWindReceiver.this.getSogTrack(fix.getSensor().getDeviceSerialNumber()).add((Timed)fix);
        }

        @Override
        public void received(HDG fix) {
            IgtimiWindReceiver.this.getHdgTrack(fix.getSensor().getDeviceSerialNumber()).add((Timed)fix);
        }

        @Override
        public void received(HDGM fix) {
            IgtimiWindReceiver.this.getHdgmTrack(fix.getSensor().getDeviceSerialNumber()).add((Timed)fix);
        }

        @Override
        public void received(BatteryLevel fix) {
            IgtimiWindReceiver.this.getBatteryLevelTrack(fix.getSensor().getDeviceSerialNumber()).add((Timed)fix);
        }
    }
}

