/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter.impl;

import com.sap.sailing.domain.igtimiadapter.IgtimiConnection;
import com.sap.sailing.domain.igtimiadapter.IgtimiConnectionFactory;
import com.sap.sailing.domain.igtimiadapter.impl.IgtimiConnectionImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class IgtimiConnectionFactoryImpl
implements IgtimiConnectionFactory {
    private final URL baseUrl;
    private final String defaultBearerToken;
    private final ConcurrentMap<String, IgtimiConnection> connectionPool;

    public IgtimiConnectionFactoryImpl(URL baseUrl, String defaultBearerToken) throws MalformedURLException {
        this.baseUrl = baseUrl.toString().endsWith("/") ? new URL(baseUrl.toString().substring(0, baseUrl.toString().length() - 1)) : baseUrl;
        this.defaultBearerToken = defaultBearerToken;
        this.connectionPool = new ConcurrentHashMap<String, IgtimiConnection>();
    }

    @Override
    public URL getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public boolean hasCredentials() {
        return this.defaultBearerToken != null;
    }

    @Override
    public synchronized IgtimiConnection getOrCreateConnection(String bearerToken) {
        IgtimiConnection result;
        String poolKey = bearerToken == null ? "" : bearerToken;
        IgtimiConnection pooledConnection = (IgtimiConnection)this.connectionPool.get(poolKey);
        if (pooledConnection == null) {
            result = new IgtimiConnectionImpl(this.baseUrl, bearerToken);
            this.connectionPool.put(poolKey, result);
        } else {
            result = pooledConnection;
        }
        return result;
    }

    @Override
    public IgtimiConnection getOrCreateConnection() {
        return this.getOrCreateConnection(this.defaultBearerToken);
    }
}

