/*
 * Decompiled with CFR 0.152.
 */
package smile.data.parser.microarray;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.text.ParseException;
import smile.data.Attribute;
import smile.data.AttributeDataset;
import smile.data.NumericAttribute;

public class TXTParser {
    public AttributeDataset parse(URI uri) throws IOException, ParseException {
        return this.parse(new File(uri));
    }

    public AttributeDataset parse(String name, URI uri) throws IOException, ParseException {
        return this.parse(name, new File(uri));
    }

    public AttributeDataset parse(String path) throws IOException, ParseException {
        return this.parse(new File(path));
    }

    public AttributeDataset parse(String name, String path) throws IOException, ParseException {
        return this.parse(name, new File(path));
    }

    public AttributeDataset parse(File file) throws IOException, ParseException {
        return this.parse(file.getPath(), new FileInputStream(file));
    }

    public AttributeDataset parse(String name, File file) throws IOException, ParseException {
        return this.parse(name, new FileInputStream(file));
    }

    public AttributeDataset parse(String name, InputStream stream) throws IOException, ParseException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String line = reader.readLine();
        if (line == null) {
            throw new IOException("Empty data source.");
        }
        String[] tokens = line.split("\t", -1);
        int start = 1;
        int p = tokens.length - 1;
        if (tokens[1].equalsIgnoreCase("description")) {
            start = 2;
            p = tokens.length - 2;
        }
        Attribute[] attributes = new Attribute[p];
        for (int i = 0; i < p; ++i) {
            attributes[i] = new NumericAttribute(tokens[i + start]);
        }
        AttributeDataset data = new AttributeDataset(name, attributes);
        int i = 2;
        while ((line = reader.readLine()) != null) {
            tokens = line.split("\t", -1);
            if (tokens.length != p + start) {
                throw new IOException(String.format("Invalid number of elements of line %d: %d", i, tokens.length));
            }
            double[] x = new double[p];
            for (int j = 0; j < p; ++j) {
                x[j] = tokens[j + start].isEmpty() ? Double.NaN : Double.valueOf(tokens[j + start]);
            }
            AttributeDataset.Row datum = data.add(x);
            datum.name = tokens[0];
            if (start == 2) {
                datum.description = tokens[1];
            }
            ++i;
        }
        reader.close();
        return data;
    }
}

