/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.tracking.impl.UpdateResponse;
import com.sap.sailing.domain.tracking.impl.UpdateResponseDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import com.sap.sse.util.HttpUrlConnectionHelper;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.http.message.BasicNameValuePair;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

public class UpdateHandler {
    private static final Logger logger = Logger.getLogger(UpdateHandler.class.getName());
    private JsonDeserializer<UpdateResponse> updateDeserializer;
    private final URI baseURI;
    private final String username;
    private final String password;
    private final Serializable eventId;
    private final Serializable raceId;
    private final String action;
    private final boolean active;
    private static final String HttpPostRequestMethod = "POST";
    private static final String HttpGetRequestMethod = "GET";
    private static final String ContentType = "Content-Type";
    private static final String ContentLength = "Content-Length";
    private static final String ContentTypeApplicationJson = "application/json";
    private static final String EncodingUtf8 = "UTF-8";
    private static final String ResponseCodeForFailure = "FAILURE";
    private static final String UpdateUrlTemplate = "%s%s?eventid=%s&raceid=%s&username=%s&password=%s";

    public UpdateHandler(URI updateURI, String action, String username, String password, Serializable eventId, Serializable raceId) {
        this.baseURI = updateURI;
        this.action = action;
        this.username = username;
        this.password = password;
        this.eventId = eventId;
        this.raceId = raceId;
        this.updateDeserializer = new UpdateResponseDeserializer();
        if (Util.hasLength((String)username)) {
            logger.info("Activating update handler " + this + " for race with ID " + raceId);
            this.active = true;
        } else {
            this.active = false;
        }
    }

    protected URI getBaseURI() {
        return this.baseURI;
    }

    protected URI getActionURI() throws URISyntaxException {
        return this.getActionURI(this.action);
    }

    protected URI getActionURI(String action) throws URISyntaxException {
        return new URI(this.baseURI.getScheme(), this.baseURI.getHost(), String.valueOf(this.baseURI.getPath()) + (this.baseURI.getPath().endsWith("/") ? "" : "/") + action, this.baseURI.getFragment());
    }

    protected String eraseSecurityRelatedValuesFromURL(String url) {
        return url.replaceAll("password=([^&]*)&", "password=****&");
    }

    protected List<BasicNameValuePair> getDefaultParametersAsNewList() {
        ArrayList<BasicNameValuePair> result = new ArrayList<BasicNameValuePair>();
        result.add(new BasicNameValuePair("eventid", this.eventId.toString()));
        result.add(new BasicNameValuePair("raceid", this.raceId.toString()));
        result.add(new BasicNameValuePair("username", this.username));
        result.add(new BasicNameValuePair("password", this.password));
        return result;
    }

    protected URL buildUpdateURL(Map<String, String> additionalParameters) throws MalformedURLException, UnsupportedEncodingException {
        String serverUpdateURI = this.baseURI.toString();
        if (!serverUpdateURI.endsWith("/")) {
            serverUpdateURI = String.valueOf(serverUpdateURI) + "/";
        }
        String url = String.format(UpdateUrlTemplate, serverUpdateURI.toString(), this.action, URLEncoder.encode(this.eventId.toString(), EncodingUtf8), URLEncoder.encode(this.raceId.toString(), EncodingUtf8), URLEncoder.encode(this.username, EncodingUtf8), URLEncoder.encode(this.password, EncodingUtf8));
        for (Map.Entry<String, String> entry : additionalParameters.entrySet()) {
            url = String.valueOf(url) + String.format("&%s=%s", URLEncoder.encode(entry.getKey(), EncodingUtf8), URLEncoder.encode(entry.getValue(), EncodingUtf8));
        }
        return new URL(url);
    }

    protected URL buildUpdateURL() throws MalformedURLException, UnsupportedEncodingException {
        return this.buildUpdateURL(new HashMap<String, String>());
    }

    protected void checkAndLogUpdateResponse(HttpURLConnection connection) throws IOException, ParseException {
        connection.setConnectTimeout(10000);
        connection.connect();
        BufferedReader reader = this.getResponseOnUpdateFromProvider(connection);
        this.parseAndLogResponse(reader);
    }

    protected void parseAndLogResponse(BufferedReader reader) throws IOException, ParseException, JsonDeserializationException {
        Object responseBody = JSONValue.parseWithException((Reader)reader);
        JSONObject responseObject = Helpers.toJSONObjectSafe((Object)responseBody);
        UpdateResponse updateResponse = (UpdateResponse)this.updateDeserializer.deserialize(responseObject);
        if (updateResponse.getStatus().equals(ResponseCodeForFailure)) {
            logger.severe("Failed to send data to provider, got following response: " + updateResponse.getMessage());
        } else {
            logger.info("Successfully sent data to provider with response: " + updateResponse.getMessage());
        }
    }

    private BufferedReader getResponseOnUpdateFromProvider(HttpURLConnection connection) throws IOException {
        InputStream inputStream = connection.getInputStream();
        Charset charset = HttpUrlConnectionHelper.getCharsetFromConnectionOrDefault((URLConnection)connection, (String)EncodingUtf8);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, charset));
        return reader;
    }

    protected HttpURLConnection setConnectionProperties(HttpURLConnection connection) throws IOException {
        return this.followRedirects(connection, c -> {
            c.setRequestMethod(HttpGetRequestMethod);
            c.setDoOutput(false);
            c.setUseCaches(false);
        });
    }

    protected HttpURLConnection setConnectionPropertiesAndSendWithPayload(HttpURLConnection connection, String payload) throws IOException {
        return this.followRedirects(connection, c -> {
            c.setRequestMethod(HttpPostRequestMethod);
            c.setDoOutput(true);
            c.setUseCaches(false);
            c.setRequestProperty(ContentType, ContentTypeApplicationJson);
            c.addRequestProperty(ContentLength, String.valueOf(payload.getBytes().length));
            DataOutputStream writer = new DataOutputStream(c.getOutputStream());
            writer.writeBytes(payload);
            writer.flush();
            writer.close();
        });
    }

    private HttpURLConnection followRedirects(HttpURLConnection connection, ConnectionConsumer connectionConsumer) throws IOException {
        int responseCode;
        int HTTP_MAX_REDIRECTS = 5;
        int redirects = 0;
        do {
            connectionConsumer.consume(connection);
            connection.setReadTimeout((int)Duration.ONE_MINUTE.times(10L).asMillis());
            responseCode = connection.getResponseCode();
            if (connection.getResponseCode() != 301 && connection.getResponseCode() != 302 || redirects >= 5) continue;
            String location = connection.getHeaderField("Location");
            URL nextUrl = new URL(location);
            connection = (HttpURLConnection)nextUrl.openConnection();
            ++redirects;
        } while ((responseCode == 301 || responseCode == 302) && redirects < 5);
        return connection;
    }

    protected boolean isActive() {
        return this.active;
    }

    @FunctionalInterface
    private static interface ConnectionConsumer {
        public void consume(HttpURLConnection var1) throws IOException;
    }
}

