/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogGateLineOpeningTimeEvent;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.FinishedTimeFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.StartTimeFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.StartTimeFinderResult;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.TrackingTimesFinder;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogGateLineOpeningTimeEventImpl;
import com.sap.sailing.domain.abstractlog.race.state.ReadonlyRaceState;
import com.sap.sailing.domain.abstractlog.race.state.impl.ReadonlyRaceStateImpl;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.ReadonlyRacingProcedure;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.tracking.analyzing.impl.RegattaLogDefinedMarkAnalyzer;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.CPUMeteringType;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.ControlPoint;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.CourseListener;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.RegattaListener;
import com.sap.sailing.domain.base.Sideline;
import com.sap.sailing.domain.base.SpeedWithBearingWithConfidence;
import com.sap.sailing.domain.base.SpeedWithConfidence;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.base.impl.SpeedWithConfidenceImpl;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.NauticalSide;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.RaceTimesCalculationUtil;
import com.sap.sailing.domain.common.RankingMetrics;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaNameAndRaceName;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.domain.common.TargetTimeInfo;
import com.sap.sailing.domain.common.TrackedRaceStatusEnum;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.abstractlog.TimePointSpecificationFoundInLog;
import com.sap.sailing.domain.common.confidence.BearingWithConfidence;
import com.sap.sailing.domain.common.confidence.BearingWithConfidenceCluster;
import com.sap.sailing.domain.common.confidence.Weigher;
import com.sap.sailing.domain.common.confidence.impl.BearingWithConfidenceImpl;
import com.sap.sailing.domain.common.confidence.impl.HyperbolicTimeDifferenceWeigher;
import com.sap.sailing.domain.common.confidence.impl.PositionAndTimePointWeigher;
import com.sap.sailing.domain.common.impl.CentralAngleDistance;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.TargetTimeInfoImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.domain.common.impl.WindSourceImpl;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.common.racelog.RacingProcedureType;
import com.sap.sailing.domain.common.scalablevalue.impl.ScalablePosition;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.common.tracking.SensorFix;
import com.sap.sailing.domain.confidence.ConfidenceBasedWindAverager;
import com.sap.sailing.domain.confidence.ConfidenceFactory;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.caching.LeaderboardDTOCalculationReuseCache;
import com.sap.sailing.domain.leaderboard.impl.CompetitorAndRankComparable;
import com.sap.sailing.domain.leaderboard.impl.RankAndRankComparable;
import com.sap.sailing.domain.maneuverdetection.IncrementalManeuverDetector;
import com.sap.sailing.domain.maneuverdetection.ManeuverDetector;
import com.sap.sailing.domain.maneuverdetection.ShortTimeAfterLastHitCache;
import com.sap.sailing.domain.maneuverdetection.impl.IncrementalManeuverDetectorImpl;
import com.sap.sailing.domain.markpassingcalculation.MarkPassingCalculator;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprintRegistry;
import com.sap.sailing.domain.orc.ORCPerformanceCurveRankingMetric;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.domain.racelog.RaceLogAndTrackedRaceResolver;
import com.sap.sailing.domain.ranking.OneDesignRankingMetric;
import com.sap.sailing.domain.ranking.RankingMetric;
import com.sap.sailing.domain.ranking.RankingMetricConstructor;
import com.sap.sailing.domain.tracking.AddResult;
import com.sap.sailing.domain.tracking.BravoFixTrack;
import com.sap.sailing.domain.tracking.DynamicSensorFixTrack;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.GPSTrackListener;
import com.sap.sailing.domain.tracking.LineDetails;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.MarkPositionAtTimePointCache;
import com.sap.sailing.domain.tracking.RaceChangeListener;
import com.sap.sailing.domain.tracking.RaceExecutionOrderProvider;
import com.sap.sailing.domain.tracking.RaceListener;
import com.sap.sailing.domain.tracking.SensorFixTrack;
import com.sap.sailing.domain.tracking.Track;
import com.sap.sailing.domain.tracking.TrackFactory;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRaceStatus;
import com.sap.sailing.domain.tracking.TrackedRaceWithWindEssentials;
import com.sap.sailing.domain.tracking.TrackedRegatta;
import com.sap.sailing.domain.tracking.TrackingConnectorInfo;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sailing.domain.tracking.WindPositionMode;
import com.sap.sailing.domain.tracking.WindStore;
import com.sap.sailing.domain.tracking.WindSummary;
import com.sap.sailing.domain.tracking.WindTrack;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sailing.domain.tracking.impl.AbstractRaceChangeListener;
import com.sap.sailing.domain.tracking.impl.CourseChangeBasedTrackApproximation;
import com.sap.sailing.domain.tracking.impl.CrossTrackErrorCache;
import com.sap.sailing.domain.tracking.impl.DummyMarkPassingWithTimePointAndCompetitor;
import com.sap.sailing.domain.tracking.impl.DummyMarkPassingWithTimePointOnly;
import com.sap.sailing.domain.tracking.impl.DynamicGPSFixMovingTrackImpl;
import com.sap.sailing.domain.tracking.impl.DynamicGPSFixTrackImpl;
import com.sap.sailing.domain.tracking.impl.EmptyWindStore;
import com.sap.sailing.domain.tracking.impl.LineDetailsImpl;
import com.sap.sailing.domain.tracking.impl.MarkPassingByTimeComparator;
import com.sap.sailing.domain.tracking.impl.MarkPassingsByTimeAndCompetitorIdComparator;
import com.sap.sailing.domain.tracking.impl.MarkPositionAtTimePointCacheImpl;
import com.sap.sailing.domain.tracking.impl.ShortTimeWindCache;
import com.sap.sailing.domain.tracking.impl.TimedComparator;
import com.sap.sailing.domain.tracking.impl.TrackedLegImpl;
import com.sap.sailing.domain.tracking.impl.TrackedRaceAsWaypointList;
import com.sap.sailing.domain.tracking.impl.TrackedRaceStatusImpl;
import com.sap.sailing.domain.tracking.impl.WindSummaryImpl;
import com.sap.sailing.domain.tracking.impl.WindWithConfidenceImpl;
import com.sap.sailing.domain.windestimation.IncrementalWindEstimation;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.IsManagedByCache;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Timed;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.scalablevalue.ScalableValue;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import com.sap.sse.shared.util.impl.ApproximateTime;
import com.sap.sse.shared.util.impl.ArrayListNavigableSet;
import com.sap.sse.util.IdentityWrapper;
import com.sap.sse.util.SmartFutureCache;
import com.sap.sse.util.impl.FutureTaskWithTracingGet;
import difflib.DiffUtils;
import difflib.Patch;
import difflib.PatchFailedException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;

public abstract class TrackedRaceImpl
extends TrackedRaceWithWindEssentials
implements CourseListener {
    private static final long serialVersionUID = -4825546964220003507L;
    private static final Logger logger = Logger.getLogger(TrackedRaceImpl.class.getName());
    private static final long DELAY_FOR_CACHE_CLEARING_IN_MILLISECONDS = 7500L;
    public static final Duration TIME_BEFORE_START_TO_TRACK_WIND_MILLIS = Duration.ONE_MINUTE.times(4L);
    public static final Duration EXTRA_LONG_TIME_BEFORE_START_TO_TRACK_WIND_MILLIS = Duration.ONE_HOUR;
    private TrackedRaceStatus status;
    private final TrackingConnectorInfo trackingConnectorInfo;
    private final Object statusNotifier;
    private final ConcurrentMap<WindSource, TrackedRaceImpl> windSourcesToExclude;
    private TimePoint timePointOfOldestEvent;
    private TimePoint startOfTrackingReceived;
    private TimePoint endOfTrackingReceived;
    private TimePoint startOfTracking;
    private TimePoint endOfTracking;
    private TimePoint startTimeReceived;
    private TimePoint startTime;
    private TimePoint startTimeWithoutInferenceFromStartMarkPassings;
    private TimePoint endTime;
    private TimePoint finishingTime;
    private TimePoint finishedTime;
    private transient List<Util.Pair<Waypoint, Util.Pair<TimePoint, TimePoint>>> markPassingsTimes;
    private TimePoint timePointOfNewestEvent;
    private TimePoint timePointOfLastEvent;
    private long updateCount;
    private static final int MAX_COMPETITOR_RANKINGS_CACHE_SIZE = 10;
    private transient LinkedHashMap<TimePoint, LinkedHashMap<Competitor, RankAndRankComparable>> competitorRankings;
    private transient LinkedHashMap<TimePoint, NamedReentrantReadWriteLock> competitorRankingsLocks;
    private final LinkedHashMap<Leg, TrackedLeg> trackedLegs;
    private final Map<Competitor, GPSFixTrack<Competitor, GPSFixMoving>> tracks;
    private final Map<Competitor, NavigableSet<MarkPassing>> markPassingsForCompetitor;
    private final Map<Waypoint, NavigableSet<MarkPassing>> markPassingsForWaypoint;
    private transient SmartFutureCache<Competitor, List<Maneuver>, SmartFutureCache.EmptyUpdateInterval> maneuverCache;
    private final Map<Competitor, CourseChangeBasedTrackApproximation> maneuverApproximators;
    private transient ConcurrentMap<TimePoint, Future<Wind>> directionFromStartToNextMarkCache;
    protected transient MarkPassingCalculator markPassingCalculator;
    private final ConcurrentMap<Mark, GPSFixTrack<Mark, GPSFix>> markTracks;
    private final Map<Util.Pair<Competitor, String>, DynamicSensorFixTrack<Competitor, ?>> sensorTracks;
    private final Map<String, Sideline> courseSidelines;
    protected long millisecondsOverWhichToAverageSpeed;
    private final Map<Mark, StartToNextMarkCacheInvalidationListener> startToNextMarkCacheInvalidationListeners;
    private transient Timer cacheInvalidationTimer;
    private transient Object cacheInvalidationTimerLock;
    private boolean cachesSuspended;
    private boolean triggerManeuverCacheInvalidationForAllCompetitors;
    protected transient ConcurrentMap<Serializable, RaceLog> attachedRaceLogs;
    protected transient WeakHashMap<RaceLog, ReadonlyRaceState> raceStates;
    protected transient ConcurrentMap<Serializable, RegattaLog> attachedRegattaLogs;
    private transient ConcurrentMap<RaceExecutionOrderProvider, RaceExecutionOrderProvider> attachedRaceExecutionOrderProviders;
    private long delayToLiveInMillis;
    private LoadingFromStoresState loadingFromWindStoreState = LoadingFromStoresState.NOT_STARTED;
    private transient CrossTrackErrorCache crossTrackErrorCache;
    private final NamedReentrantReadWriteLock loadingFromWindStoreLock;
    private final NamedReentrantReadWriteLock loadingFromGPSFixStoreLock;
    private final ConcurrentMap<IdentityWrapper<Iterable<MarkPassing>>, NamedReentrantReadWriteLock> locksForMarkPassings;
    private transient ShortTimeWindCache shortTimeWindCache;
    private transient PolarDataService polarDataService;
    private volatile transient IncrementalWindEstimation windEstimation;
    private transient ShortTimeAfterLastHitCache<Competitor, IncrementalManeuverDetector> maneuverDetectorPerCompetitorCache;
    private final RankingMetric rankingMetric;
    private transient RaceLogAndTrackedRaceResolver raceLogResolver;
    private final NamedReentrantReadWriteLock sensorTracksLock;
    private static final int MAX_DISTANCES_FROM_STARBOARD_SIDE_OF_START_LINE_PROJECTED_ONTO_LINE_CACHE_SIZE = 10;
    private transient ConcurrentMap<TimePoint, SortedMap<Competitor, Distance>> distancesFromStarboardSideOfStartLineProjectedOntoLineCache;
    private transient ConcurrentMap<TimePoint, TimePoint> distancesFromStarboardSideOfStartLineProjectedOntoLineCacheLastAccessTimes;
    private final Serializable updateStartAndEndOfTrackingMonitor = "" + new Random().nextDouble();
    private final String updateStartOfRaceCacheFieldsMonitor = "" + new Random().nextDouble();

    public TrackedRaceImpl(TrackedRegatta trackedRegatta, RaceDefinition race, Iterable<Sideline> sidelines, WindStore windStore, long delayToLiveInMillis, long millisecondsOverWhichToAverageWind, long millisecondsOverWhichToAverageSpeed, long delayForWindEstimationCacheInvalidation, boolean useInternalMarkPassingAlgorithm, RaceLogAndTrackedRaceResolver raceLogResolver, TrackingConnectorInfo trackingConnectorInfo, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry) {
        this(trackedRegatta, race, sidelines, windStore, delayToLiveInMillis, millisecondsOverWhichToAverageWind, millisecondsOverWhichToAverageSpeed, delayForWindEstimationCacheInvalidation, useInternalMarkPassingAlgorithm, OneDesignRankingMetric::new, raceLogResolver, trackingConnectorInfo, markPassingRaceFingerprintRegistry);
    }

    public TrackedRaceImpl(final TrackedRegatta trackedRegatta, RaceDefinition race, Iterable<Sideline> sidelines, final WindStore windStore, long delayToLiveInMillis, final long millisecondsOverWhichToAverageWind, long millisecondsOverWhichToAverageSpeed, long delayForWindEstimationCacheInvalidation, boolean useInternalMarkPassingAlgorithm, RankingMetricConstructor rankingMetricConstructor, RaceLogAndTrackedRaceResolver raceLogResolver, TrackingConnectorInfo trackingConnectorInfo, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry) {
        super(race, trackedRegatta, windStore, millisecondsOverWhichToAverageWind);
        this.distancesFromStarboardSideOfStartLineProjectedOntoLineCache = new ConcurrentHashMap<TimePoint, SortedMap<Competitor, Distance>>();
        this.distancesFromStarboardSideOfStartLineProjectedOntoLineCacheLastAccessTimes = new ConcurrentHashMap<TimePoint, TimePoint>();
        this.registerRegattaListener();
        this.raceLogResolver = raceLogResolver;
        this.trackingConnectorInfo = trackingConnectorInfo;
        this.raceStates = new WeakHashMap();
        this.shortTimeWindCache = new ShortTimeWindCache(this, millisecondsOverWhichToAverageWind / 2L);
        this.locksForMarkPassings = new ConcurrentHashMap<IdentityWrapper<Iterable<MarkPassing>>, NamedReentrantReadWriteLock>();
        this.attachedRaceLogs = new ConcurrentHashMap<Serializable, RaceLog>();
        this.attachedRegattaLogs = new ConcurrentHashMap<Serializable, RegattaLog>();
        this.attachedRaceExecutionOrderProviders = new ConcurrentHashMap<RaceExecutionOrderProvider, RaceExecutionOrderProvider>();
        this.status = new TrackedRaceStatusImpl(TrackedRaceStatusEnum.PREPARED, 0.0);
        this.statusNotifier = new Object[0];
        this.loadingFromWindStoreLock = new NamedReentrantReadWriteLock("Loading from wind store lock for tracked race " + race.getName(), false);
        this.loadingFromGPSFixStoreLock = new NamedReentrantReadWriteLock("Loading from GPSFix store lock for tracked race " + race.getName(), false);
        this.cacheInvalidationTimerLock = new Object();
        this.updateCount = 0L;
        this.windSourcesToExclude = new ConcurrentHashMap<WindSource, TrackedRaceImpl>();
        this.directionFromStartToNextMarkCache = new ConcurrentHashMap<TimePoint, Future<Wind>>();
        this.millisecondsOverWhichToAverageSpeed = millisecondsOverWhichToAverageSpeed;
        this.delayToLiveInMillis = delayToLiveInMillis;
        this.startToNextMarkCacheInvalidationListeners = new ConcurrentHashMap<Mark, StartToNextMarkCacheInvalidationListener>();
        this.maneuverDetectorPerCompetitorCache = this.createManeuverDetectorCache();
        this.maneuverCache = this.createManeuverCache();
        this.markTracks = new ConcurrentHashMap<Mark, GPSFixTrack<Mark, GPSFix>>();
        int i = 0;
        for (Waypoint waypoint : race.getCourse().getWaypoints()) {
            for (Mark mark : waypoint.getMarks()) {
                this.getOrCreateTrack(mark);
                if (i >= 2) continue;
                this.addStartToNextMarkCacheInvalidationListener(mark);
            }
            ++i;
        }
        this.courseSidelines = new LinkedHashMap<String, Sideline>();
        for (Sideline sideline : sidelines) {
            this.courseSidelines.put(sideline.getName(), sideline);
            for (Mark mark : sideline.getMarks()) {
                this.getOrCreateTrack(mark);
            }
        }
        this.trackedLegs = new LinkedHashMap();
        race.getCourse().lockForRead();
        try {
            for (Leg leg : race.getCourse().getLegs()) {
                this.trackedLegs.put(leg, this.createTrackedLeg(leg));
            }
            this.getRace().getCourse().addCourseListener(this);
        }
        finally {
            race.getCourse().unlockAfterRead();
        }
        this.markPassingsForCompetitor = new HashMap<Competitor, NavigableSet<MarkPassing>>();
        this.tracks = new HashMap<Competitor, GPSFixTrack<Competitor, GPSFixMoving>>();
        this.maneuverApproximators = new HashMap<Competitor, CourseChangeBasedTrackApproximation>();
        for (Competitor competitor : race.getCompetitors()) {
            this.markPassingsForCompetitor.put(competitor, new ConcurrentSkipListSet<MarkPassing>(MarkPassingByTimeComparator.INSTANCE));
            DynamicGPSFixMovingTrackImpl<Competitor> track = new DynamicGPSFixMovingTrackImpl<Competitor>(competitor, millisecondsOverWhichToAverageSpeed);
            this.tracks.put(competitor, track);
            this.maneuverApproximators.put(competitor, new CourseChangeBasedTrackApproximation(track, race.getBoatOfCompetitor(competitor).getBoatClass()));
        }
        this.markPassingsForWaypoint = new ConcurrentHashMap<Waypoint, NavigableSet<MarkPassing>>();
        for (Waypoint waypoint : race.getCourse().getWaypoints()) {
            this.markPassingsForWaypoint.put(waypoint, new ConcurrentSkipListSet<MarkPassing>(MarkPassingsByTimeAndCompetitorIdComparator.INSTANCE));
        }
        this.markPassingsTimes = new ArrayList<Util.Pair<Waypoint, Util.Pair<TimePoint, TimePoint>>>();
        this.crossTrackErrorCache = new CrossTrackErrorCache(this);
        this.loadingFromWindStoreState = LoadingFromStoresState.NOT_STARTED;
        new Thread("Mongo wind loader for tracked race " + this.getRace().getName()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LockUtil.lockForRead((NamedReentrantReadWriteLock)TrackedRaceImpl.this.getSerializationLock());
                LockUtil.lockForWrite((NamedReentrantReadWriteLock)TrackedRaceImpl.this.getLoadingFromWindStoreLock());
                TrackedRaceImpl trackedRaceImpl = TrackedRaceImpl.this;
                synchronized (trackedRaceImpl) {
                    TrackedRaceImpl.this.loadingFromWindStoreState = LoadingFromStoresState.RUNNING;
                    TrackedRaceImpl.this.notifyAll();
                }
                try {
                    logger.info("Started loading wind tracks for " + TrackedRaceImpl.this.getRace().getName());
                    Map<? extends WindSource, ? extends WindTrack> loadedWindTracks = windStore.loadWindTracks(trackedRegatta.getRegatta().getName(), TrackedRaceImpl.this, millisecondsOverWhichToAverageWind);
                    TrackedRaceImpl.this.windTracks.putAll(loadedWindTracks);
                    for (WindSource windSource : loadedWindTracks.keySet()) {
                        TrackedRaceImpl.this.updateWindSourcesByType(windSource);
                    }
                    TrackedRaceImpl.this.updateEventTimePoints(loadedWindTracks.values());
                    logger.info("Finished loading wind tracks for " + TrackedRaceImpl.this.getRace().getName() + ". Found " + TrackedRaceImpl.this.windTracks.size() + " wind tracks for this race.");
                }
                catch (Throwable throwable) {
                    Object object = TrackedRaceImpl.this;
                    synchronized (object) {
                        TrackedRaceImpl.this.loadingFromWindStoreState = LoadingFromStoresState.FINISHED;
                        TrackedRaceImpl.this.notifyAll();
                    }
                    object = TrackedRaceImpl.this.loadingFromWindStoreState;
                    synchronized (object) {
                        ((Object)((Object)TrackedRaceImpl.this.loadingFromWindStoreState)).notifyAll();
                    }
                    LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)TrackedRaceImpl.this.getLoadingFromWindStoreLock());
                    LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)TrackedRaceImpl.this.getSerializationLock());
                    throw throwable;
                }
                Object object = TrackedRaceImpl.this;
                synchronized (object) {
                    TrackedRaceImpl.this.loadingFromWindStoreState = LoadingFromStoresState.FINISHED;
                    TrackedRaceImpl.this.notifyAll();
                }
                object = TrackedRaceImpl.this.loadingFromWindStoreState;
                synchronized (object) {
                    ((Object)((Object)TrackedRaceImpl.this.loadingFromWindStoreState)).notifyAll();
                }
                LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)TrackedRaceImpl.this.getLoadingFromWindStoreLock());
                LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)TrackedRaceImpl.this.getSerializationLock());
            }
        }.start();
        WindSourceImpl courseBasedWindSource = new WindSourceImpl(WindSourceType.COURSE_BASED);
        this.windTracks.put(courseBasedWindSource, this.getOrCreateWindTrack((WindSource)courseBasedWindSource, delayForWindEstimationCacheInvalidation));
        WindSourceImpl trackBasedWindSource = new WindSourceImpl(WindSourceType.TRACK_BASED_ESTIMATION);
        this.windTracks.put(trackBasedWindSource, this.getOrCreateWindTrack((WindSource)trackBasedWindSource, delayForWindEstimationCacheInvalidation));
        this.competitorRankings = this.createCompetitorRankingsCache();
        this.competitorRankingsLocks = this.createCompetitorRankingsLockMap();
        if (useInternalMarkPassingAlgorithm) {
            this.markPassingCalculator = this.createMarkPassingCalculator(markPassingRaceFingerprintRegistry);
            this.trackedRegatta.addRaceListener(new RaceListener(){

                @Override
                public void raceAdded(TrackedRace trackedRace) {
                }

                @Override
                public void raceRemoved(TrackedRace trackedRace) {
                    if (trackedRace == TrackedRaceImpl.this) {
                        TrackedRaceImpl.this.markPassingCalculator.stop();
                    }
                }
            }, Optional.empty(), false);
        } else {
            this.markPassingCalculator = null;
        }
        this.sensorTracks = new HashMap();
        this.sensorTracksLock = new NamedReentrantReadWriteLock("sensorTracksLock", true);
        try {
            this.waitUntilLoadingFromWindStoreComplete();
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "Waiting for loading from stores to finish was interrupted", e);
        }
        this.rankingMetric = (RankingMetric)rankingMetricConstructor.apply(this);
    }

    protected void invalidateDistancesFromStarboardSideOfStartLineProjectedOntoLineCache(TimeRange timeRangeToInvalidate) {
        if (!this.distancesFromStarboardSideOfStartLineProjectedOntoLineCache.isEmpty()) {
            Iterator i = this.distancesFromStarboardSideOfStartLineProjectedOntoLineCache.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry next = i.next();
                if (!timeRangeToInvalidate.includes((TimePoint)next.getKey())) continue;
                i.remove();
                this.distancesFromStarboardSideOfStartLineProjectedOntoLineCacheLastAccessTimes.remove(next.getKey());
            }
        }
    }

    @Override
    public boolean recordWind(Wind wind, WindSource windSource, boolean applyFilter) {
        boolean result;
        if (!applyFilter || this.takesWindFixWithTimePoint(wind.getTimePoint())) {
            WindTrack windTrack = this.getOrCreateWindTrack(windSource);
            result = windTrack.add(wind);
            if (result) {
                this.updated(wind.getTimePoint());
                this.triggerManeuverCacheRecalculationForAllCompetitors();
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public void removeWind(Wind wind, WindSource windSource) {
        this.getOrCreateWindTrack(windSource).remove(wind);
        this.updated(null);
        this.triggerManeuverCacheRecalculationForAllCompetitors();
    }

    @Override
    public RankingMetric getRankingMetric() {
        return this.rankingMetric;
    }

    private LinkedHashMap<TimePoint, NamedReentrantReadWriteLock> createCompetitorRankingsLockMap() {
        return new LinkedHashMap<TimePoint, NamedReentrantReadWriteLock>(){
            private static final long serialVersionUID = 6298801656693955386L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<TimePoint, NamedReentrantReadWriteLock> eldest) {
                return this.size() > 10;
            }
        };
    }

    private LinkedHashMap<TimePoint, LinkedHashMap<Competitor, RankAndRankComparable>> createCompetitorRankingsCache() {
        return new LinkedHashMap<TimePoint, LinkedHashMap<Competitor, RankAndRankComparable>>(){
            private static final long serialVersionUID = -6044369612727021861L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<TimePoint, LinkedHashMap<Competitor, RankAndRankComparable>> eldest) {
                return this.size() > 10;
            }
        };
    }

    private void updateEventTimePoints(Iterable<? extends Track<? extends Timed>> tracks) {
        for (Track<? extends Timed> track : tracks) {
            track.lockForRead();
            try {
                for (Timed fix : track.getRawFixes()) {
                    this.updated(fix.getTimePoint());
                }
            }
            finally {
                track.unlockAfterRead();
            }
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.getRace().getCourse().lockForRead();
        try {
            LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.getSerializationLock());
            try {
                s.defaultWriteObject();
            }
            finally {
                LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.getSerializationLock());
            }
        }
        finally {
            this.getRace().getCourse().unlockAfterRead();
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.distancesFromStarboardSideOfStartLineProjectedOntoLineCache = new ConcurrentHashMap<TimePoint, SortedMap<Competitor, Distance>>();
        this.distancesFromStarboardSideOfStartLineProjectedOntoLineCacheLastAccessTimes = new ConcurrentHashMap<TimePoint, TimePoint>();
        this.getRace().getCourse().addCourseListener(this);
        for (DynamicSensorFixTrack<Competitor, ?> sensorTrack : this.sensorTracks.values()) {
            sensorTrack.addedToTrackedRace(this);
        }
        this.raceStates = new WeakHashMap();
        this.attachedRaceLogs = new ConcurrentHashMap<Serializable, RaceLog>();
        this.attachedRegattaLogs = new ConcurrentHashMap<Serializable, RegattaLog>();
        this.attachedRaceExecutionOrderProviders = new ConcurrentHashMap<RaceExecutionOrderProvider, RaceExecutionOrderProvider>();
        this.markPassingsTimes = new ArrayList<Util.Pair<Waypoint, Util.Pair<TimePoint, TimePoint>>>();
        this.shortTimeWindCache = new ShortTimeWindCache(this, this.millisecondsOverWhichToAverageWind / 2L);
        this.cacheInvalidationTimerLock = new Object();
        this.windStore = EmptyWindStore.INSTANCE;
        this.competitorRankings = this.createCompetitorRankingsCache();
        this.competitorRankingsLocks = this.createCompetitorRankingsLockMap();
        this.directionFromStartToNextMarkCache = new ConcurrentHashMap<TimePoint, Future<Wind>>();
        this.maneuverDetectorPerCompetitorCache = this.createManeuverDetectorCache();
        this.maneuverCache = this.createManeuverCache();
        logger.info("Deserialized race " + this.getRace().getName());
    }

    @Override
    public void initializeAfterDeserialization() {
        this.crossTrackErrorCache = new CrossTrackErrorCache(this);
        try {
            this.adjustStructureToCourse();
        }
        catch (PatchFailedException e) {
            throw new RuntimeException(e);
        }
        this.triggerManeuverCacheRecalculationForAllCompetitors();
    }

    private void adjustStructureToCourse() throws PatchFailedException {
        TrackedRaceAsWaypointList trackedRaceAsWaypointList = new TrackedRaceAsWaypointList(this);
        Patch diff = DiffUtils.diff((Iterable)trackedRaceAsWaypointList, (Iterable)this.getRace().getCourse().getWaypoints());
        if (!diff.isEmpty()) {
            logger.warning("Found inconsistency between race's course (" + this.getRace().getCourse() + ") and TrackedRace's structures in " + this + "; fixing");
        }
        diff.applyToInPlace((List)trackedRaceAsWaypointList);
    }

    @Override
    public synchronized void waitUntilLoadingFromWindStoreComplete() throws InterruptedException {
        while (this.loadingFromWindStoreState != LoadingFromStoresState.FINISHED) {
            this.wait();
        }
    }

    @Override
    public synchronized void waitForLoadingToFinish() throws InterruptedException {
    }

    public void waitForManeuverDetectionToFinish() {
        for (Competitor competitor : this.getRace().getCompetitors()) {
            this.getManeuvers(competitor, true);
        }
    }

    private ShortTimeAfterLastHitCache<Competitor, IncrementalManeuverDetector> createManeuverDetectorCache() {
        return new ShortTimeAfterLastHitCache<Competitor, IncrementalManeuverDetector>(600000L, competitor -> new IncrementalManeuverDetectorImpl(this, (Competitor)competitor, this.windEstimation));
    }

    private SmartFutureCache<Competitor, List<Maneuver>, SmartFutureCache.EmptyUpdateInterval> createManeuverCache() {
        return new SmartFutureCache((SmartFutureCache.CacheUpdater)new SmartFutureCache.AbstractCacheUpdater<Competitor, List<Maneuver>, SmartFutureCache.EmptyUpdateInterval>(){

            public List<Maneuver> computeCacheUpdate(Competitor competitor, SmartFutureCache.EmptyUpdateInterval updateInterval) throws NoWindException {
                return (List)TrackedRaceImpl.this.getTrackedRegatta().callWithCPUMeterWithException(() -> {
                    Duration averageIntervalBetweenRawFixes = TrackedRaceImpl.this.getTrack(competitor).getAverageIntervalBetweenRawFixes();
                    if (averageIntervalBetweenRawFixes != null) {
                        ManeuverDetector maneuverDetector = (ManeuverDetector)TrackedRaceImpl.this.maneuverDetectorPerCompetitorCache.getValue(competitor);
                        List maneuvers = TrackedRaceImpl.this.computeManeuvers(competitor, maneuverDetector);
                        return maneuvers;
                    }
                    return Collections.emptyList();
                }, CPUMeteringType.MANEUVER_DETECTION.name());
            }
        }, "Maneuver cache for race " + this.getRace().getName());
    }

    protected abstract TrackedLeg createTrackedLeg(Leg var1);

    @Override
    public RegattaAndRaceIdentifier getRaceIdentifier() {
        return new RegattaNameAndRaceName(this.getTrackedRegatta().getRegatta().getName(), this.getRace().getName());
    }

    @Override
    public NavigableSet<MarkPassing> getMarkPassings(Competitor competitor) {
        return this.getMarkPassings(competitor, false);
    }

    @Override
    public NavigableSet<MarkPassing> getMarkPassings(Competitor competitor, boolean waitForLatestUpdates) {
        if (waitForLatestUpdates && this.markPassingCalculator != null) {
            this.markPassingCalculator.lockForRead();
        }
        try {
            NavigableSet<MarkPassing> navigableSet = this.markPassingsForCompetitor.get(competitor);
            return navigableSet;
        }
        finally {
            if (waitForLatestUpdates && this.markPassingCalculator != null) {
                this.markPassingCalculator.unlockForRead();
            }
        }
    }

    protected NavigableSet<MarkPassing> getMarkPassingsInOrderAsNavigableSet(Waypoint waypoint) {
        return this.markPassingsForWaypoint.get(waypoint);
    }

    @Override
    public WindStore getWindStore() {
        return this.windStore;
    }

    public NavigableSet<MarkPassing> getMarkPassingsInOrder(Waypoint waypoint) {
        return this.getMarkPassingsInOrderAsNavigableSet(waypoint);
    }

    protected NavigableSet<MarkPassing> getOrCreateMarkPassingsInOrderAsNavigableSet(Waypoint waypoint) {
        NavigableSet<MarkPassing> result = this.getMarkPassingsInOrderAsNavigableSet(waypoint);
        if (result == null) {
            result = this.createMarkPassingsCollectionForWaypoint(waypoint);
        }
        return result;
    }

    protected NavigableSet<MarkPassing> createMarkPassingsCollectionForWaypoint(Waypoint waypoint) {
        ConcurrentSkipListSet<MarkPassing> result = new ConcurrentSkipListSet<MarkPassing>(MarkPassingsByTimeAndCompetitorIdComparator.INSTANCE);
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.getSerializationLock());
        try {
            this.markPassingsForWaypoint.put(waypoint, result);
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.getSerializationLock());
        }
        return result;
    }

    @Override
    public TimePoint getStartOfTracking() {
        return this.startOfTracking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStartAndEndOfTracking(boolean waitForGPSFixesToLoad) {
        TimePoint oldEndOfTracking;
        TimePoint oldStartOfTracking;
        Serializable serializable = this.updateStartAndEndOfTrackingMonitor;
        synchronized (serializable) {
            Util.Pair<TimePointSpecificationFoundInLog, TimePointSpecificationFoundInLog> trackingTimesFromRaceLog = this.getTrackingTimesFromRaceLogs();
            oldStartOfTracking = this.getStartOfTracking();
            oldEndOfTracking = this.getEndOfTracking();
            boolean startOfTrackingFound = false;
            boolean endOfTrackingFound = false;
            if (trackingTimesFromRaceLog != null) {
                if (trackingTimesFromRaceLog.getA() != null) {
                    this.startOfTracking = ((TimePointSpecificationFoundInLog)trackingTimesFromRaceLog.getA()).getTimePoint();
                    startOfTrackingFound = true;
                }
                if (trackingTimesFromRaceLog.getB() != null) {
                    this.endOfTracking = ((TimePointSpecificationFoundInLog)trackingTimesFromRaceLog.getB()).getTimePoint();
                    endOfTrackingFound = true;
                }
            }
            if (!startOfTrackingFound || !endOfTrackingFound) {
                if (this.startOfTrackingReceived != null && !startOfTrackingFound) {
                    startOfTrackingFound = true;
                    this.startOfTracking = this.startOfTrackingReceived;
                }
                if (this.endOfTrackingReceived != null && !endOfTrackingFound) {
                    endOfTrackingFound = true;
                    this.endOfTracking = this.endOfTrackingReceived;
                }
            }
            if (!startOfTrackingFound || !endOfTrackingFound) {
                if (!startOfTrackingFound && this.getStartOfRace() != null && this.getTrackedRegatta().getRegatta().isControlTrackingFromStartAndFinishTimes()) {
                    this.startOfTracking = this.getStartOfRace().minus(START_TRACKING_THIS_MUCH_BEFORE_RACE_START);
                    startOfTrackingFound = true;
                }
                if (!endOfTrackingFound && this.getFinishedTime() != null && this.getTrackedRegatta().getRegatta().isControlTrackingFromStartAndFinishTimes()) {
                    this.endOfTracking = this.getFinishedTime().plus(STOP_TRACKING_THIS_MUCH_AFTER_RACE_FINISH);
                    endOfTrackingFound = true;
                }
            }
            if (!startOfTrackingFound) {
                this.startOfTracking = null;
            }
            if (!endOfTrackingFound) {
                this.endOfTracking = null;
            }
        }
        this.startOfTrackingChanged(oldStartOfTracking, waitForGPSFixesToLoad);
        this.endOfTrackingChanged(oldEndOfTracking, waitForGPSFixesToLoad);
    }

    @Override
    public TimePoint getEndOfTracking() {
        return this.endOfTracking;
    }

    public void invalidateStartTime() {
        this.updateStartOfRaceCacheFields();
        this.updateStartAndEndOfTracking(false);
    }

    public void invalidateEndTime() {
        this.endTime = null;
        this.updateStartAndEndOfTracking(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateMarkPassingTimes() {
        List<Util.Pair<Waypoint, Util.Pair<TimePoint, TimePoint>>> list = this.markPassingsTimes;
        synchronized (list) {
            this.markPassingsTimes.clear();
        }
        this.updateStartAndEndOfTracking(false);
    }

    @Override
    public Util.Pair<TimePointSpecificationFoundInLog, TimePointSpecificationFoundInLog> getTrackingTimesFromRaceLogs() {
        for (RaceLog raceLog : this.attachedRaceLogs.values()) {
            Util.Pair result = (Util.Pair)new TrackingTimesFinder(raceLog).analyze();
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Util.Pair<TimePoint, TimePoint> getStartAndFinishedTimeFromRaceLogs() {
        for (RaceLog raceLog : this.attachedRaceLogs.values()) {
            TimePoint startTime = ((StartTimeFinderResult)new StartTimeFinder((RaceLogResolver)this.raceLogResolver, raceLog).analyze()).getStartTime();
            TimePoint finishedTime = (TimePoint)new FinishedTimeFinder(raceLog).analyze();
            if (startTime == null && finishedTime == null) continue;
            return new Util.Pair((Object)startTime, (Object)finishedTime);
        }
        return null;
    }

    @Override
    public TimePoint getStartOfRace() {
        return this.getStartOfRace(true);
    }

    @Override
    public TimePoint getStartOfRace(boolean inferred) {
        TimePoint result = inferred ? this.startTime : this.startTimeWithoutInferenceFromStartMarkPassings;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStartOfRaceCacheFields() {
        String string = this.updateStartOfRaceCacheFieldsMonitor;
        synchronized (string) {
            TimePoint newStartTime = null;
            TimePoint newStartTimeWithoutInferenceFromStartMarkPassings = null;
            for (RaceLog raceLog : this.attachedRaceLogs.values()) {
                logger.finest(() -> "Analyzing race log " + raceLog + " for race " + this.getRace().getName());
                newStartTime = ((StartTimeFinderResult)new StartTimeFinder((RaceLogResolver)this.raceLogResolver, raceLog).analyze()).getStartTime();
                if (newStartTime == null) continue;
                newStartTimeWithoutInferenceFromStartMarkPassings = newStartTime;
                TimePoint finalNewStartTime = newStartTime;
                logger.finest(() -> "Found start time " + finalNewStartTime + " in race log " + raceLog + " for race " + this.getRace().getName());
                break;
            }
            if (newStartTime == null) {
                Waypoint firstWaypoint;
                logger.finest(() -> "No start time found in race logs for race " + this.getRace().getName());
                newStartTime = this.getStartTimeReceived();
                if (newStartTime != null) {
                    newStartTimeWithoutInferenceFromStartMarkPassings = newStartTime;
                }
                if (this.getTrackedRegatta().getRegatta().useStartTimeInference() && (firstWaypoint = this.getRace().getCourse().getFirstWaypoint()) != null) {
                    if (this.startTimeReceived != null) {
                        TimePoint timeOfFirstMarkPassing = this.getFirstPassingTime(firstWaypoint);
                        if (timeOfFirstMarkPassing != null) {
                            long startTimeReceived2timeOfFirstMarkPassingFirstMark = timeOfFirstMarkPassing.asMillis() - this.startTimeReceived.asMillis();
                            if (startTimeReceived2timeOfFirstMarkPassingFirstMark > 30000L) {
                                TimePoint finalNewStartTime = newStartTime = new MillisecondsTimePoint(timeOfFirstMarkPassing.asMillis() - 30000L);
                                logger.finest(() -> "Using start mark passings for start time of race " + this.getRace().getName() + ": " + finalNewStartTime);
                            } else {
                                TimePoint finalNewStartTime = newStartTime = this.startTimeReceived;
                                logger.finest(() -> "Using start mark received for race " + this.getRace().getName() + ": " + finalNewStartTime);
                            }
                        }
                    } else {
                        NavigableSet<MarkPassing> markPassingsForFirstWaypointInOrder = this.getMarkPassingsInOrderAsNavigableSet(firstWaypoint);
                        if (markPassingsForFirstWaypointInOrder != null && (newStartTime = this.calculateStartOfRaceFromMarkPassings(markPassingsForFirstWaypointInOrder, this.getRace().getCompetitors())) != null && logger.isLoggable(Level.FINEST)) {
                            logger.finest("Using start mark passings for start time of race " + this.getRace().getName() + ": " + newStartTime);
                        }
                    }
                }
            }
            this.startTime = newStartTime;
            this.startTimeWithoutInferenceFromStartMarkPassings = newStartTimeWithoutInferenceFromStartMarkPassings;
        }
    }

    @Override
    public TimePoint getEndOfRace() {
        if (this.endTime == null) {
            this.endTime = this.getLastPassingOfFinishLine();
        }
        return this.endTime;
    }

    @Override
    public TimePoint getFinishingTime() {
        return this.finishingTime;
    }

    protected void setFinishingTime(TimePoint newFinishingTime) {
        this.finishingTime = newFinishingTime;
        this.updated(newFinishingTime);
    }

    @Override
    public TimePoint getFinishedTime() {
        return this.finishedTime;
    }

    protected void setFinishedTime(TimePoint newFinishedTime) {
        this.finishedTime = newFinishedTime;
        this.updated(newFinishedTime);
    }

    private TimePoint getLastPassingOfFinishLine() {
        Iterable markPassingsInOrder;
        TimePoint passingTime = null;
        Waypoint lastWaypoint = this.getRace().getCourse().getLastWaypoint();
        if (lastWaypoint != null && (markPassingsInOrder = this.getMarkPassingsInOrder(lastWaypoint)) != null) {
            this.lockForRead(markPassingsInOrder);
            try {
                MarkPassing last;
                MarkPassing markPassing = last = markPassingsInOrder.isEmpty() ? null : (MarkPassing)markPassingsInOrder.last();
                if (last != null) {
                    passingTime = last.getTimePoint();
                }
            }
            finally {
                this.unlockAfterRead(markPassingsInOrder);
            }
        }
        return passingTime;
    }

    private TimePoint getFirstPassingTime(Waypoint waypoint) {
        NavigableSet<MarkPassing> markPassingsInOrder = this.getMarkPassingsInOrderAsNavigableSet(waypoint);
        MarkPassing firstMarkPassing = null;
        if (markPassingsInOrder != null) {
            this.lockForRead(markPassingsInOrder);
            try {
                if (!markPassingsInOrder.isEmpty()) {
                    firstMarkPassing = (MarkPassing)markPassingsInOrder.first();
                }
            }
            finally {
                this.unlockAfterRead(markPassingsInOrder);
            }
        }
        TimePoint timeOfFirstMarkPassing = null;
        if (firstMarkPassing != null) {
            timeOfFirstMarkPassing = firstMarkPassing.getTimePoint();
        }
        return timeOfFirstMarkPassing;
    }

    /*
     * Unable to fully structure code
     */
    private TimePoint calculateStartOfRaceFromMarkPassings(NavigableSet<MarkPassing> markPassings, Iterable<Competitor> competitors) {
        block6: {
            startOfRace = null;
            this.lockForRead(markPassings);
            try {
                if (markPassings == null) break block6;
                largestStartGroupWithinOneMinuteSize = 0;
                startOfLargestGroupSoFar = null;
                candiateGroupSize = 0;
                candidateForStartOfLargestGroupSoFar = null;
                for (MarkPassing currentMarkPassing : markPassings) {
                    if (candidateForStartOfLargestGroupSoFar == null) {
                        candidateForStartOfLargestGroupSoFar = currentMarkPassing;
                        candiateGroupSize = 1;
                        startOfLargestGroupSoFar = currentMarkPassing;
                        largestStartGroupWithinOneMinuteSize = 1;
                        continue;
                    }
                    if (candidateForStartOfLargestGroupSoFar.getTimePoint().until(currentMarkPassing.getTimePoint()).compareTo((Object)Duration.ONE_MINUTE) > 0) ** GOTO lbl23
                    if (++candiateGroupSize <= largestStartGroupWithinOneMinuteSize) continue;
                    startOfLargestGroupSoFar = candidateForStartOfLargestGroupSoFar;
                    largestStartGroupWithinOneMinuteSize = candiateGroupSize;
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        candidateForStartOfLargestGroupSoFar = markPassings.higher(candidateForStartOfLargestGroupSoFar);
                        --candiateGroupSize;
lbl23:
                        // 2 sources

                        ** while (candidateForStartOfLargestGroupSoFar.getTimePoint().until((TimePoint)currentMarkPassing.getTimePoint()).compareTo((Object)Duration.ONE_MINUTE) > 0)
                    }
lbl24:
                    // 1 sources

                }
                startOfRace = startOfLargestGroupSoFar == null ? null : startOfLargestGroupSoFar.getTimePoint();
            }
            finally {
                this.unlockAfterRead(markPassings);
            }
        }
        return startOfRace;
    }

    @Override
    public boolean hasStarted(TimePoint at) {
        return this.getStartOfRace() != null && this.getStartOfRace().compareTo((Object)at) <= 0;
    }

    @Override
    public boolean isLive(TimePoint at) {
        Util.Pair minMax;
        Date timePoint = null;
        if (at != null) {
            timePoint = at.asDate();
        } else if (this.startOfTracking != null) {
            timePoint = this.startOfTracking.asDate();
        } else if (this.startTime != null) {
            timePoint = this.startTime.minus(240000L).plus(1L).asDate();
        }
        if (this.hasGPSData() && this.hasWindData() && (minMax = RaceTimesCalculationUtil.calculateRaceMinMax((Date)timePoint, (Date)(this.startOfTracking != null ? this.startOfTracking.asDate() : null), (Date)(this.startTime != null ? this.startTime.asDate() : null), (Date)(this.finishingTime != null ? this.finishingTime.asDate() : null), (Date)(this.finishedTime != null ? this.finishedTime.asDate() : null), (Date)(this.endTime != null ? this.endTime.asDate() : null), (Date)(this.endOfTracking != null ? this.endOfTracking.asDate() : null), (long)240000L, (long)180000L, (long)180000L)).getA() != null && minMax.getB() != null) {
            return !((Date)minMax.getA()).after(at.asDate()) && !at.asDate().after((Date)minMax.getB());
        }
        return false;
    }

    @Override
    public RaceDefinition getRace() {
        return this.race;
    }

    @Override
    public Iterable<TrackedLeg> getTrackedLegs() {
        this.getRace().getCourse().lockForRead();
        try {
            ArrayList<TrackedLeg> arrayList = new ArrayList<TrackedLeg>(this.trackedLegs.values());
            return arrayList;
        }
        finally {
            this.getRace().getCourse().unlockAfterRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Util.Pair<Waypoint, Util.Pair<TimePoint, TimePoint>>> getMarkPassingsTimes() {
        this.getRace().getCourse().lockForRead();
        try {
            List<Util.Pair<Waypoint, Util.Pair<TimePoint, TimePoint>>> list = this.markPassingsTimes;
            synchronized (list) {
                if (this.markPassingsTimes.isEmpty()) {
                    Date previousLegPassingTime = null;
                    for (Waypoint waypoint : this.getRace().getCourse().getWaypoints()) {
                        TimePoint firstPassingTime = null;
                        Object lastPassingTime = null;
                        NavigableSet<MarkPassing> markPassings = this.getMarkPassingsInOrderAsNavigableSet(waypoint);
                        if (markPassings != null && !markPassings.isEmpty()) {
                            this.lockForRead(markPassings);
                            try {
                                for (MarkPassing currentMarkPassing : markPassings) {
                                    Date currentPassingDate = currentMarkPassing.getTimePoint().asDate();
                                    if (previousLegPassingTime != null && !currentPassingDate.after(previousLegPassingTime)) continue;
                                    firstPassingTime = currentMarkPassing.getTimePoint();
                                    previousLegPassingTime = currentPassingDate;
                                    break;
                                }
                            }
                            finally {
                                this.unlockAfterRead(markPassings);
                            }
                        }
                        Util.Pair timesPair = new Util.Pair(firstPassingTime, lastPassingTime);
                        this.markPassingsTimes.add((Util.Pair<Waypoint, Util.Pair<TimePoint, TimePoint>>)new Util.Pair((Object)waypoint, (Object)timesPair));
                    }
                }
                List<Util.Pair<Waypoint, Util.Pair<TimePoint, TimePoint>>> list2 = this.markPassingsTimes;
                return list2;
            }
        }
        finally {
            this.getRace().getCourse().unlockAfterRead();
        }
    }

    @Override
    public Distance getDistanceTraveledIncludingGateStart(Competitor competitor, TimePoint timePoint) {
        return this.getDistanceTraveled(competitor, timePoint, true);
    }

    @Override
    public Distance getDistanceTraveled(Competitor competitor, TimePoint timePoint) {
        return this.getDistanceTraveled(competitor, timePoint, false);
    }

    private Distance getDistanceTraveled(Competitor competitor, TimePoint timePoint, boolean considerGateStart) {
        return (Distance)this.getValueFromStartToTimePointOrEnd(competitor, timePoint, (from, to) -> {
            Distance preResult = this.getTrack(competitor).getDistanceTraveled(from, to);
            Distance result = considerGateStart && preResult != null ? preResult.add(this.getAdditionalGateStartDistance(competitor, timePoint)) : preResult;
            return result;
        });
    }

    @Override
    public Distance getDistanceFoiled(Competitor competitor, TimePoint timePoint) {
        return this.getBravoValue(competitor, timePoint, BravoFixTrack::getDistanceSpentFoiling);
    }

    @Override
    public Duration getDurationFoiled(Competitor competitor, TimePoint timePoint) {
        return this.getBravoValue(competitor, timePoint, BravoFixTrack::getTimeSpentFoiling);
    }

    private <T> T getBravoValue(Competitor competitor, TimePoint timePoint, BravoFromToValueCalculator<T> bravoValueCalculator) {
        return this.getValueFromStartToTimePointOrEnd(competitor, timePoint, (from, to) -> {
            BravoFixTrack bravoFixTrack = (BravoFixTrack)this.getSensorTrack(competitor, "BravoFixTrack");
            Object result = bravoFixTrack != null ? bravoValueCalculator.getValue(bravoFixTrack, from, to) : null;
            return result;
        });
    }

    private <T> T getValueFromStartToTimePointOrEnd(Competitor competitor, TimePoint timePoint, Track.TimeRangeValueCalculator<T> valueCalculator) {
        NavigableSet<MarkPassing> markPassings = this.getMarkPassings(competitor);
        try {
            Object result;
            this.lockForRead(markPassings);
            if (markPassings.isEmpty()) {
                result = null;
            } else {
                TimePoint end = timePoint;
                if (((MarkPassing)markPassings.last()).getWaypoint() == this.getRace().getCourse().getLastWaypoint() && timePoint.compareTo((Object)((MarkPassing)markPassings.last()).getTimePoint()) > 0) {
                    end = ((MarkPassing)markPassings.last()).getTimePoint();
                } else {
                    TimePoint endOfTracking = this.getEndOfTracking();
                    TrackedLegOfCompetitor trackedLegOfCompetitor = this.getTrackedLeg(competitor, timePoint);
                    if (trackedLegOfCompetitor == null || endOfTracking != null && !trackedLegOfCompetitor.hasFinishedLeg(endOfTracking) && (timePoint.after(endOfTracking) || this.getStatus().getStatus() == TrackedRaceStatusEnum.FINISHED)) {
                        end = null;
                    }
                }
                result = end == null ? null : valueCalculator.calculate(((MarkPassing)markPassings.first()).getTimePoint(), end);
            }
            Object object = result;
            return (T)object;
        }
        finally {
            this.unlockAfterRead(markPassings);
        }
    }

    @Override
    public GPSFixTrack<Competitor, GPSFixMoving> getTrack(Competitor competitor) {
        return this.tracks.get(competitor);
    }

    @Override
    public TrackedLeg getTrackedLegFinishingAt(Waypoint endOfLeg) {
        this.getRace().getCourse().lockForRead();
        try {
            int indexOfWaypoint = this.getRace().getCourse().getIndexOfWaypoint(endOfLeg);
            if (indexOfWaypoint == -1) {
                throw new IllegalArgumentException("Waypoint " + endOfLeg + " not found in " + this.getRace().getCourse());
            }
            TrackedLeg result = indexOfWaypoint == 0 ? null : this.trackedLegs.get(this.race.getCourse().getLegs().get(indexOfWaypoint - 1));
            TrackedLeg trackedLeg = result;
            return trackedLeg;
        }
        finally {
            this.getRace().getCourse().unlockAfterRead();
        }
    }

    @Override
    public TrackedLeg getTrackedLegStartingAt(Waypoint startOfLeg) {
        this.getRace().getCourse().lockForRead();
        try {
            int indexOfWaypoint = this.getRace().getCourse().getIndexOfWaypoint(startOfLeg);
            if (indexOfWaypoint == -1) {
                throw new IllegalArgumentException("Waypoint " + startOfLeg + " not found in " + this.getRace().getCourse());
            }
            if (indexOfWaypoint == this.getRace().getCourse().getNumberOfWaypoints() - 1) {
                throw new IllegalArgumentException("Waypoint " + startOfLeg + " isn't start of any leg in " + this.getRace().getCourse());
            }
            TrackedLeg trackedLeg = this.trackedLegs.get(this.race.getCourse().getLeg(indexOfWaypoint));
            return trackedLeg;
        }
        finally {
            this.getRace().getCourse().unlockAfterRead();
        }
    }

    @Override
    public TrackedLegOfCompetitor getTrackedLeg(Competitor competitor, TimePoint at) {
        TrackedLegOfCompetitor result = null;
        NavigableSet<MarkPassing> roundings = this.getMarkPassings(competitor);
        if (roundings != null) {
            ArrayListNavigableSet localRoundings;
            this.lockForRead(roundings);
            try {
                localRoundings = new ArrayListNavigableSet(roundings.size(), (Comparator)new TimedComparator());
                localRoundings.addAll(roundings);
            }
            finally {
                this.unlockAfterRead(roundings);
            }
            Waypoint lastWaypoint = this.getRace().getCourse().getLastWaypoint();
            MarkPassing lastBeforeOrAt = localRoundings.floor(new DummyMarkPassingWithTimePointOnly(at));
            TrackedLeg trackedLeg = lastBeforeOrAt != null ? (lastWaypoint != lastBeforeOrAt.getWaypoint() ? this.getTrackedLegStartingAt(lastBeforeOrAt.getWaypoint()) : (!localRoundings.isEmpty() && at.equals(((MarkPassing)localRoundings.last()).getTimePoint()) ? this.getTrackedLegFinishingAt(lastBeforeOrAt.getWaypoint()) : null)) : null;
            if (trackedLeg != null) {
                result = trackedLeg.getTrackedLeg(competitor);
            }
        }
        return result;
    }

    @Override
    public TrackedLeg getTrackedLeg(Leg leg) {
        this.getRace().getCourse().lockForRead();
        try {
            TrackedLeg trackedLeg = this.trackedLegs.get(leg);
            return trackedLeg;
        }
        finally {
            this.getRace().getCourse().unlockAfterRead();
        }
    }

    @Override
    public TrackedLegOfCompetitor getTrackedLeg(Competitor competitor, Leg leg) {
        TrackedLeg trackedLeg = this.getTrackedLeg(leg);
        return trackedLeg == null ? null : trackedLeg.getTrackedLeg(competitor);
    }

    @Override
    public long getUpdateCount() {
        return this.updateCount;
    }

    @Override
    public int getRankDifference(Competitor competitor, Leg leg, TimePoint timePoint) {
        int previousRank;
        if (leg == this.getRace().getCourse().getFirstLeg()) {
            previousRank = 0;
        } else {
            TrackedLeg previousLeg = this.getTrackedLegFinishingAt(leg.getFrom());
            previousRank = previousLeg.getTrackedLeg(competitor).getRank(timePoint);
        }
        int currentRank = this.getTrackedLeg(competitor, leg).getRank(timePoint);
        return currentRank - previousRank;
    }

    @Override
    public int getRank(Competitor competitor) throws NoWindException {
        return this.getRank(competitor, MillisecondsTimePoint.now());
    }

    @Override
    public Competitor getOverallLeader(TimePoint timePoint) {
        return this.getOverallLeader(timePoint, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    @Override
    public Competitor getOverallLeader(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return (Competitor)Util.first(this.getCompetitorsFromBestToWorst(timePoint, cache));
    }

    private boolean hasZeroRankBecauseNoMarkPassingsAtOrBeforeTimePoint(Competitor competitor, TimePoint timePoint) {
        boolean hasZeroRankBecauseNoMarkPassingsAtOrBeforeTimePoint;
        NavigableSet<MarkPassing> markPassings = this.getMarkPassings(competitor);
        if (markPassings.isEmpty()) {
            hasZeroRankBecauseNoMarkPassingsAtOrBeforeTimePoint = true;
        } else {
            boolean hasNoMarkPassingAtOrBeforeTimePoint;
            this.lockForRead(markPassings);
            try {
                hasNoMarkPassingAtOrBeforeTimePoint = markPassings.floor(new DummyMarkPassingWithTimePointOnly(timePoint)) == null;
            }
            finally {
                this.unlockAfterRead(markPassings);
            }
            hasZeroRankBecauseNoMarkPassingsAtOrBeforeTimePoint = hasNoMarkPassingAtOrBeforeTimePoint;
        }
        return hasZeroRankBecauseNoMarkPassingsAtOrBeforeTimePoint;
    }

    @Override
    public int getRank(Competitor competitor, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        int result;
        if (this.hasZeroRankBecauseNoMarkPassingsAtOrBeforeTimePoint(competitor, timePoint)) {
            result = 0;
        } else {
            RankAndRankComparable rankAndRankComparable = this.getCompetitorsFromBestToWorstAndRankAndRankComparable(timePoint, cache).get(competitor);
            result = competitor == null ? 0 : rankAndRankComparable.getRank();
        }
        return result;
    }

    @Override
    public Boat getBoatOfCompetitor(Competitor competitor) {
        return this.getRace().getBoatOfCompetitor(competitor);
    }

    @Override
    public Competitor getCompetitorOfBoat(Boat boat) {
        if (boat == null) {
            return null;
        }
        for (Map.Entry<Competitor, Boat> competitorWithBoat : this.getRace().getCompetitorsAndTheirBoats().entrySet()) {
            if (!boat.equals(competitorWithBoat.getValue())) continue;
            return competitorWithBoat.getKey();
        }
        return null;
    }

    @Override
    public Iterable<Competitor> getCompetitorsFromBestToWorst(TimePoint timePoint) {
        return this.getCompetitorsFromBestToWorst(timePoint, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    @Override
    public Iterable<Competitor> getCompetitorsFromBestToWorst(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return this.getCompetitorsFromBestToWorstAndRankAndRankComparable(timePoint, new LeaderboardDTOCalculationReuseCache(timePoint)).keySet();
    }

    @Override
    public LinkedHashMap<Competitor, RankAndRankComparable> getCompetitorsFromBestToWorstAndRankAndRankComparable(TimePoint timePoint) {
        return this.getCompetitorsFromBestToWorstAndRankAndRankComparable(timePoint, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    @Override
    public List<CompetitorAndRankComparable> getCompetitorsFromBestToWorstAndRankComparable(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return this.getCompetitorsFromBestToWorstAndRankAndRankComparable(timePoint, cache).entrySet().stream().map(e -> new CompetitorAndRankComparable((Competitor)e.getKey(), ((RankAndRankComparable)e.getValue()).getRankComparable())).collect(Collectors.toList());
    }

    @Override
    public List<CompetitorAndRankComparable> getCompetitorsFromBestToWorstAndRankComparable(TimePoint timePoint) {
        return this.getCompetitorsFromBestToWorstAndRankAndRankComparable(timePoint).entrySet().stream().map(e -> new CompetitorAndRankComparable((Competitor)e.getKey(), ((RankAndRankComparable)e.getValue()).getRankComparable())).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashMap<Competitor, RankAndRankComparable> getCompetitorsFromBestToWorstAndRankAndRankComparable(TimePoint unadjustedTimePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        LinkedHashMap<Object, RankAndRankComparable> rankedCompetitors;
        block19: {
            NamedReentrantReadWriteLock readWriteLock;
            TimePoint timePoint = Util.compareToWithNull((Comparable)unadjustedTimePoint, (Comparable)this.getTimePointOfNewestEvent(), (boolean)false) <= 0 ? unadjustedTimePoint : this.getTimePointOfNewestEvent();
            LinkedHashMap<TimePoint, NamedReentrantReadWriteLock> linkedHashMap = this.competitorRankingsLocks;
            synchronized (linkedHashMap) {
                readWriteLock = this.competitorRankingsLocks.get(timePoint);
                if (readWriteLock == null) {
                    readWriteLock = new NamedReentrantReadWriteLock("competitor rankings for race " + this.getRace().getName() + " for time point " + timePoint, false);
                    this.competitorRankingsLocks.put(timePoint, readWriteLock);
                }
            }
            LinkedHashMap<TimePoint, LinkedHashMap<Competitor, RankAndRankComparable>> linkedHashMap2 = this.competitorRankings;
            synchronized (linkedHashMap2) {
                rankedCompetitors = this.competitorRankings.get(timePoint);
            }
            if (rankedCompetitors == null) {
                LockUtil.lockForWrite((NamedReentrantReadWriteLock)readWriteLock);
                try {
                    rankedCompetitors = this.competitorRankings.get(timePoint);
                    if (rankedCompetitors != null) break block19;
                    this.getRace().getCourse().lockForRead();
                    try {
                        Comparator<Competitor> comparator = this.getRankingMetric().getRaceRankingComparator(timePoint, cache);
                        ArrayList<Competitor> tempList = new ArrayList<Competitor>();
                        for (Competitor c : this.getRace().getCompetitors()) {
                            tempList.add(c);
                        }
                        Collections.sort(tempList, comparator);
                        Iterator it = tempList.iterator();
                        rankedCompetitors = new LinkedHashMap();
                        int i = 1;
                        while (it.hasNext()) {
                            Competitor competitor = (Competitor)it.next();
                            int rank = this.hasZeroRankBecauseNoMarkPassingsAtOrBeforeTimePoint(competitor, timePoint) ? 0 : i;
                            rankedCompetitors.put(competitor, new RankAndRankComparable(rank, new Leaderboard.RankComparableRank(rank)));
                            ++i;
                        }
                    }
                    finally {
                        this.getRace().getCourse().unlockAfterRead();
                    }
                    linkedHashMap2 = this.competitorRankings;
                    synchronized (linkedHashMap2) {
                        this.competitorRankings.put(timePoint, rankedCompetitors);
                    }
                }
                finally {
                    LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)readWriteLock);
                }
            }
        }
        return rankedCompetitors;
    }

    @Override
    public Distance getAverageAbsoluteCrossTrackError(Competitor competitor, TimePoint timePoint, boolean waitForLatestAnalysis) {
        return this.getAverageAbsoluteCrossTrackError(competitor, timePoint, waitForLatestAnalysis, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    @Override
    public Distance getAverageAbsoluteCrossTrackError(Competitor competitor, TimePoint timePoint, boolean waitForLatestAnalysis, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        NavigableSet<MarkPassing> markPassings = this.getMarkPassings(competitor);
        TimePoint from = null;
        this.lockForRead(markPassings);
        try {
            if (markPassings != null && !markPassings.isEmpty()) {
                from = markPassings.iterator().next().getTimePoint();
            }
        }
        finally {
            this.unlockAfterRead(markPassings);
        }
        Distance result = from != null ? this.getAverageAbsoluteCrossTrackError(competitor, from, timePoint, true, waitForLatestAnalysis) : null;
        return result;
    }

    @Override
    public Distance getAverageSignedCrossTrackError(Competitor competitor, TimePoint timePoint, boolean waitForLatestAnalysis) {
        return this.getAverageSignedCrossTrackError(competitor, timePoint, waitForLatestAnalysis, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    @Override
    public Distance getAverageSignedCrossTrackError(Competitor competitor, TimePoint timePoint, boolean waitForLatestAnalyses, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        NavigableSet<MarkPassing> markPassings = this.getMarkPassings(competitor);
        TimePoint from = null;
        this.lockForRead(markPassings);
        try {
            if (markPassings != null && !markPassings.isEmpty()) {
                from = markPassings.iterator().next().getTimePoint();
            }
        }
        finally {
            this.unlockAfterRead(markPassings);
        }
        Distance result = from != null ? this.getAverageSignedCrossTrackError(competitor, from, timePoint, true, waitForLatestAnalyses) : null;
        return result;
    }

    @Override
    public Distance getAverageAbsoluteCrossTrackError(Competitor competitor, TimePoint from, TimePoint to, boolean upwindOnly, boolean waitForLatestAnalysis) {
        Distance result = this.crossTrackErrorCache.getAverageAbsoluteCrossTrackError(competitor, from, to, upwindOnly, waitForLatestAnalysis);
        return result;
    }

    @Override
    public Distance getAverageSignedCrossTrackError(Competitor competitor, TimePoint from, TimePoint to, boolean upwindOnly, boolean waitForLatestAnalysis) {
        Distance result = this.crossTrackErrorCache.getAverageSignedCrossTrackError(competitor, from, to, upwindOnly, waitForLatestAnalysis);
        return result;
    }

    @Override
    public Distance getAverageRideHeight(Competitor competitor, TimePoint timePoint) {
        Distance result;
        TrackedLegOfCompetitor firstTrackedLeg;
        Leg firstLeg;
        BravoFixTrack track = (BravoFixTrack)this.getSensorTrack(competitor, "BravoFixTrack");
        if (track != null && (firstLeg = this.getRace().getCourse().getFirstLeg()) != null && (firstTrackedLeg = this.getTrackedLeg(competitor, firstLeg)).hasStartedLeg(timePoint)) {
            TrackedLegOfCompetitor lastTrackedLeg = this.getTrackedLegFinishingAt(this.getRace().getCourse().getLastWaypoint()).getTrackedLeg(competitor);
            TimePoint endTimePoint = lastTrackedLeg.hasFinishedLeg(timePoint) ? lastTrackedLeg.getFinishTime() : timePoint;
            result = track.getAverageRideHeight(firstTrackedLeg.getStartTime(), endTimePoint);
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public TrackedLegOfCompetitor getCurrentLeg(Competitor competitor, TimePoint timePoint) {
        NavigableSet<MarkPassing> competitorMarkPassings = this.markPassingsForCompetitor.get(competitor);
        DummyMarkPassingWithTimePointAndCompetitor markPassingTimePoint = new DummyMarkPassingWithTimePointAndCompetitor(timePoint, competitor);
        TrackedLegOfCompetitor result = null;
        if (!competitorMarkPassings.isEmpty()) {
            Course course = this.getRace().getCourse();
            course.lockForRead();
            try {
                Waypoint waypointPassedLastAtOrBeforeTimePoint;
                MarkPassing lastMarkPassingAtOfBeforeTimePoint = competitorMarkPassings.floor(markPassingTimePoint);
                if (lastMarkPassingAtOfBeforeTimePoint != null && (waypointPassedLastAtOrBeforeTimePoint = lastMarkPassingAtOfBeforeTimePoint.getWaypoint()) != course.getLastWaypoint()) {
                    result = this.getTrackedLegStartingAt(waypointPassedLastAtOrBeforeTimePoint).getTrackedLeg(competitor);
                }
            }
            finally {
                course.unlockAfterRead();
            }
        }
        return result;
    }

    @Override
    public TrackedLeg getCurrentLeg(TimePoint timePoint) {
        Waypoint lastWaypointPassed = null;
        int indexOfLastWaypointPassed = -1;
        for (Map.Entry<Waypoint, NavigableSet<MarkPassing>> entry : this.markPassingsForWaypoint.entrySet()) {
            int indexOfWaypoint;
            MarkPassing first;
            if (entry.getValue().isEmpty() || (first = (MarkPassing)entry.getValue().first()).getTimePoint().compareTo((Object)timePoint) > 0 || (indexOfWaypoint = this.getRace().getCourse().getIndexOfWaypoint(entry.getKey())) <= indexOfLastWaypointPassed) continue;
            indexOfLastWaypointPassed = indexOfWaypoint;
            lastWaypointPassed = entry.getKey();
        }
        TrackedLeg result = null;
        if (lastWaypointPassed != null && lastWaypointPassed != this.getRace().getCourse().getLastWaypoint()) {
            result = this.getTrackedLegStartingAt(lastWaypointPassed);
        }
        return result;
    }

    @Override
    public int getLastLegStarted(TimePoint timePoint) {
        int result = 0;
        int indexOfLastWaypointPassed = -1;
        int legCount = this.race.getCourse().getLegs().size();
        for (Map.Entry<Waypoint, NavigableSet<MarkPassing>> entry : this.markPassingsForWaypoint.entrySet()) {
            int indexOfWaypoint;
            MarkPassing first;
            if (entry.getValue().isEmpty() || (first = (MarkPassing)entry.getValue().first()).getTimePoint().compareTo((Object)timePoint) > 0 || (indexOfWaypoint = this.getRace().getCourse().getIndexOfWaypoint(entry.getKey())) <= indexOfLastWaypointPassed) continue;
            indexOfLastWaypointPassed = indexOfWaypoint;
        }
        if (indexOfLastWaypointPassed >= 0) {
            result = indexOfLastWaypointPassed + 1 < legCount ? indexOfLastWaypointPassed + 1 : legCount;
        }
        return result;
    }

    @Override
    public MarkPassing getMarkPassing(Competitor competitor, Waypoint waypoint) {
        Iterable markPassings = this.getMarkPassingsInOrder(waypoint);
        if (markPassings != null) {
            this.lockForRead(markPassings);
            try {
                for (MarkPassing markPassing : markPassings) {
                    if (markPassing.getCompetitor() != competitor) continue;
                    MarkPassing markPassing2 = markPassing;
                    return markPassing2;
                }
            }
            finally {
                this.unlockAfterRead(markPassings);
            }
        }
        return null;
    }

    @Override
    public GPSFixTrack<Mark, GPSFix> getOrCreateTrack(Mark mark) {
        return this.getOrCreateTrack(mark, true);
    }

    @Override
    public GPSFixTrack<Mark, GPSFix> getTrack(Mark mark) {
        return this.getOrCreateTrack(mark, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GPSFixTrack<Mark, GPSFix> getOrCreateTrack(Mark mark, boolean createIfNotExistent) {
        DynamicGPSFixTrackImpl<Mark> result = (DynamicGPSFixTrackImpl<Mark>)this.markTracks.get(mark);
        if (result == null) {
            ConcurrentMap<Mark, GPSFixTrack<Mark, GPSFix>> concurrentMap = this.markTracks;
            synchronized (concurrentMap) {
                LockUtil.lockForRead((NamedReentrantReadWriteLock)this.getSerializationLock());
                try {
                    result = (GPSFixTrack)this.markTracks.get(mark);
                    if (result == null && createIfNotExistent) {
                        result = this.createMarkTrack(mark);
                        this.markTracks.put(mark, result);
                    }
                }
                finally {
                    LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.getSerializationLock());
                }
            }
        }
        return result;
    }

    protected DynamicGPSFixTrackImpl<Mark> createMarkTrack(Mark mark) {
        return new DynamicGPSFixTrackImpl<Mark>(mark, this.millisecondsOverWhichToAverageSpeed);
    }

    @Override
    public Position getApproximatePosition(Waypoint waypoint, TimePoint timePoint, MarkPositionAtTimePointCache markPositionCache) {
        assert (timePoint.equals(markPositionCache.getTimePoint()));
        assert (this == markPositionCache.getTrackedRace());
        Position result = null;
        for (Mark mark : waypoint.getMarks()) {
            Position nextPos = markPositionCache.getEstimatedPosition(mark);
            if (result == null) {
                result = nextPos;
                continue;
            }
            if (nextPos == null) continue;
            result = result.translateGreatCircle(result.getBearingGreatCircle(nextPos), result.getDistance(nextPos).scale(0.5));
        }
        return result;
    }

    @Override
    public boolean hasWindData() {
        boolean result = false;
        Course course = this.getRace().getCourse();
        TimePoint timepoint = this.getStartOfRace();
        if (timepoint == null) {
            timepoint = this.getStartOfTracking();
        }
        if (timepoint != null) {
            Wind wind;
            Position position = null;
            for (Waypoint waypoint : course.getWaypoints()) {
                position = this.getApproximatePosition(waypoint, timepoint);
                if (position != null) break;
            }
            if ((wind = this.getWind(position, timepoint)) != null) {
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean takesWindFixWithTimePoint(TimePoint timePoint) {
        HashSet<TrackedRace> visited = new HashSet<TrackedRace>();
        visited.add(this);
        return this.takesWindFixWithTimePointRecursively(timePoint, visited);
    }

    @Override
    public boolean takesWindFixWithTimePointRecursively(TimePoint windFixTimePoint, Set<TrackedRace> visited) {
        TimePoint earliestStartTimePoint = Util.getEarliestOfTimePoints((TimePoint)this.getStartOfRace(), (TimePoint)this.getStartOfTracking());
        TimePoint latestEndTimePoint = Util.getLatestOfTimePoints((TimePoint)this.getEndOfRace(), (TimePoint)this.getEndOfTracking());
        boolean result = earliestStartTimePoint != null ? (latestEndTimePoint == null || windFixTimePoint.minus(180000L).before(latestEndTimePoint) ? (windFixTimePoint.plus(TIME_BEFORE_START_TO_TRACK_WIND_MILLIS).after(earliestStartTimePoint) ? true : (windFixTimePoint.plus(EXTRA_LONG_TIME_BEFORE_START_TO_TRACK_WIND_MILLIS).before(earliestStartTimePoint) ? false : this.noPreviousRaceTakesWindFixWithTimePoint(windFixTimePoint, visited))) : false) : false;
        return result;
    }

    private boolean noPreviousRaceTakesWindFixWithTimePoint(TimePoint timePoint, Set<TrackedRace> visited) {
        Set<TrackedRace> previousRacesInExecutionOrder = this.getPreviousRacesFromAttachedRaceExecutionOrderProviders();
        boolean result = previousRacesInExecutionOrder == null || !previousRacesInExecutionOrder.stream().filter(tr -> visited.add((TrackedRace)tr) && tr.takesWindFixWithTimePointRecursively(timePoint, visited)).findAny().isPresent();
        return result;
    }

    @Override
    public Wind getWind(Position p, TimePoint at) {
        return this.getWind(p, at, this.getWindSourcesToExclude());
    }

    @Override
    public Wind getWind(Position p, TimePoint at, Set<WindSource> windSourcesToExclude) {
        WindWithConfidence<Util.Pair<Position, TimePoint>> windWithConfidence = this.getWindWithConfidence(p, at, windSourcesToExclude);
        return windWithConfidence == null ? null : (Wind)windWithConfidence.getObject();
    }

    @Override
    public WindWithConfidence<Util.Pair<Position, TimePoint>> getWindWithConfidence(Position p, TimePoint at) {
        return this.getWindWithConfidence(p, at, this.getWindSourcesToExclude());
    }

    @Override
    public Set<WindSource> getWindSourcesToExclude() {
        return Collections.unmodifiableSet(this.windSourcesToExclude.keySet());
    }

    @Override
    public void setWindSourcesToExclude(Iterable<? extends WindSource> windSourcesToExclude) {
        HashSet<WindSource> old = new HashSet<WindSource>(this.getWindSourcesToExclude());
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.getSerializationLock());
        try {
            this.windSourcesToExclude.clear();
            for (WindSource windSource : windSourcesToExclude) {
                this.windSourcesToExclude.put(windSource, this);
            }
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.getSerializationLock());
        }
        if (!old.equals(new HashSet<WindSource>(this.getWindSourcesToExclude()))) {
            this.clearAllCachesExceptManeuvers();
            this.triggerManeuverCacheRecalculationForAllCompetitors();
        }
    }

    @Override
    public WindWithConfidence<Util.Pair<Position, TimePoint>> getWindWithConfidence(Position position, TimePoint at, Set<WindSource> windSourcesToExclude) {
        WindWithConfidence<Util.Pair<Position, TimePoint>> windWithConfidence = this.shortTimeWindCache.getWindWithConfidence(position, this.roundToDuration(at, Duration.ONE_SECOND), windSourcesToExclude);
        return windWithConfidence;
    }

    private TimePoint roundToDuration(TimePoint t, Duration roundTo) {
        long roundToMillis = roundTo.asMillis();
        long half = roundToMillis / 2L;
        return new MillisecondsTimePoint((t.asMillis() + half) / roundToMillis * roundToMillis);
    }

    public WindWithConfidence<Util.Pair<Position, TimePoint>> getWindWithConfidenceUncached(Position p, TimePoint at, Iterable<WindSource> windSourcesToExclude) {
        boolean canUseSpeedOfAtLeastOneWindSource = false;
        PositionAndTimePointWeigher weigher = new PositionAndTimePointWeigher(WindTrack.WIND_HALF_CONFIDENCE_DURATION, WindTrack.WIND_HALF_CONFIDENCE_DISTANCE);
        ConfidenceBasedWindAverager<Util.Pair> averager = ConfidenceFactory.INSTANCE.createWindAverager(weigher);
        ArrayList<WindWithConfidence<Util.Pair<Position, TimePoint>>> windFixesWithConfidences = new ArrayList<WindWithConfidence<Util.Pair<Position, TimePoint>>>();
        for (WindSource windSource : this.getWindSources()) {
            WindTrack track;
            WindWithConfidence<Util.Pair<Position, TimePoint>> windWithConfidence;
            if (Util.contains(windSourcesToExclude, (Object)windSource) || (windWithConfidence = (track = this.getOrCreateWindTrack(windSource)).getAveragedWindWithConfidence(p, at)) == null) continue;
            windFixesWithConfidences.add(windWithConfidence);
            boolean bl = canUseSpeedOfAtLeastOneWindSource = canUseSpeedOfAtLeastOneWindSource || windSource.getType().useSpeed();
        }
        WindWithConfidence<Util.Pair> average = averager.getAverage(windFixesWithConfidences, new Util.Pair((Object)p, (Object)at));
        WindWithConfidenceImpl<Util.Pair> result = average == null ? null : new WindWithConfidenceImpl<Util.Pair>((Wind)average.getObject(), average.getConfidence(), new Util.Pair((Object)p, (Object)at), canUseSpeedOfAtLeastOneWindSource);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Wind getDirectionFromStartToNextMark(final TimePoint at) {
        FutureTask newFuture = null;
        Future future = (Future)this.directionFromStartToNextMarkCache.get(at);
        if (future == null) {
            ConcurrentMap<TimePoint, Future<Wind>> concurrentMap = this.directionFromStartToNextMarkCache;
            synchronized (concurrentMap) {
                future = (Future)this.directionFromStartToNextMarkCache.get(at);
                if (future == null) {
                    newFuture = new FutureTaskWithTracingGet("getDirectionFromStartToNextMark for " + this, (Callable)new Callable<Wind>(){

                        @Override
                        public Wind call() {
                            WindImpl result;
                            Leg firstLeg = TrackedRaceImpl.this.getRace().getCourse().getFirstLeg();
                            if (firstLeg != null) {
                                Position firstLegEnd = TrackedRaceImpl.this.getApproximatePosition(firstLeg.getTo(), at);
                                Position firstLegStart = TrackedRaceImpl.this.getApproximatePosition(firstLeg.getFrom(), at);
                                result = firstLegStart != null && firstLegEnd != null ? new WindImpl(firstLegStart, at, (SpeedWithBearing)new KnotSpeedWithBearingImpl(0.0, firstLegEnd.getBearingGreatCircle(firstLegStart))) : null;
                            } else {
                                result = null;
                            }
                            return result;
                        }
                    });
                    this.directionFromStartToNextMarkCache.put(at, newFuture);
                }
            }
        }
        if (newFuture != null) {
            newFuture.run();
            future = newFuture;
        }
        try {
            return (Wind)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TimePoint getTimePointOfOldestEvent() {
        return this.timePointOfOldestEvent;
    }

    @Override
    public TimePoint getTimePointOfNewestEvent() {
        return this.timePointOfNewestEvent;
    }

    @Override
    public TimePoint getTimePointOfLastEvent() {
        return this.timePointOfLastEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updated(TimePoint timeOfEvent) {
        ++this.updateCount;
        this.clearAllCachesExceptManeuvers();
        if (timeOfEvent != null) {
            if (this.timePointOfNewestEvent == null || this.timePointOfNewestEvent.compareTo((Object)timeOfEvent) < 0) {
                this.timePointOfNewestEvent = timeOfEvent;
            }
            if (this.timePointOfOldestEvent == null || this.timePointOfOldestEvent.compareTo((Object)timeOfEvent) > 0) {
                this.timePointOfOldestEvent = timeOfEvent;
            }
            this.timePointOfLastEvent = timeOfEvent;
        }
        TrackedRaceImpl trackedRaceImpl = this;
        synchronized (trackedRaceImpl) {
            this.notifyAll();
        }
    }

    protected void setStartTimeReceived(TimePoint start) {
        if (!Util.equalsWithNull((Object)start, (Object)this.startTimeReceived)) {
            this.startTimeReceived = start;
            this.invalidateStartTime();
            this.invalidateMarkPassingTimes();
        }
    }

    @Override
    public TimePoint getStartTimeReceived() {
        return this.startTimeReceived;
    }

    protected void setStartOfTrackingReceived(TimePoint startOfTracking, boolean waitForGPSFixesToLoad) {
        this.startOfTrackingReceived = startOfTracking;
        this.updateStartAndEndOfTracking(waitForGPSFixesToLoad);
    }

    protected void startOfTrackingChanged(TimePoint oldStartOfTracking, boolean waitForGPSFixesToLoad) {
    }

    protected void setEndOfTrackingReceived(TimePoint endOfTracking, boolean waitForGPSFixesToLoad) {
        this.endOfTrackingReceived = endOfTracking;
        this.updateStartAndEndOfTracking(waitForGPSFixesToLoad);
    }

    protected void endOfTrackingChanged(TimePoint oldEndOfTracking, boolean waitForGPSFixesToLoad) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAllCachesExceptManeuvers() {
        Object object = this.cacheInvalidationTimerLock;
        synchronized (object) {
            if (this.cacheInvalidationTimer == null) {
                this.cacheInvalidationTimer = new Timer("Cache invalidation timer for TrackedRaceImpl " + this.getRace().getName(), true);
                this.cacheInvalidationTimer.schedule(new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = TrackedRaceImpl.this.cacheInvalidationTimerLock;
                        synchronized (object) {
                            TrackedRaceImpl.this.cacheInvalidationTimer.cancel();
                            TrackedRaceImpl.this.cacheInvalidationTimer = null;
                        }
                        object = TrackedRaceImpl.this.competitorRankings;
                        synchronized (object) {
                            TrackedRaceImpl.this.competitorRankings.clear();
                        }
                        object = TrackedRaceImpl.this.competitorRankingsLocks;
                        synchronized (object) {
                            TrackedRaceImpl.this.competitorRankingsLocks.clear();
                        }
                    }
                }, 7500L);
            }
        }
    }

    @Override
    public synchronized void waitForNextUpdate(int sinceUpdate) throws InterruptedException {
        while (this.updateCount <= (long)sinceUpdate) {
            this.wait();
        }
    }

    @Override
    public void waypointAdded(int zeroBasedIndex, Waypoint waypointThatGotAdded) {
        logger.info("waypoint at zero-based index " + zeroBasedIndex + " (" + waypointThatGotAdded + ") added; updating tracked race " + this + "'s data structures...");
        this.invalidateMarkPassingTimes();
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.getSerializationLock());
        try {
            this.updateStartToNextMarkCacheInvalidationCacheListenersAfterWaypointAdded(zeroBasedIndex, waypointThatGotAdded);
            this.getOrCreateMarkPassingsInOrderAsNavigableSet(waypointThatGotAdded);
            for (Mark mark : waypointThatGotAdded.getMarks()) {
                this.getOrCreateTrack(mark);
            }
            LinkedHashMap<Leg, TrackedLeg> reorderedTrackedLegs = new LinkedHashMap<Leg, TrackedLeg>();
            List newLegs = this.getRace().getCourse().getLegs();
            for (Leg leg : newLegs) {
                TrackedLeg trackedLeg = this.trackedLegs.get(leg);
                if (trackedLeg != null) {
                    reorderedTrackedLegs.put(leg, trackedLeg);
                    continue;
                }
                reorderedTrackedLegs.put(leg, this.createTrackedLeg(leg));
            }
            this.trackedLegs.clear();
            for (Map.Entry entry : reorderedTrackedLegs.entrySet()) {
                this.trackedLegs.put((Leg)entry.getKey(), (TrackedLeg)entry.getValue());
                ((TrackedLeg)entry.getValue()).waypointsMayHaveChanges();
            }
            this.updated(null);
            logger.info("done updating tracked race " + this + "'s data structures...");
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.getSerializationLock());
        }
    }

    private void updateStartToNextMarkCacheInvalidationCacheListenersAfterWaypointAdded(int zeroBasedIndex, Waypoint waypointThatGotAdded) {
        if (zeroBasedIndex < 2) {
            this.clearDirectionFromStartToNextMarkCache();
            Iterator waypointsIter = this.getRace().getCourse().getWaypoints().iterator();
            waypointsIter.next();
            if (waypointsIter.hasNext()) {
                waypointsIter.next();
                if (waypointsIter.hasNext()) {
                    Waypoint oldSecond = (Waypoint)waypointsIter.next();
                    this.stopAndRemoveStartToNextMarkCacheInvalidationListener(oldSecond);
                }
            }
        }
        this.addStartToNextMarkCacheInvalidationListener(waypointThatGotAdded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearDirectionFromStartToNextMarkCache() {
        ConcurrentMap<TimePoint, Future<Wind>> concurrentMap = this.directionFromStartToNextMarkCache;
        synchronized (concurrentMap) {
            this.directionFromStartToNextMarkCache.clear();
        }
    }

    private void addStartToNextMarkCacheInvalidationListener(Waypoint waypoint) {
        for (Mark mark : waypoint.getMarks()) {
            this.addStartToNextMarkCacheInvalidationListener(mark);
        }
    }

    private void addStartToNextMarkCacheInvalidationListener(Mark mark) {
        GPSFixTrack<Mark, GPSFix> track = this.getOrCreateTrack(mark);
        StartToNextMarkCacheInvalidationListener listener = new StartToNextMarkCacheInvalidationListener(track);
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.getSerializationLock());
        try {
            this.startToNextMarkCacheInvalidationListeners.put(mark, listener);
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.getSerializationLock());
        }
        track.addListener(listener);
    }

    private void stopAndRemoveStartToNextMarkCacheInvalidationListener(Waypoint waypoint) {
        for (Mark mark : waypoint.getMarks()) {
            this.stopAndRemoveStartToNextMarkCacheInvalidationListener(mark);
        }
    }

    private void stopAndRemoveStartToNextMarkCacheInvalidationListener(Mark mark) {
        StartToNextMarkCacheInvalidationListener listener = this.startToNextMarkCacheInvalidationListeners.get(mark);
        if (listener != null) {
            listener.stopListening();
            LockUtil.lockForRead((NamedReentrantReadWriteLock)this.getSerializationLock());
            try {
                this.startToNextMarkCacheInvalidationListeners.remove(mark);
            }
            finally {
                LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.getSerializationLock());
            }
        }
    }

    @Override
    public void waypointRemoved(int zeroBasedIndex, Waypoint waypointThatGotRemoved) {
        logger.info("waypoint at zero-based index " + zeroBasedIndex + " (" + waypointThatGotRemoved + ") removed; updating tracked race " + this + "'s data structures...");
        this.invalidateMarkPassingTimes();
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.getSerializationLock());
        try {
            this.updateStartToNextMarkCacheInvalidationCacheListenersAfterWaypointRemoved(zeroBasedIndex, waypointThatGotRemoved);
            Leg toRemove = null;
            Leg last = null;
            int i = 0;
            for (Map.Entry<Leg, TrackedLeg> e : this.trackedLegs.entrySet()) {
                last = e.getKey();
                if (i == zeroBasedIndex) {
                    toRemove = e.getKey();
                    break;
                }
                ++i;
            }
            if (toRemove == null && !this.trackedLegs.isEmpty()) {
                toRemove = last;
            }
            if (toRemove != null) {
                logger.info("Removing tracked leg at zero-based index " + zeroBasedIndex + " from tracked race " + this.getRace().getName());
                LinkedHashMap<Leg, TrackedLeg> newTrackedLegs = new LinkedHashMap<Leg, TrackedLeg>();
                for (Map.Entry<Leg, TrackedLeg> trackedLegsEntry : this.trackedLegs.entrySet()) {
                    if (trackedLegsEntry.getKey() == toRemove) break;
                    newTrackedLegs.put(trackedLegsEntry.getKey(), trackedLegsEntry.getValue());
                }
                this.trackedLegs.clear();
                this.trackedLegs.putAll(newTrackedLegs);
                List newLegs = this.getRace().getCourse().getLegs();
                int j = zeroBasedIndex;
                while (j < newLegs.size()) {
                    this.trackedLegs.put((Leg)newLegs.get(j), this.createTrackedLeg((Leg)newLegs.get(j)));
                    ++j;
                }
                this.updated(null);
            }
            NavigableSet<MarkPassing> markPassingsRemoved = this.markPassingsForWaypoint.remove(waypointThatGotRemoved);
            for (NavigableSet<MarkPassing> markPassingsForOneCompetitor : this.markPassingsForCompetitor.values()) {
                if (markPassingsForOneCompetitor.isEmpty()) continue;
                Competitor competitor = markPassingsForOneCompetitor.iterator().next().getCompetitor();
                LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.getMarkPassingsLock(markPassingsForOneCompetitor));
                try {
                    markPassingsForOneCompetitor.removeAll(markPassingsRemoved);
                }
                finally {
                    LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.getMarkPassingsLock(markPassingsForOneCompetitor));
                }
                this.triggerManeuverCacheRecalculation(competitor);
            }
            logger.info("done updating tracked race " + this + "'s data structures...");
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.getSerializationLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NamedReentrantReadWriteLock getMarkPassingsLock(Iterable<MarkPassing> markPassings) {
        IdentityWrapper markPassingsIdentity = new IdentityWrapper(markPassings);
        NamedReentrantReadWriteLock lock = (NamedReentrantReadWriteLock)this.locksForMarkPassings.get(markPassingsIdentity);
        if (lock == null) {
            ConcurrentMap<IdentityWrapper<Iterable<MarkPassing>>, NamedReentrantReadWriteLock> concurrentMap = this.locksForMarkPassings;
            synchronized (concurrentMap) {
                lock = (NamedReentrantReadWriteLock)this.locksForMarkPassings.get(markPassingsIdentity);
                if (lock == null) {
                    lock = new NamedReentrantReadWriteLock("mark passings lock for tracked race " + this.getRace().getName(), false);
                    this.locksForMarkPassings.put((IdentityWrapper<Iterable<MarkPassing>>)markPassingsIdentity, lock);
                }
            }
        }
        return lock;
    }

    private void updateStartToNextMarkCacheInvalidationCacheListenersAfterWaypointRemoved(int zeroBasedIndex, Waypoint waypointThatGotRemoved) {
        if (zeroBasedIndex < 2) {
            this.clearDirectionFromStartToNextMarkCache();
            this.stopAndRemoveStartToNextMarkCacheInvalidationListener(waypointThatGotRemoved);
            Iterator waypointsIter = this.getRace().getCourse().getWaypoints().iterator();
            if (waypointsIter.hasNext()) {
                waypointsIter.next();
                if (waypointsIter.hasNext()) {
                    waypointsIter.next();
                    if (waypointsIter.hasNext()) {
                        Waypoint newSecond = (Waypoint)waypointsIter.next();
                        this.addStartToNextMarkCacheInvalidationListener(newSecond);
                    }
                }
            }
        }
    }

    @Override
    public TrackedRegatta getTrackedRegatta() {
        return this.trackedRegatta;
    }

    @Override
    public Wind getEstimatedWindDirection(TimePoint timePoint) {
        WindWithConfidence<TimePoint> estimatedWindWithConfidence = this.getEstimatedWindDirectionWithConfidence(timePoint);
        return estimatedWindWithConfidence == null ? null : (Wind)estimatedWindWithConfidence.getObject();
    }

    private double getConfidenceMultiplierForClusterSize(int numberOfBoatsInSmallestCluster) {
        return 1.0 - 8.1 / (8.0 + (double)numberOfBoatsInSmallestCluster);
    }

    @Override
    public WindWithConfidence<TimePoint> getEstimatedWindDirectionWithConfidence(TimePoint timePoint) {
        DummyMarkPassingWithTimePointOnly dummyMarkPassingForNow = new DummyMarkPassingWithTimePointOnly(timePoint);
        Weigher weigher = ConfidenceFactory.INSTANCE.createExponentialTimeDifferenceWeigher(this.getMillisecondsOverWhichToAverageSpeed(), 1.0E-10);
        Map<LegType, Util.Pair<BearingWithConfidenceCluster<TimePoint>, ScalablePosition>> bearings = this.clusterBearingsByLegType(timePoint, dummyMarkPassingForNow, (Weigher<TimePoint>)weigher);
        BearingWithConfidenceImpl reversedUpwindAverage = null;
        double confidence = 0.0;
        BearingWithConfidence resultBearing = null;
        ScalablePosition scaledPosition = null;
        int numberOfFixesConsideredForScaledPosition = 0;
        HashSet<WindSource> estimationExcluded = new HashSet<WindSource>();
        estimationExcluded.addAll(this.getWindSources(WindSourceType.TRACK_BASED_ESTIMATION));
        estimationExcluded.addAll(this.getWindSources(WindSourceType.COURSE_BASED));
        if (bearings != null) {
            int upwindNumberOfRelevantBoats = 0;
            int numberOfFixesUpwind = ((BearingWithConfidenceCluster)bearings.get(LegType.UPWIND).getA()).size();
            if (numberOfFixesUpwind > 0) {
                ScalablePosition upwindPosition = (ScalablePosition)bearings.get(LegType.UPWIND).getB();
                Util.Pair<Double, Double> minimumAngleBetweenDifferentTacksUpwindWithConfidence = this.getMinimumAngleBetweenDifferentTacksUpwind(this.getWind(upwindPosition.divide((double)numberOfFixesUpwind), timePoint, estimationExcluded));
                BearingWithConfidenceCluster[] bearingClustersUpwind = ((BearingWithConfidenceCluster)bearings.get(LegType.UPWIND).getA()).splitInTwo(((Double)minimumAngleBetweenDifferentTacksUpwindWithConfidence.getA()).doubleValue(), (Object)timePoint);
                if (!bearingClustersUpwind[0].isEmpty() && !bearingClustersUpwind[1].isEmpty()) {
                    BearingWithConfidence average0 = bearingClustersUpwind[0].getAverage((Object)timePoint);
                    BearingWithConfidence average1 = bearingClustersUpwind[1].getAverage((Object)timePoint);
                    upwindNumberOfRelevantBoats = Math.min(bearingClustersUpwind[0].size(), bearingClustersUpwind[1].size());
                    confidence = Math.min(average0.getConfidence(), average1.getConfidence()) * this.getRace().getBoatClass().getUpwindWindEstimationConfidence() * this.getConfidenceMultiplierForClusterSize(upwindNumberOfRelevantBoats) * (Double)minimumAngleBetweenDifferentTacksUpwindWithConfidence.getB();
                    reversedUpwindAverage = new BearingWithConfidenceImpl(((Bearing)average0.getObject()).middle((Bearing)average1.getObject()).reverse(), confidence, (Object)timePoint);
                    scaledPosition = upwindPosition;
                    numberOfFixesConsideredForScaledPosition += ((BearingWithConfidenceCluster)bearings.get(LegType.UPWIND).getA()).size();
                }
            }
            BearingWithConfidenceImpl downwindAverage = null;
            int downwindNumberOfRelevantBoats = 0;
            int numberOfFixesDownwind = ((BearingWithConfidenceCluster)bearings.get(LegType.DOWNWIND).getA()).size();
            if (numberOfFixesDownwind > 0) {
                ScalablePosition downwindPosition = (ScalablePosition)bearings.get(LegType.DOWNWIND).getB();
                Util.Pair<Double, Double> minimumAngleBetweenDifferentTacksDownwindWithConfidence = this.getMinimumAngleBetweenDifferentTacksDownwind(this.getWind(downwindPosition.divide((double)numberOfFixesDownwind), timePoint, estimationExcluded));
                BearingWithConfidenceCluster[] bearingClustersDownwind = ((BearingWithConfidenceCluster)bearings.get(LegType.DOWNWIND).getA()).splitInTwo(((Double)minimumAngleBetweenDifferentTacksDownwindWithConfidence.getA()).doubleValue(), (Object)timePoint);
                if (!bearingClustersDownwind[0].isEmpty() && !bearingClustersDownwind[1].isEmpty()) {
                    BearingWithConfidence average0 = bearingClustersDownwind[0].getAverage((Object)timePoint);
                    BearingWithConfidence average1 = bearingClustersDownwind[1].getAverage((Object)timePoint);
                    downwindNumberOfRelevantBoats = Math.min(bearingClustersDownwind[0].size(), bearingClustersDownwind[1].size());
                    confidence = Math.min(average0.getConfidence(), average1.getConfidence()) * this.getRace().getBoatClass().getDownwindWindEstimationConfidence() * this.getConfidenceMultiplierForClusterSize(downwindNumberOfRelevantBoats) * (Double)minimumAngleBetweenDifferentTacksDownwindWithConfidence.getB();
                    downwindAverage = new BearingWithConfidenceImpl(((Bearing)average0.getObject()).middle((Bearing)average1.getObject()), confidence, (Object)timePoint);
                    if (scaledPosition == null) {
                        scaledPosition = downwindPosition;
                    } else {
                        scaledPosition.add((ScalableValue)downwindPosition);
                    }
                    numberOfFixesConsideredForScaledPosition += ((BearingWithConfidenceCluster)bearings.get(LegType.DOWNWIND).getA()).size();
                }
            }
            BearingWithConfidenceCluster resultCluster = new BearingWithConfidenceCluster(weigher);
            assert (upwindNumberOfRelevantBoats == 0 || reversedUpwindAverage != null);
            if (upwindNumberOfRelevantBoats > 0) {
                resultCluster.add(reversedUpwindAverage);
            }
            assert (downwindNumberOfRelevantBoats == 0 || downwindAverage != null);
            if (downwindNumberOfRelevantBoats > 0) {
                resultCluster.add(downwindAverage);
            }
            resultBearing = resultCluster.getAverage((Object)timePoint);
        }
        Position position = scaledPosition == null ? null : scaledPosition.divide((double)numberOfFixesConsideredForScaledPosition);
        return resultBearing == null ? null : new WindWithConfidenceImpl<TimePoint>((Wind)new WindImpl(position, timePoint, (SpeedWithBearing)new KnotSpeedWithBearingImpl(0.0, (Bearing)resultBearing.getObject())), resultBearing.getConfidence(), (TimePoint)resultBearing.getRelativeTo(), false);
    }

    private Map<LegType, Util.Pair<BearingWithConfidenceCluster<TimePoint>, ScalablePosition>> clusterBearingsByLegType(TimePoint timePoint, DummyMarkPassingWithTimePointOnly dummyMarkPassingForNow, Weigher<TimePoint> weigher) {
        HashMap<LegType, Util.Pair<BearingWithConfidenceCluster<TimePoint>, ScalablePosition>> result;
        HyperbolicTimeDifferenceWeigher weigherForMarkPassingProximity = new HyperbolicTimeDifferenceWeigher(this.getMillisecondsOverWhichToAverageSpeed() * 5L);
        HashMap<LegType, BearingWithConfidenceCluster> bearings = new HashMap<LegType, BearingWithConfidenceCluster>();
        HashMap<LegType, ScalablePosition> scaledCentersOfGravity = new HashMap<LegType, ScalablePosition>();
        LegType[] legTypeArray = LegType.values();
        int n = legTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LegType legType = legTypeArray[n2];
            bearings.put(legType, new BearingWithConfidenceCluster(weigher));
            scaledCentersOfGravity.put(legType, null);
            ++n2;
        }
        HashMap<TrackedLeg, LegType> legTypesCache = new HashMap<TrackedLeg, LegType>();
        this.getRace().getCourse().lockForRead();
        try {
            for (Competitor competitor : this.getRace().getCompetitors()) {
                TrackedLegOfCompetitor leg;
                try {
                    leg = this.getTrackedLeg(competitor, timePoint);
                }
                catch (IllegalArgumentException iae) {
                    logger.warning("Caught " + iae + " during wind estimation; ignoring seemingly broken leg");
                    logger.log(Level.SEVERE, "clusterBearingsByLegType", iae);
                    leg = null;
                }
                if (bearings == null || leg == null) continue;
                TrackedLeg trackedLeg = leg.getTrackedLeg();
                try {
                    SpeedWithBearingWithConfidence<TimePoint> estimatedSpeedWithConfidence;
                    GPSFixTrack<Competitor, GPSFixMoving> track;
                    LegType legType = (LegType)legTypesCache.get(trackedLeg);
                    if (legType == null) {
                        legType = trackedLeg.getLegType(timePoint);
                        legTypesCache.put(trackedLeg, legType);
                    }
                    if (legType == LegType.REACHING || (track = this.getTrack(competitor)).hasDirectionChange(timePoint, this.getManeuverDegreeAngleThreshold() / 2.0) || (estimatedSpeedWithConfidence = track.getEstimatedSpeed(timePoint, weigher)) == null || estimatedSpeedWithConfidence.getObject() == null || !this.isNavigatingForward(estimatedSpeedWithConfidence.getObject().getBearing(), trackedLeg, timePoint)) continue;
                    NavigableSet<MarkPassing> markPassings = this.getMarkPassings(competitor);
                    double markPassingProximityConfidenceReduction = 1.0;
                    this.lockForRead(markPassings);
                    try {
                        NavigableSet<MarkPassing> prevMarkPassing = markPassings.headSet(dummyMarkPassingForNow, true);
                        NavigableSet<MarkPassing> nextMarkPassing = markPassings.tailSet(dummyMarkPassingForNow, true);
                        if (prevMarkPassing != null && !prevMarkPassing.isEmpty()) {
                            markPassingProximityConfidenceReduction *= Math.max(0.0, 1.0 - weigherForMarkPassingProximity.getConfidence((Object)((MarkPassing)prevMarkPassing.last()).getTimePoint(), (Object)timePoint));
                        }
                        if (nextMarkPassing != null && !nextMarkPassing.isEmpty()) {
                            markPassingProximityConfidenceReduction *= Math.max(0.0, 1.0 - weigherForMarkPassingProximity.getConfidence((Object)((MarkPassing)nextMarkPassing.first()).getTimePoint(), (Object)timePoint));
                        }
                    }
                    finally {
                        this.unlockAfterRead(markPassings);
                    }
                    BearingWithConfidenceImpl bearing = new BearingWithConfidenceImpl(estimatedSpeedWithConfidence.getObject() == null ? null : estimatedSpeedWithConfidence.getObject().getBearing(), markPassingProximityConfidenceReduction * estimatedSpeedWithConfidence.getConfidence(), (Object)((TimePoint)estimatedSpeedWithConfidence.getRelativeTo()));
                    BearingWithConfidenceCluster bearingClusterForLegType = (BearingWithConfidenceCluster)bearings.get(legType);
                    bearingClusterForLegType.add((BearingWithConfidence)bearing);
                    Position position = track.getEstimatedPosition(timePoint, false);
                    ScalablePosition scalablePosition = new ScalablePosition(position);
                    ScalablePosition scaledCenterOfGravitySoFar = (ScalablePosition)scaledCentersOfGravity.get(legType);
                    ScalablePosition newScaledCenterOfGravity = scaledCenterOfGravitySoFar == null ? scalablePosition : scaledCenterOfGravitySoFar.add((ScalableValue)scalablePosition);
                    scaledCentersOfGravity.put(legType, newScaledCenterOfGravity);
                }
                catch (NoWindException e) {
                    logger.fine("Unable to determine leg type for race " + this.getRace().getName() + " while trying to estimate wind (Background: I've got a NoWindException)");
                    bearings = null;
                }
            }
        }
        finally {
            this.getRace().getCourse().unlockAfterRead();
        }
        if (bearings == null) {
            result = null;
        } else {
            result = new HashMap<LegType, Util.Pair<BearingWithConfidenceCluster<TimePoint>, ScalablePosition>>();
            LegType[] legTypeArray2 = LegType.values();
            int n3 = legTypeArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                LegType legType = legTypeArray2[n4];
                result.put(legType, (Util.Pair<BearingWithConfidenceCluster<TimePoint>, ScalablePosition>)new Util.Pair((Object)((BearingWithConfidenceCluster)bearings.get(legType)), (Object)((ScalablePosition)scaledCentersOfGravity.get(legType))));
                ++n4;
            }
        }
        return result;
    }

    private boolean isNavigatingForward(Bearing bearing, TrackedLeg trackedLeg, TimePoint at) {
        Bearing legBearing = trackedLeg.getLegBearing(at);
        return Math.abs(bearing.getDifferenceTo(legBearing).getDegrees()) < 90.0;
    }

    @Override
    public Tack getTack(Competitor competitor, TimePoint timePoint) throws NoWindException {
        SpeedWithBearing estimatedSpeed = this.getTrack(competitor).getEstimatedSpeed(timePoint);
        Tack result = null;
        if (estimatedSpeed != null) {
            result = this.getTack(this.getTrack(competitor).getEstimatedPosition(timePoint, false), timePoint, estimatedSpeed.getBearing());
        }
        return result;
    }

    @Override
    public Tack getTack(SpeedWithBearing estimatedSpeed, Wind wind, TimePoint timePoint) {
        Tack result = null;
        if (estimatedSpeed != null) {
            result = this.getTack(wind, estimatedSpeed.getBearing());
        }
        return result;
    }

    @Override
    public Tack getTack(Position where, TimePoint timePoint, Bearing boatBearing) throws NoWindException {
        Wind wind = this.getWind(where, timePoint);
        if (wind == null) {
            throw new NoWindException("Can't determine wind direction in position " + where + " at " + timePoint + ", therefore cannot determine tack");
        }
        return this.getTack(wind, boatBearing);
    }

    private Tack getTack(Wind wind, Bearing boatBearing) {
        Bearing windBearing = wind.getBearing();
        Bearing difference = windBearing.getDifferenceTo(boatBearing);
        return difference.getDegrees() <= 0.0 ? Tack.PORT : Tack.STARBOARD;
    }

    public String toString() {
        return "TrackedRace for " + this.getRace();
    }

    @Override
    public Iterable<GPSFixMoving> approximate(Competitor competitor, Distance maxDistance, TimePoint from, TimePoint to) {
        return this.maneuverApproximators.get(competitor).approximate(from, to);
    }

    protected void triggerManeuverCacheRecalculationForAllCompetitors() {
        if (this.cachesSuspended) {
            this.triggerManeuverCacheInvalidationForAllCompetitors = true;
        } else {
            ArrayList<Competitor> shuffledCompetitors = new ArrayList<Competitor>();
            for (Competitor competitor : this.getRace().getCompetitors()) {
                shuffledCompetitors.add(competitor);
            }
            Collections.shuffle(shuffledCompetitors);
            for (Competitor competitor : shuffledCompetitors) {
                this.triggerManeuverCacheRecalculation(competitor);
            }
        }
    }

    public void triggerManeuverCacheRecalculation(Competitor competitor) {
        if (this.cachesSuspended) {
            this.triggerManeuverCacheInvalidationForAllCompetitors = true;
        } else {
            this.maneuverCache.triggerUpdate((Object)competitor, null);
        }
    }

    private List<Maneuver> computeManeuvers(Competitor competitor, ManeuverDetector maneuverDetector) throws NoWindException {
        logger.finest("computeManeuvers(" + competitor.getName() + ") called in tracked race " + this);
        long startedAt = System.currentTimeMillis();
        List<Maneuver> result = maneuverDetector.detectManeuvers();
        logger.finest("computeManeuvers(" + competitor.getName() + ") called in tracked race " + this + " took " + (System.currentTimeMillis() - startedAt) + "ms");
        return result;
    }

    @Override
    public Iterable<Maneuver> getManeuvers(Competitor competitor, TimePoint from, TimePoint to, boolean waitForLatest) {
        List allManeuvers = (List)this.maneuverCache.get((Object)competitor, waitForLatest);
        List<Maneuver> result = allManeuvers == null ? Collections.emptyList() : this.extractInterval(from, to, allManeuvers);
        return result;
    }

    @Override
    public Iterable<Maneuver> getManeuvers(Competitor competitor, boolean waitForLatest) {
        List allManeuvers = (List)this.maneuverCache.get((Object)competitor, waitForLatest);
        List result = allManeuvers == null ? Collections.emptyList() : allManeuvers;
        return result;
    }

    private <T extends Timed> List<T> extractInterval(TimePoint from, TimePoint to, List<T> listOfTimed) {
        LinkedList<Timed> result = new LinkedList<Timed>();
        for (Timed timed : listOfTimed) {
            if (timed.getTimePoint().compareTo((Object)from) < 0 || timed.getTimePoint().compareTo((Object)to) > 0) continue;
            result.add(timed);
        }
        return result;
    }

    private double getManeuverDegreeAngleThreshold() {
        return this.getRace().getBoatClass().getManeuverDegreeAngleThreshold();
    }

    private Util.Pair<Double, Double> getMinimumAngleBetweenDifferentTacksDownwind(Wind wind) {
        double defaultAngle = this.getRace().getBoatClass().getMinimumAngleBetweenDifferentTacksDownwind();
        double threshold = 20.0;
        Util.Pair<Double, Double> result = this.usePolarsIfPossible(wind, defaultAngle, LegType.DOWNWIND, threshold);
        return result;
    }

    private Util.Pair<Double, Double> getMinimumAngleBetweenDifferentTacksUpwind(Wind wind) {
        double defaultAngle = this.getRace().getBoatClass().getMinimumAngleBetweenDifferentTacksUpwind();
        double threshold = 10.0;
        Util.Pair<Double, Double> result = this.usePolarsIfPossible(wind, defaultAngle, LegType.UPWIND, threshold);
        return result;
    }

    private Util.Pair<Double, Double> usePolarsIfPossible(Wind wind, double defaultAngle, LegType legType, double threshold) {
        Util.Pair result;
        block5: {
            if (this.polarDataService != null) {
                try {
                    BearingWithConfidence<Void> average = this.polarDataService.getManeuverAngle(this.getRace().getBoatClass(), legType == LegType.DOWNWIND ? ManeuverType.JIBE : ManeuverType.TACK, (Speed)wind);
                    double averageAngleInDegMinusThreshold = ((Bearing)average.getObject()).getDegrees() - threshold;
                    if (averageAngleInDegMinusThreshold < defaultAngle) {
                        result = new Util.Pair((Object)defaultAngle, (Object)0.1);
                        break block5;
                    }
                    result = new Util.Pair((Object)averageAngleInDegMinusThreshold, (Object)average.getConfidence());
                }
                catch (NotEnoughDataHasBeenAddedException | IllegalArgumentException e) {
                    result = new Util.Pair((Object)defaultAngle, (Object)0.1);
                }
            } else {
                result = new Util.Pair((Object)defaultAngle, (Object)0.1);
            }
        }
        return result;
    }

    @Override
    public Distance getWindwardDistanceToCompetitorFarthestAhead(Competitor competitor, TimePoint timePoint, WindPositionMode windPositionMode) {
        TrackedLegOfCompetitor trackedLeg = this.getTrackedLeg(competitor, timePoint);
        return trackedLeg == null ? null : trackedLeg.getWindwardDistanceToCompetitorFarthestAhead(timePoint, windPositionMode, this.getRankingMetric().getRankingInfo(timePoint));
    }

    @Override
    public Distance getWindwardDistanceToCompetitorFarthestAhead(Competitor competitor, TimePoint timePoint, WindPositionMode windPositionMode, RankingMetric.RankingInfo rankingInfo, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        TrackedLegOfCompetitor trackedLeg = this.getTrackedLeg(competitor, timePoint);
        return trackedLeg == null ? null : trackedLeg.getWindwardDistanceToCompetitorFarthestAhead(timePoint, windPositionMode, rankingInfo, cache);
    }

    @Override
    public Iterable<Mark> getMarks() {
        while (true) {
            try {
                return new HashSet<Mark>(this.markTracks.keySet());
            }
            catch (ConcurrentModificationException cme) {
                logger.info("Caught " + cme + "; trying again.");
                continue;
            }
            break;
        }
    }

    @Override
    public Iterable<Sideline> getCourseSidelines() {
        return new ArrayList<Sideline>(this.courseSidelines.values());
    }

    @Override
    public long getDelayToLiveInMillis() {
        return this.delayToLiveInMillis;
    }

    protected void setDelayToLiveInMillis(long delayToLiveInMillis) {
        logger.info("Setting live delay for race " + this.getRace().getName() + " to " + delayToLiveInMillis + "ms");
        this.delayToLiveInMillis = delayToLiveInMillis;
    }

    @Override
    public TrackedRaceStatus getStatus() {
        return this.status;
    }

    protected Object getStatusNotifier() {
        return this.statusNotifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runSynchronizedOnStatus(Runnable runnable) {
        Object object = this.getStatusNotifier();
        synchronized (object) {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStatus(TrackedRaceStatus newStatus) {
        TrackedRaceStatusEnum oldStatus;
        assert (newStatus != null);
        Object object = this.getStatusNotifier();
        synchronized (object) {
            oldStatus = this.getStatus().getStatus();
            this.status = newStatus;
            this.getStatusNotifier().notifyAll();
        }
        if (newStatus.getStatus() == TrackedRaceStatusEnum.LOADING && oldStatus != TrackedRaceStatusEnum.LOADING) {
            this.suspendAllCachesNotUpdatingWhileLoading();
        } else if (oldStatus == TrackedRaceStatusEnum.LOADING && newStatus.getStatus() != TrackedRaceStatusEnum.LOADING && newStatus.getStatus() != TrackedRaceStatusEnum.REMOVED) {
            this.resumeAllCachesNotUpdatingWhileLoading();
        }
    }

    private void suspendAllCachesNotUpdatingWhileLoading() {
        this.cachesSuspended = true;
        for (GPSFixTrack<Competitor, GPSFixMoving> competitorTrack : this.tracks.values()) {
            competitorTrack.suspendValidityAndMaxSpeedCaching();
        }
        for (GPSFixTrack<Object, Object> markTrack : this.markTracks.values()) {
            markTrack.suspendValidityAndMaxSpeedCaching();
        }
        if (this.markPassingCalculator != null) {
            this.markPassingCalculator.suspend();
        }
        this.crossTrackErrorCache.suspend();
        this.maneuverCache.suspend();
    }

    private void resumeAllCachesNotUpdatingWhileLoading() {
        this.cachesSuspended = false;
        this.shortTimeWindCache.clearCache();
        for (GPSFixTrack<Competitor, GPSFixMoving> competitorTrack : this.tracks.values()) {
            competitorTrack.resumeValidityAndMaxSpeedCaching();
        }
        for (GPSFixTrack<Object, Object> markTrack : this.markTracks.values()) {
            markTrack.resumeValidityAndMaxSpeedCaching();
        }
        if (this.markPassingCalculator != null) {
            this.markPassingCalculator.resume();
        }
        this.crossTrackErrorCache.resume();
        if (this.triggerManeuverCacheInvalidationForAllCompetitors) {
            this.triggerManeuverCacheRecalculationForAllCompetitors();
        }
        this.maneuverCache.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void waitUntilNotLoading() {
        Object object = this.getStatusNotifier();
        synchronized (object) {
            while (true) {
                if (this.getStatus().getStatus() != TrackedRaceStatusEnum.LOADING) {
                    return;
                }
                try {
                    this.getStatusNotifier().wait();
                }
                catch (InterruptedException e) {
                    logger.info("waitUntilNotLoading on tracked race " + this + " interrupted: " + e.getMessage() + ". Continuing to wait.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasFinishedLoading() {
        Object object = this.getStatusNotifier();
        synchronized (object) {
            TrackedRaceStatusEnum status = this.getStatus().getStatus();
            return this.hasFinishedLoading(status);
        }
    }

    private boolean hasFinishedLoading(TrackedRaceStatusEnum status) {
        return status != TrackedRaceStatusEnum.PREPARED && status != TrackedRaceStatusEnum.LOADING && status != TrackedRaceStatusEnum.ERROR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runWhenDoneLoading(final Runnable runnable) {
        Object object = this.getStatusNotifier();
        synchronized (object) {
            if (!this.hasFinishedLoading()) {
                this.addListener(new AbstractRaceChangeListener(){

                    @Override
                    public void statusChanged(TrackedRaceStatus newStatus, TrackedRaceStatus oldStatus) {
                        logger.info("race " + TrackedRaceImpl.this + " went from " + oldStatus + " to " + newStatus);
                        if (TrackedRaceImpl.this.hasFinishedLoading(newStatus.getStatus())) {
                            logger.info("race " + TrackedRaceImpl.this + " is considered having finished loading; running " + runnable);
                            TrackedRaceImpl.this.removeListener(this);
                            runnable.run();
                        }
                    }
                });
            } else {
                runnable.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachRaceLog(RaceLog raceLog) {
        TrackedRaceImpl trackedRaceImpl = this;
        synchronized (trackedRaceImpl) {
            this.attachedRaceLogs.put(raceLog.getId(), raceLog);
            this.notifyAll();
            this.invalidateStartTime();
        }
        this.notifyListenersWhenAttachingRaceLog(raceLog);
    }

    @Override
    public void attachRaceExecutionProvider(RaceExecutionOrderProvider raceExecutionOrderProvider) {
        if (raceExecutionOrderProvider != null && !this.attachedRaceExecutionOrderProviders.containsKey(raceExecutionOrderProvider)) {
            this.attachedRaceExecutionOrderProviders.put(raceExecutionOrderProvider, raceExecutionOrderProvider);
        }
    }

    protected Set<TrackedRace> getPreviousRacesFromAttachedRaceExecutionOrderProviders() {
        Set result = this.attachedRaceExecutionOrderProviders != null ? (Set)this.attachedRaceExecutionOrderProviders.values().stream().map(reop -> reop.getPreviousRacesInExecutionOrder(this)).collect(HashSet::new, (r, e) -> {
            boolean bl = r.addAll(e);
        }, (r, e) -> {
            boolean bl = r.addAll(e);
        }) : Collections.emptySet();
        return result;
    }

    @Override
    public void detachRaceExecutionOrderProvider(RaceExecutionOrderProvider raceExecutionOrderProvider) {
        if (raceExecutionOrderProvider != null) {
            this.attachedRaceExecutionOrderProviders.remove(raceExecutionOrderProvider);
        }
    }

    public boolean hasRaceExecutionOrderProvidersAttached() {
        return !this.attachedRaceExecutionOrderProviders.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReadonlyRaceState getRaceState(RaceLog raceLog) {
        ReadonlyRaceState result;
        WeakHashMap<RaceLog, ReadonlyRaceState> weakHashMap = this.raceStates;
        synchronized (weakHashMap) {
            result = this.raceStates.get(raceLog);
            if (result == null) {
                result = ReadonlyRaceStateImpl.getOrCreate((RaceLogResolver)this.raceLogResolver, (RaceLog)raceLog);
                this.raceStates.put(raceLog, result);
            }
        }
        return result;
    }

    @Override
    public UUID getCourseAreaId() {
        for (RaceLog raceLog : this.getAttachedRaceLogs()) {
            ReadonlyRaceState raceStateForRaceLog = this.getRaceState(raceLog);
            UUID courseAreaId = raceStateForRaceLog.getCourseAreaId();
            if (courseAreaId == null) continue;
            return courseAreaId;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachRegattaLog(RegattaLog regattaLog) {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.getSerializationLock());
        TrackedRaceImpl trackedRaceImpl = this;
        synchronized (trackedRaceImpl) {
            if (this.attachedRegattaLogs != null) {
                this.attachedRegattaLogs.put(regattaLog.getId(), regattaLog);
            }
            this.notifyListenersWhenAttachingRegattaLog(regattaLog);
            this.notifyAll();
        }
        LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.getSerializationLock());
        this.updateStartAndEndOfTracking(false);
    }

    @Override
    public Iterable<RegattaLog> getAttachedRegattaLogs() {
        return this.attachedRegattaLogs == null ? Collections.emptySet() : new HashSet(this.attachedRegattaLogs.values());
    }

    @Override
    public RaceLog detachRaceLog(Serializable identifier) {
        RaceLog raceLog = (RaceLog)this.attachedRaceLogs.remove(identifier);
        this.notifyListenersWhenDetachingRaceLog(raceLog);
        this.updateStartOfRaceCacheFields();
        this.updateStartAndEndOfTracking(false);
        return raceLog;
    }

    @Override
    public RaceLog getRaceLog(Serializable identifier) {
        return (RaceLog)this.attachedRaceLogs.get(identifier);
    }

    @Override
    public Distance getDistanceToStartLine(Competitor competitor, long millisecondsBeforeRaceStart) {
        return this.getSomethingMillisecondsBeforeRaceStart(competitor, millisecondsBeforeRaceStart, this::getDistanceToStartLine);
    }

    @Override
    public Distance getDistanceToStartLine(Competitor competitor, TimePoint timePoint) {
        Distance result;
        Waypoint startWaypoint = this.getRace().getCourse().getFirstWaypoint();
        if (startWaypoint == null) {
            result = null;
        } else {
            Position competitorPosition = this.getTrack(competitor).getEstimatedPosition(timePoint, false);
            if (competitorPosition == null) {
                result = null;
            } else {
                Iterable marks = startWaypoint.getControlPoint().getMarks();
                Iterator marksIterator = marks.iterator();
                Mark first = (Mark)marksIterator.next();
                Position firstPosition = this.getOrCreateTrack(first).getEstimatedPosition(timePoint, false);
                if (firstPosition == null) {
                    result = null;
                } else if (marksIterator.hasNext()) {
                    Mark second = (Mark)marksIterator.next();
                    Position secondPosition = this.getOrCreateTrack(second).getEstimatedPosition(timePoint, false);
                    if (secondPosition == null) {
                        result = null;
                    } else {
                        Bearing bearingFromFirstToCompetitor;
                        Bearing lineBearingGreatCircleFromFirstToSecond = firstPosition.getBearingGreatCircle(secondPosition);
                        Bearing angleBetweenFromFirstToCompetitorAndLine = lineBearingGreatCircleFromFirstToSecond.getDifferenceTo(bearingFromFirstToCompetitor = firstPosition.getBearingGreatCircle(competitorPosition));
                        if (angleBetweenFromFirstToCompetitorAndLine.getDegrees() < -90.0 || angleBetweenFromFirstToCompetitorAndLine.getDegrees() > 90.0) {
                            result = competitorPosition.getDistance(firstPosition);
                        } else {
                            Bearing bearingFromSecondToCompetitor = secondPosition.getBearingGreatCircle(competitorPosition);
                            Bearing angleBetweenFromSecondToCompetitorAndReversedLine = lineBearingGreatCircleFromFirstToSecond.reverse().getDifferenceTo(bearingFromSecondToCompetitor);
                            if (angleBetweenFromSecondToCompetitorAndReversedLine.getDegrees() < -90.0 || angleBetweenFromSecondToCompetitorAndReversedLine.getDegrees() > 90.0) {
                                result = competitorPosition.getDistance(secondPosition);
                            } else {
                                Position competitorProjectedOntoStartLine = competitorPosition.projectToLineThrough(firstPosition, lineBearingGreatCircleFromFirstToSecond);
                                result = competitorPosition.getDistance(competitorProjectedOntoStartLine);
                            }
                        }
                    }
                } else {
                    result = competitorPosition.getDistance(firstPosition);
                }
            }
        }
        return result;
    }

    private TimePoint getTimePointMillisecondsBeforeStart(long millisecondsBeforeRaceStart) {
        MillisecondsTimePoint result = this.getStartOfRace() == null ? null : new MillisecondsTimePoint(this.getStartOfRace().asMillis() - millisecondsBeforeRaceStart);
        return result;
    }

    private <T> T getSomethingMillisecondsBeforeRaceStart(Competitor competitor, long millisecondsBeforeRaceStart, BiFunction<Competitor, TimePoint, T> dataSupplier) {
        TimePoint timePoint = this.getTimePointMillisecondsBeforeStart(millisecondsBeforeRaceStart);
        T result = timePoint == null ? null : (T)dataSupplier.apply(competitor, timePoint);
        return result;
    }

    @Override
    public Distance getWindwardDistanceToFavoredSideOfStartLine(Competitor competitor, long millisecondsBeforeRaceStart) {
        return this.getSomethingMillisecondsBeforeRaceStart(competitor, millisecondsBeforeRaceStart, this::getWindwardDistanceToFavoredSideOfStartLine);
    }

    @Override
    public Distance getWindwardDistanceToFavoredSideOfStartLine(Competitor competitor, long millisecondsBeforeRaceStart, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return this.getSomethingMillisecondsBeforeRaceStart(competitor, millisecondsBeforeRaceStart, (c, t) -> this.getWindwardDistanceToFavoredSideOfStartLine((Competitor)c, (TimePoint)t, cache));
    }

    @Override
    public Distance getWindwardDistanceToFavoredSideOfStartLine(Competitor competitor, TimePoint timePoint) {
        return this.getWindwardDistanceToFavoredSideOfStartLine(competitor, timePoint, (WindLegTypeAndLegBearingAndORCPerformanceCurveCache)new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    @Override
    public Distance getWindwardDistanceToFavoredSideOfStartLine(Competitor competitor, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Distance result;
        Waypoint startWaypoint = this.getRace().getCourse().getFirstWaypoint();
        if (startWaypoint == null) {
            result = null;
        } else {
            TrackedLeg firstLeg;
            LineDetails startLine;
            Position competitorPosition = this.getTrack(competitor).getEstimatedPosition(timePoint, false);
            Object referenceStartPosition = Util.size((Iterable)startWaypoint.getControlPoint().getMarks()) == 1 ? this.getApproximatePosition(startWaypoint, timePoint) : ((startLine = this.getStartLine(timePoint)) == null ? null : startLine.getAdvantageousMarkPosition());
            result = competitorPosition == null ? null : (referenceStartPosition == null ? null : ((firstLeg = this.getTrackedLegStartingAt(startWaypoint)) == null ? null : firstLeg.getWindwardDistance(competitorPosition, (Position)referenceStartPosition, timePoint, WindPositionMode.LEG_MIDDLE, cache)));
        }
        return result;
    }

    @Override
    public Speed getSpeed(Competitor competitor, long millisecondsBeforeRaceStart) {
        SpeedWithBearing result;
        if (this.getStartOfRace() == null) {
            result = null;
        } else {
            MillisecondsTimePoint beforeStart = new MillisecondsTimePoint(this.getStartOfRace().asMillis() - millisecondsBeforeRaceStart);
            result = this.getTrack(competitor).getEstimatedSpeed((TimePoint)beforeStart);
        }
        return result;
    }

    @Override
    public Distance getDistanceFromStarboardSideOfStartLineWhenPassingStart(Competitor competitor) {
        Distance result;
        TrackedLegOfCompetitor firstTrackedLegOfCompetitor = this.getTrackedLeg(competitor, this.getRace().getCourse().getFirstLeg());
        TimePoint competitorStartTime = firstTrackedLegOfCompetitor.getStartTime();
        if (competitorStartTime != null) {
            Position competitorPositionWhenPassingStart = this.getTrack(competitor).getEstimatedPosition(competitorStartTime, false);
            Position starboardMarkPosition = this.getStarboardMarkOfStartlinePosition(competitorStartTime);
            result = competitorPositionWhenPassingStart != null && starboardMarkPosition != null ? (starboardMarkPosition == null ? null : competitorPositionWhenPassingStart.getDistance(starboardMarkPosition)) : null;
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public Distance getDistanceFromStarboardSideOfStartLine(Competitor competitor, TimePoint timePoint) {
        Distance result;
        if (timePoint != null) {
            Position competitorPositionWhenPassingStart = this.getTrack(competitor).getEstimatedPosition(timePoint, false);
            Position starboardMarkPosition = this.getStarboardMarkOfStartlinePosition(timePoint);
            result = competitorPositionWhenPassingStart != null && starboardMarkPosition != null ? (starboardMarkPosition == null ? null : competitorPositionWhenPassingStart.getDistance(starboardMarkPosition)) : null;
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public Distance getDistanceFromStarboardSideOfStartLineProjectedOntoLine(Competitor competitor, TimePoint timePoint) {
        Distance result;
        Util.Pair<Bearing, Position> startLineBearingAndStarboardMarkPosition = this.getStartLineBearingAndStarboardMarkPosition(timePoint);
        if (startLineBearingAndStarboardMarkPosition.getA() == null || startLineBearingAndStarboardMarkPosition.getB() == null) {
            result = null;
        } else {
            Position competitorPosition = this.getTrack(competitor).getEstimatedPosition(timePoint, true);
            if (competitorPosition == null) {
                result = null;
            } else {
                Position competitorPositionProjectedOntoLine = competitorPosition.projectToLineThrough((Position)startLineBearingAndStarboardMarkPosition.getB(), (Bearing)startLineBearingAndStarboardMarkPosition.getA());
                result = competitorPositionProjectedOntoLine.getDistance((Position)startLineBearingAndStarboardMarkPosition.getB());
            }
        }
        return result;
    }

    @Override
    public Util.Pair<Bearing, Position> getStartLineBearingAndStarboardMarkPosition(TimePoint timePoint) {
        Object lineBearing;
        Position starboardMarkPosition;
        LineDetails startLine = this.getStartLine(timePoint);
        if (startLine == null) {
            Bearing bearingFirstLeg;
            Iterable<TrackedLeg> trackedLegs;
            starboardMarkPosition = this.getStarboardMarkOfStartlinePosition(timePoint);
            lineBearing = starboardMarkPosition == null ? null : ((trackedLegs = this.getTrackedLegs()) == null || !trackedLegs.iterator().hasNext() ? null : ((bearingFirstLeg = trackedLegs.iterator().next().getLegBearing(timePoint)) == null ? null : bearingFirstLeg.add((Bearing)new DegreeBearingImpl(270.0))));
        } else {
            lineBearing = startLine.getBearingFromStarboardToPortWhenApproachingLine();
            starboardMarkPosition = startLine.getStarboardMarkPosition();
        }
        Util.Pair startLineBearingAndStarboardMarkPosition = new Util.Pair(lineBearing, (Object)starboardMarkPosition);
        return startLineBearingAndStarboardMarkPosition;
    }

    @Override
    public SortedMap<Competitor, Distance> getDistancesFromStarboardSideOfStartLineProjectedOntoLine(TimePoint timePoint, BiFunction<Competitor, TimePoint, MaxPointsReason> maxPointsReasonSupplier) {
        SortedMap result = this.distancesFromStarboardSideOfStartLineProjectedOntoLineCache.computeIfAbsent(timePoint, tp -> {
            HashMap<Competitor, Distance> distances = new HashMap<Competitor, Distance>();
            for (Competitor competitor : this.getRace().getCompetitors()) {
                MaxPointsReason penaltyCode = (MaxPointsReason)maxPointsReasonSupplier.apply(competitor, timePoint);
                if (penaltyCode == MaxPointsReason.DNC || penaltyCode == MaxPointsReason.DNS) continue;
                distances.put(competitor, this.getDistanceFromStarboardSideOfStartLineProjectedOntoLine(competitor, (TimePoint)tp));
            }
            TreeMap<Competitor, Distance> map = new TreeMap<Competitor, Distance>((c1, c2) -> ((Distance)distances.get(c1)).compareTo((Object)((Distance)distances.get(c2))));
            map.putAll(distances);
            return map;
        });
        this.distancesFromStarboardSideOfStartLineProjectedOntoLineCacheLastAccessTimes.put(timePoint, ApproximateTime.approximateNow());
        if (this.distancesFromStarboardSideOfStartLineProjectedOntoLineCache.size() > 10) {
            TimePoint keyLeastRecentlyAccessed = (TimePoint)((Map.Entry)this.distancesFromStarboardSideOfStartLineProjectedOntoLineCacheLastAccessTimes.entrySet().stream().max((e1, e2) -> ((TimePoint)e1.getValue()).compareTo((Object)((TimePoint)e2.getValue()))).get()).getKey();
            this.distancesFromStarboardSideOfStartLineProjectedOntoLineCache.remove(keyLeastRecentlyAccessed);
            this.distancesFromStarboardSideOfStartLineProjectedOntoLineCacheLastAccessTimes.remove(keyLeastRecentlyAccessed);
        }
        return result;
    }

    @Override
    public Competitor getNextCompetitorToPortOnStartLine(Competitor relativeTo, TimePoint timePoint, BiFunction<Competitor, TimePoint, MaxPointsReason> maxPointsReasonSupplier) {
        Competitor competitorImmediatelyToPort;
        SortedMap<Competitor, Distance> competitorsSortedByDistanceFromStarboardSideOfStartLineProjectedOntoLine = this.getDistancesFromStarboardSideOfStartLineProjectedOntoLine(timePoint, maxPointsReasonSupplier);
        Distance competitorDistance = (Distance)competitorsSortedByDistanceFromStarboardSideOfStartLineProjectedOntoLine.get(relativeTo);
        if (competitorDistance == null) {
            competitorImmediatelyToPort = null;
        } else {
            SortedMap<Competitor, Distance> competitorsFurtherToPortIncludingSelf = competitorsSortedByDistanceFromStarboardSideOfStartLineProjectedOntoLine.tailMap(relativeTo);
            Iterator<Map.Entry<Competitor, Distance>> iterator = competitorsFurtherToPortIncludingSelf.entrySet().iterator();
            iterator.next();
            competitorImmediatelyToPort = iterator.hasNext() ? iterator.next().getKey() : null;
        }
        return competitorImmediatelyToPort;
    }

    @Override
    public Competitor getNextCompetitorToStarboardOnStartLine(Competitor relativeTo, TimePoint timePoint, BiFunction<Competitor, TimePoint, MaxPointsReason> maxPointsReasonSupplier) {
        SortedMap<Competitor, Distance> competitorsFurtherToStarboard;
        SortedMap<Competitor, Distance> competitorsSortedByDistanceFromStarboardSideOfStartLineProjectedOntoLine = this.getDistancesFromStarboardSideOfStartLineProjectedOntoLine(timePoint, maxPointsReasonSupplier);
        Distance competitorDistance = (Distance)competitorsSortedByDistanceFromStarboardSideOfStartLineProjectedOntoLine.get(relativeTo);
        Competitor competitorImmediatelyToStarboard = competitorDistance == null ? null : ((competitorsFurtherToStarboard = competitorsSortedByDistanceFromStarboardSideOfStartLineProjectedOntoLine.headMap(relativeTo)) != null && !competitorsFurtherToStarboard.isEmpty() ? competitorsFurtherToStarboard.lastKey() : null);
        return competitorImmediatelyToStarboard;
    }

    protected Mark getStarboardMarkOfStartlineOrSingleStartMark(TimePoint at) {
        LineMarksWithPositions startLine;
        Waypoint startWaypoint = this.getRace().getCourse().getFirstWaypoint();
        Object result = startWaypoint != null ? ((startLine = this.getLineMarksAndPositions(at, startWaypoint)) != null ? startLine.getStarboardMarkWhileApproachingLine() : (startWaypoint != null && startWaypoint.getMarks().iterator().hasNext() ? (Mark)startWaypoint.getMarks().iterator().next() : null)) : null;
        return result;
    }

    private Position getStarboardMarkOfStartlinePosition(TimePoint at) {
        Mark starboardMark = this.getStarboardMarkOfStartlineOrSingleStartMark(at);
        if (starboardMark != null) {
            return this.getOrCreateTrack(starboardMark).getEstimatedPosition(at, false);
        }
        return null;
    }

    protected NamedReentrantReadWriteLock getLoadingFromWindStoreLock() {
        return this.loadingFromWindStoreLock;
    }

    public NamedReentrantReadWriteLock getLoadingFromGPSFixStoreLock() {
        return this.loadingFromGPSFixStoreLock;
    }

    private LineDetails getLineLengthAndAdvantage(TimePoint timePoint, Waypoint waypoint) {
        LineMarksWithPositions marksAndPositions = this.getLineMarksAndPositions(timePoint, waypoint);
        LineDetailsImpl result = null;
        if (marksAndPositions != null) {
            NauticalSide advantageousSideWhileApproachingLine;
            Object distanceAdvantage;
            Bearing differenceToCombinedWind;
            TrackedLeg legDeterminingDirection = this.getLegDeterminingDirectionInWhichToPassWaypoint(waypoint);
            Mark portMarkWhileApproachingLine = marksAndPositions.getPortMarkWhileApproachingLine();
            Mark starboardMarkWhileApproachingLine = marksAndPositions.getStarboardMarkWhileApproachingLine();
            Position portMarkPositionWhileApproachingLine = marksAndPositions.getPortMarkPositionWhileApproachingLine();
            Position starboardMarkPositionWhileApproachingLine = marksAndPositions.getStarboardMarkPositionWhileApproachingLine();
            Wind combinedWind = this.getWind(starboardMarkPositionWhileApproachingLine, timePoint);
            if (combinedWind != null) {
                Position betterMarkPosition;
                Position worseMarkPosition;
                boolean isStartLine;
                differenceToCombinedWind = portMarkPositionWhileApproachingLine.getBearingGreatCircle(starboardMarkPositionWhileApproachingLine).getDifferenceTo(combinedWind.getFrom());
                Distance windwardDistanceFromFirstToSecondMark = legDeterminingDirection.getWindwardDistance(portMarkPositionWhileApproachingLine, starboardMarkPositionWhileApproachingLine, timePoint, WindPositionMode.EXACT);
                int indexOfWaypoint = this.getRace().getCourse().getIndexOfWaypoint(waypoint);
                boolean bl = isStartLine = indexOfWaypoint == 0;
                if (isStartLine && windwardDistanceFromFirstToSecondMark.getMeters() > 0.0 || !isStartLine && windwardDistanceFromFirstToSecondMark.getMeters() < 0.0) {
                    worseMarkPosition = portMarkPositionWhileApproachingLine;
                    betterMarkPosition = starboardMarkPositionWhileApproachingLine;
                } else {
                    worseMarkPosition = starboardMarkPositionWhileApproachingLine;
                    betterMarkPosition = portMarkPositionWhileApproachingLine;
                }
                distanceAdvantage = windwardDistanceFromFirstToSecondMark.getMeters() >= 0.0 ? windwardDistanceFromFirstToSecondMark : new CentralAngleDistance(-windwardDistanceFromFirstToSecondMark.getCentralAngleRad());
                advantageousSideWhileApproachingLine = betterMarkPosition.crossTrackError(worseMarkPosition, legDeterminingDirection.getLegBearing(timePoint)).getCentralAngleRad() > 0.0 ? NauticalSide.STARBOARD : NauticalSide.PORT;
            } else {
                differenceToCombinedWind = null;
                advantageousSideWhileApproachingLine = null;
                distanceAdvantage = null;
            }
            result = new LineDetailsImpl(timePoint, waypoint, portMarkPositionWhileApproachingLine.getDistance(starboardMarkPositionWhileApproachingLine), differenceToCombinedWind, advantageousSideWhileApproachingLine, distanceAdvantage, portMarkWhileApproachingLine, starboardMarkWhileApproachingLine, portMarkPositionWhileApproachingLine, starboardMarkPositionWhileApproachingLine);
        }
        return result;
    }

    private LineMarksWithPositions getLineMarksAndPositions(TimePoint timePoint, Waypoint waypoint) {
        LineMarksWithPositions result;
        ArrayList<Position> markPositions = new ArrayList<Position>();
        int numberOfMarks = 0;
        boolean allMarksHavePositions = true;
        if (waypoint != null) {
            for (Mark lineMark : waypoint.getMarks()) {
                ++numberOfMarks;
                Position estimatedMarkPosition = this.getOrCreateTrack(lineMark).getEstimatedPosition(timePoint, false);
                if (estimatedMarkPosition != null) {
                    markPositions.add(estimatedMarkPosition);
                    continue;
                }
                allMarksHavePositions = false;
            }
            List legs = this.getRace().getCourse().getLegs();
            if (!legs.isEmpty()) {
                if (allMarksHavePositions && numberOfMarks == 2) {
                    Bearing legBearing;
                    TrackedLeg legDeterminingDirection = this.getLegDeterminingDirectionInWhichToPassWaypoint(waypoint);
                    if (legDeterminingDirection == null || (legBearing = legDeterminingDirection.getLegBearing(timePoint)) == null) {
                        result = null;
                    } else {
                        Position starboardMarkPositionWhileApproachingLine;
                        Mark starboardMarkWhileApproachingLine;
                        Position portMarkPositionWhileApproachingLine;
                        Mark portMarkWhileApproachingLine;
                        Distance crossTrackErrorOfMark0OnLineFromMark1ToNextWaypoint = ((Position)markPositions.get(0)).crossTrackError((Position)markPositions.get(1), legBearing);
                        if (crossTrackErrorOfMark0OnLineFromMark1ToNextWaypoint.getMeters() < 0.0) {
                            portMarkWhileApproachingLine = (Mark)Util.get((Iterable)waypoint.getMarks(), (int)0);
                            portMarkPositionWhileApproachingLine = (Position)markPositions.get(0);
                            starboardMarkWhileApproachingLine = (Mark)Util.get((Iterable)waypoint.getMarks(), (int)1);
                            starboardMarkPositionWhileApproachingLine = (Position)markPositions.get(1);
                        } else {
                            portMarkWhileApproachingLine = (Mark)Util.get((Iterable)waypoint.getMarks(), (int)1);
                            portMarkPositionWhileApproachingLine = (Position)markPositions.get(1);
                            starboardMarkWhileApproachingLine = (Mark)Util.get((Iterable)waypoint.getMarks(), (int)0);
                            starboardMarkPositionWhileApproachingLine = (Position)markPositions.get(0);
                        }
                        result = new LineMarksWithPositions(portMarkPositionWhileApproachingLine, starboardMarkPositionWhileApproachingLine, starboardMarkWhileApproachingLine, portMarkWhileApproachingLine);
                    }
                } else {
                    result = null;
                }
            } else {
                result = null;
            }
        } else {
            result = null;
        }
        return result;
    }

    private TrackedLeg getLegDeterminingDirectionInWhichToPassWaypoint(Waypoint waypoint) {
        int indexOfWaypoint = this.getRace().getCourse().getIndexOfWaypoint(waypoint);
        boolean isStartLine = indexOfWaypoint == 0;
        TrackedLeg legDeterminingDirection = this.getTrackedLeg((Leg)this.getRace().getCourse().getLegs().get(isStartLine ? 0 : indexOfWaypoint - 1));
        return legDeterminingDirection;
    }

    @Override
    public LineDetails getStartLine(TimePoint at) {
        return this.getLineLengthAndAdvantage(at, this.getRace().getCourse().getFirstWaypoint());
    }

    @Override
    public LineDetails getFinishLine(TimePoint at) {
        return this.getLineLengthAndAdvantage(at, this.getRace().getCourse().getLastWaypoint());
    }

    @Override
    public SpeedWithConfidence<TimePoint> getAverageWindSpeedWithConfidence(long resolutionInMillis) {
        TimePoint fromTimePoint = this.getStartOfRace() == null ? this.getStartOfTracking() : this.getStartOfRace();
        TimePoint toTimePoint = this.getEndOfRace() == null ? this.getTimePointOfNewestEvent() : this.getEndOfRace();
        SpeedWithConfidence<TimePoint> result = fromTimePoint != null && toTimePoint != null ? this.getAverageWindSpeedWithConfidence(fromTimePoint, toTimePoint, (int)((toTimePoint.asMillis() - fromTimePoint.asMillis()) / resolutionInMillis)) : null;
        return result;
    }

    @Override
    public SpeedWithConfidence<TimePoint> getAverageWindSpeedWithConfidenceWithNumberOfSamples(int numberOfFixes) {
        TimePoint fromTimePoint = this.getStartOfRace() == null ? this.getStartOfTracking() : this.getStartOfRace();
        TimePoint toTimePoint = this.getEndOfRace() == null ? this.getTimePointOfNewestEvent() : this.getEndOfRace();
        SpeedWithConfidence<TimePoint> result = fromTimePoint != null && toTimePoint != null ? this.getAverageWindSpeedWithConfidence(fromTimePoint, toTimePoint, numberOfFixes) : null;
        return result;
    }

    @Override
    public SpeedWithConfidence<TimePoint> getAverageWindSpeedWithConfidence(TimePoint fromTimePoint, TimePoint toTimePoint, int numberOfFixes) {
        SpeedWithConfidenceImpl<TimePoint> result = null;
        if (toTimePoint != null) {
            ArrayList<WindSourceImpl> windSourcesToDeliver = new ArrayList<WindSourceImpl>();
            WindSourceImpl windSource = new WindSourceImpl(WindSourceType.COMBINED);
            windSourcesToDeliver.add(windSource);
            double sumWindSpeed = 0.0;
            double sumWindSpeedConfidence = 0.0;
            int speedCounter = 0;
            WindTrack windTrack = this.getOrCreateWindTrack((WindSource)windSource);
            TimePoint timePoint = fromTimePoint;
            int resolutionInMillis = (int)((toTimePoint.asMillis() - fromTimePoint.asMillis()) / (long)numberOfFixes);
            int i = 0;
            while (i < numberOfFixes && timePoint.compareTo((Object)toTimePoint) < 0) {
                WindWithConfidence<Util.Pair<Position, TimePoint>> averagedWindWithConfidence = windTrack.getAveragedWindWithConfidence(null, timePoint);
                if (averagedWindWithConfidence != null) {
                    double windSpeedinKnots = ((Wind)averagedWindWithConfidence.getObject()).getKnots();
                    double confidence = averagedWindWithConfidence.getConfidence();
                    sumWindSpeed += windSpeedinKnots;
                    sumWindSpeedConfidence += confidence;
                    ++speedCounter;
                }
                timePoint = new MillisecondsTimePoint(timePoint.asMillis() + (long)resolutionInMillis);
                ++i;
            }
            if (speedCounter > 0) {
                KnotSpeedImpl averageWindSpeed = new KnotSpeedImpl(sumWindSpeed / (double)speedCounter);
                double averageWindSpeedConfidence = sumWindSpeedConfidence / (double)speedCounter;
                result = new SpeedWithConfidenceImpl<TimePoint>((Speed)averageWindSpeed, averageWindSpeedConfidence, toTimePoint);
            }
        }
        return result;
    }

    @Override
    public Distance getCourseLength() {
        Distance.NullDistance d = Distance.NULL;
        for (TrackedLeg trackedLeg : this.getTrackedLegs()) {
            d = d.add(trackedLeg.getWindwardDistance());
        }
        return d;
    }

    @Override
    public Speed getSpeedWhenCrossingStartLine(Competitor competitor) {
        NavigableSet<MarkPassing> competitorMarkPassings = this.getMarkPassings(competitor);
        SpeedWithBearing competitorSpeedWhenPassingStart = null;
        this.lockForRead(competitorMarkPassings);
        try {
            if (!competitorMarkPassings.isEmpty()) {
                TimePoint competitorStartTime = ((MarkPassing)competitorMarkPassings.first()).getTimePoint();
                competitorSpeedWhenPassingStart = this.getTrack(competitor).getEstimatedSpeed(competitorStartTime);
            }
        }
        finally {
            this.unlockAfterRead(competitorMarkPassings);
        }
        return competitorSpeedWhenPassingStart;
    }

    protected abstract MarkPassingCalculator createMarkPassingCalculator(MarkPassingRaceFingerprintRegistry var1);

    @Override
    public boolean isUsingMarkPassingCalculator() {
        return this.markPassingCalculator != null;
    }

    @Override
    public Position getCenterOfCourse(TimePoint at) {
        int count = 0;
        ScalablePosition sum = null;
        MarkPositionAtTimePointCacheImpl cache = new MarkPositionAtTimePointCacheImpl(this, at);
        HashSet<Util.Pair> visited = new HashSet<Util.Pair>();
        Course course = this.getRace().getCourse();
        course.lockForRead();
        try {
            for (Leg leg : course.getLegs()) {
                Util.Pair visitedKey = new Util.Pair((Object)leg.getFrom().getControlPoint(), (Object)leg.getTo().getControlPoint());
                if (visited.contains(visitedKey)) continue;
                visited.add(visitedKey);
                visited.add(new Util.Pair((Object)((ControlPoint)visitedKey.getB()), (Object)((ControlPoint)visitedKey.getA())));
                Distance legDistance = this.getTrackedLeg(leg).getGreatCircleDistance(at, cache);
                Position legMiddle = this.getTrackedLeg(leg).getMiddleOfLeg(at, cache);
                if (legMiddle == null) continue;
                ScalablePosition p = new ScalablePosition(legMiddle).multiply(legDistance.getMeters());
                sum = sum == null ? p : sum.add((ScalableValue)p);
                ++count;
            }
        }
        finally {
            course.unlockAfterRead();
        }
        Position result = sum == null ? null : sum.divide((double)count);
        return result;
    }

    Iterable<Waypoint> getWaypoints() {
        return this.markPassingsForWaypoint.keySet();
    }

    @Override
    public Boolean isGateStart() {
        Boolean result = null;
        for (RaceLog raceLog : this.attachedRaceLogs.values()) {
            ReadonlyRaceState raceState = this.getRaceState(raceLog);
            ReadonlyRacingProcedure procedure = raceState.getRacingProcedureNoFallback();
            if (procedure == null || procedure.getType() == null) continue;
            result = procedure.getType() == RacingProcedureType.GateStart;
            break;
        }
        return result;
    }

    @Override
    public long getGateStartGolfDownTime() {
        long result = 0L;
        Boolean isGateStart = this.isGateStart();
        if (isGateStart != null && isGateStart.booleanValue()) {
            for (RaceLog raceLog : this.attachedRaceLogs.values()) {
                raceLog.lockForRead();
                try {
                    for (RaceLogEvent raceLogEvent : raceLog.getRawFixes()) {
                        if (!raceLogEvent.getClass().equals(RaceLogGateLineOpeningTimeEventImpl.class)) continue;
                        RaceLogGateLineOpeningTimeEvent raceLogGateLineOpeningTimeEvent = (RaceLogGateLineOpeningTimeEvent)raceLogEvent;
                        result = raceLogGateLineOpeningTimeEvent.getGateLineOpeningTimes().getGolfDownTime();
                    }
                }
                finally {
                    raceLog.unlockAfterRead();
                }
            }
        }
        return result;
    }

    @Override
    public Distance getAdditionalGateStartDistance(Competitor competitor, TimePoint timePoint) {
        Object result;
        TrackedLegOfCompetitor competitorLeg;
        Leg startLeg = this.getRace().getCourse().getFirstLeg();
        if (startLeg != null && this.isGateStart() == Boolean.TRUE && (competitorLeg = this.getTrackedLeg(competitor, startLeg)).hasStartedLeg(timePoint)) {
            TimePoint competitorLegStartTime = competitorLeg.getStartTime();
            Mark portMarkOfStartLine = this.getStartLine(competitorLegStartTime).getPortMarkWhileApproachingLine();
            Position portSideOfStartLinePosition = this.getOrCreateTrack(portMarkOfStartLine).getEstimatedPosition(competitorLegStartTime, true);
            Position estimatedCompetitorPositionAtStart = this.getTrack(competitor).getEstimatedPosition(competitorLegStartTime, false);
            result = estimatedCompetitorPositionAtStart != null && portSideOfStartLinePosition != null ? portSideOfStartLinePosition.getDistance(estimatedCompetitorPositionAtStart) : Distance.NULL;
        } else {
            result = Distance.NULL;
        }
        return result;
    }

    @Override
    public TargetTimeInfo getEstimatedTimeToComplete(TimePoint timepoint) throws NotEnoughDataHasBeenAddedException, NoWindException {
        if (this.polarDataService == null) {
            throw new NotEnoughDataHasBeenAddedException("Target time estimation failed. No polar service available.");
        }
        Duration durationOfAllLegs = Duration.NULL;
        TimePoint current = timepoint;
        ArrayList<TargetTimeInfo.LegTargetTimeInfo> legTargetTimes = new ArrayList<TargetTimeInfo.LegTargetTimeInfo>();
        for (TrackedLeg leg : this.trackedLegs.values()) {
            MarkPositionAtTimePointCacheImpl markPositionCache = new MarkPositionAtTimePointCacheImpl(this, current);
            TargetTimeInfo.LegTargetTimeInfo legTargetTime = leg.getEstimatedTimeAndDistanceToComplete(this.polarDataService, current, markPositionCache);
            legTargetTimes.add(legTargetTime);
            durationOfAllLegs = durationOfAllLegs.plus(legTargetTime.getExpectedDuration());
            current = current.plus(legTargetTime.getExpectedDuration());
        }
        return new TargetTimeInfoImpl(legTargetTimes);
    }

    @Override
    public Duration getTimeSailedSinceRaceStart(Competitor competitor, TimePoint timePoint) {
        return this.getRankingMetric().getActualTimeSinceStartOfRace(competitor, timePoint);
    }

    @Override
    public Distance getEstimatedDistanceToComplete(TimePoint timepoint) throws NotEnoughDataHasBeenAddedException, NoWindException {
        if (this.polarDataService == null) {
            throw new NotEnoughDataHasBeenAddedException("Target time estimation failed. No polar service available.");
        }
        Distance.NullDistance distanceOfAllLegs = Distance.NULL;
        TimePoint current = timepoint;
        ArrayList<TargetTimeInfo.LegTargetTimeInfo> legTargetTimes = new ArrayList<TargetTimeInfo.LegTargetTimeInfo>();
        for (TrackedLeg leg : this.trackedLegs.values()) {
            MarkPositionAtTimePointCacheImpl markPositionCache = new MarkPositionAtTimePointCacheImpl(this, current);
            TargetTimeInfo.LegTargetTimeInfo legTargetTime = leg.getEstimatedTimeAndDistanceToComplete(this.polarDataService, current, markPositionCache);
            legTargetTimes.add(legTargetTime);
            distanceOfAllLegs = distanceOfAllLegs.add(legTargetTime.getExpectedDistance());
            current = current.plus(legTargetTime.getExpectedDuration());
        }
        return distanceOfAllLegs;
    }

    @Override
    public void setPolarDataService(PolarDataService polarDataService) {
        this.polarDataService = polarDataService;
        if (polarDataService != null && this.windEstimation != null) {
            this.updateManeuversAndWindWithNewWindEstimation(this.windEstimation, this.windEstimation);
        }
    }

    @Override
    public void setWindEstimation(IncrementalWindEstimation windEstimation) {
        IncrementalWindEstimation previousWindEstimation = this.windEstimation;
        if (previousWindEstimation != windEstimation) {
            this.updateManeuversAndWindWithNewWindEstimation(windEstimation, previousWindEstimation);
        }
    }

    private void updateManeuversAndWindWithNewWindEstimation(IncrementalWindEstimation windEstimation, IncrementalWindEstimation previousWindEstimation) {
        WindSourceImpl windSource = new WindSourceImpl(WindSourceType.MANEUVER_BASED_ESTIMATION);
        this.windTracks.remove(windSource);
        if (windEstimation != null) {
            this.windTracks.put(windSource, windEstimation.getWindTrack());
        }
        this.updateWindSourcesByType((WindSource)windSource);
        this.windEstimation = windEstimation;
        this.maneuverDetectorPerCompetitorCache.clearCache();
        this.shortTimeWindCache.clearCache();
        this.triggerManeuverCacheRecalculationForAllCompetitors();
    }

    @Override
    public RaceLogAndTrackedRaceResolver getRaceLogResolver() {
        return this.raceLogResolver;
    }

    public void setRaceLogResolver(RaceLogAndTrackedRaceResolver raceLogResolver) {
        this.raceLogResolver = raceLogResolver;
    }

    public IsManagedByCache<DomainFactory> resolve(DomainFactory domainFactory) {
        this.raceLogResolver = (RaceLogAndTrackedRaceResolver)domainFactory.getRaceLogResolver();
        return this;
    }

    public void registerRegattaListener() {
        this.trackedRegatta.getRegatta().addRegattaListener(new TimingUpdaterCallback());
    }

    @Override
    public Iterable<Mark> getMarksFromRegattaLogs() {
        HashSet<Mark> result = new HashSet<Mark>();
        for (RegattaLog log : this.attachedRegattaLogs.values()) {
            result.addAll((Collection)new RegattaLogDefinedMarkAnalyzer(log).analyze());
        }
        return result;
    }

    @Override
    public <FixT extends SensorFix, TrackT extends SensorFixTrack<Competitor, FixT>> TrackT getSensorTrack(Competitor competitor, String trackName) {
        Util.Pair key = new Util.Pair((Object)competitor, (Object)trackName);
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.sensorTracksLock);
        try {
            TrackT TrackT = this.getTrackInternal((Util.Pair<Competitor, String>)key);
            return TrackT;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.sensorTracksLock);
        }
    }

    @Override
    public <FixT extends SensorFix, TrackT extends SensorFixTrack<Competitor, FixT>> Iterable<TrackT> getSensorTracks(String trackName) {
        return (Iterable)LockUtil.executeWithReadLockAndResult((NamedReentrantReadWriteLock)this.sensorTracksLock, () -> {
            HashSet result = new HashSet();
            for (Competitor competitor : this.tracks.keySet()) {
                Util.Pair key = new Util.Pair((Object)competitor, (Object)trackName);
                Object track = this.getTrackInternal((Util.Pair<Competitor, String>)key);
                if (track == null) continue;
                result.add(track);
            }
            return result;
        });
    }

    protected <FixT extends SensorFix, TrackT extends DynamicSensorFixTrack<Competitor, FixT>> TrackT getOrCreateSensorTrack(Competitor competitor, String trackName, TrackFactory<TrackT> newTrackFactory) {
        DynamicSensorFixTrack result;
        Util.Pair key = new Util.Pair((Object)competitor, (Object)trackName);
        Optional<Runnable> executeAfterReleasingLock = Optional.empty();
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.sensorTracksLock);
        try {
            result = (DynamicSensorFixTrack)this.getTrackInternal((Util.Pair<Competitor, String>)key);
            if (result == null && this.tracks.containsKey(competitor)) {
                result = (DynamicSensorFixTrack)newTrackFactory.get();
                executeAfterReleasingLock = this.addSensorTrackInternal((Util.Pair<Competitor, String>)key, result);
            }
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.sensorTracksLock);
        }
        executeAfterReleasingLock.ifPresent(r -> r.run());
        return (TrackT)result;
    }

    protected void addSensorTrack(Competitor competitor, String trackName, DynamicSensorFixTrack<Competitor, ?> track) {
        Util.Pair key = new Util.Pair((Object)competitor, (Object)trackName);
        Optional<Object> executeAfterReleasingLock = Optional.empty();
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.sensorTracksLock);
        try {
            if (this.getTrackInternal((Util.Pair<Competitor, String>)key) != null) {
                if (logger != null && logger.getLevel() != null && logger.getLevel().equals(Level.WARNING)) {
                    logger.warning(String.valueOf(SensorFixTrack.class.getName()) + " already exists for competitor: " + competitor.getName() + "; trackName: " + trackName);
                }
            } else {
                executeAfterReleasingLock = this.addSensorTrackInternal((Util.Pair<Competitor, String>)key, track);
            }
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.sensorTracksLock);
        }
        executeAfterReleasingLock.ifPresent(r -> r.run());
    }

    protected <FixT extends SensorFix> Optional<Runnable> addSensorTrackInternal(Util.Pair<Competitor, String> key, DynamicSensorFixTrack<Competitor, FixT> track) {
        assert (this.sensorTracksLock.isWriteLockedByCurrentThread());
        this.sensorTracks.put(key, track);
        track.addedToTrackedRace(this);
        return Optional.empty();
    }

    private <TrackT extends SensorFixTrack<Competitor, ?>> TrackT getTrackInternal(Util.Pair<Competitor, String> key) {
        return (TrackT)this.sensorTracks.get(key);
    }

    protected abstract Set<RaceChangeListener> getListeners();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(Consumer<RaceChangeListener> notifyAction) {
        RaceChangeListener[] listeners;
        Set<RaceChangeListener> set = this.getListeners();
        synchronized (set) {
            listeners = this.getListeners().toArray(new RaceChangeListener[this.getListeners().size()]);
        }
        RaceChangeListener[] raceChangeListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            RaceChangeListener listener = raceChangeListenerArray[n2];
            try {
                notifyAction.accept(listener);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "RaceChangeListener " + listener + " threw exception " + e.getMessage());
                logger.log(Level.SEVERE, "notifyListeners(Consumer<RaceChangeListener> notifyAction", e);
            }
            ++n2;
        }
    }

    private void notifyListenersWhenAttachingRegattaLog(RegattaLog regattaLog) {
        this.notifyListeners(listener -> listener.regattaLogAttached(regattaLog));
    }

    private void notifyListenersWhenAttachingRaceLog(RaceLog raceLog) {
        this.notifyListeners(listener -> listener.raceLogAttached(raceLog));
    }

    private void notifyListenersWhenDetachingRaceLog(RaceLog raceLog) {
        this.notifyListeners(listener -> listener.raceLogDetached(raceLog));
    }

    @Override
    public void lockForSerializationRead() {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.getSerializationLock());
    }

    @Override
    public void unlockAfterSerializationRead() {
        LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.getSerializationLock());
    }

    @Override
    public Iterable<RaceLog> getAttachedRaceLogs() {
        return this.attachedRaceLogs == null ? Collections.emptySet() : new HashSet(this.attachedRaceLogs.values());
    }

    @Override
    public Speed getAverageSpeedOverGround(Competitor competitor, TimePoint timePoint) {
        Speed result = null;
        Duration totalTimeSailedInRace = Duration.NULL;
        Distance.NullDistance totalDistanceSailedInRace = Distance.NULL;
        for (TrackedLeg legGeneral : this.getTrackedLegs()) {
            TrackedLegOfCompetitor leg = legGeneral.getTrackedLeg(competitor);
            if (leg == null || !leg.hasStartedLeg(timePoint)) continue;
            totalDistanceSailedInRace = totalDistanceSailedInRace.add(leg.getDistanceTraveled(timePoint));
            totalTimeSailedInRace = totalTimeSailedInRace.plus(leg.getTime(timePoint));
        }
        if (!totalTimeSailedInRace.equals(Duration.NULL) && !totalDistanceSailedInRace.equals(Distance.NULL)) {
            result = totalDistanceSailedInRace.inTime(totalTimeSailedInRace);
        }
        return result;
    }

    @Override
    public SpeedWithBearing getVelocityMadeGood(Competitor competitor, TimePoint timePoint, WindPositionMode windPositionMode, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        SpeedWithBearing result;
        TrackedLegOfCompetitor trackedLeg = this.getTrackedLeg(competitor, timePoint);
        if (trackedLeg != null) {
            result = trackedLeg.getVelocityMadeGood(timePoint, windPositionMode, cache);
        } else if (windPositionMode == WindPositionMode.LEG_MIDDLE) {
            result = null;
        } else {
            Wind wind = this.getWind(windPositionMode, null, competitor, timePoint, cache);
            result = this.projectOnto(this.getTrack(competitor).getEstimatedSpeed(timePoint), wind.getBearing());
        }
        return result;
    }

    SpeedWithBearing projectOnto(SpeedWithBearing speed, Bearing projectToBearing) {
        KnotSpeedWithBearingImpl result;
        if (speed != null && speed.getBearing() != null && projectToBearing != null) {
            double cos = Math.cos(speed.getBearing().getRadians() - projectToBearing.getRadians());
            if (cos < 0.0) {
                projectToBearing = projectToBearing.reverse();
            }
            result = new KnotSpeedWithBearingImpl(Math.abs(speed.getKnots() * cos), projectToBearing);
        } else {
            result = null;
        }
        return result;
    }

    Wind getWind(WindPositionMode windPositionMode, TrackedLegImpl trackedLeg, Competitor competitor, TimePoint at, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Wind wind = windPositionMode == WindPositionMode.EXACT ? cache.getWind(this, competitor, at) : this.getWind(trackedLeg == null ? null : trackedLeg.getEffectiveWindPosition(() -> this.getTrack(competitor).getEstimatedPosition(at, false), at, windPositionMode), at);
        return wind;
    }

    @Override
    public PolarDataService getPolarDataService() {
        return this.polarDataService;
    }

    @Override
    public WindSummary getWindSummary() {
        WindSummaryImpl result;
        Wind minTrueWindSpeed = null;
        Wind maxTrueWindSpeed = null;
        TimePoint finishedTime = this.getFinishedTime();
        TimePoint endOfRace = this.getEndOfRace();
        TimePoint finishTime = finishedTime == null ? (endOfRace == null ? MillisecondsTimePoint.now().minus(this.getDelayToLiveInMillis()) : endOfRace) : finishedTime;
        TimePoint newestEvent = this.getTimePointOfNewestEvent();
        TimePoint toTimePoint = newestEvent != null && newestEvent.before(finishTime) ? newestEvent : finishTime;
        BearingWithConfidenceCluster bwcc = new BearingWithConfidenceCluster((Weigher)new Weigher<TimePoint>(){
            private static final long serialVersionUID = -5779398785058438328L;

            public double getConfidence(TimePoint fix, TimePoint request) {
                return 1.0;
            }
        });
        TimePoint middleOfRace = this.getStartOfRace().plus(this.getStartOfRace().until(toTimePoint).divide(2L));
        List<TimePoint> pointsToGetWind = Arrays.asList(this.getStartOfRace(), middleOfRace, toTimePoint);
        for (TimePoint timePoint : pointsToGetWind) {
            WindWithConfidence<Util.Pair<Position, TimePoint>> averagedWindWithConfidence = this.getWindWithConfidence(this.getCenterOfCourse(timePoint), timePoint);
            WindWithConfidence<Util.Pair<Position, TimePoint>> windFixToUse = averagedWindWithConfidence != null && ((Wind)averagedWindWithConfidence.getObject()).getKnots() >= 0.05 ? averagedWindWithConfidence : null;
            if (windFixToUse == null) continue;
            Wind wind = (Wind)windFixToUse.getObject();
            bwcc.add((BearingWithConfidence)new BearingWithConfidenceImpl(wind.getBearing(), windFixToUse.getConfidence(), (Object)timePoint));
            if (minTrueWindSpeed == null || minTrueWindSpeed.compareTo((Object)wind) > 0) {
                minTrueWindSpeed = wind;
            }
            if (maxTrueWindSpeed != null && maxTrueWindSpeed.compareTo((Object)wind) >= 0) continue;
            maxTrueWindSpeed = wind;
        }
        if (minTrueWindSpeed != null && maxTrueWindSpeed != null) {
            BearingWithConfidence average = bwcc.getAverage((Object)middleOfRace);
            result = new WindSummaryImpl(((Bearing)average.getObject()).reverse(), (Speed)minTrueWindSpeed, (Speed)maxTrueWindSpeed);
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public TrackingConnectorInfo getTrackingConnectorInfo() {
        return this.trackingConnectorInfo;
    }

    @Override
    public Double getPercentTargetBoatSpeed(Competitor competitor, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) throws NotEnoughDataHasBeenAddedException, MaxIterationsExceededException, FunctionEvaluationException {
        Double result;
        if (this.getRankingMetric().getType() == RankingMetrics.ONE_DESIGN) {
            PolarDataService polarDataService = this.getPolarDataService();
            if (polarDataService != null) {
                GPSFixTrack<Competitor, GPSFixMoving> competitorTrack = this.getTrack(competitor);
                Wind wind = this.getWind(competitorTrack.getEstimatedPosition(timePoint, true), timePoint);
                Bearing twa = this.getTWA(competitor, timePoint, cache);
                if (twa != null) {
                    try {
                        SpeedWithConfidence<Void> targetSpeed = polarDataService.getSpeed(this.getBoatOfCompetitor(competitor).getBoatClass(), (Speed)wind, twa);
                        SpeedWithBearing sog = competitorTrack.getEstimatedSpeed(timePoint);
                        result = targetSpeed != null && targetSpeed.getObject() != null && sog != null ? Double.valueOf(100.0 * sog.getKnots() / ((Speed)targetSpeed.getObject()).getKnots()) : null;
                    }
                    catch (NotEnoughDataHasBeenAddedException e) {
                        result = null;
                    }
                } else {
                    result = null;
                }
            } else {
                result = null;
            }
        } else if (this.getRankingMetric() instanceof ORCPerformanceCurveRankingMetric) {
            ORCPerformanceCurveRankingMetric orcRankingMetric = (ORCPerformanceCurveRankingMetric)((Object)this.getRankingMetric());
            GPSFixTrack<Competitor, GPSFixMoving> competitorTrack = this.getTrack(competitor);
            Wind wind = this.getWind(competitorTrack.getEstimatedPosition(timePoint, true), timePoint);
            Speed impliedWind = orcRankingMetric.getImpliedWind(competitor, timePoint, cache);
            result = impliedWind == null || wind == null ? null : Double.valueOf(impliedWind.divide((Speed)wind) * 100.0);
        } else {
            result = null;
        }
        return result;
    }

    @FunctionalInterface
    private static interface BravoFromToValueCalculator<T> {
        public T getValue(BravoFixTrack<Competitor> var1, TimePoint var2, TimePoint var3);
    }

    private static class LineMarksWithPositions {
        private final Position portMarkPositionWhileApproachingLine;
        private final Position starboardMarkPositionWhileApproachingLine;
        private final Mark starboardMarkWhileApproachingLine;
        private final Mark portMarkWhileApproachingLine;

        protected LineMarksWithPositions(Position portMarkPositionWhileApproachingLine, Position starboardMarkPositionWhileApproachingLine, Mark starboardMarkWhileApproachingLine, Mark portMarkWhileApproachingLine) {
            this.portMarkPositionWhileApproachingLine = portMarkPositionWhileApproachingLine;
            this.starboardMarkPositionWhileApproachingLine = starboardMarkPositionWhileApproachingLine;
            this.starboardMarkWhileApproachingLine = starboardMarkWhileApproachingLine;
            this.portMarkWhileApproachingLine = portMarkWhileApproachingLine;
        }

        public Position getPortMarkPositionWhileApproachingLine() {
            return this.portMarkPositionWhileApproachingLine;
        }

        public Position getStarboardMarkPositionWhileApproachingLine() {
            return this.starboardMarkPositionWhileApproachingLine;
        }

        public Mark getStarboardMarkWhileApproachingLine() {
            return this.starboardMarkWhileApproachingLine;
        }

        public Mark getPortMarkWhileApproachingLine() {
            return this.portMarkWhileApproachingLine;
        }
    }

    private static enum LoadingFromStoresState {
        NOT_STARTED,
        RUNNING,
        FINISHED;

    }

    private class StartToNextMarkCacheInvalidationListener
    implements GPSTrackListener<Mark, GPSFix> {
        private static final long serialVersionUID = 3540278554797445085L;
        private final GPSFixTrack<Mark, GPSFix> listeningTo;

        public StartToNextMarkCacheInvalidationListener(GPSFixTrack<Mark, GPSFix> listeningTo) {
            this.listeningTo = listeningTo;
        }

        public void stopListening() {
            this.listeningTo.removeListener(this);
        }

        @Override
        public void gpsFixReceived(GPSFix fix, Mark mark, boolean firstFixInTrack, AddResult addedOrReplaced) {
            TrackedRaceImpl.this.clearDirectionFromStartToNextMarkCache();
        }

        @Override
        public void speedAveragingChanged(long oldMillisecondsOverWhichToAverage, long newMillisecondsOverWhichToAverage) {
        }

        @Override
        public boolean isTransient() {
            return false;
        }
    }

    private class TimingUpdaterCallback
    implements RegattaListener {
        private TimingUpdaterCallback() {
        }

        @Override
        public void useStartTimeInferenceChanged(Regatta regatta, boolean newUseStartTimeInference) {
            TrackedRaceImpl.this.updateStartAndEndOfTracking(false);
        }

        @Override
        public void controlTrackingFromStartAndFinishTimesChanged(Regatta regatta, boolean newControlTrackingFromStartAndFinishTimes) {
            TrackedRaceImpl.this.updateStartAndEndOfTracking(false);
        }
    }
}

