/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.TrackedRaceStatusEnum;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.common.tracking.SensorFix;
import com.sap.sailing.domain.tracking.AddResult;
import com.sap.sailing.domain.tracking.DynamicSensorFixTrack;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRaceStatus;
import com.sap.sailing.domain.tracking.WindTrack;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sailing.domain.tracking.impl.AbstractRaceChangeListener;
import com.sap.sailing.domain.tracking.impl.VirtualWindFixesAsNavigableSet;
import com.sap.sailing.domain.tracking.impl.VirtualWindTrackImpl;
import com.sap.sailing.domain.tracking.impl.WindWithConfidenceImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.AbstractTimePoint;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.impl.SerializableComparator;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import com.sap.sse.shared.util.impl.ArrayListNavigableSet;
import com.sap.sse.util.ThreadPoolUtil;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;

public class TrackBasedEstimationWindTrackImpl
extends VirtualWindTrackImpl {
    private static final long serialVersionUID = -4397496421917807499L;
    private static final SpeedWithBearing defaultSpeedWithBearing = new KnotSpeedWithBearingImpl(0.0, (Bearing)new DegreeBearingImpl(0.0));
    private static final Duration RESOLUTION = Duration.ONE_SECOND;
    private final EstimatedWindFixesAsNavigableSet virtualInternalRawFixes;
    private final NavigableSet<TimePoint> timePointsWithCachedNullResult;
    private final NavigableSet<WindWithConfidence<TimePoint>> cache;
    private final NamedReentrantReadWriteLock cacheLock;
    private final NamedReentrantReadWriteLock scheduledRefreshIntervalLock;
    private final HashSet<TimePoint> timePointsWithCachedNullResultFastContains;
    private final long delayForCacheInvalidationInMilliseconds;
    private final InvalidationInterval scheduledRefreshInterval;
    private final CacheInvalidationRaceChangeListener listener;

    public TrackBasedEstimationWindTrackImpl(TrackedRace trackedRace, long millisecondsOverWhichToAverage, double baseConfidence, long delayForCacheInvalidationInMilliseconds) {
        super(trackedRace, millisecondsOverWhichToAverage, baseConfidence, WindSourceType.TRACK_BASED_ESTIMATION.useSpeed());
        this.delayForCacheInvalidationInMilliseconds = delayForCacheInvalidationInMilliseconds;
        this.scheduledRefreshInterval = new InvalidationInterval();
        this.cache = new ArrayListNavigableSet((Comparator)new SerializableComparator<WindWithConfidence<TimePoint>>(){
            private static final long serialVersionUID = 5760349397418542705L;

            public int compare(WindWithConfidence<TimePoint> o1, WindWithConfidence<TimePoint> o2) {
                return ((Wind)o1.getObject()).getTimePoint().compareTo((Object)((Wind)o2.getObject()).getTimePoint());
            }
        });
        this.cacheLock = new NamedReentrantReadWriteLock(String.valueOf(TrackBasedEstimationWindTrackImpl.class.getSimpleName()) + " cacheLock for race " + trackedRace.getRace().getName(), false);
        this.scheduledRefreshIntervalLock = new NamedReentrantReadWriteLock(String.valueOf(TrackBasedEstimationWindTrackImpl.class.getSimpleName()) + " scheduledRefreshIntervalLock for race " + trackedRace.getRace().getName(), false);
        this.virtualInternalRawFixes = new EstimatedWindFixesAsNavigableSet(trackedRace);
        this.listener = new CacheInvalidationRaceChangeListener();
        trackedRace.addListener(this.listener);
        this.timePointsWithCachedNullResult = new ArrayListNavigableSet(AbstractTimePoint.TIMEPOINT_COMPARATOR);
        this.timePointsWithCachedNullResultFastContains = new HashSet();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.scheduledRefreshIntervalLock);
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.cacheLock);
        this.lockForRead();
        try {
            s.defaultWriteObject();
        }
        finally {
            this.unlockAfterRead();
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.cacheLock);
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.scheduledRefreshIntervalLock);
        }
    }

    public TrackBasedEstimationWindTrackImpl(TrackedRace trackedRace, long millisecondsOverWhichToAverage, double baseConfidence) {
        this(trackedRace, millisecondsOverWhichToAverage, baseConfidence, trackedRace.getMillisecondsOverWhichToAverageWind() / 2L);
    }

    protected EstimatedWindFixesAsNavigableSet getInternalRawFixes() {
        return this.virtualInternalRawFixes;
    }

    private NavigableSet<WindWithConfidence<TimePoint>> getCachedFixes() {
        return this.cache;
    }

    protected void cache(TimePoint timePoint, WindWithConfidence<TimePoint> fix) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.cacheLock);
        try {
            if (fix == null) {
                this.timePointsWithCachedNullResult.add(timePoint);
                this.timePointsWithCachedNullResultFastContains.add(timePoint);
            } else {
                this.cache.add(fix);
            }
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.cacheLock);
        }
    }

    private void scheduleCacheRefresh(WindWithConfidence<TimePoint> startOfInvalidation, TimePoint endOfInvalidation) {
        boolean alreadyContained;
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.scheduledRefreshIntervalLock);
        try {
            alreadyContained = this.scheduledRefreshInterval.contains(((Wind)startOfInvalidation.getObject()).getTimePoint(), endOfInvalidation);
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.scheduledRefreshIntervalLock);
        }
        if (!alreadyContained) {
            LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.scheduledRefreshIntervalLock);
            try {
                if (!this.scheduledRefreshInterval.isSet()) {
                    this.scheduledRefreshInterval.set(startOfInvalidation, endOfInvalidation);
                    this.startSchedulerForCacheRefresh();
                } else {
                    this.scheduledRefreshInterval.extend(startOfInvalidation, endOfInvalidation);
                }
            }
            finally {
                LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.scheduledRefreshIntervalLock);
            }
        }
    }

    private void invalidateCache() {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.scheduledRefreshIntervalLock);
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.cacheLock);
        try {
            Iterator<WindWithConfidence<TimePoint>> iter = (this.scheduledRefreshInterval.getStart() == null ? this.getCachedFixes() : this.getCachedFixes().tailSet(this.scheduledRefreshInterval.getStart(), true)).iterator();
            while (iter.hasNext()) {
                WindWithConfidence<TimePoint> next = iter.next();
                if (this.scheduledRefreshInterval.getEnd() != null && ((Wind)next.getObject()).getTimePoint().compareTo((Object)this.scheduledRefreshInterval.getEnd()) >= 0) break;
                iter.remove();
            }
            Iterator<TimePoint> nullIter = (this.scheduledRefreshInterval.getStart() == null ? this.timePointsWithCachedNullResult : this.timePointsWithCachedNullResult.tailSet(((Wind)this.scheduledRefreshInterval.getStart().getObject()).getTimePoint(), true)).iterator();
            while (nullIter.hasNext()) {
                TimePoint next = nullIter.next();
                if (this.scheduledRefreshInterval.getEnd() != null && next.compareTo((Object)this.scheduledRefreshInterval.getEnd()) >= 0) break;
                nullIter.remove();
                this.timePointsWithCachedNullResultFastContains.remove(next);
            }
            this.scheduledRefreshInterval.clear();
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.cacheLock);
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.scheduledRefreshIntervalLock);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void refreshCacheIncrementally() {
        TimePoint refreshIntervalEnd;
        WindWithConfidence<TimePoint> refreshIntervalStart;
        HashSet<WindWithConfidence<TimePoint>> windFixesToRecalculate = new HashSet<WindWithConfidence<TimePoint>>();
        HashSet<void> cachedNullResultsToRecalculate = new HashSet<void>();
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.scheduledRefreshIntervalLock);
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.cacheLock);
        try {
            TimePoint timePoint;
            refreshIntervalStart = this.scheduledRefreshInterval.getStart();
            Iterator<WindWithConfidence<TimePoint>> iter = (refreshIntervalStart == null ? this.getCachedFixes() : this.getCachedFixes().tailSet(refreshIntervalStart, true)).iterator();
            Iterator<TimePoint> nullIter = (refreshIntervalStart == null ? this.timePointsWithCachedNullResult : this.timePointsWithCachedNullResult.tailSet(((Wind)refreshIntervalStart.getObject()).getTimePoint(), true)).iterator();
            WindWithConfidence<TimePoint> nextFixToRecalculate = null;
            refreshIntervalEnd = this.scheduledRefreshInterval.getEnd();
            while (iter.hasNext() && ((Wind)(nextFixToRecalculate = iter.next()).getObject()).getTimePoint().compareTo((Object)refreshIntervalEnd) < 0 || refreshIntervalEnd == null) {
                windFixesToRecalculate.add(nextFixToRecalculate);
            }
            Object var8_8 = null;
            while (nullIter.hasNext() && (timePoint = nullIter.next()).compareTo((Object)refreshIntervalEnd) < 0 || refreshIntervalEnd == null) {
                void var8_9;
                cachedNullResultsToRecalculate.add(var8_9);
            }
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.cacheLock);
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.scheduledRefreshIntervalLock);
        }
        HashSet<TimePoint> nullRemovals = new HashSet<TimePoint>();
        HashSet<TimePoint> nullInsertions = new HashSet<TimePoint>();
        HashMap<TimePoint, WindWithConfidence<TimePoint>> cacheInsertions = new HashMap<TimePoint, WindWithConfidence<TimePoint>>();
        for (TimePoint timePoint : cachedNullResultsToRecalculate) {
            WindWithConfidence<TimePoint> replacementFix = this.getTrackedRace().getEstimatedWindDirectionWithConfidence(timePoint);
            if (replacementFix == null) continue;
            nullRemovals.add(timePoint);
            cacheInsertions.put(timePoint, replacementFix);
        }
        for (WindWithConfidence windWithConfidence : windFixesToRecalculate) {
            TimePoint timePoint = ((Wind)windWithConfidence.getObject()).getTimePoint();
            WindWithConfidence<TimePoint> replacementFix = this.getTrackedRace().getEstimatedWindDirectionWithConfidence(timePoint);
            if (replacementFix == null) {
                nullInsertions.add(timePoint);
                continue;
            }
            cacheInsertions.put(timePoint, replacementFix);
        }
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.cacheLock);
        try {
            for (TimePoint timePoint : nullRemovals) {
                this.timePointsWithCachedNullResult.remove(timePoint);
                this.timePointsWithCachedNullResultFastContains.remove(timePoint);
            }
            for (TimePoint timePoint : nullInsertions) {
                this.cache(timePoint, null);
            }
            for (WindWithConfidence windWithConfidence : windFixesToRecalculate) {
                this.getCachedFixes().remove(windWithConfidence);
            }
            for (Map.Entry entry : cacheInsertions.entrySet()) {
                this.cache((TimePoint)entry.getKey(), (WindWithConfidence)entry.getValue());
            }
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.cacheLock);
        }
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.scheduledRefreshIntervalLock);
        try {
            InvalidationInterval invalidationInterval = this.scheduledRefreshInterval.subtract(refreshIntervalStart, refreshIntervalEnd);
            this.scheduledRefreshInterval.clear();
            if (invalidationInterval.isSet()) {
                this.scheduleCacheRefresh(invalidationInterval.getStart(), invalidationInterval.getEnd());
            }
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.scheduledRefreshIntervalLock);
        }
    }

    private void startSchedulerForCacheRefresh() {
        if (this.delayForCacheInvalidationInMilliseconds == 0L) {
            this.invalidateCache();
        } else {
            ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor().schedule(() -> {
                if (this.getTrackedRace().getStatus().getStatus() == TrackedRaceStatusEnum.LOADING) {
                    this.invalidateCache();
                } else {
                    this.refreshCacheIncrementally();
                }
            }, this.delayForCacheInvalidationInMilliseconds, TimeUnit.MILLISECONDS);
        }
    }

    private void clearCache() {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.cacheLock);
        try {
            this.cache.clear();
            this.timePointsWithCachedNullResult.clear();
            this.timePointsWithCachedNullResultFastContains.clear();
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.cacheLock);
        }
    }

    private WindWithConfidence<TimePoint> getEstimatedWindDirection(TimePoint timePoint) {
        boolean nullResultCacheContains;
        WindWithConfidence<TimePoint> cachedFix = null;
        WindWithConfidence<TimePoint> result = null;
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.cacheLock);
        try {
            nullResultCacheContains = this.nullResultCacheContains(timePoint);
            if (nullResultCacheContains) {
                result = null;
            } else {
                cachedFix = this.cache.floor(TrackBasedEstimationWindTrackImpl.getDummyFixWithConfidence(timePoint));
            }
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.cacheLock);
        }
        if (!nullResultCacheContains) {
            if (cachedFix == null || !((Wind)cachedFix.getObject()).getTimePoint().equals(timePoint)) {
                result = this.getTrackedRace().getEstimatedWindDirectionWithConfidence(timePoint);
                this.cache(timePoint, result);
            } else {
                result = cachedFix;
            }
        }
        return result;
    }

    private static WindWithConfidence<TimePoint> getDummyFixWithConfidence(TimePoint timePoint) {
        return new WindWithConfidenceImpl<TimePoint>((Wind)new WindImpl(null, timePoint, defaultSpeedWithBearing), 0.0, timePoint, false);
    }

    private boolean nullResultCacheContains(TimePoint timePoint) {
        this.assertReadLock();
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.cacheLock);
        try {
            boolean bl = this.timePointsWithCachedNullResultFastContains.contains(timePoint);
            return bl;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.cacheLock);
        }
    }

    @Override
    public String toString() {
        this.lockForRead();
        try {
            String string = "This is the " + this.getClass().getName() + " object from " + this.virtualInternalRawFixes.getFrom() + " to " + this.virtualInternalRawFixes.getTo() + " for race " + this.getTrackedRace();
            return string;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    @Override
    protected Iterator<WindWithConfidence<Util.Pair<Position, TimePoint>>> getInternalFixesLimitedHeadSetDescendingIterator(TimePoint endingAt) {
        final TimePoint startingAt = endingAt.minus(2L * this.getMillisecondsOverWhichToAverageWind());
        return new EstimationIterator(this, this.getInternalRawFixes().floorToResolution(endingAt)){

            @Override
            protected WindWithConfidence<TimePoint> advance() {
                WindWithConfidence<TimePoint> next;
                if (this.t.before(startingAt)) {
                    next = null;
                } else {
                    do {
                        next = this.tryToGetNext();
                        this.t = this.getInternalRawFixes().lowerToResolution(this.t);
                    } while (next == null && !this.t.before(startingAt));
                }
                return next;
            }
        };
    }

    @Override
    protected Iterator<WindWithConfidence<Util.Pair<Position, TimePoint>>> getInternalFixesLimitedTailSetIterator(TimePoint startingAt) {
        final TimePoint endingAt = startingAt.plus(2L * this.getMillisecondsOverWhichToAverageWind());
        return new EstimationIterator(this, this.getInternalRawFixes().ceilingToResolution(startingAt)){

            @Override
            protected WindWithConfidence<TimePoint> advance() {
                WindWithConfidence<TimePoint> next;
                if (this.t.after(endingAt)) {
                    next = null;
                } else {
                    do {
                        next = this.tryToGetNext();
                        this.t = this.getInternalRawFixes().higherToResolution(this.t);
                    } while (next == null && !this.t.after(endingAt));
                }
                return next;
            }
        };
    }

    protected WindWithConfidenceImpl<Util.Pair<Position, TimePoint>> createWindWithTimeAndPositionBasedConfidence(WindWithConfidence<TimePoint> estimatedWindWithTimeBasedConfidence) {
        return new WindWithConfidenceImpl<Util.Pair<Position, TimePoint>>((Wind)estimatedWindWithTimeBasedConfidence.getObject(), estimatedWindWithTimeBasedConfidence.getConfidence(), new Util.Pair((Object)((Wind)estimatedWindWithTimeBasedConfidence.getObject()).getPosition(), (Object)((Wind)estimatedWindWithTimeBasedConfidence.getObject()).getTimePoint()), this.isUseSpeed());
    }

    public void windDataReceived(WindImpl wind, WindSource realWindSource) {
        this.listener.windDataReceived((Wind)wind, realWindSource);
    }

    @Override
    public Duration getResolutionOutsideOfWhichNoFixWillBeReturned() {
        return RESOLUTION;
    }

    private class CacheInvalidationRaceChangeListener
    extends AbstractRaceChangeListener
    implements Serializable {
        private static final long serialVersionUID = -6623310087193133466L;
        private boolean suspended;

        public CacheInvalidationRaceChangeListener() {
            if (TrackBasedEstimationWindTrackImpl.this.getTrackedRace().getStatus().getStatus() == TrackedRaceStatusEnum.LOADING) {
                this.suspended = true;
                TrackBasedEstimationWindTrackImpl.this.clearCache();
            } else {
                this.suspended = false;
            }
        }

        @Override
        protected void defaultAction() {
            TrackBasedEstimationWindTrackImpl.this.clearCache();
        }

        @Override
        public void windDataReceived(Wind wind, WindSource windSource) {
            if (!this.suspended) {
                this.invalidateForNewWind(wind, windSource);
            }
        }

        @Override
        public void startOfRaceChanged(TimePoint oldStartOfRace, TimePoint newStartOfRace) {
        }

        @Override
        public void finishedTimeChanged(TimePoint oldFinishedTime, TimePoint newFinishedTime) {
        }

        @Override
        public void startTimeReceivedChanged(TimePoint startTimeReceived) {
        }

        @Override
        public void delayToLiveChanged(long delayToLiveInMillis) {
        }

        private void invalidateForNewWind(Wind wind, WindSource windSource) {
            WindTrack windTrack = TrackBasedEstimationWindTrackImpl.this.getTrackedRace().getOrCreateWindTrack(windSource);
            long averagingInterval = TrackBasedEstimationWindTrackImpl.this.getTrackedRace().getMillisecondsOverWhichToAverageWind();
            TimePoint timePoint = wind.getTimePoint();
            Wind lastFixBefore = (Wind)windTrack.getLastFixBefore(timePoint.minus(1L));
            Wind firstFixAfter = (Wind)windTrack.getFirstFixAfter(timePoint.plus(1L));
            WindWithConfidence<Object> startOfInvalidation = lastFixBefore == null ? (TrackBasedEstimationWindTrackImpl.this.getTrackedRace().getStartOfTracking() == null ? TrackBasedEstimationWindTrackImpl.getDummyFixWithConfidence((TimePoint)new MillisecondsTimePoint(0L)) : TrackBasedEstimationWindTrackImpl.getDummyFixWithConfidence(TrackBasedEstimationWindTrackImpl.this.getTrackedRace().getStartOfTracking())) : (lastFixBefore.getTimePoint().before(timePoint.minus(averagingInterval)) ? new WindWithConfidenceImpl<TimePoint>(lastFixBefore, 1.0, timePoint, windSource.getType().useSpeed()) : TrackBasedEstimationWindTrackImpl.getDummyFixWithConfidence(timePoint.minus(averagingInterval)));
            Object endOfInvalidation = firstFixAfter == null ? (TrackBasedEstimationWindTrackImpl.this.getTrackedRace().getEndOfTracking() == null ? new MillisecondsTimePoint(Long.MAX_VALUE) : TrackBasedEstimationWindTrackImpl.this.getTrackedRace().getEndOfTracking()) : (firstFixAfter.getTimePoint().after(timePoint.plus(averagingInterval)) ? firstFixAfter.getTimePoint() : timePoint.plus(averagingInterval));
            TrackBasedEstimationWindTrackImpl.this.scheduleCacheRefresh(startOfInvalidation, (TimePoint)endOfInvalidation);
        }

        @Override
        public void windDataRemoved(Wind wind, WindSource windSource) {
            if (!this.suspended) {
                this.invalidateForNewWind(wind, windSource);
            }
        }

        @Override
        public void competitorPositionChanged(GPSFixMoving fix, Competitor competitor, AddResult addedOrReplaced) {
            if (!this.suspended) {
                long averagingInterval = TrackBasedEstimationWindTrackImpl.this.getTrackedRace().getMillisecondsOverWhichToAverageSpeed();
                WindWithConfidence startOfInvalidation = TrackBasedEstimationWindTrackImpl.getDummyFixWithConfidence((TimePoint)new MillisecondsTimePoint(fix.getTimePoint().asMillis() - averagingInterval));
                MillisecondsTimePoint endOfInvalidation = new MillisecondsTimePoint(fix.getTimePoint().asMillis() + averagingInterval);
                TrackBasedEstimationWindTrackImpl.this.scheduleCacheRefresh(startOfInvalidation, (TimePoint)endOfInvalidation);
            }
        }

        @Override
        public void statusChanged(TrackedRaceStatus newStatus, TrackedRaceStatus oldStatus) {
            if (oldStatus.getStatus() == TrackedRaceStatusEnum.LOADING) {
                if (newStatus.getStatus() != TrackedRaceStatusEnum.LOADING && newStatus.getStatus() != TrackedRaceStatusEnum.REMOVED) {
                    this.suspended = false;
                }
            } else if (newStatus.getStatus() == TrackedRaceStatusEnum.LOADING) {
                this.suspended = true;
                TrackBasedEstimationWindTrackImpl.this.clearCache();
            }
        }

        @Override
        public void markPassingReceived(Competitor competitor, Map<Waypoint, MarkPassing> oldMarkPassings, Iterable<MarkPassing> markPassings) {
            if (!this.suspended) {
                long averagingInterval = TrackBasedEstimationWindTrackImpl.this.getTrackedRace().getMillisecondsOverWhichToAverageSpeed();
                for (MarkPassing markPassing : markPassings) {
                    MillisecondsTimePoint endOfInvalidation;
                    WindWithConfidence startOfInvalidation;
                    MarkPassing oldMarkPassing = oldMarkPassings.get(markPassing.getWaypoint());
                    if (oldMarkPassing == markPassing) continue;
                    if (oldMarkPassing == null) {
                        startOfInvalidation = TrackBasedEstimationWindTrackImpl.getDummyFixWithConfidence((TimePoint)new MillisecondsTimePoint(markPassing.getTimePoint().asMillis() - averagingInterval));
                        endOfInvalidation = new MillisecondsTimePoint(markPassing.getTimePoint().asMillis() + averagingInterval);
                    } else {
                        Object[] interval = new TimePoint[]{oldMarkPassing.getTimePoint(), markPassing.getTimePoint()};
                        Arrays.sort(interval);
                        startOfInvalidation = TrackBasedEstimationWindTrackImpl.getDummyFixWithConfidence((TimePoint)new MillisecondsTimePoint(interval[0].asMillis() - averagingInterval));
                        endOfInvalidation = new MillisecondsTimePoint(interval[1].asMillis() + averagingInterval);
                    }
                    TrackBasedEstimationWindTrackImpl.this.scheduleCacheRefresh(startOfInvalidation, (TimePoint)endOfInvalidation);
                }
            }
        }

        @Override
        public void markPositionChanged(GPSFix fix, Mark mark, boolean firstInTrack, AddResult addedOrReplaced) {
            assert (fix != null && fix.getTimePoint() != null);
            if (!this.suspended) {
                TimeRange interval = TrackBasedEstimationWindTrackImpl.this.getTrackedRace().getOrCreateTrack(mark).getEstimatedPositionTimePeriodAffectedBy(fix);
                WindWithConfidence startOfInvalidation = TrackBasedEstimationWindTrackImpl.getDummyFixWithConfidence(interval.from());
                TimePoint endOfInvalidation = interval.to();
                TrackBasedEstimationWindTrackImpl.this.scheduleCacheRefresh(startOfInvalidation, endOfInvalidation);
            }
        }

        @Override
        public void competitorSensorFixAdded(Competitor competitor, String trackName, SensorFix fix, AddResult addedOrReplaced) {
        }

        @Override
        public void competitorSensorTrackAdded(DynamicSensorFixTrack<Competitor, ?> track) {
        }
    }

    public class EstimatedWindFixesAsNavigableSet
    extends VirtualWindFixesAsNavigableSet {
        private static final long serialVersionUID = -6902341522276949873L;

        public EstimatedWindFixesAsNavigableSet(TrackedRace trackedRace) {
            this(trackedRace, null, null);
        }

        private EstimatedWindFixesAsNavigableSet(TrackedRace trackedRace, TimePoint from, TimePoint to) {
            super(TrackBasedEstimationWindTrackImpl.this, trackedRace, from, to, RESOLUTION.asMillis());
        }

        @Override
        protected TrackBasedEstimationWindTrackImpl getTrack() {
            return (TrackBasedEstimationWindTrackImpl)super.getTrack();
        }

        @Override
        protected Wind getWind(Position p, TimePoint timePoint) {
            WindWithConfidence<TimePoint> estimatedWindDirectionWithConfidence = this.getWindWithConfidence(timePoint);
            return estimatedWindDirectionWithConfidence == null ? null : (Wind)estimatedWindDirectionWithConfidence.getObject();
        }

        protected WindWithConfidence<TimePoint> getWindWithConfidence(TimePoint timePoint) {
            return this.getTrack().getEstimatedWindDirection(timePoint);
        }

        @Override
        protected NavigableSet<Wind> createSubset(WindTrack track, TrackedRace trackedRace, TimePoint from, TimePoint to) {
            return new EstimatedWindFixesAsNavigableSet(trackedRace, from, to);
        }
    }

    private abstract class EstimationIterator
    implements Iterator<WindWithConfidence<Util.Pair<Position, TimePoint>>> {
        protected TimePoint t;
        private WindWithConfidence<TimePoint> nextEstimatedWindWithTimeBasedConfidence;

        EstimationIterator(TimePoint t) {
            this.t = t;
            this.nextEstimatedWindWithTimeBasedConfidence = this.advance();
        }

        protected abstract WindWithConfidence<TimePoint> advance();

        @Override
        public boolean hasNext() {
            return this.nextEstimatedWindWithTimeBasedConfidence != null;
        }

        protected WindWithConfidence<TimePoint> tryToGetNext() {
            return TrackBasedEstimationWindTrackImpl.this.getEstimatedWindDirection(this.t);
        }

        @Override
        public WindWithConfidence<Util.Pair<Position, TimePoint>> next() {
            if (this.nextEstimatedWindWithTimeBasedConfidence == null) {
                throw new NoSuchElementException();
            }
            WindWithConfidenceImpl<Util.Pair<Position, TimePoint>> result = TrackBasedEstimationWindTrackImpl.this.createWindWithTimeAndPositionBasedConfidence(this.nextEstimatedWindWithTimeBasedConfidence);
            this.nextEstimatedWindWithTimeBasedConfidence = this.advance();
            return result;
        }
    }

    private static class InvalidationInterval
    implements Serializable {
        private static final long serialVersionUID = -6406690520919193690L;
        private WindWithConfidence<TimePoint> start;
        private TimePoint end;

        public WindWithConfidence<TimePoint> getStart() {
            return this.start;
        }

        public TimePoint getEnd() {
            return this.end;
        }

        public void clear() {
            this.start = null;
            this.end = null;
        }

        public boolean isSet() {
            return this.start != null && this.end != null;
        }

        public boolean contains(TimePoint start, TimePoint end) {
            return this.isSet() && !((Wind)this.getStart().getObject()).getTimePoint().after(start) && !end.after(this.getEnd());
        }

        public void set(WindWithConfidence<TimePoint> startOfInvalidation, TimePoint endOfInvalidation) {
            assert (startOfInvalidation != null);
            assert (endOfInvalidation != null);
            this.start = startOfInvalidation;
            this.end = endOfInvalidation;
        }

        public void extend(WindWithConfidence<TimePoint> startOfInvalidation, TimePoint endOfInvalidation) {
            assert (startOfInvalidation != null);
            assert (endOfInvalidation != null);
            if (((Wind)startOfInvalidation.getObject()).getTimePoint().compareTo((Object)((Wind)this.start.getObject()).getTimePoint()) < 0) {
                this.start = startOfInvalidation;
            }
            if (endOfInvalidation.compareTo((Object)this.end) > 0) {
                this.end = endOfInvalidation;
            }
        }

        public InvalidationInterval subtract(WindWithConfidence<TimePoint> start, TimePoint end) {
            assert (start != null);
            assert (end != null);
            InvalidationInterval result = new InvalidationInterval();
            if (!this.isSet()) {
                result.set(start, end);
            } else {
                TimePoint newEnd;
                TimePoint startTimePoint = ((Wind)this.getStart().getObject()).getTimePoint();
                WindWithConfidence newStart = ((Wind)start.getObject()).getTimePoint().before(startTimePoint) ? start : TrackBasedEstimationWindTrackImpl.getDummyFixWithConfidence(this.getEnd().asMillis() == Long.MAX_VALUE ? this.getEnd() : this.getEnd().plus(1L));
                if (end.after(this.getEnd())) {
                    newEnd = end;
                } else {
                    TimePoint timePoint = newEnd = startTimePoint.asMillis() == 0L ? startTimePoint : startTimePoint.minus(1L);
                }
                if (!((Wind)newStart.getObject()).getTimePoint().after(newEnd)) {
                    result.set(newStart, newEnd);
                }
            }
            return result;
        }
    }
}

