/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.tracking.StartTimeChangedListener;
import com.sap.sailing.domain.tracking.impl.UpdateHandler;
import com.sap.sse.common.TimePoint;
import java.io.IOException;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.logging.Logger;
import org.json.simple.parser.ParseException;

public class StartTimeResetHandler
extends UpdateHandler
implements StartTimeChangedListener {
    private static final String ACTION = "resetStartTime";
    private static final Logger logger = Logger.getLogger(StartTimeResetHandler.class.getName());

    public StartTimeResetHandler(URI updateURI, String username, String password, Serializable eventId, Serializable raceId) {
        super(updateURI, ACTION, username, password, eventId, raceId);
    }

    @Override
    public void startTimeChanged(TimePoint newStartTime) throws MalformedURLException, IOException {
        if (!this.isActive() || newStartTime != null) {
            return;
        }
        URL startTimeUpdateURL = this.buildUpdateURL();
        logger.info("Using " + this.eraseSecurityRelatedValuesFromURL(startTimeUpdateURL.toString()) + " for the start reset!");
        HttpURLConnection connection = (HttpURLConnection)startTimeUpdateURL.openConnection();
        try {
            connection = this.setConnectionProperties(connection);
            try {
                this.checkAndLogUpdateResponse(connection);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            } else {
                logger.severe("Connection to TracTrac start time reset URL " + this.eraseSecurityRelatedValuesFromURL(startTimeUpdateURL.toString()) + " could not be established");
            }
        }
    }
}

