/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.tracking.AddResult;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.GPSTrackListener;
import com.sap.sailing.domain.tracking.impl.GPSFixTrackImpl;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.TimeRangeImpl;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import com.sap.sse.shared.util.impl.ArrayListNavigableSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;

public class MaxSpeedCache<ItemType, FixType extends GPSFix>
implements GPSTrackListener<ItemType, FixType> {
    private static final long serialVersionUID = 8825205750854940612L;
    private final GPSFixTrackImpl<ItemType, FixType> track;
    private final Map<TimePoint, NavigableSet<Util.Pair<TimePoint, Util.Pair<FixType, Speed>>>> cache;
    private final NamedReentrantReadWriteLock lock;

    public MaxSpeedCache(GPSFixTrackImpl<ItemType, FixType> track) {
        this.track = track;
        this.cache = new HashMap<TimePoint, NavigableSet<Util.Pair<TimePoint, Util.Pair<FixType, Speed>>>>();
        this.lock = new NamedReentrantReadWriteLock(String.valueOf(MaxSpeedCache.class.getSimpleName()) + " for track of " + track.getTrackedItem(), false);
        track.addListener(this);
    }

    protected NamedReentrantReadWriteLock getLock() {
        return this.lock;
    }

    @Override
    public void gpsFixReceived(FixType fix, ItemType item, boolean firstFixInTrack, AddResult addedOrReplaced) {
        TimeRange invalidationInterval = this.track.getTimeIntervalWhoseEstimatedSpeedMayHaveChangedAfterAddingFix(fix);
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        HashMap<TimePoint, NavigableSet<Util.Pair<TimePoint, Util.Pair<FixType, Speed>>>> additionalCacheEntries = new HashMap<TimePoint, NavigableSet<Util.Pair<TimePoint, Util.Pair<FixType, Speed>>>>();
        try {
            Iterator<Map.Entry<TimePoint, NavigableSet<Util.Pair<TimePoint, Util.Pair<FixType, Speed>>>>> i = this.cache.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<TimePoint, NavigableSet<Util.Pair<TimePoint, Util.Pair<FixType, Speed>>>> next = i.next();
                additionalCacheEntries.putAll(this.invalidateEntriesAndReturnAdditionalCacheEntries(next, invalidationInterval));
                if (!next.getValue().isEmpty()) continue;
                i.remove();
            }
            this.mergeAdditionalCacheEntries(additionalCacheEntries);
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
    }

    @Override
    public boolean isTransient() {
        return true;
    }

    private void mergeAdditionalCacheEntries(Map<TimePoint, NavigableSet<Util.Pair<TimePoint, Util.Pair<FixType, Speed>>>> additionalCacheEntries) {
        assert (this.lock.writeLock().isHeldByCurrentThread());
        for (Map.Entry<TimePoint, NavigableSet<Util.Pair<TimePoint, Util.Pair<FixType, Speed>>>> additionalCacheEntry : additionalCacheEntries.entrySet()) {
            NavigableSet<Util.Pair<TimePoint, Util.Pair<FixType, Speed>>> existingEntry = this.cache.get(additionalCacheEntry.getKey());
            if (existingEntry == null) {
                this.cache.put(additionalCacheEntry.getKey(), additionalCacheEntry.getValue());
                continue;
            }
            existingEntry.addAll((Collection)additionalCacheEntry.getValue());
        }
    }

    private Map<TimePoint, NavigableSet<Util.Pair<TimePoint, Util.Pair<FixType, Speed>>>> invalidateEntriesAndReturnAdditionalCacheEntries(Map.Entry<TimePoint, NavigableSet<Util.Pair<TimePoint, Util.Pair<FixType, Speed>>>> cacheEntry, TimeRange invalidationInterval) {
        assert (this.lock.writeLock().isHeldByCurrentThread());
        HashMap<TimePoint, NavigableSet<Util.Pair<TimePoint, Util.Pair<FixType, Speed>>>> result = new HashMap<TimePoint, NavigableSet<Util.Pair<TimePoint, Util.Pair<FixType, Speed>>>>();
        TimePoint cacheEntryFrom = cacheEntry.getKey();
        if (!cacheEntryFrom.after(invalidationInterval.to())) {
            Iterator<Util.Pair> toAndResultIter = cacheEntry.getValue().tailSet(new Util.Pair((Object)invalidationInterval.from(), null), true).iterator();
            while (toAndResultIter.hasNext()) {
                TimeRangeImpl croppedCacheEntryTimeRangeContainingMaxFix;
                TimePoint maxFixTimePoint;
                Util.Pair toAndResult = toAndResultIter.next();
                toAndResultIter.remove();
                if (toAndResult.getB() == null || invalidationInterval.includes(maxFixTimePoint = ((GPSFix)((Util.Pair)toAndResult.getB()).getA()).getTimePoint())) continue;
                TimePoint cacheEntryTo = (TimePoint)toAndResult.getA();
                if (invalidationInterval.startsAtOrAfter(maxFixTimePoint)) {
                    croppedCacheEntryTimeRangeContainingMaxFix = new TimeRangeImpl(cacheEntryFrom, invalidationInterval.from());
                } else {
                    assert (invalidationInterval.endsBefore(maxFixTimePoint));
                    croppedCacheEntryTimeRangeContainingMaxFix = new TimeRangeImpl(invalidationInterval.to(), cacheEntryTo);
                }
                this.addEntryToMap(croppedCacheEntryTimeRangeContainingMaxFix.from(), croppedCacheEntryTimeRangeContainingMaxFix.to(), (Util.Pair)toAndResult.getB(), result);
            }
        }
        return result;
    }

    @Override
    public void speedAveragingChanged(long oldMillisecondsOverWhichToAverage, long newMillisecondsOverWhichToAverage) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            this.cache.clear();
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
    }

    public Util.Pair<FixType, Speed> getMaxSpeed(TimePoint from, TimePoint to) {
        Util.Pair<FixType, Speed> result = null;
        if (!to.before(from) && (result = this.cacheLookup(from, to)) == null) {
            LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
            try {
                result = this.computeMaxSpeed(from, to);
                this.cache(from, to, result);
            }
            finally {
                LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
            }
        }
        return result;
    }

    private Util.Pair<FixType, Speed> cacheLookup(TimePoint from, TimePoint to) {
        TimePoint entryTo;
        assert (!from.after(to));
        Object result = null;
        Util.Pair entryForLongestSubseries = null;
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        try {
            NavigableSet<Util.Pair<TimePoint, Util.Pair<FixType, Speed>>> entry = this.cache.get(from);
            if (entry != null) {
                entryForLongestSubseries = entry.floor(new Util.Pair((Object)to, null));
            }
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }
        if (entryForLongestSubseries != null && entryForLongestSubseries.getB() != null && ((entryTo = (TimePoint)entryForLongestSubseries.getA()).equals(to) || entryTo.after(from))) {
            if (entryTo.before(to)) {
                Util.Pair<FixType, Speed> maxInMissingTail = this.getMaxSpeed(entryTo, to);
                result = maxInMissingTail != null && ((Speed)maxInMissingTail.getB()).compareTo((Object)((Speed)((Util.Pair)entryForLongestSubseries.getB()).getB())) > 0 ? maxInMissingTail : (Util.Pair)entryForLongestSubseries.getB();
                this.cache(from, to, (Util.Pair<FixType, Speed>)result);
            } else {
                result = (Util.Pair<FixType, Speed>)entryForLongestSubseries.getB();
            }
        }
        return result;
    }

    protected void cache(TimePoint from, TimePoint to, Util.Pair<FixType, Speed> fixAtMaxSpeed) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            this.addEntryToMap(from, to, fixAtMaxSpeed, this.cache);
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
    }

    private void addEntryToMap(TimePoint from, TimePoint to, Util.Pair<FixType, Speed> fixAtMaxSpeed, Map<TimePoint, NavigableSet<Util.Pair<TimePoint, Util.Pair<FixType, Speed>>>> map) {
        ArrayListNavigableSet setForFrom = map.get(from);
        if (setForFrom == null) {
            setForFrom = new ArrayListNavigableSet(new Comparator<Util.Pair<TimePoint, Util.Pair<FixType, Speed>>>(){

                @Override
                public int compare(Util.Pair<TimePoint, Util.Pair<FixType, Speed>> o1, Util.Pair<TimePoint, Util.Pair<FixType, Speed>> o2) {
                    return ((TimePoint)o1.getA()).compareTo((Object)((TimePoint)o2.getA()));
                }
            });
            map.put(from, (NavigableSet<Util.Pair<TimePoint, Util.Pair<FixType, Speed>>>)setForFrom);
        }
        setForFrom.add(new Util.Pair((Object)to, fixAtMaxSpeed));
    }

    protected Util.Pair<FixType, Speed> computeMaxSpeed(TimePoint from, TimePoint to) {
        this.track.lockForRead();
        try {
            Iterator iter = this.track.getFixesIterator(from, true);
            Speed max = Speed.NULL;
            GPSFix maxSpeedFix = null;
            if (iter.hasNext()) {
                while (iter.hasNext()) {
                    GPSFix fix = (GPSFix)iter.next();
                    if (fix.getTimePoint().after(to)) break;
                    SpeedWithBearing speedAtFixTime = null;
                    speedAtFixTime = fix instanceof GPSFixMoving ? ((GPSFixMoving)fix).getSpeed() : this.track.getEstimatedSpeed(fix.getTimePoint());
                    if (speedAtFixTime == null || speedAtFixTime.compareTo((Object)GPSFixTrack.DEFAULT_MAX_SPEED_FOR_SMOOTHING) >= 0 || speedAtFixTime.compareTo((Object)max) <= 0) continue;
                    max = speedAtFixTime;
                    maxSpeedFix = fix;
                }
            }
            Util.Pair pair = maxSpeedFix == null ? null : new Util.Pair(maxSpeedFix, (Object)max);
            return pair;
        }
        finally {
            this.track.unlockAfterRead();
        }
    }
}

