/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.abstractlog.race.CompetitorResult;
import com.sap.sailing.domain.abstractlog.race.CompetitorResults;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.AbstractFinishPositioningListFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.ConfirmedFinishPositioningListFinder;
import com.sap.sailing.domain.abstractlog.race.state.RaceStateChangedListener;
import com.sap.sailing.domain.abstractlog.race.state.ReadonlyRaceState;
import com.sap.sailing.domain.abstractlog.race.state.impl.BaseRaceStateChangedListener;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CourseBase;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Sideline;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.TrackedRaceStatusEnum;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.impl.WindSourceImpl;
import com.sap.sailing.domain.common.racelog.Flags;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.common.tracking.SensorFix;
import com.sap.sailing.domain.markpassingcalculation.MarkPassingCalculator;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprintRegistry;
import com.sap.sailing.domain.racelog.RaceLogAndTrackedRaceResolver;
import com.sap.sailing.domain.ranking.RankingMetricConstructor;
import com.sap.sailing.domain.tracking.AddResult;
import com.sap.sailing.domain.tracking.CourseDesignChangedListener;
import com.sap.sailing.domain.tracking.DynamicGPSFixTrack;
import com.sap.sailing.domain.tracking.DynamicSensorFixTrack;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.GPSTrackListener;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.RaceAbortedListener;
import com.sap.sailing.domain.tracking.RaceChangeListener;
import com.sap.sailing.domain.tracking.SensorFixTrackListener;
import com.sap.sailing.domain.tracking.StartTimeChangedListener;
import com.sap.sailing.domain.tracking.TrackFactory;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedRaceStatus;
import com.sap.sailing.domain.tracking.TrackedRegatta;
import com.sap.sailing.domain.tracking.TrackingConnectorInfo;
import com.sap.sailing.domain.tracking.TrackingDataLoader;
import com.sap.sailing.domain.tracking.WindStore;
import com.sap.sailing.domain.tracking.WindTrack;
import com.sap.sailing.domain.tracking.impl.DynamicGPSFixTrackImpl;
import com.sap.sailing.domain.tracking.impl.DynamicTrackedRaceLogListener;
import com.sap.sailing.domain.tracking.impl.MarkPassingImpl;
import com.sap.sailing.domain.tracking.impl.TrackedLegImpl;
import com.sap.sailing.domain.tracking.impl.TrackedRaceImpl;
import com.sap.sailing.domain.tracking.impl.TrackedRaceStatusImpl;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Timed;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DynamicTrackedRaceImpl
extends TrackedRaceImpl
implements DynamicTrackedRace,
GPSTrackListener<Competitor, GPSFixMoving> {
    private static final long serialVersionUID = 1092726918239676958L;
    private static final Logger logger = Logger.getLogger(DynamicTrackedRaceImpl.class.getName());
    private transient Set<RaceChangeListener> listeners;
    private boolean raceIsKnownToStartUpwind;
    private boolean delayToLiveInMillisFixed;
    private transient DynamicTrackedRaceLogListener logListener;
    private transient Set<CourseDesignChangedListener> courseDesignChangedListeners;
    private transient Set<StartTimeChangedListener> startTimeChangedListeners;
    private transient Set<RaceAbortedListener> raceAbortedListeners;
    private transient Map<TrackingDataLoader, TrackedRaceStatus> loaderStatus = new HashMap<TrackingDataLoader, TrackedRaceStatus>();
    private Map<Competitor, CompetitorResult> competitorResultsFromRaceLog;
    private transient RaceStateChangedListener raceStateBasedStartTimeChangedListener = this.createRaceStateStartTimeChangeListener();
    private final AtomicBoolean gpsFixReceived;

    public DynamicTrackedRaceImpl(TrackedRegatta trackedRegatta, RaceDefinition race, Iterable<Sideline> sidelines, WindStore windStore, long delayToLiveInMillis, long millisecondsOverWhichToAverageWind, long millisecondsOverWhichToAverageSpeed, long delayForCacheInvalidationOfWindEstimation, boolean useInternalMarkPassingAlgorithm, RankingMetricConstructor rankingMetricConstructor, RaceLogAndTrackedRaceResolver raceLogResolver, TrackingConnectorInfo trackingConnectorInfo, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry) {
        super(trackedRegatta, race, sidelines, windStore, delayToLiveInMillis, millisecondsOverWhichToAverageWind, millisecondsOverWhichToAverageSpeed, delayForCacheInvalidationOfWindEstimation, useInternalMarkPassingAlgorithm, rankingMetricConstructor, raceLogResolver, trackingConnectorInfo, markPassingRaceFingerprintRegistry);
        this.competitorResultsFromRaceLog = new HashMap<Competitor, CompetitorResult>();
        this.logListener = new DynamicTrackedRaceLogListener(this);
        if (this.markPassingCalculator != null) {
            this.logListener.setMarkPassingUpdateListener(this.markPassingCalculator.getListener());
        }
        this.courseDesignChangedListeners = new HashSet<CourseDesignChangedListener>();
        this.startTimeChangedListeners = new HashSet<StartTimeChangedListener>();
        this.raceAbortedListeners = new HashSet<RaceAbortedListener>();
        this.gpsFixReceived = new AtomicBoolean(false);
        this.raceIsKnownToStartUpwind = race.getBoatClass().typicallyStartsUpwind();
        if (!this.raceIsKnownToStartUpwind) {
            this.setWindSourcesToExclude(this.getWindSourcesToExclude());
        }
        for (Competitor competitor : this.getRace().getCompetitors()) {
            GPSFixTrack track = this.getTrack(competitor);
            track.addListener(this);
        }
    }

    @Override
    public boolean hasGPSData() {
        return this.gpsFixReceived.get();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.raceStateBasedStartTimeChangedListener = this.createRaceStateStartTimeChangeListener();
        for (RaceLog raceLog : this.attachedRaceLogs.values()) {
            this.getRaceState(raceLog).addChangedListener(this.raceStateBasedStartTimeChangedListener);
        }
        this.listeners = this.getListeners();
        this.logListener = new DynamicTrackedRaceLogListener(this);
        this.courseDesignChangedListeners = new HashSet<CourseDesignChangedListener>();
        this.startTimeChangedListeners = new HashSet<StartTimeChangedListener>();
        this.raceAbortedListeners = new HashSet<RaceAbortedListener>();
    }

    protected Object readResolve() {
        if (this.markPassingCalculator != null) {
            this.logListener.setMarkPassingUpdateListener(this.markPassingCalculator.getListener());
        }
        return this;
    }

    private RaceStateChangedListener createRaceStateStartTimeChangeListener() {
        return new BaseRaceStateChangedListener(){

            public void onStartTimeChanged(ReadonlyRaceState state) {
                TimePoint oldStartTime = DynamicTrackedRaceImpl.this.getStartOfRace();
                DynamicTrackedRaceImpl.this.invalidateStartTime();
                TimePoint startTimeFromRaceLog = state.getStartTime();
                if (!Util.equalsWithNull((Object)oldStartTime, (Object)startTimeFromRaceLog)) {
                    DynamicTrackedRaceImpl.this.onStartTimeChangedByRaceCommittee(startTimeFromRaceLog);
                }
            }
        };
    }

    public DynamicTrackedRaceImpl(TrackedRegatta trackedRegatta, RaceDefinition race, Iterable<Sideline> sidelines, WindStore windStore, long delayToLiveInMillis, long millisecondsOverWhichToAverageWind, long millisecondsOverWhichToAverageSpeed, boolean useInternalMarkPassingAlgorithm, RankingMetricConstructor rankingMetricConstructor, RaceLogAndTrackedRaceResolver raceLogResolver, TrackingConnectorInfo trackingConnectorInfo, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry) {
        this(trackedRegatta, race, sidelines, windStore, delayToLiveInMillis, millisecondsOverWhichToAverageWind, millisecondsOverWhichToAverageSpeed, millisecondsOverWhichToAverageWind / 2L, useInternalMarkPassingAlgorithm, rankingMetricConstructor, raceLogResolver, trackingConnectorInfo, markPassingRaceFingerprintRegistry);
    }

    @Override
    public boolean recordFix(Competitor competitor, GPSFixMoving fix, boolean onlyWhenInTrackingTimesInterval) {
        boolean result;
        if (!onlyWhenInTrackingTimesInterval || this.isWithinStartAndEndOfTracking(fix.getTimePoint())) {
            GPSFixTrack track = this.getTrack(competitor);
            if (track != null) {
                if (logger != null && logger.getLevel() != null && logger.getLevel().equals(Level.FINEST)) {
                    logger.finest(competitor.getName() + ": " + fix);
                }
                result = track.addGPSFix(fix);
            } else {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public void setStatus(TrackedRaceStatus newStatus) {
        TrackedRaceStatus oldStatus = this.getStatus();
        super.setStatus(newStatus);
        this.notifyListeners(newStatus, oldStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStatusChanged(TrackingDataLoader source, TrackedRaceStatus newStatus) {
        TrackedRaceStatusEnum raceStatus;
        double totalProgress = 1.0;
        if (newStatus.getStatus() == TrackedRaceStatusEnum.REMOVED) {
            Map<TrackingDataLoader, TrackedRaceStatus> map = this.loaderStatus;
            synchronized (map) {
                this.updateLoaderStatus(source, newStatus);
            }
            raceStatus = newStatus.getStatus();
        } else {
            raceStatus = TrackedRaceStatusEnum.FINISHED;
            Map<TrackingDataLoader, TrackedRaceStatus> map = this.loaderStatus;
            synchronized (map) {
                this.updateLoaderStatus(source, newStatus);
                if (!this.loaderStatus.isEmpty()) {
                    double sumOfLoaderProgresses = 0.0;
                    boolean anyError = false;
                    boolean anyLoading = false;
                    boolean allPrepared = true;
                    raceStatus = TrackedRaceStatusEnum.TRACKING;
                    for (TrackedRaceStatus status : this.loaderStatus.values()) {
                        anyError |= status.getStatus() == TrackedRaceStatusEnum.ERROR;
                        anyLoading |= status.getStatus() == TrackedRaceStatusEnum.LOADING;
                        allPrepared &= status.getStatus() == TrackedRaceStatusEnum.PREPARED;
                        sumOfLoaderProgresses += status.getLoadingProgress();
                    }
                    if (anyError) {
                        raceStatus = TrackedRaceStatusEnum.ERROR;
                    } else if (anyLoading) {
                        raceStatus = TrackedRaceStatusEnum.LOADING;
                        totalProgress = sumOfLoaderProgresses / (double)this.loaderStatus.size();
                    } else {
                        raceStatus = allPrepared ? TrackedRaceStatusEnum.PREPARED : TrackedRaceStatusEnum.TRACKING;
                    }
                }
            }
        }
        this.setStatus(new TrackedRaceStatusImpl(raceStatus, totalProgress));
    }

    private void updateLoaderStatus(TrackingDataLoader loader, TrackedRaceStatus status) {
        if (status.getStatus() == TrackedRaceStatusEnum.FINISHED || status.getStatus() == TrackedRaceStatusEnum.REMOVED) {
            this.loaderStatus.remove(loader);
        } else {
            this.loaderStatus.put(loader, status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void waitForLoadingToFinish() throws InterruptedException {
        Object object = this.getStatusNotifier();
        synchronized (object) {
            while (true) {
                if (this.getStatus().getStatus() != TrackedRaceStatusEnum.PREPARED && this.getStatus().getStatus() != TrackedRaceStatusEnum.LOADING) {
                    return;
                }
                try {
                    this.getStatusNotifier().wait();
                }
                catch (InterruptedException e) {
                    logger.info("waitUntilNotLoading on tracked race " + this + " interrupted: " + e.getMessage() + ". Continuing to wait.");
                }
            }
        }
    }

    @Override
    public void recordFix(Mark mark, GPSFix fix, boolean onlyWhenInTrackingTimeInterval) {
        TimePoint fixTimePoint = fix.getTimePoint();
        if (!onlyWhenInTrackingTimeInterval || this.isWithinStartAndEndOfTracking(fixTimePoint)) {
            this.getOrCreateTrack(mark).addGPSFix(fix);
        } else {
            logger.finer(() -> "Dropped fix " + fix + " because it is outside the tracking interval " + this.getStartOfTracking() + ".." + this.getEndOfTracking());
        }
    }

    @Override
    public boolean isWithinStartAndEndOfTracking(TimePoint fixTimePoint) {
        return this.getStartOfTracking() != null && this.getStartOfTracking().compareTo((Object)fixTimePoint) <= 0 && (this.getEndOfTracking() == null || this.getEndOfTracking().compareTo((Object)fixTimePoint) >= 0);
    }

    @Override
    public void setMillisecondsOverWhichToAverageSpeed(long millisecondsOverWhichToAverageSpeed) {
        this.millisecondsOverWhichToAverageSpeed = millisecondsOverWhichToAverageSpeed;
        for (Competitor competitor : this.getRace().getCompetitors()) {
            this.getTrack(competitor).setMillisecondsOverWhichToAverage(millisecondsOverWhichToAverageSpeed);
        }
        for (Waypoint waypoint : this.getRace().getCourse().getWaypoints()) {
            for (Mark mark : waypoint.getMarks()) {
                this.getOrCreateTrack(mark).setMillisecondsOverWhichToAverage(millisecondsOverWhichToAverageSpeed);
            }
        }
        this.updated(null);
        this.triggerManeuverCacheRecalculationForAllCompetitors();
    }

    @Override
    public void setMillisecondsOverWhichToAverageWind(long millisecondsOverWhichToAverageWind) {
        long oldMillisecondsOverWhichToAverageWind = this.millisecondsOverWhichToAverageWind;
        this.millisecondsOverWhichToAverageWind = millisecondsOverWhichToAverageWind;
        for (WindSource windSource : this.getWindSources()) {
            this.getOrCreateWindTrack(windSource).setMillisecondsOverWhichToAverage(millisecondsOverWhichToAverageWind);
        }
        this.updated(null);
        this.triggerManeuverCacheRecalculationForAllCompetitors();
        this.notifyListenersWindAveragingChanged(oldMillisecondsOverWhichToAverageWind, millisecondsOverWhichToAverageWind);
    }

    @Override
    public void setAndFixDelayToLiveInMillis(long delayToLiveInMillis) {
        if (this.getDelayToLiveInMillis() != delayToLiveInMillis) {
            super.setDelayToLiveInMillis(delayToLiveInMillis);
            this.notifyListenersDelayToLiveChanged(delayToLiveInMillis);
        }
        this.delayToLiveInMillisFixed = true;
    }

    @Override
    public void setDelayToLiveInMillis(long delayToLiveInMillis) {
        if (!this.delayToLiveInMillisFixed) {
            if (this.getDelayToLiveInMillis() != delayToLiveInMillis) {
                super.setDelayToLiveInMillis(delayToLiveInMillis);
                this.notifyListenersDelayToLiveChanged(delayToLiveInMillis);
            }
        } else {
            logger.info("Not setting live delay for race " + this.getRace().getName() + " to " + delayToLiveInMillis + "ms because delay has been fixed");
        }
    }

    @Override
    public DynamicGPSFixTrack<Competitor, GPSFixMoving> getTrack(Competitor competitor) {
        return (DynamicGPSFixTrack)super.getTrack(competitor);
    }

    @Override
    public DynamicGPSFixTrack<Mark, GPSFix> getOrCreateTrack(Mark mark) {
        return (DynamicGPSFixTrack)super.getOrCreateTrack(mark);
    }

    @Override
    protected DynamicGPSFixTrackImpl<Mark> createMarkTrack(Mark mark) {
        final DynamicGPSFixTrackImpl<Mark> result = super.createMarkTrack(mark);
        result.addListener(new GPSTrackListener<Mark, GPSFix>(){
            private static final long serialVersionUID = -2855787105725103732L;

            @Override
            public void gpsFixReceived(GPSFix fix, Mark mark, boolean firstFixInTrack, AddResult addedOrReplaced) {
                TimePoint fixTimePoint = fix.getTimePoint();
                DynamicTrackedRaceImpl.this.updated(fixTimePoint);
                GPSFix lastFixBefore = (GPSFix)result.getLastFixBefore(fixTimePoint);
                GPSFix firstFixAfter = (GPSFix)result.getFirstFixAfter(fixTimePoint);
                DynamicTrackedRaceImpl.this.invalidateDistancesFromStarboardSideOfStartLineProjectedOntoLineCache(TimeRange.create((TimePoint)(lastFixBefore == null ? null : lastFixBefore.getTimePoint()), (TimePoint)(firstFixAfter == null ? null : firstFixAfter.getTimePoint())));
                DynamicTrackedRaceImpl.this.triggerManeuverCacheRecalculationForAllCompetitors();
                DynamicTrackedRaceImpl.this.notifyListeners(fix, mark, firstFixInTrack, addedOrReplaced);
            }

            @Override
            public void speedAveragingChanged(long oldMillisecondsOverWhichToAverage, long newMillisecondsOverWhichToAverage) {
            }

            @Override
            public boolean isTransient() {
                return false;
            }
        });
        return result;
    }

    @Override
    protected Set<RaceChangeListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new HashSet<RaceChangeListener>();
        }
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(RaceChangeListener listener) {
        Set<RaceChangeListener> set = this.getListeners();
        synchronized (set) {
            this.getListeners().add(listener);
        }
    }

    @Override
    public void invalidateStartTime() {
        TimePoint oldStartOfRace = this.getStartOfRace();
        super.invalidateStartTime();
        if (!Util.equalsWithNull((Object)oldStartOfRace, (Object)this.getStartOfRace())) {
            this.notifyListenersStartOfRaceChanged(oldStartOfRace, this.getStartOfRace());
        }
    }

    @Override
    public void addListener(RaceChangeListener listener, boolean notifyAboutWindFixesAlreadyLoaded, boolean notifyAboutGPSFixesAlreadyLoaded) {
        if (notifyAboutWindFixesAlreadyLoaded) {
            LockUtil.lockForRead((NamedReentrantReadWriteLock)this.getLoadingFromWindStoreLock());
        }
        if (notifyAboutGPSFixesAlreadyLoaded) {
            LockUtil.lockForRead((NamedReentrantReadWriteLock)this.getLoadingFromGPSFixStoreLock());
        }
        try {
            this.addListener(listener);
            if (notifyAboutWindFixesAlreadyLoaded) {
                for (WindSource windSource : this.getWindSources()) {
                    if (!windSource.getType().canBeStored()) continue;
                    WindTrack windTrack = this.getOrCreateWindTrack(windSource);
                    windTrack.lockForRead();
                    try {
                        for (Wind wind : windTrack.getRawFixes()) {
                            listener.windDataReceived(wind, windSource);
                        }
                    }
                    finally {
                        windTrack.unlockAfterRead();
                    }
                }
            }
            if (notifyAboutGPSFixesAlreadyLoaded) {
                for (Mark mark : this.getMarks()) {
                    GPSFixTrack markTrack = this.getOrCreateTrack(mark);
                    markTrack.lockForRead();
                    try {
                        boolean firstInTrack = true;
                        for (GPSFix fix : markTrack.getRawFixes()) {
                            listener.markPositionChanged(fix, mark, firstInTrack, AddResult.ADDED);
                            firstInTrack = false;
                        }
                    }
                    finally {
                        markTrack.unlockAfterRead();
                    }
                }
                for (Competitor competitor : this.getRace().getCompetitors()) {
                    GPSFixTrack competitorTrack = this.getTrack(competitor);
                    competitorTrack.lockForRead();
                    try {
                        for (GPSFixMoving fix : competitorTrack.getRawFixes()) {
                            listener.competitorPositionChanged(fix, competitor, AddResult.ADDED);
                        }
                    }
                    finally {
                        competitorTrack.unlockAfterRead();
                    }
                }
            }
        }
        finally {
            if (notifyAboutWindFixesAlreadyLoaded) {
                LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.getLoadingFromWindStoreLock());
            }
            if (notifyAboutGPSFixesAlreadyLoaded) {
                LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.getLoadingFromGPSFixStoreLock());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(RaceChangeListener listener) {
        Set<RaceChangeListener> set = this.getListeners();
        synchronized (set) {
            this.getListeners().remove(listener);
        }
    }

    @Override
    public void setWindSourcesToExclude(Iterable<? extends WindSource> windSourcesToExclude) {
        HashSet<WindSourceImpl> effectiveWindSourcesToExclude = new HashSet<WindSourceImpl>();
        Util.addAll(windSourcesToExclude, effectiveWindSourcesToExclude);
        if (!this.raceIsKnownToStartUpwind) {
            effectiveWindSourcesToExclude.add(new WindSourceImpl(WindSourceType.COURSE_BASED));
        }
        super.setWindSourcesToExclude(effectiveWindSourcesToExclude);
        this.notifyListenersWindSourcesToExcludeChanged(effectiveWindSourcesToExclude);
    }

    @Override
    public void setFinishingTime(TimePoint newFinishingTime) {
        TimePoint oldFinishingTime = this.getFinishingTime();
        if (!Util.equalsWithNull((Object)newFinishingTime, (Object)oldFinishingTime)) {
            logger.info("Finishing time of race " + this.getRace().getName() + " updated from " + this.getFinishingTime() + " to " + newFinishingTime);
            super.setFinishingTime(newFinishingTime);
            this.notifyListenersFinishingTimeChanged(oldFinishingTime, newFinishingTime);
        }
    }

    @Override
    public void setFinishedTime(TimePoint newFinishedTime) {
        TimePoint oldFinishedTime = this.getFinishedTime();
        if (!Util.equalsWithNull((Object)newFinishedTime, (Object)oldFinishedTime)) {
            logger.info("Finished time of race " + this.getRace().getName() + " updated from " + this.getFinishedTime() + " to " + newFinishedTime);
            super.setFinishedTime(newFinishedTime);
            this.updateStartAndEndOfTracking(false);
            this.notifyListenersFinishedTimeChanged(oldFinishedTime, newFinishedTime);
        }
    }

    private void notifyListenersWindSourcesToExcludeChanged(Iterable<? extends WindSource> windSourcesToExclude) {
        this.notifyListeners(listener -> listener.windSourcesToExcludeChanged(windSourcesToExclude));
    }

    private void notifyListenersStartOfTrackingChanged(TimePoint oldStartOfTracking, TimePoint newStartOfTracking) {
        this.notifyListeners(listener -> listener.startOfTrackingChanged(oldStartOfTracking, newStartOfTracking));
    }

    private void notifyListenersEndOfTrackingChanged(TimePoint oldEndOfTracking, TimePoint newEndOfTracking) {
        this.notifyListeners(listener -> listener.endOfTrackingChanged(oldEndOfTracking, newEndOfTracking));
    }

    private void notifyListenersStartTimeReceivedChanged(TimePoint startTimeReceived) {
        this.notifyListeners(listener -> listener.startTimeReceivedChanged(startTimeReceived));
    }

    private void notifyListenersStartOfRaceChanged(TimePoint oldStartOfRace, TimePoint newStartOfRace) {
        this.notifyListeners(listener -> listener.startOfRaceChanged(oldStartOfRace, newStartOfRace));
    }

    private void notifyListenersFinishingTimeChanged(TimePoint oldFinishingTime, TimePoint newFinishingTime) {
        this.notifyListeners(listener -> listener.finishingTimeChanged(oldFinishingTime, newFinishingTime));
    }

    private void notifyListenersFinishedTimeChanged(TimePoint oldFinishedTime, TimePoint newFinishedTime) {
        this.notifyListeners(listener -> listener.finishedTimeChanged(oldFinishedTime, newFinishedTime));
    }

    private void notifyListenersWaypointAdded(int zeroBasedIndex, Waypoint waypointThatGotAdded) {
        this.notifyListeners(listener -> listener.waypointAdded(zeroBasedIndex, waypointThatGotAdded));
    }

    private void notifyListenersWaypointRemoved(int zeroBasedIndex, Waypoint waypointThatGotRemoved) {
        this.notifyListeners(listener -> listener.waypointRemoved(zeroBasedIndex, waypointThatGotRemoved));
    }

    @Override
    public void waypointAdded(int zeroBasedIndex, Waypoint waypointThatGotAdded) {
        super.waypointAdded(zeroBasedIndex, waypointThatGotAdded);
        if (zeroBasedIndex == this.getRace().getCourse().getNumberOfWaypoints() - 1) {
            this.updateFinishingTimesFromRaceLog();
        }
        this.notifyListenersWaypointAdded(zeroBasedIndex, waypointThatGotAdded);
    }

    @Override
    public void waypointRemoved(int zeroBasedIndex, Waypoint waypointThatGotRemoved) {
        super.waypointRemoved(zeroBasedIndex, waypointThatGotRemoved);
        if (zeroBasedIndex == this.getRace().getCourse().getNumberOfWaypoints()) {
            this.updateFinishingTimesFromRaceLog();
        }
        this.notifyListenersWaypointRemoved(zeroBasedIndex, waypointThatGotRemoved);
    }

    private void notifyListeners(GPSFix fix, Mark mark, boolean firstInTrack, AddResult addedOrReplaced) {
        this.notifyListeners(listener -> listener.markPositionChanged(fix, mark, firstInTrack, addedOrReplaced));
    }

    private void notifyListeners(GPSFixMoving fix, Competitor competitor, AddResult addedOrReplaced) {
        this.notifyListeners(listener -> listener.competitorPositionChanged(fix, competitor, addedOrReplaced));
    }

    private void notifyListenersAboutFirstGPSFixReceived() {
        this.notifyListeners(RaceChangeListener::firstGPSFixReceived);
    }

    private void notifyListeners(TrackedRaceStatus status, TrackedRaceStatus oldStatus) {
        this.notifyListeners(listener -> listener.statusChanged(status, oldStatus));
    }

    private void notifyListeners(Wind wind, WindSource windSource) {
        this.notifyListeners(listener -> listener.windDataReceived(wind, windSource));
    }

    private void notifyListenersSpeedAveragingChanged(long oldMillisecondsOverWhichToAverageSpeed, long newMillisecondsOverWhichToAverageSpeed) {
        this.notifyListeners(listener -> listener.speedAveragingChanged(oldMillisecondsOverWhichToAverageSpeed, newMillisecondsOverWhichToAverageSpeed));
    }

    private void notifyListenersWindAveragingChanged(long oldMillisecondsOverWhichToAverageWind, long newMillisecondsOverWhichToAverageWind) {
        this.notifyListeners(listener -> listener.windAveragingChanged(oldMillisecondsOverWhichToAverageWind, newMillisecondsOverWhichToAverageWind));
    }

    private void notifyListenersDelayToLiveChanged(long delayToLiveInMillis) {
        this.notifyListeners(listener -> listener.delayToLiveChanged(delayToLiveInMillis));
    }

    private void notifyListenersWindRemoved(Wind wind, WindSource windSource) {
        this.notifyListeners(listener -> listener.windDataRemoved(wind, windSource));
    }

    private void notifyListeners(Competitor competitor, Map<Waypoint, MarkPassing> oldMarkPassings, Iterable<MarkPassing> markPassings) {
        this.notifyListeners(listener -> listener.markPassingReceived(competitor, oldMarkPassings, markPassings));
    }

    private void notifyListenersAboutSensorTrackAdded(DynamicSensorFixTrack<Competitor, ?> track) {
        this.notifyListeners(listener -> listener.competitorSensorTrackAdded(track));
    }

    private void notifyListeners(Competitor competitor, String trackName, SensorFix fix, AddResult addedOrReplaced) {
        this.notifyListeners(listener -> listener.competitorSensorFixAdded(competitor, trackName, fix, addedOrReplaced));
    }

    @Override
    public void updateMarkPassings(Competitor competitor, Iterable<MarkPassing> markPassings) {
        CompetitorResult resultFromRaceLog = this.competitorResultsFromRaceLog.get(competitor);
        Iterable<MarkPassing> markPassingsToUse = this.createOrUpdateFinishMarkPassingIfRequired(competitor, markPassings, resultFromRaceLog);
        this.updateMarkPassingsNotConsideringFinishingTimesFromRaceLog(competitor, markPassingsToUse);
    }

    @Override
    public void updateMarkPassingsAfterRaceLogChanges() {
        this.competitorResultsFromRaceLog = this.getResultsFromRaceLogs();
        this.updateFinishingTimesFromRaceLog();
    }

    private Iterable<MarkPassing> createOrUpdateFinishMarkPassingIfRequired(Competitor competitor, Iterable<MarkPassing> markPassings, CompetitorResult competitorResult) {
        assert (competitorResult == null || competitorResult.getCompetitorId().equals(competitor.getId()));
        Waypoint finish = this.getRace().getCourse().getLastWaypoint();
        ArrayList<MarkPassing> copyOfMarkPassings = new ArrayList<MarkPassing>();
        boolean neededToCreateOrUpdateFinishMarkPassing = false;
        boolean foundFinishMarkPassing = false;
        for (MarkPassing originalMarkPassing : markPassings) {
            MarkPassing finishMarkPassingToUse;
            MarkPassing originalsOriginal = originalMarkPassing.getOriginal();
            if (originalMarkPassing.getWaypoint() != finish) {
                if (originalsOriginal == null) continue;
                copyOfMarkPassings.add(originalsOriginal);
                continue;
            }
            foundFinishMarkPassing = true;
            if (competitorResult != null && competitorResult.getFinishingTime() != null) {
                if (originalsOriginal == originalMarkPassing || !originalMarkPassing.getTimePoint().equals(competitorResult.getFinishingTime())) {
                    finishMarkPassingToUse = new MarkPassingFromRaceLogProvidedFinishingTimeImpl(competitorResult.getFinishingTime(), finish, competitor, originalsOriginal);
                    logger.info(String.valueOf(this.getRace().getName()) + ": Updating finish mark passing " + originalsOriginal + " to " + finishMarkPassingToUse);
                    neededToCreateOrUpdateFinishMarkPassing = true;
                } else {
                    assert (originalsOriginal != originalMarkPassing);
                    assert (originalMarkPassing.getTimePoint().equals(competitorResult.getFinishingTime()));
                    finishMarkPassingToUse = originalMarkPassing;
                    neededToCreateOrUpdateFinishMarkPassing = false;
                }
            } else {
                finishMarkPassingToUse = originalsOriginal;
                if (finishMarkPassingToUse != originalMarkPassing) {
                    logger.info(String.valueOf(this.getRace().getName()) + ": Reverting race log-based finish mark passing " + originalMarkPassing + " to " + finishMarkPassingToUse + " because no finishing time found anymore for that competitor in race log");
                    neededToCreateOrUpdateFinishMarkPassing = true;
                } else {
                    neededToCreateOrUpdateFinishMarkPassing = false;
                }
            }
            if (finishMarkPassingToUse == null) continue;
            copyOfMarkPassings.add(finishMarkPassingToUse);
        }
        if (!foundFinishMarkPassing && competitorResult != null && competitorResult.getFinishingTime() != null) {
            MarkPassingFromRaceLogProvidedFinishingTimeImpl finishMarkPassingToUse = new MarkPassingFromRaceLogProvidedFinishingTimeImpl(competitorResult.getFinishingTime(), finish, competitor, null);
            copyOfMarkPassings.add(finishMarkPassingToUse);
            logger.info(String.valueOf(this.getRace().getName()) + ": Created " + finishMarkPassingToUse + " based on finishing time provided in race log");
            neededToCreateOrUpdateFinishMarkPassing = true;
        }
        return neededToCreateOrUpdateFinishMarkPassing ? copyOfMarkPassings : markPassings;
    }

    private Map<Competitor, CompetitorResult> getResultsFromRaceLogs() {
        HashMap<Competitor, CompetitorResult> result = new HashMap<Competitor, CompetitorResult>();
        CompetitorResults results = null;
        for (RaceLog raceLog : this.attachedRaceLogs.values()) {
            results = ((AbstractFinishPositioningListFinder.CompetitorResultsAndTheirCreationTimePoints)new ConfirmedFinishPositioningListFinder(raceLog).analyze()).getCompetitorResults();
            if (results == null) continue;
            for (CompetitorResult cr : results) {
                result.put(this.getRace().getCompetitorById(cr.getCompetitorId()), cr);
            }
        }
        return result;
    }

    private void updateMarkPassingsNotConsideringFinishingTimesFromRaceLog(Competitor competitor, Iterable<MarkPassing> markPassings) {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.getSerializationLock());
        try {
            HashMap<Waypoint, MarkPassing> oldMarkPassings = new HashMap<Waypoint, MarkPassing>();
            MarkPassing oldStartMarkPassing = null;
            boolean requiresStartTimeUpdate = true;
            NavigableSet<MarkPassing> markPassingsForCompetitor = this.getMarkPassings(competitor);
            this.lockForRead(markPassingsForCompetitor);
            try {
                for (MarkPassing oldMarkPassing : markPassingsForCompetitor) {
                    if (oldStartMarkPassing == null) {
                        oldStartMarkPassing = oldMarkPassing;
                    }
                    oldMarkPassings.put(oldMarkPassing.getWaypoint(), oldMarkPassing);
                }
            }
            finally {
                this.unlockAfterRead(markPassingsForCompetitor);
            }
            NamedReentrantReadWriteLock markPassingsLock = this.getMarkPassingsLock(markPassingsForCompetitor);
            MillisecondsTimePoint timePointOfLatestEvent = new MillisecondsTimePoint(0L);
            this.getRace().getCourse().lockForRead();
            LockUtil.lockForWrite((NamedReentrantReadWriteLock)markPassingsLock);
            try {
                this.clearMarkPassings(competitor);
                for (MarkPassing markPassing : markPassings) {
                    if (this.getRace().getCourse().getIndexOfWaypoint(markPassing.getWaypoint()) >= 0) {
                        if (oldStartMarkPassing != null && markPassing.getWaypoint().equals(oldStartMarkPassing.getWaypoint()) && markPassing.getTimePoint() != null && oldStartMarkPassing.getTimePoint() != null && markPassing.getTimePoint().equals(oldStartMarkPassing.getTimePoint())) {
                            requiresStartTimeUpdate = false;
                        }
                        if (!Util.contains((Iterable)this.getRace().getCourse().getWaypoints(), (Object)markPassing.getWaypoint())) {
                            StringBuilder courseWaypointsWithID = new StringBuilder();
                            boolean first = true;
                            for (Waypoint courseWaypoint : this.getRace().getCourse().getWaypoints()) {
                                if (first) {
                                    first = false;
                                } else {
                                    courseWaypointsWithID.append(" -> ");
                                }
                                courseWaypointsWithID.append(courseWaypoint.toString());
                                courseWaypointsWithID.append(" (ID=");
                                courseWaypointsWithID.append(courseWaypoint.getId());
                                courseWaypointsWithID.append(")");
                            }
                            logger.severe("Received mark passing " + markPassing + " for race " + this.getRace() + " for waypoint ID" + markPassing.getWaypoint().getId() + " but the waypoint does not exist in course " + courseWaypointsWithID);
                        } else {
                            markPassingsForCompetitor.add(markPassing);
                        }
                        NavigableSet<MarkPassing> markPassingsInOrderForWaypoint = this.getOrCreateMarkPassingsInOrderAsNavigableSet(markPassing.getWaypoint());
                        NamedReentrantReadWriteLock markPassingsLock2 = this.getMarkPassingsLock(markPassingsInOrderForWaypoint);
                        LockUtil.lockForWrite((NamedReentrantReadWriteLock)markPassingsLock2);
                        try {
                            markPassingsInOrderForWaypoint.add(markPassing);
                        }
                        finally {
                            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)markPassingsLock2);
                        }
                        if (markPassing.getTimePoint().compareTo((Object)timePointOfLatestEvent) <= 0) continue;
                        timePointOfLatestEvent = markPassing.getTimePoint();
                        continue;
                    }
                    logger.warning("Received mark passing " + markPassing + " for non-existing waypoint " + markPassing.getWaypoint() + " in race " + this.getRace().getName() + ". Ignoring.");
                }
            }
            finally {
                LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)markPassingsLock);
                this.getRace().getCourse().unlockAfterRead();
            }
            this.updated((TimePoint)timePointOfLatestEvent);
            this.triggerManeuverCacheRecalculation(competitor);
            if (requiresStartTimeUpdate) {
                this.invalidateStartTime();
            }
            this.invalidateMarkPassingTimes();
            this.invalidateEndTime();
            this.notifyListeners(competitor, oldMarkPassings, markPassings);
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.getSerializationLock());
        }
    }

    private void updateFinishingTimesFromRaceLog() {
        Waypoint finish = this.getRace().getCourse().getLastWaypoint();
        if (finish != null) {
            for (Competitor competitor : this.getRace().getCompetitors()) {
                Iterable<MarkPassing> markPassingsToUse;
                CompetitorResult competitorResult = this.competitorResultsFromRaceLog.get(competitor);
                NavigableSet<MarkPassing> markPassings = this.getMarkPassings(competitor);
                this.lockForRead(markPassings);
                try {
                    markPassingsToUse = this.createOrUpdateFinishMarkPassingIfRequired(competitor, markPassings, competitorResult);
                }
                finally {
                    this.unlockAfterRead(markPassings);
                }
                if (markPassingsToUse == markPassings) continue;
                this.updateMarkPassingsNotConsideringFinishingTimesFromRaceLog(competitor, markPassingsToUse);
            }
        }
    }

    @Override
    public void lockForRead(Iterable<MarkPassing> markPassings) {
        this.getRace().getCourse().lockForRead();
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.getMarkPassingsLock(markPassings));
    }

    @Override
    public void unlockAfterRead(Iterable<MarkPassing> markPassings) {
        LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.getMarkPassingsLock(markPassings));
        this.getRace().getCourse().unlockAfterRead();
    }

    private void clearMarkPassings(Competitor competitor) {
        NavigableSet<MarkPassing> markPassings = this.getMarkPassings(competitor);
        NamedReentrantReadWriteLock markPassingsLock = this.getMarkPassingsLock(markPassings);
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)markPassingsLock);
        try {
            Iterator<MarkPassing> mpIter = markPassings.iterator();
            while (mpIter.hasNext()) {
                MarkPassing mp = mpIter.next();
                mpIter.remove();
                NavigableSet<MarkPassing> markPassingsInOrder = this.getMarkPassingsInOrderAsNavigableSet(mp.getWaypoint());
                LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.getMarkPassingsLock(markPassingsInOrder));
                try {
                    markPassingsInOrder.remove(mp);
                }
                finally {
                    LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.getMarkPassingsLock(markPassingsInOrder));
                }
            }
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)markPassingsLock);
        }
    }

    @Override
    public void setStartTimeReceived(TimePoint startTimeReceived) {
        if (!Util.equalsWithNull((Object)startTimeReceived, (Object)this.getStartTimeReceived())) {
            super.setStartTimeReceived(startTimeReceived);
            this.notifyListenersStartTimeReceivedChanged(this.getStartTimeReceived());
        }
    }

    @Override
    public void setStartOfTrackingReceived(TimePoint startOfTrackingReceived) {
        this.setStartOfTrackingReceived(startOfTrackingReceived, false);
    }

    @Override
    public void setStartOfTrackingReceived(TimePoint startOfTrackingReceived, boolean waitForGPSFixesToLoad) {
        super.setStartOfTrackingReceived(startOfTrackingReceived, waitForGPSFixesToLoad);
    }

    @Override
    protected void startOfTrackingChanged(TimePoint oldStartOfTracking, boolean waitForGPSFixesToLoad) {
        super.startOfTrackingChanged(oldStartOfTracking, waitForGPSFixesToLoad);
        if (!Util.equalsWithNull((Object)oldStartOfTracking, (Object)this.getStartOfTracking())) {
            this.notifyListenersStartOfTrackingChanged(oldStartOfTracking, this.getStartOfTracking());
        }
    }

    @Override
    protected void endOfTrackingChanged(TimePoint oldEndOfTracking, boolean waitForGPSFixesToLoad) {
        super.endOfTrackingChanged(oldEndOfTracking, waitForGPSFixesToLoad);
        if (!Util.equalsWithNull((Object)oldEndOfTracking, (Object)this.getEndOfTracking())) {
            this.notifyListenersEndOfTrackingChanged(oldEndOfTracking, this.getEndOfTracking());
        }
    }

    @Override
    public void setEndOfTrackingReceived(TimePoint endOfTrackingReceived, boolean waitForGPSFixesToLoad) {
        super.setEndOfTrackingReceived(endOfTrackingReceived, waitForGPSFixesToLoad);
    }

    @Override
    public void setEndOfTrackingReceived(TimePoint endOfTrackingReceived) {
        this.setEndOfTrackingReceived(endOfTrackingReceived, false);
    }

    @Override
    protected void notifyWindTrackHasBeenCreatedAndAddedToWindTracks(WindSource windSource, WindTrack windTrack) {
        super.notifyWindTrackHasBeenCreatedAndAddedToWindTracks(windSource, windTrack);
        if (windSource.getType().canBeStored()) {
            windTrack.lockForRead();
            try {
                for (Wind wind : windTrack.getRawFixes()) {
                    this.notifyListeners(wind, windSource);
                }
            }
            finally {
                windTrack.unlockAfterRead();
            }
        }
    }

    @Override
    public boolean recordWind(Wind wind, WindSource windSource, boolean applyFilter) {
        boolean result = super.recordWind(wind, windSource, applyFilter);
        if (result) {
            this.notifyListeners(wind, windSource);
        }
        return result;
    }

    @Override
    public void removeWind(Wind wind, WindSource windSource) {
        super.removeWind(wind, windSource);
        this.notifyListenersWindRemoved(wind, windSource);
    }

    @Override
    public void gpsFixReceived(GPSFixMoving fix, Competitor competitor, boolean firstFixInTrack, AddResult addedOrReplaced) {
        this.updated(fix.getTimePoint());
        this.invalidateDistancesFromStarboardSideOfStartLineProjectedOntoLineCache(TimeRange.create((TimePoint)fix.getTimePoint().minus(this.getMillisecondsOverWhichToAverageSpeed()), (TimePoint)fix.getTimePoint().plus(this.getMillisecondsOverWhichToAverageSpeed())));
        this.triggerManeuverCacheRecalculation(competitor);
        this.notifyListeners(fix, competitor, addedOrReplaced);
        boolean oldGPSFixReceived = this.gpsFixReceived.getAndSet(true);
        if (!oldGPSFixReceived) {
            this.notifyListenersAboutFirstGPSFixReceived();
        }
    }

    @Override
    public void speedAveragingChanged(long oldMillisecondsOverWhichToAverage, long newMillisecondsOverWhichToAverage) {
        this.notifyListenersSpeedAveragingChanged(oldMillisecondsOverWhichToAverage, newMillisecondsOverWhichToAverage);
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    protected TrackedLeg createTrackedLeg(Leg leg) {
        return new TrackedLegImpl(this, leg, this.getRace().getCompetitors());
    }

    @Override
    public long getMillisecondsOverWhichToAverageSpeed() {
        long result = 0L;
        Iterator<Competitor> compIter = this.getRace().getCompetitors().iterator();
        if (compIter.hasNext()) {
            GPSFixTrack someTrack = this.getTrack(compIter.next());
            result = someTrack.getMillisecondsOverWhichToAverageSpeed();
        }
        return result;
    }

    @Override
    public long getMillisecondsOverWhichToAverageWind() {
        return this.millisecondsOverWhichToAverageWind;
    }

    @Override
    public DynamicTrackedRegatta getTrackedRegatta() {
        return (DynamicTrackedRegatta)super.getTrackedRegatta();
    }

    @Override
    public void setRaceIsKnownToStartUpwind(boolean raceIsKnownToStartUpwind) {
        this.raceIsKnownToStartUpwind = raceIsKnownToStartUpwind;
    }

    @Override
    public boolean raceIsKnownToStartUpwind() {
        return this.raceIsKnownToStartUpwind;
    }

    @Override
    public void attachRaceLog(RaceLog raceLog) {
        this.logListener.beforeAttaching(raceLog);
        super.attachRaceLog(raceLog);
        this.logListener.afterAttaching(raceLog);
        this.getRaceState(raceLog).addChangedListener(this.raceStateBasedStartTimeChangedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RaceLog detachRaceLog(Serializable identifier) {
        RaceLog attachedRaceLog = (RaceLog)this.attachedRaceLogs.get(identifier);
        if (attachedRaceLog != null) {
            this.logListener.beforeDetaching(attachedRaceLog);
        }
        RaceLog raceLogDetached = super.detachRaceLog(identifier);
        if (attachedRaceLog != null) {
            this.logListener.afterDetaching(attachedRaceLog);
        }
        assert (raceLogDetached == attachedRaceLog);
        WeakHashMap weakHashMap = this.raceStates;
        synchronized (weakHashMap) {
            ReadonlyRaceState raceState = (ReadonlyRaceState)this.raceStates.remove(attachedRaceLog);
            if (raceState != null) {
                raceState.removeChangedListener(this.raceStateBasedStartTimeChangedListener);
            }
        }
        return attachedRaceLog;
    }

    @Override
    public void addCourseDesignChangedListener(CourseDesignChangedListener listener) {
        this.courseDesignChangedListeners.add(listener);
    }

    @Override
    public void onCourseDesignChangedByRaceCommittee(CourseBase newCourseDesign) {
        try {
            for (CourseDesignChangedListener courseDesignChangedListener : this.courseDesignChangedListeners) {
                courseDesignChangedListener.courseDesignChanged(newCourseDesign);
            }
        }
        catch (IOException e) {
            logger.log(Level.INFO, "Exception trying to notify race course design change listeners about course design change", e);
        }
    }

    @Override
    public void onStartTimeChangedByRaceCommittee(TimePoint newStartTime) {
        logger.info("Start time of race " + this.getRace().getName() + " updated by race committee to " + newStartTime);
        try {
            for (StartTimeChangedListener startTimeChangedListener : this.startTimeChangedListeners) {
                startTimeChangedListener.startTimeChanged(newStartTime);
            }
        }
        catch (IOException | URISyntaxException e) {
            logger.log(Level.INFO, "Exception trying to notify race status change listeners about start time change", e);
        }
        this.updateStartAndEndOfTracking(false);
    }

    @Override
    public void onAbortedByRaceCommittee(Flags flag) {
        try {
            for (RaceAbortedListener raceAbortedListener : this.raceAbortedListeners) {
                raceAbortedListener.raceAborted(flag);
            }
        }
        catch (IOException e) {
            logger.log(Level.INFO, "Exception trying to notify race status change listeners about start time change", e);
        }
    }

    @Override
    public void addStartTimeChangedListener(StartTimeChangedListener listener) {
        this.startTimeChangedListeners.add(listener);
    }

    @Override
    public void removeStartTimeChangedListener(StartTimeChangedListener listener) {
        this.startTimeChangedListeners.remove(listener);
    }

    @Override
    public void addRaceAbortedListener(RaceAbortedListener listener) {
        this.raceAbortedListeners.add(listener);
    }

    @Override
    protected MarkPassingCalculator createMarkPassingCalculator(MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry) {
        return new MarkPassingCalculator(this, true, false, markPassingRaceFingerprintRegistry);
    }

    public DynamicGPSFixTrack<Mark, GPSFix> getTrack(Mark mark) {
        return (DynamicGPSFixTrack)super.getTrack(mark);
    }

    @Override
    public <FixT extends SensorFix, TrackT extends DynamicSensorFixTrack<Competitor, FixT>> TrackT getOrCreateSensorTrack(Competitor competitor, String trackName, TrackFactory<TrackT> newTrackFactory) {
        return super.getOrCreateSensorTrack(competitor, trackName, newTrackFactory);
    }

    @Override
    public <FixT extends SensorFix, TrackT extends DynamicSensorFixTrack<Competitor, FixT>> TrackT getDynamicSensorTrack(Competitor competitor, String trackName) {
        return (TrackT)((DynamicSensorFixTrack)super.getSensorTrack(competitor, trackName));
    }

    @Override
    public void recordSensorFix(Competitor competitor, String trackName, SensorFix fix, boolean onlyWhenInTrackingTimesInterval) {
        DynamicSensorFixTrack track;
        if ((!onlyWhenInTrackingTimesInterval || this.isWithinStartAndEndOfTracking(fix.getTimePoint())) && (track = (DynamicSensorFixTrack)this.getSensorTrack(competitor, trackName)) != null) {
            if (logger != null && logger.getLevel() != null && logger.getLevel().equals(Level.FINEST)) {
                logger.finest(competitor.getName() + ": " + fix);
            }
            track.add((Timed)fix);
        }
    }

    @Override
    public void addSensorTrack(Competitor competitor, String trackName, DynamicSensorFixTrack<Competitor, ?> track) {
        super.addSensorTrack(competitor, trackName, track);
    }

    @Override
    protected <FixT extends SensorFix> Optional<Runnable> addSensorTrackInternal(Util.Pair<Competitor, String> key, DynamicSensorFixTrack<Competitor, FixT> track) {
        super.addSensorTrackInternal(key, track);
        track.addListener(new SensorFixTrackListener<Competitor, FixT>(){
            private static final long serialVersionUID = 6143309919537011377L;

            @Override
            public boolean isTransient() {
                return true;
            }

            @Override
            public void fixReceived(FixT fix, Competitor item, String trackName, boolean firstFixInTrack, AddResult addedOrReplaced) {
                DynamicTrackedRaceImpl.this.notifyListeners(item, trackName, fix, addedOrReplaced);
            }
        });
        return Optional.of(() -> this.notifyListenersAboutSensorTrackAdded(track));
    }

    private static class MarkPassingFromRaceLogProvidedFinishingTimeImpl
    extends MarkPassingImpl {
        private static final long serialVersionUID = 2900812554717213461L;
        private final MarkPassing original;

        public MarkPassingFromRaceLogProvidedFinishingTimeImpl(TimePoint timePoint, Waypoint waypoint, Competitor competitor, MarkPassing original) {
            super(timePoint, waypoint, competitor);
            this.original = original;
        }

        @Override
        public MarkPassing getOriginal() {
            return this.original;
        }
    }
}

