/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.base.CPUMeteringType;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.tracking.AddResult;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.Track;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.impl.AbstractRaceChangeListener;
import com.sap.sailing.domain.tracking.impl.TrackImpl;
import com.sap.sse.common.Distance;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Timed;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.util.SmartFutureCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

public class CrossTrackErrorCache
extends AbstractRaceChangeListener {
    private static final Logger logger = Logger.getLogger(CrossTrackErrorCache.class.getName());
    private final SmartFutureCache<Competitor, CrossTrackErrorSumAndNumberOfFixesTrack, FromTimePointToEndUpdateInterval> cachePerCompetitor;
    private final TrackedRace owner;

    public CrossTrackErrorCache(final TrackedRace owner) {
        this.cachePerCompetitor = new SmartFutureCache((SmartFutureCache.CacheUpdater)new SmartFutureCache.CacheUpdater<Competitor, CrossTrackErrorSumAndNumberOfFixesTrack, FromTimePointToEndUpdateInterval>(){

            public CrossTrackErrorSumAndNumberOfFixesTrack computeCacheUpdate(Competitor competitor, FromTimePointToEndUpdateInterval updateInterval) throws NoWindException {
                return (CrossTrackErrorSumAndNumberOfFixesTrack)((Object)owner.getTrackedRegatta().callWithCPUMeterWithException(() -> {
                    GPSFixMoving firstRawFix;
                    Object from = updateInterval == null ? ((firstRawFix = (GPSFixMoving)owner.getTrack(competitor).getFirstRawFix()) == null ? new MillisecondsTimePoint(0L) : firstRawFix.getTimePoint()) : updateInterval.getFrom();
                    return CrossTrackErrorCache.this.computeFixesForCacheUpdate(competitor, from);
                }, CPUMeteringType.CROSS_TRACK_ERROR.name()));
            }

            public CrossTrackErrorSumAndNumberOfFixesTrack provideNewCacheValue(Competitor key, CrossTrackErrorSumAndNumberOfFixesTrack oldValue, CrossTrackErrorSumAndNumberOfFixesTrack computedCacheUpdate, FromTimePointToEndUpdateInterval updateInterval) {
                CrossTrackErrorSumAndNumberOfFixesTrack result;
                if (oldValue != null) {
                    if (updateInterval == null) {
                        oldValue.deleteAll();
                    } else {
                        oldValue.deleteAllLaterThan(updateInterval.getFrom());
                    }
                    computedCacheUpdate.lockForRead();
                    try {
                        for (CrossTrackErrorSumAndNumberOfFixes entry : computedCacheUpdate.getRawFixes()) {
                            oldValue.add(entry);
                        }
                    }
                    finally {
                        computedCacheUpdate.unlockAfterRead();
                    }
                    result = oldValue;
                } else {
                    result = computedCacheUpdate;
                }
                return result;
            }
        }, String.valueOf(CrossTrackErrorCache.class.getSimpleName()) + " for race " + owner.getRace().getName());
        this.owner = owner;
        this.triggerUpdateForAllRaceCompetitors();
        owner.addListener(this);
    }

    public Distance getAverageAbsoluteCrossTrackError(Competitor competitor, TimePoint from, TimePoint to, boolean upwindOnly, boolean waitForLatest) {
        CrossTrackErrorMeterRetriever absoluteMetersRetriever = cacheEntry -> cacheEntry.getAbsoluteDistanceInMetersSumFromStart();
        return this.getAbsoluteOrSignedAverageCrossTrackError(competitor, from, to, upwindOnly, waitForLatest, absoluteMetersRetriever);
    }

    public Distance getAverageSignedCrossTrackError(Competitor competitor, TimePoint from, TimePoint to, boolean upwindOnly, boolean waitForLatest) {
        CrossTrackErrorMeterRetriever signedMetersRetriever = cacheEntry -> cacheEntry.getSignedDistanceInMetersSumFromStart();
        return this.getAbsoluteOrSignedAverageCrossTrackError(competitor, from, to, upwindOnly, waitForLatest, signedMetersRetriever);
    }

    private Distance getAbsoluteOrSignedAverageCrossTrackError(Competitor competitor, TimePoint from, TimePoint to, boolean upwindOnly, boolean waitForLatest, CrossTrackErrorMeterRetriever absoluteOrSignedMetersRetriever) {
        Track cacheForCompetitor = (Track)this.cachePerCompetitor.get((Object)competitor, waitForLatest);
        double distanceInMeters = 0.0;
        int count = 0;
        if (to != null && cacheForCompetitor != null) {
            this.owner.getRace().getCourse().lockForRead();
            try {
                CrossTrackErrorSumAndNumberOfFixes startAggregate = null;
                for (Leg leg : this.owner.getRace().getCourse().getLegs()) {
                    CrossTrackErrorSumAndNumberOfFixes endAggregate;
                    MarkPassing legEndMarkPassing;
                    TimePoint end;
                    TimePoint legStart;
                    TimePoint start;
                    LegType legType;
                    TrackedLeg trackedLeg = this.owner.getTrackedLeg(leg);
                    MarkPassing legStartMarkPassing = this.owner.getMarkPassing(competitor, leg.getFrom());
                    if (legStartMarkPassing == null) continue;
                    try {
                        legType = trackedLeg.getLegType(legStartMarkPassing.getTimePoint());
                    }
                    catch (NoWindException e) {
                        legType = null;
                    }
                    if (upwindOnly && legType != LegType.UPWIND || (start = (legStart = legStartMarkPassing.getTimePoint()).compareTo((Object)from) < 0 ? from : legStart).compareTo((Object)(end = (legEndMarkPassing = this.owner.getMarkPassing(competitor, leg.getTo())) == null || legEndMarkPassing.getTimePoint().compareTo((Object)to) >= 0 ? to : legEndMarkPassing.getTimePoint())) >= 0) continue;
                    if (startAggregate == null) {
                        startAggregate = (CrossTrackErrorSumAndNumberOfFixes)cacheForCompetitor.getLastFixAtOrBefore(start);
                    }
                    if (startAggregate == null) {
                        startAggregate = new CrossTrackErrorSumAndNumberOfFixes(null, 0.0, 0.0, 0);
                    }
                    if ((endAggregate = (CrossTrackErrorSumAndNumberOfFixes)cacheForCompetitor.getLastFixAtOrBefore(end)) == null) continue;
                    distanceInMeters += absoluteOrSignedMetersRetriever.getDistanceInMetersSumFromStart(endAggregate) - absoluteOrSignedMetersRetriever.getDistanceInMetersSumFromStart(startAggregate);
                    count += endAggregate.getFixCountFromStart() - startAggregate.getFixCountFromStart();
                    startAggregate = endAggregate;
                }
            }
            finally {
                this.owner.getRace().getCourse().unlockAfterRead();
            }
        }
        return count == 0 ? null : new MeterDistance(distanceInMeters / (double)count);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CrossTrackErrorSumAndNumberOfFixesTrack computeFixesForCacheUpdate(Competitor competitor, TimePoint from) throws NoWindException {
        int count;
        double signedDistanceInMeters;
        double absoluteDistanceInMeters;
        CrossTrackErrorSumAndNumberOfFixes lastCacheEntryBeforeFrom;
        CrossTrackErrorSumAndNumberOfFixesTrack result = new CrossTrackErrorSumAndNumberOfFixesTrack(String.valueOf(CrossTrackErrorSumAndNumberOfFixesTrack.class.getSimpleName()) + " for competitor " + competitor.getName() + " in race " + this.owner.getRace().getName());
        CrossTrackErrorSumAndNumberOfFixesTrack competitorCacheEntry = (CrossTrackErrorSumAndNumberOfFixesTrack)((Object)this.cachePerCompetitor.get((Object)competitor, false));
        CrossTrackErrorSumAndNumberOfFixes crossTrackErrorSumAndNumberOfFixes = lastCacheEntryBeforeFrom = competitorCacheEntry == null ? null : (CrossTrackErrorSumAndNumberOfFixes)competitorCacheEntry.getLastFixBefore(from);
        if (lastCacheEntryBeforeFrom != null) {
            absoluteDistanceInMeters = lastCacheEntryBeforeFrom.getAbsoluteDistanceInMetersSumFromStart();
            signedDistanceInMeters = lastCacheEntryBeforeFrom.getSignedDistanceInMetersSumFromStart();
            count = lastCacheEntryBeforeFrom.getFixCountFromStart();
        } else {
            absoluteDistanceInMeters = 0.0;
            signedDistanceInMeters = 0.0;
            count = 0;
        }
        GPSFixTrack<Competitor, GPSFixMoving> track = this.owner.getTrack(competitor);
        GPSFixMoving fix = null;
        this.owner.getRace().getCourse().lockForRead();
        track.lockForRead();
        try {
            block11: {
                MarkPassing markPassingAtLegEnd;
                MarkPassing markPassingAtLegStart;
                Leg currentLeg;
                Iterator legIter;
                Iterator fixIter;
                block10: {
                    fixIter = track.getFixesIterator(from, true);
                    legIter = this.owner.getRace().getCourse().getLegs().iterator();
                    if (!legIter.hasNext()) return result;
                    currentLeg = (Leg)legIter.next();
                    markPassingAtLegStart = this.owner.getMarkPassing(competitor, currentLeg.getFrom());
                    markPassingAtLegEnd = this.owner.getMarkPassing(competitor, currentLeg.getTo());
                    if (!true) break block10;
                    if (currentLeg == null) return result;
                    if (!fixIter.hasNext()) break block11;
                }
                do {
                    TrackedLeg trackedLeg;
                    Distance xte;
                    fix = (GPSFixMoving)fixIter.next();
                    while (currentLeg != null && markPassingAtLegEnd != null && markPassingAtLegEnd.getTimePoint().compareTo((Object)fix.getTimePoint()) <= 0) {
                        if (legIter.hasNext()) {
                            currentLeg = (Leg)legIter.next();
                            markPassingAtLegStart = this.owner.getMarkPassing(competitor, currentLeg.getFrom());
                            markPassingAtLegEnd = this.owner.getMarkPassing(competitor, currentLeg.getTo());
                            continue;
                        }
                        currentLeg = null;
                    }
                    if (currentLeg != null && markPassingAtLegStart != null && fix.getTimePoint().compareTo((Object)markPassingAtLegStart.getTimePoint()) >= 0 && (xte = this.owner.getTrackedLeg((trackedLeg = this.owner.getTrackedLeg(currentLeg)).getLeg()).getSignedCrossTrackError(fix.getPosition(), fix.getTimePoint())) != null) {
                        CrossTrackErrorSumAndNumberOfFixes newCacheEntry = new CrossTrackErrorSumAndNumberOfFixes(fix.getTimePoint(), absoluteDistanceInMeters += Math.abs(xte.getMeters()), signedDistanceInMeters += xte.getMeters(), ++count);
                        result.add(newCacheEntry);
                    }
                    if (currentLeg == null) return result;
                } while (fixIter.hasNext());
            }
            return result;
        }
        finally {
            this.owner.getRace().getCourse().unlockAfterRead();
            track.unlockAfterRead();
        }
    }

    private void invalidate(Competitor competitor, TimePoint from) {
        this.cachePerCompetitor.triggerUpdate((Object)competitor, (SmartFutureCache.UpdateInterval)new FromTimePointToEndUpdateInterval(from));
    }

    @Override
    public void competitorPositionChanged(GPSFixMoving fix, Competitor competitor, AddResult addedOrReplaced) {
        TimePoint from = this.owner.getTrack(competitor).getEstimatedPositionTimePeriodAffectedBy((GPSFix)fix).from();
        this.invalidate(competitor, from);
    }

    @Override
    public void markPositionChanged(GPSFix fix, Mark mark, boolean firstInTrack, AddResult addedOrReplaced) {
        TimePoint from = this.owner.getOrCreateTrack(mark).getEstimatedPositionTimePeriodAffectedBy(fix).from();
        ArrayList shuffledCompetitors = new ArrayList(this.cachePerCompetitor.keySet());
        Collections.shuffle(shuffledCompetitors);
        for (Competitor competitor : shuffledCompetitors) {
            this.invalidate(competitor, from);
        }
    }

    @Override
    public void markPassingReceived(Competitor competitor, Map<Waypoint, MarkPassing> oldMarkPassings, Iterable<MarkPassing> markPassings) {
        assert (oldMarkPassings != null && markPassings != null);
        TimePoint from = null;
        HashSet<Waypoint> foundOldWaypoints = new HashSet<Waypoint>();
        for (MarkPassing markPassing : markPassings) {
            MarkPassing oldMarkPassing = oldMarkPassings.get(markPassing.getWaypoint());
            if (oldMarkPassing == null) {
                from = markPassing.getTimePoint();
                break;
            }
            foundOldWaypoints.add(oldMarkPassing.getWaypoint());
            if (oldMarkPassing.getTimePoint().equals(markPassing.getTimePoint())) continue;
            if (oldMarkPassing.getTimePoint().compareTo((Object)markPassing.getTimePoint()) < 0) {
                from = oldMarkPassing.getTimePoint();
                break;
            }
            from = markPassing.getTimePoint();
            break;
        }
        if (foundOldWaypoints.size() != oldMarkPassings.size()) {
            for (Map.Entry entry : oldMarkPassings.entrySet()) {
                if (foundOldWaypoints.contains(entry.getKey())) continue;
                TimePoint timePointOfRemovedMarkPassing = ((MarkPassing)entry.getValue()).getTimePoint();
                if (from != null && timePointOfRemovedMarkPassing.compareTo((Object)from) >= 0) continue;
                from = timePointOfRemovedMarkPassing;
            }
        }
        if (from != null) {
            this.invalidate(competitor, from);
        }
    }

    @Override
    public void waypointAdded(int zeroBasedIndex, Waypoint waypointThatGotAdded) {
        this.invalidate();
    }

    public void invalidate() {
        ArrayList shuffledCompetitors = new ArrayList(this.cachePerCompetitor.keySet());
        Collections.shuffle(shuffledCompetitors);
        for (Competitor competitor : shuffledCompetitors) {
            this.cachePerCompetitor.triggerUpdate((Object)competitor, null);
        }
    }

    @Override
    public void waypointRemoved(int zeroBasedIndex, Waypoint waypointThatGotRemoved) {
        this.invalidate();
    }

    public String toString() {
        return "CrossTrackErrorCache for competitors " + this.cachePerCompetitor.keySet();
    }

    public void suspend() {
        this.owner.removeListener(this);
        this.cachePerCompetitor.suspend();
    }

    public void resume() {
        this.owner.addListener(this);
        this.triggerUpdateForAllRaceCompetitors();
        this.cachePerCompetitor.resume();
    }

    private void triggerUpdateForAllRaceCompetitors() {
        for (Competitor competitor : this.owner.getRace().getCompetitors()) {
            this.cachePerCompetitor.triggerUpdate((Object)competitor, null);
        }
    }

    @FunctionalInterface
    private static interface CrossTrackErrorMeterRetriever {
        public double getDistanceInMetersSumFromStart(CrossTrackErrorSumAndNumberOfFixes var1);
    }

    private static class CrossTrackErrorSumAndNumberOfFixes
    implements Timed {
        private static final long serialVersionUID = -278130726836884454L;
        private final TimePoint timePoint;
        private final double absoluteDistanceInMetersSumFromStart;
        private final double signedDistanceInMetersSumFromStart;
        private final int fixCountFromStart;

        public CrossTrackErrorSumAndNumberOfFixes(TimePoint timePoint, double absoluteDistanceInMetersSumFromStart, double signedDistanceInMetersSumFromStart, int fixCountFromStart) {
            this.timePoint = timePoint;
            this.absoluteDistanceInMetersSumFromStart = absoluteDistanceInMetersSumFromStart;
            this.signedDistanceInMetersSumFromStart = signedDistanceInMetersSumFromStart;
            this.fixCountFromStart = fixCountFromStart;
        }

        public TimePoint getTimePoint() {
            return this.timePoint;
        }

        public double getAbsoluteDistanceInMetersSumFromStart() {
            return this.absoluteDistanceInMetersSumFromStart;
        }

        public double getSignedDistanceInMetersSumFromStart() {
            return this.signedDistanceInMetersSumFromStart;
        }

        public int getFixCountFromStart() {
            return this.fixCountFromStart;
        }
    }

    private static class CrossTrackErrorSumAndNumberOfFixesTrack
    extends TrackImpl<CrossTrackErrorSumAndNumberOfFixes> {
        private static final long serialVersionUID = 4884868659665863604L;

        private CrossTrackErrorSumAndNumberOfFixesTrack(String nameForReadWriteLock) {
            super(nameForReadWriteLock);
        }

        public void deleteAll() {
            this.lockForWrite();
            try {
                this.getInternalRawFixes().clear();
            }
            finally {
                this.unlockAfterWrite();
            }
        }

        public void deleteAllLaterThan(TimePoint from) {
            this.lockForWrite();
            try {
                int count = 0;
                Iterator i = this.getRawFixesIterator(from, false);
                while (i.hasNext()) {
                    i.next();
                    i.remove();
                    ++count;
                }
                if (count > 0) {
                    logger.finest("Deleted " + count + " CrossTrackError cache entries");
                }
            }
            finally {
                this.unlockAfterWrite();
            }
        }

        public boolean add(CrossTrackErrorSumAndNumberOfFixes entry) {
            return super.add((Timed)entry, true);
        }
    }

    private static class FromTimePointToEndUpdateInterval
    implements SmartFutureCache.UpdateInterval<FromTimePointToEndUpdateInterval> {
        private final TimePoint from;

        public FromTimePointToEndUpdateInterval(TimePoint from) {
            this.from = from;
        }

        public FromTimePointToEndUpdateInterval join(FromTimePointToEndUpdateInterval otherUpdateInterval) {
            return new FromTimePointToEndUpdateInterval(this.getFrom() == null ? otherUpdateInterval.getFrom() : (otherUpdateInterval.getFrom() == null ? this.getFrom() : (this.getFrom().before(otherUpdateInterval.getFrom()) ? this.getFrom() : otherUpdateInterval.getFrom())));
        }

        public TimePoint getFrom() {
            return this.from;
        }
    }
}

