/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.base.CourseBase;
import com.sap.sailing.domain.tracking.CourseDesignChangedListener;
import com.sap.sailing.domain.tracking.impl.UpdateHandler;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.ControlPointJsonSerializer;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.CourseBaseJsonSerializer;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.CourseJsonSerializer;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.GateJsonSerializer;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.MarkJsonSerializer;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.WaypointJsonSerializer;
import com.sap.sse.shared.json.JsonSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

public class CourseDesignUpdateHandler
extends UpdateHandler
implements CourseDesignChangedListener {
    private static final String ACTION = "update_course";
    private static final Logger logger = Logger.getLogger(CourseDesignUpdateHandler.class.getName());
    private final JsonSerializer<CourseBase> courseSerializer = new CourseJsonSerializer((JsonSerializer)new CourseBaseJsonSerializer((JsonSerializer)new WaypointJsonSerializer((JsonSerializer)new ControlPointJsonSerializer((JsonSerializer)new MarkJsonSerializer(), (JsonSerializer)new GateJsonSerializer((JsonSerializer)new MarkJsonSerializer())))));

    public CourseDesignUpdateHandler(URI updateURI, String username, String password, Serializable eventId, Serializable raceId) {
        super(updateURI, ACTION, username, password, eventId, raceId);
    }

    @Override
    public void courseDesignChanged(CourseBase newCourseDesign) throws MalformedURLException, IOException {
        if (!this.isActive()) {
            logger.info("Not sending course update to TracTrac because no URL has been provided.");
            return;
        }
        CourseBase newCourseDesignWithExistingControlPoints = this.replaceControlPointsByMatchingExistingControlPoints(newCourseDesign);
        JSONObject serializedCourseDesign = this.courseSerializer.serialize((Object)newCourseDesignWithExistingControlPoints);
        String payload = serializedCourseDesign.toJSONString();
        URL currentCourseDesignURL = this.buildUpdateURL();
        logger.info("Using " + this.eraseSecurityRelatedValuesFromURL(currentCourseDesignURL.toString()) + " for the course update!");
        logger.info("Payload is " + payload);
        HttpURLConnection connection = (HttpURLConnection)currentCourseDesignURL.openConnection();
        try {
            this.setConnectionPropertiesAndSendWithPayload(connection, payload);
            try {
                this.checkAndLogUpdateResponse(connection);
            }
            catch (ParseException e) {
                logger.log(Level.SEVERE, "Error trying to send course update to TracTrac", e);
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            } else {
                logger.severe("Connection to TracTrac Course Update URL " + this.eraseSecurityRelatedValuesFromURL(currentCourseDesignURL.toString()) + " could not be established");
            }
        }
    }

    protected CourseBase replaceControlPointsByMatchingExistingControlPoints(CourseBase courseDesign) {
        return courseDesign;
    }
}

