/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.common.tracking.impl.GPSFixMovingImpl;
import com.sap.sailing.domain.tracking.AddResult;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.GPSTrackListener;
import com.sap.sailing.domain.tracking.impl.TimedComparator;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Timed;
import com.sap.sse.common.impl.TimeRangeImpl;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NavigableSet;
import java.util.TreeSet;

public class CourseChangeBasedTrackApproximation
implements Serializable,
GPSTrackListener<Competitor, GPSFixMoving> {
    private static final long serialVersionUID = -258129016229111573L;
    private final GPSFixTrack<Competitor, GPSFixMoving> track;
    private final BoatClass boatClass;
    private final FixWindow fixWindow;
    private final NavigableSet<GPSFixMoving> maneuverCandidates;

    public CourseChangeBasedTrackApproximation(GPSFixTrack<Competitor, GPSFixMoving> track, BoatClass boatClass) {
        this.track = track;
        this.boatClass = boatClass;
        this.fixWindow = new FixWindow();
        this.maneuverCandidates = new TreeSet<GPSFixMoving>(TimedComparator.INSTANCE);
        track.addListener(this);
        this.addAllFixesOfTrack();
    }

    private synchronized void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    private synchronized void addAllFixesOfTrack() {
        this.track.lockForRead();
        try {
            for (GPSFixMoving fix : this.track.getFixes()) {
                this.addFix(fix);
            }
        }
        finally {
            this.track.unlockAfterRead();
        }
    }

    private void addFix(GPSFixMoving fix) {
        this.addFix(fix, this.fixWindow);
    }

    private void addFix(GPSFixMoving fix, FixWindow fixWindowToAddTo) {
        GPSFixMoving maneuverCandidate = fixWindowToAddTo.add(fix);
        if (maneuverCandidate != null) {
            this.maneuverCandidates.add(maneuverCandidate);
        }
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public synchronized void gpsFixReceived(GPSFixMoving fix, Competitor competitor, boolean firstFixInTrack, AddResult addedOrReplaced) {
        assert (competitor == this.track.getTrackedItem());
        if (this.fixWindow.isAtOrAfterFirst(fix.getTimePoint())) {
            this.addFix(fix);
        } else {
            GPSFixMoving candidateInRange;
            FixWindow outOfOrderWindow = new FixWindow();
            Duration maximumWindowLength = outOfOrderWindow.getMaximumWindowLength();
            TimeRangeImpl leftPartOfTimeRangeToReScan = new TimeRangeImpl(fix.getTimePoint().minus(maximumWindowLength), fix.getTimePoint());
            TimeRangeImpl rightPartOfTimeRangeToReScan = new TimeRangeImpl(fix.getTimePoint(), fix.getTimePoint().plus(maximumWindowLength));
            while ((candidateInRange = this.getExistingManeuverCandidateInRange((TimeRange)leftPartOfTimeRangeToReScan)) != null) {
                this.maneuverCandidates.remove(candidateInRange);
                leftPartOfTimeRangeToReScan = new TimeRangeImpl(candidateInRange.getTimePoint().minus(maximumWindowLength), candidateInRange.getTimePoint());
            }
            while ((candidateInRange = this.getExistingManeuverCandidateInRange((TimeRange)rightPartOfTimeRangeToReScan)) != null) {
                this.maneuverCandidates.remove(candidateInRange);
                rightPartOfTimeRangeToReScan = new TimeRangeImpl(candidateInRange.getTimePoint(), candidateInRange.getTimePoint().plus(maximumWindowLength));
            }
            TimeRangeImpl totalRange = new TimeRangeImpl(leftPartOfTimeRangeToReScan.from(), rightPartOfTimeRangeToReScan.to());
            ArrayList<GPSFixMoving> fixesToAdd = new ArrayList<GPSFixMoving>();
            this.track.lockForRead();
            try {
                for (GPSFixMoving reAnalysisFix : this.track.getFixes(totalRange.from(), true, totalRange.to(), true)) {
                    fixesToAdd.add(reAnalysisFix);
                }
            }
            finally {
                this.track.unlockAfterRead();
            }
            for (GPSFixMoving reAnalysisFix : fixesToAdd) {
                this.addFix(reAnalysisFix, outOfOrderWindow);
            }
            GPSFixMoving remainingCandidate = outOfOrderWindow.tryToExtractManeuverCandidate();
            if (remainingCandidate != null) {
                this.maneuverCandidates.add(remainingCandidate);
            }
        }
    }

    private GPSFixMoving getExistingManeuverCandidateInRange(TimeRange leftPartOfTimeRangeToReScan) {
        GPSFixMoving firstCandidateAtOrAfterStartOfTimeRange = this.maneuverCandidates.ceiling((GPSFixMoving)this.createDummyFix(leftPartOfTimeRangeToReScan.from()));
        Object result = leftPartOfTimeRangeToReScan.includes((Timed)firstCandidateAtOrAfterStartOfTimeRange) ? firstCandidateAtOrAfterStartOfTimeRange : null;
        return result;
    }

    private GPSFixMovingImpl createDummyFix(TimePoint timePoint) {
        return new GPSFixMovingImpl(null, timePoint, null, null);
    }

    @Override
    public void speedAveragingChanged(long oldMillisecondsOverWhichToAverage, long newMillisecondsOverWhichToAverage) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Iterable<GPSFixMoving> approximate(TimePoint from, TimePoint to) {
        Collection<GPSFixMoving> result;
        GPSFixMoving remainingCandidate;
        if (this.fixWindow.isAtOrAfterFirst(to) && (remainingCandidate = this.fixWindow.tryToExtractManeuverCandidate()) != null) {
            this.maneuverCandidates.add(remainingCandidate);
        }
        if (from.before(to)) {
            NavigableSet<GPSFixMoving> navigableSet = this.maneuverCandidates;
            synchronized (navigableSet) {
                result = new ArrayList<GPSFixMoving>(this.maneuverCandidates.subSet((GPSFixMoving)this.createDummyFix(from), true, (GPSFixMoving)this.createDummyFix(to), true));
            }
        } else {
            result = Collections.emptySet();
        }
        return result;
    }

    private class FixWindow
    implements Serializable {
        private static final long serialVersionUID = -6386675214043449110L;
        private final LinkedList<GPSFixMoving> window = new LinkedList();
        private final LinkedList<SpeedWithBearing> speedForFixesInWindow = new LinkedList();
        private final List<Double> totalCourseChangeFromBeginningOfWindow;
        private final double maneuverAngleInDegreesThreshold;
        private Duration windowDuration = Duration.NULL;
        private double absoluteMaximumTotalCourseChangeFromBeginningOfWindowInDegrees = 0.0;
        private int indexOfMaximumTotalCourseChange = -1;

        FixWindow() {
            this.maneuverAngleInDegreesThreshold = CourseChangeBasedTrackApproximation.this.boatClass.getManeuverDegreeAngleThreshold();
            Duration averageIntervalBetweenRawFixes = CourseChangeBasedTrackApproximation.this.track.getAverageIntervalBetweenRawFixes();
            this.totalCourseChangeFromBeginningOfWindow = new ArrayList<Double>((int)this.getMaximumWindowLength().divide(averageIntervalBetweenRawFixes == null ? Duration.ONE_SECOND : averageIntervalBetweenRawFixes) + 10);
        }

        private Duration getMaximumWindowLength() {
            Duration twiceTheApproximateManeuverDuration = CourseChangeBasedTrackApproximation.this.boatClass.getApproximateManeuverDuration().times(2L);
            Duration averageIntervalBetweenRawFixes = CourseChangeBasedTrackApproximation.this.track.getAverageIntervalBetweenRawFixes();
            Duration threeTimesTheDurationBetweenRawFixes = averageIntervalBetweenRawFixes == null ? null : averageIntervalBetweenRawFixes.times(3L);
            return Comparator.nullsFirst(Comparator.naturalOrder()).compare(twiceTheApproximateManeuverDuration, threeTimesTheDurationBetweenRawFixes) > 0 ? twiceTheApproximateManeuverDuration : threeTimesTheDurationBetweenRawFixes;
        }

        GPSFixMoving add(GPSFixMoving next) {
            GPSFixMoving result;
            SpeedWithBearing nextSpeed;
            assert (this.window.isEmpty() || !next.getTimePoint().before(this.window.peekFirst().getTimePoint()));
            SpeedWithBearing speedWithBearing = nextSpeed = next.isEstimatedSpeedCached() ? next.getCachedEstimatedSpeed() : CourseChangeBasedTrackApproximation.this.track.getEstimatedSpeed(next.getTimePoint());
            if (nextSpeed != null) {
                SpeedWithBearing previousSpeed;
                GPSFixMoving previous;
                int insertPosition = this.window.size();
                if (this.window.isEmpty()) {
                    previous = null;
                    previousSpeed = null;
                } else {
                    ListIterator<GPSFixMoving> previousFixIter = this.window.listIterator(this.window.size());
                    ListIterator<SpeedWithBearing> previousSpeedIter = this.speedForFixesInWindow.listIterator(this.speedForFixesInWindow.size());
                    previousSpeed = previousSpeedIter.previous();
                    while ((previous = previousFixIter.previous()).getTimePoint().after(next.getTimePoint())) {
                        --insertPosition;
                        previousSpeed = previousSpeedIter.previous();
                    }
                }
                this.window.add(insertPosition, next);
                this.speedForFixesInWindow.add(insertPosition, nextSpeed);
                if (previous != null) {
                    assert (previousSpeed != null);
                    double courseChangeBetweenPreviousAndNextInDegrees = previousSpeed.getBearing().getDifferenceTo(nextSpeed.getBearing()).getDegrees();
                    this.windowDuration = this.windowDuration.plus(previous.getTimePoint().until(next.getTimePoint()));
                    if (this.totalCourseChangeFromBeginningOfWindow.isEmpty()) {
                        this.totalCourseChangeFromBeginningOfWindow.add(courseChangeBetweenPreviousAndNextInDegrees);
                        this.absoluteMaximumTotalCourseChangeFromBeginningOfWindowInDegrees = Math.abs(courseChangeBetweenPreviousAndNextInDegrees);
                        this.indexOfMaximumTotalCourseChange = 0;
                    } else {
                        double totalCourseChangeFromBeginningOfWindowForCurrentFix = this.totalCourseChangeFromBeginningOfWindow.get(this.totalCourseChangeFromBeginningOfWindow.size() - 1) + courseChangeBetweenPreviousAndNextInDegrees;
                        this.totalCourseChangeFromBeginningOfWindow.add(totalCourseChangeFromBeginningOfWindowForCurrentFix);
                        if (Math.abs(totalCourseChangeFromBeginningOfWindowForCurrentFix) > this.absoluteMaximumTotalCourseChangeFromBeginningOfWindowInDegrees) {
                            this.absoluteMaximumTotalCourseChangeFromBeginningOfWindowInDegrees = Math.abs(totalCourseChangeFromBeginningOfWindowForCurrentFix);
                            this.indexOfMaximumTotalCourseChange = this.totalCourseChangeFromBeginningOfWindow.size() - 1;
                        }
                    }
                    if (this.windowDuration.compareTo((Object)this.getMaximumWindowLength()) > 0) {
                        result = this.tryToExtractManeuverCandidate();
                        if (result == null) {
                            while (this.windowDuration.compareTo((Object)this.getMaximumWindowLength()) > 0) {
                                this.removeFirst();
                            }
                        }
                    } else {
                        result = null;
                    }
                    assert (this.window.isEmpty() && this.totalCourseChangeFromBeginningOfWindow.isEmpty() || this.window.size() == this.totalCourseChangeFromBeginningOfWindow.size() + 1);
                } else {
                    result = null;
                }
            } else {
                result = null;
            }
            return result;
        }

        GPSFixMoving tryToExtractManeuverCandidate() {
            GPSFixMoving result = this.getManeuverCandidate();
            if (result != null) {
                while (!this.removeFirst().equals(result)) {
                }
            }
            return result;
        }

        private GPSFixMoving removeFirst() {
            assert (!this.window.isEmpty());
            GPSFixMoving removed = this.window.removeFirst();
            this.speedForFixesInWindow.removeFirst();
            this.windowDuration = this.window.isEmpty() ? Duration.NULL : this.windowDuration.minus(removed.getTimePoint().until(this.window.getFirst().getTimePoint()));
            this.absoluteMaximumTotalCourseChangeFromBeginningOfWindowInDegrees = 0.0;
            if (this.totalCourseChangeFromBeginningOfWindow.size() <= 1) {
                this.indexOfMaximumTotalCourseChange = -1;
            } else {
                double courseChangeOfFirstInDegrees = this.totalCourseChangeFromBeginningOfWindow.get(0);
                int i = 0;
                while (i < this.totalCourseChangeFromBeginningOfWindow.size() - 1) {
                    double totalCourseChangeFromBeginningOfWindowForFixAtIndex = this.totalCourseChangeFromBeginningOfWindow.get(i + 1) - courseChangeOfFirstInDegrees;
                    if (Math.abs(totalCourseChangeFromBeginningOfWindowForFixAtIndex) > this.absoluteMaximumTotalCourseChangeFromBeginningOfWindowInDegrees) {
                        this.absoluteMaximumTotalCourseChangeFromBeginningOfWindowInDegrees = Math.abs(totalCourseChangeFromBeginningOfWindowForFixAtIndex);
                        this.indexOfMaximumTotalCourseChange = i;
                    }
                    this.totalCourseChangeFromBeginningOfWindow.set(i, totalCourseChangeFromBeginningOfWindowForFixAtIndex);
                    ++i;
                }
            }
            if (!this.totalCourseChangeFromBeginningOfWindow.isEmpty()) {
                this.totalCourseChangeFromBeginningOfWindow.remove(this.totalCourseChangeFromBeginningOfWindow.size() - 1);
            } else assert (this.window.isEmpty());
            return removed;
        }

        private GPSFixMoving getManeuverCandidate() {
            GPSFixMoving result;
            if (this.absoluteMaximumTotalCourseChangeFromBeginningOfWindowInDegrees >= this.maneuverAngleInDegreesThreshold) {
                double signumOfMaximumAbsoluteCourseChange = Math.signum(this.totalCourseChangeFromBeginningOfWindow.get(this.indexOfMaximumTotalCourseChange));
                double previousTotalCourseChange = 0.0;
                double maximumAbsoluteCourseChangeInCorrectDirection = -1.0;
                int indexOfMaximumAbsoluteCourseChangeInCorrectDirection = -1;
                int i = 0;
                while (i <= this.indexOfMaximumTotalCourseChange) {
                    double currentTotalCourseChange = this.totalCourseChangeFromBeginningOfWindow.get(i);
                    double courseChange = currentTotalCourseChange - previousTotalCourseChange;
                    if (courseChange * signumOfMaximumAbsoluteCourseChange > maximumAbsoluteCourseChangeInCorrectDirection) {
                        maximumAbsoluteCourseChangeInCorrectDirection = courseChange * signumOfMaximumAbsoluteCourseChange;
                        indexOfMaximumAbsoluteCourseChangeInCorrectDirection = i;
                    }
                    previousTotalCourseChange = currentTotalCourseChange;
                    ++i;
                }
                result = this.window.get(indexOfMaximumAbsoluteCourseChangeInCorrectDirection);
            } else {
                result = null;
            }
            return result;
        }

        boolean isAtOrAfterFirst(TimePoint fix) {
            return this.window.isEmpty() || !fix.before(this.window.peekFirst().getTimePoint());
        }
    }
}

