/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.TackType;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.leaderboard.caching.LeaderboardDTOCalculationReuseCache;
import com.sap.sailing.domain.ranking.RankingMetric;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sailing.domain.tracking.WindPositionMode;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.io.Serializable;

public interface TrackedLegOfCompetitor
extends Serializable {
    public Leg getLeg();

    public Competitor getCompetitor();

    public Boat getBoat();

    public Duration getTime(TimePoint var1);

    public Distance getDistanceTraveled(TimePoint var1);

    public Distance getDistanceTraveledConsideringGateStart(TimePoint var1);

    public Distance getWindwardDistanceToGo(TimePoint var1, WindPositionMode var2);

    public Distance getWindwardDistanceToGo(TimePoint var1, WindPositionMode var2, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var3);

    public Distance getWindwardDistanceToGo(LegType var1, TimePoint var2, WindPositionMode var3, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var4);

    public Speed getAverageVelocityMadeGood(TimePoint var1);

    public Speed getAverageSpeedOverGround(TimePoint var1);

    public Distance getAverageRideHeight(TimePoint var1);

    public Util.Pair<GPSFixMoving, Speed> getMaximumSpeedOverGround(TimePoint var1);

    public Iterable<Maneuver> getManeuvers(TimePoint var1, boolean var2) throws NoWindException;

    public Integer getNumberOfTacks(TimePoint var1, boolean var2) throws NoWindException;

    public Integer getNumberOfJibes(TimePoint var1, boolean var2) throws NoWindException;

    public Integer getNumberOfPenaltyCircles(TimePoint var1, boolean var2) throws NoWindException;

    public int getRank(TimePoint var1);

    public int getRank(TimePoint var1, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var2);

    public Duration getGapToLeader(TimePoint var1, RankingMetric.RankingInfo var2, WindPositionMode var3);

    public Duration getGapToLeader(TimePoint var1, WindPositionMode var2, RankingMetric.RankingInfo var3, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var4);

    public Duration getGapToLeader(TimePoint var1, Competitor var2, RankingMetric.RankingInfo var3, WindPositionMode var4) throws NoWindException;

    public Duration getGapToLeader(TimePoint var1, Competitor var2, WindPositionMode var3, RankingMetric.RankingInfo var4, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var5);

    public boolean hasStartedLeg(TimePoint var1);

    public boolean hasFinishedLeg(TimePoint var1);

    public TimePoint getStartTime();

    public TimePoint getFinishTime();

    public Speed getVelocityMadeGood(TimePoint var1, WindPositionMode var2);

    public SpeedWithBearing getVelocityMadeGood(TimePoint var1, WindPositionMode var2, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var3);

    public Duration getEstimatedTimeToNextMark(TimePoint var1, WindPositionMode var2);

    public Duration getEstimatedTimeToNextMark(TimePoint var1, WindPositionMode var2, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var3);

    public SpeedWithBearing getSpeedOverGround(TimePoint var1);

    public Distance getRideHeight(TimePoint var1);

    public Bearing getHeel(TimePoint var1);

    public Bearing getPitch(TimePoint var1);

    public Distance getDistanceFoiled(TimePoint var1);

    public Duration getDurationFoiled(TimePoint var1);

    public Distance getWindwardDistanceToCompetitorFarthestAhead(TimePoint var1, WindPositionMode var2, RankingMetric.RankingInfo var3);

    public Distance getWindwardDistanceToCompetitorFarthestAhead(TimePoint var1, WindPositionMode var2, RankingMetric.RankingInfo var3, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var4);

    public Distance getAverageAbsoluteCrossTrackError(TimePoint var1, boolean var2);

    public Distance getAbsoluteCrossTrackError(TimePoint var1);

    public Distance getAverageSignedCrossTrackError(TimePoint var1, boolean var2);

    public Distance getSignedCrossTrackError(TimePoint var1);

    public Distance getUnsignedCrossTrackErrorToWindAxis(TimePoint var1);

    public Distance getSignedCrossTrackErrorToWindAxis(TimePoint var1);

    public TrackedLeg getTrackedLeg();

    public Speed getAverageVelocityMadeGood(TimePoint var1, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var2);

    public TimePoint getTimePointNotAfterFinishingOfLeg(TimePoint var1);

    public TackType getTackType(TimePoint var1, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var2) throws NoWindException;

    default public TackType getTackType(TimePoint timePoint) throws NoWindException {
        return this.getTackType(timePoint, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    public Double getExpeditionAWA(TimePoint var1);

    public Double getExpeditionAWS(TimePoint var1);

    public Double getExpeditionTWA(TimePoint var1);

    public Double getExpeditionTWS(TimePoint var1);

    public Double getExpeditionTWD(TimePoint var1);

    public Double getExpeditionTargTWA(TimePoint var1);

    public Double getExpeditionBoatSpeed(TimePoint var1);

    public Double getExpeditionTargBoatSpeed(TimePoint var1);

    public Double getExpeditionSOG(TimePoint var1);

    public Double getExpeditionCOG(TimePoint var1);

    public Double getExpeditionForestayLoad(TimePoint var1);

    public Double getExpeditionRake(TimePoint var1);

    public Double getExpeditionCourseDetail(TimePoint var1);

    public Double getExpeditionHeading(TimePoint var1);

    public Double getExpeditionVMG(TimePoint var1);

    public Double getExpeditionVMGTargVMGDelta(TimePoint var1);

    public Double getExpeditionRateOfTurn(TimePoint var1);

    public Double getExpeditionRudderAngle(TimePoint var1);

    public Double getExpeditionTargetHeel(TimePoint var1);

    public Double getExpeditionTimeToPortLayline(TimePoint var1);

    public Double getExpeditionTimeToStbLayline(TimePoint var1);

    public Double getExpeditionDistToPortLayline(TimePoint var1);

    public Double getExpeditionDistToStbLayline(TimePoint var1);

    public Double getExpeditionTimeToGunInSeconds(TimePoint var1);

    public Double getExpeditionTimeToCommitteeBoat(TimePoint var1);

    public Double getExpeditionTimeToPin(TimePoint var1);

    public Double getExpeditionTimeToBurnToLineInSeconds(TimePoint var1);

    public Double getExpeditionTimeToBurnToCommitteeBoat(TimePoint var1);

    public Double getExpeditionTimeToBurnToPin(TimePoint var1);

    public Double getExpeditionDistanceToCommitteeBoat(TimePoint var1);

    public Double getExpeditionDistanceToPinDetail(TimePoint var1);

    public Double getExpeditionDistanceBelowLineInMeters(TimePoint var1);

    public Double getExpeditionLineSquareForWindDirection(TimePoint var1);

    public Double getExpeditionBaroIfAvailable(TimePoint var1);

    public Double getExpeditionLoadSIfAvailable(TimePoint var1);

    public Double getExpeditionLoadPIfAvailable(TimePoint var1);

    public Double getExpeditionJibCarPortIfAvailable(TimePoint var1);

    public Double getExpeditionJibCarStbdIfAvailable(TimePoint var1);

    public Double getExpeditionMastButtIfAvailable(TimePoint var1);

    public Double getExpeditionKickerTensionIfAvailable(TimePoint var1);

    public Double getAverageExpeditionAWA(TimePoint var1);

    public Double getAverageExpeditionAWS(TimePoint var1);

    public Double getAverageExpeditionTWA(TimePoint var1);

    public Double getAverageExpeditionTWS(TimePoint var1);

    public Double getAverageExpeditionTWD(TimePoint var1);

    public Double getAverageExpeditionTargTWA(TimePoint var1);

    public Double getAverageExpeditionBoatSpeed(TimePoint var1);

    public Double getAverageExpeditionTargBoatSpeed(TimePoint var1);

    public Double getAverageExpeditionSOG(TimePoint var1);

    public Double getAverageExpeditionCOG(TimePoint var1);

    public Double getAverageExpeditionForestayLoad(TimePoint var1);

    public Double getAverageExpeditionRake(TimePoint var1);

    public Double getAverageExpeditionCourseDetail(TimePoint var1);

    public Double getAverageExpeditionHeading(TimePoint var1);

    public Double getAverageExpeditionVMG(TimePoint var1);

    public Double getAverageExpeditionVMGTargVMGDelta(TimePoint var1);

    public Double getAverageExpeditionRateOfTurn(TimePoint var1);

    public Double getAverageExpeditionRudderAngle(TimePoint var1);

    public Double getAverageExpeditionTargetHeel(TimePoint var1);

    public Double getAverageExpeditionTimeToPortLayline(TimePoint var1);

    public Double getAverageExpeditionTimeToStbLayline(TimePoint var1);

    public Double getAverageExpeditionDistToPortLayline(TimePoint var1);

    public Double getAverageExpeditionDistToStbLayline(TimePoint var1);

    public Double getAverageExpeditionTimeToGunInSeconds(TimePoint var1);

    public Double getAverageExpeditionTimeToCommitteeBoat(TimePoint var1);

    public Double getAverageExpeditionTimeToPin(TimePoint var1);

    public Double getAverageExpeditionTimeToBurnToLineInSeconds(TimePoint var1);

    public Double getAverageExpeditionTimeToBurnToCommitteeBoat(TimePoint var1);

    public Double getAverageExpeditionTimeToBurnToPin(TimePoint var1);

    public Double getAverageExpeditionDistanceToCommitteeBoat(TimePoint var1);

    public Double getAverageExpeditionDistanceToPinDetail(TimePoint var1);

    public Double getAverageExpeditionDistanceBelowLineInMeters(TimePoint var1);

    public Double getAverageExpeditionLineSquareForWindDirection(TimePoint var1);

    public Double getAverageExpeditionBaroIfAvailable(TimePoint var1);

    public Double getAverageExpeditionLoadSIfAvailable(TimePoint var1);

    public Double getAverageExpeditionLoadPIfAvailable(TimePoint var1);

    public Double getAverageExpeditionJibCarPortIfAvailable(TimePoint var1);

    public Double getAverageExpeditionJibCarStbdIfAvailable(TimePoint var1);

    public Double getAverageExpeditionMastButtIfAvailable(TimePoint var1);

    public Double getAverageExpeditionKickerTensionIfAvailable(TimePoint var1);
}

