/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorAndBoatStore;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Sideline;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.domain.base.impl.DynamicCompetitorWithBoat;
import com.sap.sailing.domain.base.impl.DynamicTeam;
import com.sap.sailing.domain.base.impl.RaceDefinitionImpl;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprintRegistry;
import com.sap.sailing.domain.racelog.RaceLogAndTrackedRaceResolver;
import com.sap.sailing.domain.tracking.DynamicRaceDefinitionSet;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.TrackedRegatta;
import com.sap.sailing.domain.tracking.TrackingConnectorInfo;
import com.sap.sailing.domain.tracking.WindStore;
import com.sap.sse.common.Color;
import com.sap.sse.common.Duration;
import com.sap.sse.util.ThreadLocalTransporter;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import java.util.Optional;

public interface RaceTrackingHandler {
    public DynamicTrackedRace createTrackedRace(TrackedRegatta var1, RaceDefinition var2, Iterable<Sideline> var3, WindStore var4, long var5, long var7, long var9, DynamicRaceDefinitionSet var11, boolean var12, RaceLogAndTrackedRaceResolver var13, Optional<ThreadLocalTransporter> var14, TrackingConnectorInfo var15, MarkPassingRaceFingerprintRegistry var16);

    public DynamicCompetitor getOrCreateCompetitor(CompetitorAndBoatStore var1, Serializable var2, String var3, String var4, Color var5, String var6, URI var7, DynamicTeam var8, Double var9, Duration var10, String var11);

    public RaceDefinition createRaceDefinition(Regatta var1, String var2, Course var3, BoatClass var4, Map<Competitor, Boat> var5, Serializable var6);

    public DynamicCompetitorWithBoat getOrCreateCompetitorWithBoat(CompetitorAndBoatStore var1, Serializable var2, String var3, String var4, Color var5, String var6, URI var7, DynamicTeam var8, Double var9, Duration var10, String var11, DynamicBoat var12);

    public DynamicBoat getOrCreateBoat(CompetitorAndBoatStore var1, Serializable var2, String var3, BoatClass var4, String var5, Color var6);

    public static class DefaultRaceTrackingHandler
    implements RaceTrackingHandler {
        @Override
        public DynamicTrackedRace createTrackedRace(TrackedRegatta trackedRegatta, RaceDefinition raceDefinition, Iterable<Sideline> sidelines, WindStore windStore, long delayToLiveInMillis, long millisecondsOverWhichToAverageWind, long millisecondsOverWhichToAverageSpeed, DynamicRaceDefinitionSet raceDefinitionSetToUpdate, boolean useMarkPassingCalculator, RaceLogAndTrackedRaceResolver raceLogResolver, Optional<ThreadLocalTransporter> threadLocalTransporter, TrackingConnectorInfo trackingConnectorInfo, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry) {
            return trackedRegatta.createTrackedRace(raceDefinition, sidelines, windStore, delayToLiveInMillis, millisecondsOverWhichToAverageWind, millisecondsOverWhichToAverageSpeed, raceDefinitionSetToUpdate, useMarkPassingCalculator, raceLogResolver, threadLocalTransporter, trackingConnectorInfo, markPassingRaceFingerprintRegistry);
        }

        @Override
        public RaceDefinition createRaceDefinition(Regatta regatta, String name, Course course, BoatClass boatClass, Map<Competitor, Boat> competitorsAndTheirBoats, Serializable id) {
            return new RaceDefinitionImpl(name, course, boatClass, competitorsAndTheirBoats, id);
        }

        @Override
        public DynamicCompetitor getOrCreateCompetitor(CompetitorAndBoatStore competitorStore, Serializable competitorId, String name, String shortName, Color displayColor, String email, URI flagImageURI, DynamicTeam team, Double timeOnTimeFactor, Duration timeOnDistanceAllowancePerNauticalMile, String searchTag) {
            return competitorStore.getOrCreateCompetitor(competitorId, name, shortName, displayColor, email, flagImageURI, team, timeOnTimeFactor, timeOnDistanceAllowancePerNauticalMile, searchTag, true);
        }

        @Override
        public DynamicCompetitorWithBoat getOrCreateCompetitorWithBoat(CompetitorAndBoatStore competitorStore, Serializable competitorId, String name, String shortName, Color displayColor, String email, URI flagImageURI, DynamicTeam team, Double timeOnTimeFactor, Duration timeOnDistanceAllowancePerNauticalMile, String searchTag, DynamicBoat boat) {
            return competitorStore.getOrCreateCompetitorWithBoat(competitorId, name, shortName, displayColor, email, flagImageURI, team, timeOnTimeFactor, timeOnDistanceAllowancePerNauticalMile, searchTag, boat, true);
        }

        @Override
        public DynamicBoat getOrCreateBoat(CompetitorAndBoatStore competitorAndBoatStore, Serializable id, String name, BoatClass boatClass, String sailId, Color color) {
            return competitorAndBoatStore.getOrCreateBoat(id, name, boatClass, sailId, color, true);
        }
    }
}

