/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.ranking;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.common.RankingMetrics;
import com.sap.sailing.domain.leaderboard.caching.LeaderboardDTOCalculationReuseCache;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Timed;
import java.io.Serializable;
import java.util.Comparator;
import java.util.function.Function;

public interface RankingMetric
extends Serializable {
    public TrackedRace getTrackedRace();

    public RankingMetrics getType();

    default public Comparator<Competitor> getRaceRankingComparator(TimePoint timePoint) {
        return this.getRaceRankingComparator(timePoint, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    public Comparator<Competitor> getRaceRankingComparator(TimePoint var1, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var2);

    public Comparator<TrackedLegOfCompetitor> getLegRankingComparator(TrackedLeg var1, TimePoint var2, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var3);

    public Duration getActualTimeSinceStartOfRace(Competitor var1, TimePoint var2);

    default public Duration getCorrectedTime(Competitor competitor, TimePoint timePoint) {
        return this.getCorrectedTime(competitor, timePoint, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    public Duration getCorrectedTime(Competitor var1, TimePoint var2, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var3);

    default public Duration getGapToLeaderInOwnTime(RankingInfo rankingInfo, Competitor competitor) {
        return this.getGapToLeaderInOwnTime(rankingInfo, competitor, (WindLegTypeAndLegBearingAndORCPerformanceCurveCache)new LeaderboardDTOCalculationReuseCache(rankingInfo.getTimePoint()));
    }

    default public Duration getGapToLeaderInOwnTime(Competitor competitor, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return this.getGapToLeaderInOwnTime(this.getRankingInfo(timePoint, cache), competitor, cache);
    }

    default public Duration getGapToLeaderInOwnTime(Competitor competitor, TimePoint timePoint) {
        return this.getGapToLeaderInOwnTime(competitor, timePoint, (WindLegTypeAndLegBearingAndORCPerformanceCurveCache)new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    default public RankingInfo getRankingInfo(TimePoint timePoint) {
        return this.getRankingInfo(timePoint, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    public RankingInfo getRankingInfo(TimePoint var1, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var2);

    public Duration getGapToLeaderInOwnTime(RankingInfo var1, Competitor var2, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var3);

    public Duration getLegGapToLegLeaderInOwnTime(TrackedLegOfCompetitor var1, TimePoint var2, RankingInfo var3, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var4);

    public Speed getReferenceImpliedWind(TimePoint var1, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var2);

    public static interface CompetitorRankingInfo
    extends Timed,
    Serializable {
        public TimePoint getTimePoint();

        public Competitor getCompetitor();

        public Distance getWindwardDistanceSailed();

        public Duration getDurationSinceStartOfRaceUntilTimePoint();

        public Duration getTimeElapsed();

        public Duration getCorrectedTime();

        public Duration getEstimatedActualDurationFromTimePointToCompetitorFarthestAhead();

        default public Duration getEstimatedActualDurationFromRaceStartToCompetitorFarthestAhead() {
            Duration estimatedActualDurationFromTimePointToCompetitorFarthestAhead = this.getEstimatedActualDurationFromTimePointToCompetitorFarthestAhead();
            Duration actualTime = this.getDurationSinceStartOfRaceUntilTimePoint();
            return actualTime == null ? null : (estimatedActualDurationFromTimePointToCompetitorFarthestAhead == null ? null : actualTime.plus(estimatedActualDurationFromTimePointToCompetitorFarthestAhead));
        }

        public Duration getCorrectedTimeAtEstimatedArrivalAtCompetitorFarthestAhead();
    }

    public static interface RankingInfo
    extends Timed,
    Serializable {
        public TimePoint getTimePoint();

        public Function<Competitor, CompetitorRankingInfo> getCompetitorRankingInfo();

        public Competitor getCompetitorFarthestAhead();

        public Competitor getLeaderByCorrectedEstimatedTimeToCompetitorFarthestAhead();

        public Competitor getCompetitorFarthestAheadInLeg(Leg var1, TimePoint var2, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var3);
    }

    public static interface RankingInfoWithLegLeader
    extends RankingInfo {
        public Competitor getLeaderInLegByCalculatedTime(Leg var1, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var2);
    }
}

