/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.orc.impl;

import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.domain.common.orc.ORCCertificate;
import com.sap.sailing.domain.common.orc.impl.ORCCertificateImpl;
import com.sap.sailing.domain.orc.impl.AbstractORCCertificatesCollection;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.CountryCode;
import com.sap.sse.common.CountryCodeFactory;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.impl.SecondsDurationImpl;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ORCCertificatesCollectionRMS
extends AbstractORCCertificatesCollection {
    private static final String TWA_COURSES = "R";
    private static final String CDL = "CDL";
    private static final String GPH = "GPH";
    private static final String LENGTH = "LOA";
    private static final String BOATNAME = "NAME";
    private static final String SAILNUMBER = "SAILNUMB";
    private static final String BOATCLASS = "TYPE";
    static final String ISSUEDATE = "DD_MM_yyYY";
    static final String LOA = "LOA";
    private static final String ISSUETIME = "HH:MM:SS";
    private static final String RUN_ALLOWANCE = "D";
    private static final String RUN_ANGLE = "DA";
    private static final String BEAT_ALLOWANCE = "UP";
    private static final String BEAT_ANGLE = "UA";
    private static final String WINDWARD_LEEWARD = "WL";
    private static final String LONG_DISTANCE = "OC";
    private static final String CIRCULAR_RANDOM = "CR";
    private static final String NON_SPINNAKER = "NSP";
    private static final String ISSUING_NATIONAL_AUTHORITY = "NAT";
    private static final String CERTIFICATE_NUMBER = "CERTN";
    private static final String NATCERTN = "NATCERTN";
    private static final String FILE_ID = "FILE_ID";
    private static final String NATCERTN_FILE_ID = "NATCERTN.FILE_ID";
    static final String REFERENCE_NUMBER = "ReferenceNo";
    private static final DateFormat timestampFormat = new SimpleDateFormat("dd MM yyyy HH:mm:ssZ");
    private final Map<String, Map<String, String>> certificateValuesByCertificateId = new HashMap<String, Map<String, String>>();

    public ORCCertificatesCollectionRMS(Map<String, Map<String, String>> certificateValuesByCertificateId) throws IOException {
        for (Map.Entry<String, Map<String, String>> e : certificateValuesByCertificateId.entrySet()) {
            this.certificateValuesByCertificateId.put(this.canonicalizeId(e.getKey()), e.getValue());
        }
    }

    public Set<String> getSailnumbers() {
        return Collections.unmodifiableSet(this.certificateValuesByCertificateId.keySet());
    }

    private ORCCertificateValues getValuesForCertificateId(String certificateId) {
        return this.certificateValuesByCertificateId.containsKey(this.canonicalizeId(certificateId)) ? new ORCCertificateValues(certificateId) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORCCertificate getCertificateById(String certificateId) {
        ORCCertificateImpl result;
        ORCCertificateValues certificateValues = this.getValuesForCertificateId(certificateId);
        if (certificateValues == null) {
            result = null;
        } else {
            MillisecondsTimePoint issueDate;
            String refNo = certificateValues.getValue(REFERENCE_NUMBER);
            String sailNumber = certificateValues.getValue(SAILNUMBER);
            String boatclass = certificateValues.getValue(BOATCLASS);
            String boatName = certificateValues.getValue(BOATNAME);
            MeterDistance length = new MeterDistance(Double.parseDouble(certificateValues.getValue("LOA")));
            SecondsDurationImpl gph = new SecondsDurationImpl(Double.parseDouble(certificateValues.getValue(GPH)));
            Double cdl = Double.parseDouble(certificateValues.getValue(CDL));
            String dateString = certificateValues.getValue(ISSUEDATE);
            String timeString = certificateValues.getValue(ISSUETIME);
            try {
                DateFormat dateFormat = timestampFormat;
                synchronized (dateFormat) {
                    issueDate = new MillisecondsTimePoint(timestampFormat.parse(String.valueOf(dateString) + " " + timeString + "+0000"));
                }
            }
            catch (ParseException e) {
                issueDate = null;
            }
            HashMap velocityPredictionsPerTrueWindSpeedAndAngle = new HashMap();
            HashMap<Speed, DegreeBearingImpl> beatAngles = new HashMap<Speed, DegreeBearingImpl>();
            HashMap<Speed, Speed> beatVMGPredictionPerTrueWindSpeed = new HashMap<Speed, Speed>();
            HashMap<Speed, SecondsDurationImpl> beatAllowancePerTrueWindSpeed = new HashMap<Speed, SecondsDurationImpl>();
            HashMap<Speed, DegreeBearingImpl> runAngles = new HashMap<Speed, DegreeBearingImpl>();
            HashMap<Speed, Speed> runVMGPredictionPerTrueWindSpeed = new HashMap<Speed, Speed>();
            HashMap<Speed, SecondsDurationImpl> runAllowancePerTrueWindSpeed = new HashMap<Speed, SecondsDurationImpl>();
            HashMap<Speed, Speed> windwardLeewardSpeedPredictionPerTrueWindSpeed = new HashMap<Speed, Speed>();
            HashMap<Speed, Speed> longDistanceSpeedPredictionPerTrueWindSpeed = new HashMap<Speed, Speed>();
            HashMap<Speed, Speed> circularRandomSpeedPredictionPerTrueWindSpeed = new HashMap<Speed, Speed>();
            HashMap<Speed, Speed> nonSpinnakerSpeedPredictionPerTrueWindSpeed = new HashMap<Speed, Speed>();
            Speed[] speedArray = ORCCertificate.ALLOWANCES_TRUE_WIND_SPEEDS;
            int n = ORCCertificate.ALLOWANCES_TRUE_WIND_SPEEDS.length;
            int n2 = 0;
            while (n2 < n) {
                Speed tws = speedArray[n2];
                String windSpeed = Integer.toString((int)tws.getKnots());
                String beatAngleKey = BEAT_ANGLE + windSpeed;
                String beatAllowanceKey = BEAT_ALLOWANCE + windSpeed;
                String runAngleKey = RUN_ANGLE + windSpeed;
                String runAllowanceKey = RUN_ALLOWANCE + windSpeed;
                String windwardLeewardKey = WINDWARD_LEEWARD + windSpeed;
                String longDistanceKey = LONG_DISTANCE + windSpeed;
                String circularRandomKey = CIRCULAR_RANDOM + windSpeed;
                String nonSpinnakerKey = NON_SPINNAKER + windSpeed;
                beatAngles.put(tws, new DegreeBearingImpl(Double.parseDouble(certificateValues.getValue(beatAngleKey))));
                beatAllowancePerTrueWindSpeed.put(tws, new SecondsDurationImpl(Double.parseDouble(certificateValues.getValue(beatAllowanceKey))));
                beatVMGPredictionPerTrueWindSpeed.put(tws, ORCCertificate.NAUTICAL_MILE.inTime((Duration)beatAllowancePerTrueWindSpeed.get(tws)));
                runAngles.put(tws, new DegreeBearingImpl(Double.parseDouble(certificateValues.getValue(runAngleKey))));
                runAllowancePerTrueWindSpeed.put(tws, new SecondsDurationImpl(Double.parseDouble(certificateValues.getValue(runAllowanceKey))));
                runVMGPredictionPerTrueWindSpeed.put(tws, ORCCertificate.NAUTICAL_MILE.inTime((Duration)runAllowancePerTrueWindSpeed.get(tws)));
                windwardLeewardSpeedPredictionPerTrueWindSpeed.put(tws, ORCCertificate.NAUTICAL_MILE.inTime((Duration)new SecondsDurationImpl(Double.parseDouble(certificateValues.getValue(windwardLeewardKey)))));
                longDistanceSpeedPredictionPerTrueWindSpeed.put(tws, ORCCertificate.NAUTICAL_MILE.inTime((Duration)new SecondsDurationImpl(Double.parseDouble(certificateValues.getValue(longDistanceKey)))));
                circularRandomSpeedPredictionPerTrueWindSpeed.put(tws, ORCCertificate.NAUTICAL_MILE.inTime((Duration)new SecondsDurationImpl(Double.parseDouble(certificateValues.getValue(circularRandomKey)))));
                nonSpinnakerSpeedPredictionPerTrueWindSpeed.put(tws, ORCCertificate.NAUTICAL_MILE.inTime((Duration)new SecondsDurationImpl(Double.parseDouble(certificateValues.getValue(nonSpinnakerKey)))));
                HashMap<Bearing, Speed> velocityPredictionPerTrueWindAngle = new HashMap<Bearing, Speed>();
                Bearing[] bearingArray = ORCCertificate.ALLOWANCES_TRUE_WIND_ANGLES;
                int n3 = ORCCertificate.ALLOWANCES_TRUE_WIND_ANGLES.length;
                int n4 = 0;
                while (n4 < n3) {
                    Bearing twa = bearingArray[n4];
                    String twaCoursesKey = TWA_COURSES + Integer.toString((int)twa.getDegrees()) + windSpeed;
                    velocityPredictionPerTrueWindAngle.put(twa, ORCCertificate.NAUTICAL_MILE.inTime((Duration)new SecondsDurationImpl(Double.parseDouble(certificateValues.getValue(twaCoursesKey)))));
                    ++n4;
                }
                velocityPredictionsPerTrueWindSpeedAndAngle.put(tws, velocityPredictionPerTrueWindAngle);
                ++n2;
            }
            Util.Triple<CountryCode, String, String> natCertNoFileId = this.getIssuingNationalityCertificateNumberAndFileId(certificateValues.getValue(NATCERTN_FILE_ID));
            result = new ORCCertificateImpl(refNo, (String)natCertNoFileId.getC(), sailNumber, boatName, boatclass, (Distance)length, (Duration)gph, cdl, (TimePoint)issueDate, (CountryCode)natCertNoFileId.getA(), velocityPredictionsPerTrueWindSpeedAndAngle, beatAngles, beatVMGPredictionPerTrueWindSpeed, beatAllowancePerTrueWindSpeed, runAngles, runVMGPredictionPerTrueWindSpeed, runAllowancePerTrueWindSpeed, windwardLeewardSpeedPredictionPerTrueWindSpeed, longDistanceSpeedPredictionPerTrueWindSpeed, circularRandomSpeedPredictionPerTrueWindSpeed, nonSpinnakerSpeedPredictionPerTrueWindSpeed);
        }
        return result;
    }

    private Util.Triple<CountryCode, String, String> getIssuingNationalityCertificateNumberAndFileId(String natCertFileId) {
        CountryCode nationalityIOCCode = CountryCodeFactory.INSTANCE.getFromThreeLetterIOCName(natCertFileId.substring(0, ISSUING_NATIONAL_AUTHORITY.length()));
        String certNo = natCertFileId.substring(ISSUING_NATIONAL_AUTHORITY.length(), ISSUING_NATIONAL_AUTHORITY.length() + CERTIFICATE_NUMBER.length()).trim();
        String fileId = natCertFileId.substring(NATCERTN.length() + ".".length()).trim();
        return new Util.Triple((Object)nationalityIOCCode, (Object)certNo, (Object)fileId);
    }

    @Override
    public Iterable<String> getCertificateIds() {
        return Collections.unmodifiableCollection(this.certificateValuesByCertificateId.keySet());
    }

    public class ORCCertificateValues {
        private final String certificateId;

        public ORCCertificateValues(String certificateId) {
            this.certificateId = ORCCertificatesCollectionRMS.this.canonicalizeId(certificateId);
        }

        public String getValue(String columnName) {
            return (String)((Map)ORCCertificatesCollectionRMS.this.certificateValuesByCertificateId.get(this.certificateId)).get(columnName);
        }
    }
}

