/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.orc.impl;

import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.domain.common.orc.ORCCertificate;
import com.sap.sailing.domain.common.orc.impl.ORCCertificateImpl;
import com.sap.sailing.domain.orc.impl.AbstractORCCertificatesCollection;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.CountryCodeFactory;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.impl.SecondsDurationImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ORCCertificatesCollectionJSON
extends AbstractORCCertificatesCollection {
    private static final String GYBE_ANGLE = "GybeAngle";
    private static final String BEAT_ANGLE = "BeatAngle";
    private static final String ALLOWANCES = "Allowances";
    private static final String ISSUE_DATE = "IssueDate";
    private static final String CDL2 = "CDL";
    private static final String GPH2 = "GPH";
    private static final String CLASS = "Class";
    private static final String YACHT_NAME = "YachtName";
    private static final String LOA = "LOA";
    private static final String SAIL_NO = "SailNo";
    private static final String BIN = "BIN";
    private static final String NAT_AUTH = "NatAuth";
    private static final String REFERENCE_NUMBER = "RefNo";
    private static final String RUN = "Run";
    private static final String BEAT = "Beat";
    private static final String WINDWARD_LEEWARD = "WL";
    private static final String LONG_DISTANCE = "OC";
    private static final String CIRCULAR_RANDOM = "CR";
    private static final String NON_SPINNAKER = "NS";
    private static final String WIND_SPEEDS = "WindSpeeds";
    private static final String WIND_ANGLES = "WindAngles";
    private static final Pattern twaPattern = Pattern.compile("R(\\d+(\\.\\d+)?)");
    private Map<String, JSONObject> certificateJsonObjectsByCertificateId = new HashMap<String, JSONObject>();

    public ORCCertificatesCollectionJSON(Iterable<JSONObject> data) {
        for (JSONObject o : data) {
            if (this.certificateJsonObjectsByCertificateId.put(this.canonicalizeId(this.getId(o)), o) == null) continue;
            throw new IllegalArgumentException("Certificate ID in collection not unique: " + this.getId(o));
        }
    }

    @Override
    public ORCCertificate getCertificateById(String certificateId) {
        ORCCertificateImpl result;
        block64: {
            JSONObject object;
            TreeMap<Double, DegreeBearingImpl> trueWindAngleMap;
            TreeMap<Object, Object> trueWindSpeedMap;
            HashMap<String, Map<Speed, Duration>> predefinedAllowanceDurationsPerTrueWindSpeed;
            HashMap allowanceDurationsPerTrueWindAngleAndSpeed;
            HashMap velocityPredictionPerTrueWindSpeedAndAngle;
            HashMap<KnotSpeedImpl, DegreeBearingImpl> gybeAngles;
            HashMap<KnotSpeedImpl, DegreeBearingImpl> beatAngles;
            MillisecondsTimePoint issueDate;
            Double cdl;
            SecondsDurationImpl gph;
            MeterDistance length;
            String boatclass;
            String boatName;
            String fileId;
            String natAuth;
            String refNo;
            block63: {
                refNo = null;
                natAuth = null;
                fileId = null;
                boatName = null;
                boatclass = null;
                length = null;
                gph = null;
                cdl = null;
                issueDate = null;
                beatAngles = new HashMap<KnotSpeedImpl, DegreeBearingImpl>();
                gybeAngles = new HashMap<KnotSpeedImpl, DegreeBearingImpl>();
                velocityPredictionPerTrueWindSpeedAndAngle = new HashMap();
                allowanceDurationsPerTrueWindAngleAndSpeed = new HashMap();
                predefinedAllowanceDurationsPerTrueWindSpeed = new HashMap<String, Map<Speed, Duration>>();
                trueWindSpeedMap = new TreeMap<Object, Object>();
                trueWindAngleMap = new TreeMap<Double, DegreeBearingImpl>();
                object = this.certificateJsonObjectsByCertificateId.get(this.canonicalizeId(certificateId));
                if (object != null) break block63;
                result = null;
                break block64;
            }
            String sailNumber = null;
            block33: for (Map.Entry entry : object.entrySet()) {
                switch ((String)entry.getKey()) {
                    case "RefNo": {
                        refNo = entry.getValue() == null ? null : entry.getValue().toString();
                        break;
                    }
                    case "NatAuth": {
                        natAuth = entry.getValue() == null ? null : entry.getValue().toString();
                        break;
                    }
                    case "BIN": {
                        fileId = entry.getValue() == null ? null : entry.getValue().toString();
                        break;
                    }
                    case "SailNo": {
                        sailNumber = entry.getValue() == null ? null : entry.getValue().toString();
                        break;
                    }
                    case "LOA": {
                        length = entry.getValue() == null ? null : new MeterDistance(((Number)entry.getValue()).doubleValue());
                        break;
                    }
                    case "YachtName": {
                        boatName = entry.getValue() == null ? null : entry.getValue().toString();
                        break;
                    }
                    case "Class": {
                        boatclass = (String)entry.getValue();
                        break;
                    }
                    case "GPH": {
                        gph = entry.getValue() == null ? null : new SecondsDurationImpl(((Number)entry.getValue()).doubleValue());
                        break;
                    }
                    case "CDL": {
                        cdl = entry.getValue() == null ? null : Double.valueOf(((Number)entry.getValue()).doubleValue());
                        break;
                    }
                    case "IssueDate": {
                        Date date = DatatypeConverter.parseDateTime((String)((String)entry.getValue())).getTime();
                        issueDate = new MillisecondsTimePoint(date);
                        break;
                    }
                    case "Allowances": {
                        Object twsValue;
                        JSONObject allowances = (JSONObject)entry.getValue();
                        Object windSpeedsObject = allowances.get((Object)WIND_SPEEDS);
                        if (windSpeedsObject != null) {
                            JSONArray twsArray = (JSONArray)windSpeedsObject;
                            for (Object twsObject : twsArray) {
                                twsValue = ((Number)twsObject).doubleValue();
                                trueWindSpeedMap.put(twsValue, new KnotSpeedImpl(((Double)twsValue).doubleValue()));
                            }
                        } else {
                            twsValue = ORCCertificate.ALLOWANCES_TRUE_WIND_SPEEDS;
                            int n = ORCCertificate.ALLOWANCES_TRUE_WIND_SPEEDS.length;
                            int twsObject = 0;
                            while (twsObject < n) {
                                Speed speed = twsValue[twsObject];
                                trueWindSpeedMap.put(speed.getKnots(), speed);
                                ++twsObject;
                            }
                        }
                        Double[] trueWindSpeedArray = new Double[trueWindSpeedMap.size()];
                        trueWindSpeedMap.keySet().toArray(trueWindSpeedArray);
                        for (Object aKey : allowances.keySet()) {
                            String keyString = (String)aKey;
                            Matcher matcher = twaPattern.matcher(keyString);
                            if (!matcher.lookingAt()) continue;
                            JSONArray array = (JSONArray)allowances.get((Object)keyString);
                            HashMap<Speed, SecondsDurationImpl> twsMap = new HashMap<Speed, SecondsDurationImpl>();
                            int i = 0;
                            while (i < array.size()) {
                                Double allowanceValue = ((Number)array.get(i)).doubleValue();
                                twsMap.put((Speed)trueWindSpeedMap.get(trueWindSpeedArray[i]), new SecondsDurationImpl(allowanceValue.doubleValue()));
                                ++i;
                            }
                            Double trueWindAngleValue = Double.parseDouble(matcher.group(1));
                            trueWindAngleMap.put(trueWindAngleValue, new DegreeBearingImpl(trueWindAngleValue.doubleValue()));
                            allowanceDurationsPerTrueWindAngleAndSpeed.put((Bearing)trueWindAngleMap.get(trueWindAngleValue), twsMap);
                        }
                        for (Object aKey : allowances.keySet()) {
                            JSONArray twaArray = (JSONArray)allowances.get(aKey);
                            if (((String)aKey).equals(BEAT_ANGLE)) {
                                int i = 0;
                                while (i < twaArray.size()) {
                                    beatAngles.put(new KnotSpeedImpl(trueWindSpeedArray[i].doubleValue()), new DegreeBearingImpl(((Number)twaArray.get(i)).doubleValue()));
                                    ++i;
                                }
                                continue;
                            }
                            if (((String)aKey).equals(GYBE_ANGLE)) {
                                int i = 0;
                                while (i < twaArray.size()) {
                                    gybeAngles.put(new KnotSpeedImpl(trueWindSpeedArray[i].doubleValue()), new DegreeBearingImpl(((Number)twaArray.get(i)).doubleValue()));
                                    ++i;
                                }
                                continue;
                            }
                            HashMap<KnotSpeedImpl, SecondsDurationImpl> twsMap = new HashMap<KnotSpeedImpl, SecondsDurationImpl>();
                            if (!(aKey.equals(WIND_SPEEDS) || aKey.equals(WIND_ANGLES) || twaPattern.matcher((String)aKey).lookingAt())) {
                                int i = 0;
                                while (i < twaArray.size()) {
                                    twsMap.put(new KnotSpeedImpl(trueWindSpeedArray[i].doubleValue()), new SecondsDurationImpl(((Number)twaArray.get(i)).doubleValue()));
                                    ++i;
                                }
                            }
                            switch ((String)aKey) {
                                case "Run": 
                                case "Beat": {
                                    predefinedAllowanceDurationsPerTrueWindSpeed.put((String)aKey, twsMap);
                                    break;
                                }
                                default: {
                                    predefinedAllowanceDurationsPerTrueWindSpeed.put((String)aKey, twsMap);
                                }
                            }
                        }
                        continue block33;
                    }
                }
            }
            trueWindSpeedMap.values().forEach(tws -> {
                HashMap hashMap = velocityPredictionPerTrueWindSpeedAndAngle.put(tws, new HashMap());
            });
            for (Bearing keyTWA : allowanceDurationsPerTrueWindAngleAndSpeed.keySet()) {
                for (Speed keyTWS : ((Map)allowanceDurationsPerTrueWindAngleAndSpeed.get(keyTWA)).keySet()) {
                    ((Map)velocityPredictionPerTrueWindSpeedAndAngle.get(keyTWS)).put(keyTWA, ORCCertificate.NAUTICAL_MILE.inTime((Duration)((Map)allowanceDurationsPerTrueWindAngleAndSpeed.get(keyTWA)).get(keyTWS)));
                }
            }
            HashMap<Speed, Speed> beatVMGPredictionPerTrueWindSpeed = new HashMap<Speed, Speed>();
            HashMap<Speed, Duration> beatAllowancePerTrueWindSpeed = new HashMap<Speed, Duration>();
            HashMap<Speed, Speed> runVMGPredictionPerTrueWindSpeed = new HashMap<Speed, Speed>();
            HashMap<Speed, Duration> runAllowancePerTrueWindSpeed = new HashMap<Speed, Duration>();
            HashMap<Speed, Speed> windwardLeewardSpeedPredictionPerTrueWindSpeed = new HashMap<Speed, Speed>();
            HashMap<Speed, Speed> longDistanceSpeedPredictionPerTrueWindSpeed = new HashMap<Speed, Speed>();
            HashMap<Speed, Speed> circularRandomSpeedPredictionPerTrueWindSpeed = new HashMap<Speed, Speed>();
            HashMap<Speed, Speed> nonSpinnakerSpeedPredictionPerTrueWindSpeed = new HashMap<Speed, Speed>();
            for (Speed tws2 : velocityPredictionPerTrueWindSpeedAndAngle.keySet()) {
                beatVMGPredictionPerTrueWindSpeed.put(tws2, this.getSpeedPredictionFromTimeAllowance(predefinedAllowanceDurationsPerTrueWindSpeed, BEAT, tws2));
                beatAllowancePerTrueWindSpeed.put(tws2, (Duration)((Map)predefinedAllowanceDurationsPerTrueWindSpeed.get(BEAT)).get(tws2));
                runVMGPredictionPerTrueWindSpeed.put(tws2, this.getSpeedPredictionFromTimeAllowance(predefinedAllowanceDurationsPerTrueWindSpeed, RUN, tws2));
                runAllowancePerTrueWindSpeed.put(tws2, (Duration)((Map)predefinedAllowanceDurationsPerTrueWindSpeed.get(RUN)).get(tws2));
                windwardLeewardSpeedPredictionPerTrueWindSpeed.put(tws2, this.getSpeedPredictionFromTimeAllowance(predefinedAllowanceDurationsPerTrueWindSpeed, WINDWARD_LEEWARD, tws2));
                longDistanceSpeedPredictionPerTrueWindSpeed.put(tws2, this.getSpeedPredictionFromTimeAllowance(predefinedAllowanceDurationsPerTrueWindSpeed, LONG_DISTANCE, tws2));
                circularRandomSpeedPredictionPerTrueWindSpeed.put(tws2, this.getSpeedPredictionFromTimeAllowance(predefinedAllowanceDurationsPerTrueWindSpeed, CIRCULAR_RANDOM, tws2));
                nonSpinnakerSpeedPredictionPerTrueWindSpeed.put(tws2, this.getSpeedPredictionFromTimeAllowance(predefinedAllowanceDurationsPerTrueWindSpeed, NON_SPINNAKER, tws2));
            }
            Object[] dynamicAllowancesTrueWindAngles = trueWindAngleMap.values().toArray(new Bearing[trueWindAngleMap.values().size()]);
            Object[] dynamicAllowancesTrueWindSpeeds = trueWindSpeedMap.values().toArray(new Speed[trueWindSpeedMap.values().size()]);
            result = new ORCCertificateImpl((Speed[])(Arrays.equals(ORCCertificate.ALLOWANCES_TRUE_WIND_SPEEDS, dynamicAllowancesTrueWindSpeeds) ? ORCCertificate.ALLOWANCES_TRUE_WIND_SPEEDS : dynamicAllowancesTrueWindSpeeds), (Bearing[])(Arrays.equals(ORCCertificate.ALLOWANCES_TRUE_WIND_ANGLES, dynamicAllowancesTrueWindAngles) ? ORCCertificate.ALLOWANCES_TRUE_WIND_ANGLES : dynamicAllowancesTrueWindAngles), refNo, fileId, sailNumber, boatName, boatclass, (Distance)length, (Duration)gph, cdl, (TimePoint)issueDate, CountryCodeFactory.INSTANCE.getFromThreeLetterIOCName(natAuth), velocityPredictionPerTrueWindSpeedAndAngle, beatAngles, beatVMGPredictionPerTrueWindSpeed, beatAllowancePerTrueWindSpeed, gybeAngles, runVMGPredictionPerTrueWindSpeed, runAllowancePerTrueWindSpeed, windwardLeewardSpeedPredictionPerTrueWindSpeed, longDistanceSpeedPredictionPerTrueWindSpeed, circularRandomSpeedPredictionPerTrueWindSpeed, nonSpinnakerSpeedPredictionPerTrueWindSpeed);
        }
        return result;
    }

    private Speed getSpeedPredictionFromTimeAllowance(Map<String, Map<Speed, Duration>> predefinedAllowanceDurationsPerTrueWindSpeed, String predictionCategory, Speed tws) {
        Duration timeAllowance;
        Map<Speed, Duration> timeAllowances = predefinedAllowanceDurationsPerTrueWindSpeed.get(predictionCategory);
        Object speedPrediction = timeAllowances != null && (timeAllowance = timeAllowances.get(tws)) != null ? ORCCertificate.NAUTICAL_MILE.inTime(timeAllowance) : new KnotSpeedImpl(Double.POSITIVE_INFINITY);
        return speedPrediction;
    }

    private String getId(JSONObject certificateAsJson) {
        return certificateAsJson.get((Object)REFERENCE_NUMBER).toString();
    }

    @Override
    public Iterable<String> getCertificateIds() {
        return Collections.unmodifiableCollection(this.certificateJsonObjectsByCertificateId.keySet());
    }
}

