/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.orc.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.orc.AverageWindOnLegCache;
import com.sap.sailing.domain.common.orc.ORCPerformanceCurveLeg;
import com.sap.sailing.domain.common.orc.ORCPerformanceCurveLegTypes;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sailing.domain.tracking.impl.NoCachingWindLegTypeAndLegBearingCache;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;

public abstract class AbstractORCPerformanceCurveTwaLegAdapter
implements ORCPerformanceCurveLeg {
    private static final long serialVersionUID = -6432064480098807397L;
    private static final int DEFAULT_NUMBER_OF_TIME_POINTS_AND_POSITIONS_FOR_AVERAGE_WIND = 10;
    private final TrackedLeg trackedLeg;
    private final int numParts;

    public AbstractORCPerformanceCurveTwaLegAdapter(TrackedLeg trackedLeg) {
        this(trackedLeg, 10);
    }

    public AbstractORCPerformanceCurveTwaLegAdapter(TrackedLeg trackedLeg, int numParts) {
        this.trackedLeg = trackedLeg;
        this.numParts = numParts;
    }

    protected TrackedLeg getTrackedLeg() {
        return this.trackedLeg;
    }

    public Bearing getTwa() {
        return this.getTwa(new NoCachingWindLegTypeAndLegBearingCache());
    }

    public Bearing getTwa(AverageWindOnLegCache cache) {
        TimePoint referenceTimePoint;
        Bearing bearing;
        EqualityByTrackedLegWrapper wrapper = new EqualityByTrackedLegWrapper();
        Wind wind = cache.getAverageWind((ORCPerformanceCurveLeg)wrapper, legAdapter -> {
            WindWithConfidence<Util.Pair<Position, TimePoint>> averageWind = legAdapter.getTrackedLeg().getAverageWind(this.numParts);
            return averageWind == null ? null : (Wind)averageWind.getObject();
        });
        Bearing result = wind == null ? null : ((bearing = this.trackedLeg.getLegBearing(referenceTimePoint = this.trackedLeg.getReferenceTimePoint())) != null ? bearing.getDifferenceTo(wind.getFrom()) : null);
        return result;
    }

    public ORCPerformanceCurveLegTypes getType() {
        ORCPerformanceCurveLegTypes result = !this.hasWind() ? ORCPerformanceCurveLegTypes.LONG_DISTANCE : ORCPerformanceCurveLegTypes.TWA;
        return result;
    }

    private boolean hasWind() {
        TimePoint referenceTimePoint = this.trackedLeg.getReferenceTimePoint();
        Wind result = this.trackedLeg.getTrackedRace().getWind(this.trackedLeg.getMiddleOfLeg(referenceTimePoint), referenceTimePoint);
        return result != null;
    }

    public ORCPerformanceCurveLeg scale(final double share) {
        return new AbstractORCPerformanceCurveTwaLegAdapter(this.trackedLeg, this.numParts){
            private static final long serialVersionUID = -6724721873285438431L;

            public Distance getLength() {
                return AbstractORCPerformanceCurveTwaLegAdapter.this.getLength().scale(share);
            }

            @Override
            public Distance getLength(WindLegTypeAndLegBearingAndORCPerformanceCurveCache leaderboardDTOCalculationReuseCache) {
                return AbstractORCPerformanceCurveTwaLegAdapter.this.getLength(leaderboardDTOCalculationReuseCache).scale(share);
            }
        };
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " for " + this.trackedLeg.getLeg() + ": length=" + this.getLength().getNauticalMiles() + "NM, TWA=" + this.getTwa();
    }

    public abstract Distance getLength(WindLegTypeAndLegBearingAndORCPerformanceCurveCache var1);

    private class EqualityByTrackedLegWrapper
    implements ORCPerformanceCurveLeg {
        private static final long serialVersionUID = 2580336707637358724L;

        private EqualityByTrackedLegWrapper() {
        }

        public boolean equals(Object o) {
            return o instanceof EqualityByTrackedLegWrapper && this.getTrackedLeg() == ((EqualityByTrackedLegWrapper)o).getTrackedLeg();
        }

        public int hashCode() {
            return this.getTrackedLeg().hashCode();
        }

        public Distance getLength() {
            return AbstractORCPerformanceCurveTwaLegAdapter.this.getLength();
        }

        public Bearing getTwa() {
            return AbstractORCPerformanceCurveTwaLegAdapter.this.getTwa();
        }

        public Bearing getTwa(AverageWindOnLegCache cache) {
            return AbstractORCPerformanceCurveTwaLegAdapter.this.getTwa(cache);
        }

        public ORCPerformanceCurveLegTypes getType() {
            return AbstractORCPerformanceCurveTwaLegAdapter.this.getType();
        }

        public ORCPerformanceCurveLeg scale(double share) {
            return AbstractORCPerformanceCurveTwaLegAdapter.this.scale(share);
        }

        public TrackedLeg getTrackedLeg() {
            return AbstractORCPerformanceCurveTwaLegAdapter.this.getTrackedLeg();
        }
    }
}

