/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.markpassingcalculation.impl;

import com.sap.sailing.domain.base.ControlPoint;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.tracking.AddResult;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.impl.AbstractRaceChangeListener;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.concurrent.ConcurrentWeakHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;

public class WaypointPositionAndDistanceCache {
    private final ConcurrentWeakHashMap<ControlPoint, SortedMap<TimePoint, Position>> waypointPositionCache;
    private final ConcurrentWeakHashMap<Mark, SortedMap<TimePoint, Position>> markPositionCache;
    private final ConcurrentMap<Util.Pair<ControlPoint, ControlPoint>, SortedMap<TimePoint, Distance>> distanceCache;
    private final ConcurrentMap<Util.Pair<ControlPoint, ControlPoint>, SortedMap<TimePoint, Distance>> minimumDistanceCache;
    private final Duration timeRangeResolution;
    private final TrackedRace trackedRace;
    private final List<Waypoint> waypoints;

    public WaypointPositionAndDistanceCache(TrackedRace race, Duration timeRangeResolution) {
        this.trackedRace = race;
        this.waypointPositionCache = new ConcurrentWeakHashMap();
        this.markPositionCache = new ConcurrentWeakHashMap();
        this.distanceCache = new ConcurrentHashMap<Util.Pair<ControlPoint, ControlPoint>, SortedMap<TimePoint, Distance>>();
        this.minimumDistanceCache = new ConcurrentHashMap<Util.Pair<ControlPoint, ControlPoint>, SortedMap<TimePoint, Distance>>();
        this.timeRangeResolution = timeRangeResolution;
        this.waypoints = Collections.synchronizedList(new ArrayList());
        Course course = this.trackedRace.getRace().getCourse();
        course.lockForRead();
        try {
            Util.addAll((Iterable)course.getWaypoints(), this.waypoints);
            this.trackedRace.addListener(new AbstractRaceChangeListener(){

                @Override
                public void markPositionChanged(GPSFix fix, Mark mark, boolean firstInTrack, AddResult addedOrReplaced) {
                    WaypointPositionAndDistanceCache.this.invalidate(mark, fix);
                }

                @Override
                public void waypointAdded(int zeroBasedIndex, Waypoint waypointThatGotAdded) {
                    WaypointPositionAndDistanceCache.this.waypoints.add(zeroBasedIndex, waypointThatGotAdded);
                }

                @Override
                public void waypointRemoved(int zeroBasedIndex, Waypoint waypointThatGotRemoved) {
                    if (!$assertionsDisabled && WaypointPositionAndDistanceCache.this.waypoints.get(zeroBasedIndex) != waypointThatGotRemoved) {
                        throw new AssertionError();
                    }
                    WaypointPositionAndDistanceCache.this.waypoints.remove(zeroBasedIndex);
                }
            });
        }
        finally {
            course.unlockAfterRead();
        }
    }

    public Position getApproximatePosition(Waypoint waypoint, TimePoint timePoint) {
        return this.getApproximateResult((Object)waypoint.getControlPoint(), timePoint, (Map)this.waypointPositionCache, (Function)roundedToTimeRangeCenter -> this.trackedRace.getApproximatePosition(waypoint, (TimePoint)roundedToTimeRangeCenter), null);
    }

    public Position getApproximatePosition(Mark mark, TimePoint timePoint) {
        return this.getApproximateResult((Object)mark, timePoint, (Map)this.markPositionCache, (Function)roundedToTimeRangeCenter -> this.trackedRace.getOrCreateTrack(mark).getEstimatedPosition((TimePoint)roundedToTimeRangeCenter, false), null);
    }

    private <K, R> R getApproximateResult(K cacheKey, TimePoint timePoint, Map<K, SortedMap<TimePoint, R>> cacheMap, Function<TimePoint, R> resultCalculator, Supplier<K> alternateKeySupplier) {
        Object result;
        Object cachedResult;
        SortedMap<Object, Object> map = cacheMap.get(cacheKey);
        TimePoint roundedToTimeRangeCenter = this.roundToResolution(timePoint);
        if (map == null) {
            map = Collections.synchronizedSortedMap(new TreeMap());
            cacheMap.put(cacheKey, map);
            cachedResult = null;
        } else {
            cachedResult = map.get(roundedToTimeRangeCenter);
        }
        if (cachedResult == null) {
            K alternateKey;
            result = this.computeResult(resultCalculator, roundedToTimeRangeCenter);
            map.put(roundedToTimeRangeCenter, result);
            if (alternateKeySupplier != null && (alternateKey = alternateKeySupplier.get()) != null) {
                SortedMap<Object, Object> mapForAlternateKey = cacheMap.get(alternateKey);
                if (mapForAlternateKey == null) {
                    mapForAlternateKey = Collections.synchronizedSortedMap(new TreeMap());
                    cacheMap.put(alternateKey, mapForAlternateKey);
                }
                mapForAlternateKey.put(roundedToTimeRangeCenter, result);
            }
        } else {
            result = cachedResult;
        }
        return (R)result;
    }

    protected <R> R computeResult(Function<TimePoint, R> resultCalculator, TimePoint roundedToTimeRangeCenter) {
        return resultCalculator.apply(roundedToTimeRangeCenter);
    }

    public Distance getApproximateDistance(Waypoint w1, Waypoint w2, TimePoint timePoint) {
        return this.getApproximateResult(new Util.Pair((Object)w1.getControlPoint(), (Object)w2.getControlPoint()), timePoint, this.distanceCache, roundedToTimeRangeCenter -> this.getApproximatePosition(w1, (TimePoint)roundedToTimeRangeCenter).getDistance(this.getApproximatePosition(w2, (TimePoint)roundedToTimeRangeCenter)), () -> new Util.Pair((Object)w2.getControlPoint(), (Object)w1.getControlPoint()));
    }

    public Distance getMinimumDistance(Waypoint w1, Waypoint w2, TimePoint timePoint) {
        return this.getApproximateResult(new Util.Pair((Object)w1.getControlPoint(), (Object)w2.getControlPoint()), timePoint, this.minimumDistanceCache, roundedToTimeRangeCenter -> {
            Distance minDist = null;
            for (Mark w1m : w1.getMarks()) {
                for (Mark w2m : w2.getMarks()) {
                    Position approximatePositionW1m = this.getApproximatePosition(w1m, (TimePoint)roundedToTimeRangeCenter);
                    Position approximatePositionW2m = this.getApproximatePosition(w2m, (TimePoint)roundedToTimeRangeCenter);
                    if (approximatePositionW1m == null || approximatePositionW2m == null) continue;
                    Distance w1mToW2m = approximatePositionW1m.getDistance(approximatePositionW2m);
                    if (minDist != null && minDist.compareTo((Object)w1mToW2m) <= 0) continue;
                    minDist = w1mToW2m;
                }
            }
            return minDist;
        }, () -> new Util.Pair((Object)w2.getControlPoint(), (Object)w1.getControlPoint()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate(Mark mark, GPSFix fix) {
        TimeRange affectedTimeRange = this.trackedRace.getOrCreateTrack(mark).getEstimatedPositionTimePeriodAffectedBy(fix);
        SortedMap map = (SortedMap)this.markPositionCache.get((Object)mark);
        if (map != null) {
            this.removeAffectedEntries(mark, affectedTimeRange, map, null);
        }
        List<Waypoint> list = this.waypoints;
        synchronized (list) {
            for (Waypoint waypoint : this.waypoints) {
                if (!Util.contains((Iterable)waypoint.getMarks(), (Object)mark)) continue;
                this.invalidate(waypoint.getControlPoint(), affectedTimeRange);
            }
        }
    }

    private void invalidate(ControlPoint controlPoint, TimeRange affectedTimeRange) {
        SortedMap map = (SortedMap)this.waypointPositionCache.get((Object)controlPoint);
        if (map != null) {
            this.removeAffectedEntries(controlPoint, affectedTimeRange, map, this::controlPointCacheMapEntryRemoved);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void removeAffectedEntries(T controlPoint, TimeRange affectedTimeRange, SortedMap<TimePoint, Position> map, EntryRemovedCallback<T> entryRemovedCallback) {
        SortedMap<TimePoint, Position> tailMap = map.tailMap(this.roundToResolution(affectedTimeRange.from()));
        SortedMap<TimePoint, Position> sortedMap = map;
        synchronized (sortedMap) {
            Iterator<Map.Entry<TimePoint, Position>> i = tailMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<TimePoint, Position> e = i.next();
                TimePoint timePoint = e.getKey();
                if (timePoint.after(affectedTimeRange.to())) break;
                assert (timePoint.equals(this.roundToResolution(timePoint)));
                i.remove();
                if (entryRemovedCallback == null) continue;
                entryRemovedCallback.cacheMapEntryRemoved(controlPoint, timePoint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void controlPointCacheMapEntryRemoved(ControlPoint controlPoint, TimePoint timePoint) {
        List<Waypoint> list = this.waypoints;
        synchronized (list) {
            for (Waypoint otherWaypoint : this.waypoints) {
                ControlPoint otherControlPoint = otherWaypoint.getControlPoint();
                if (otherControlPoint == controlPoint) continue;
                for (ConcurrentMap cache : Arrays.asList(this.distanceCache, this.minimumDistanceCache)) {
                    Map otherDistanceMap;
                    Map distanceMap = (Map)cache.get(new Util.Pair((Object)controlPoint, (Object)otherControlPoint));
                    if (distanceMap != null) {
                        distanceMap.remove(timePoint);
                    }
                    if ((otherDistanceMap = (Map)cache.get(new Util.Pair((Object)otherControlPoint, (Object)controlPoint))) == null) continue;
                    otherDistanceMap.remove(timePoint);
                }
            }
        }
    }

    TimePoint roundToResolution(TimePoint timePoint) {
        long mod = timePoint.asMillis() % this.timeRangeResolution.asMillis();
        long div = timePoint.asMillis() / this.timeRangeResolution.asMillis();
        long roundedMillis = mod <= (this.timeRangeResolution.asMillis() - 1L) / 2L ? div * this.timeRangeResolution.asMillis() : (div + 1L) * this.timeRangeResolution.asMillis();
        return new MillisecondsTimePoint(roundedMillis);
    }

    @FunctionalInterface
    private static interface EntryRemovedCallback<T> {
        public void cacheMapEntryRemoved(T var1, TimePoint var2);
    }
}

