/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.markpassingcalculation.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.markpassingcalculation.Candidate;
import com.sap.sailing.domain.markpassingcalculation.CandidateChooser;
import com.sap.sailing.domain.markpassingcalculation.impl.CandidateForFixedMarkPassingImpl;
import com.sap.sailing.domain.markpassingcalculation.impl.CandidateImpl;
import com.sap.sailing.domain.markpassingcalculation.impl.Edge;
import com.sap.sailing.domain.markpassingcalculation.impl.MostProbableCandidatesInSmallTimeRangeFilter;
import com.sap.sailing.domain.markpassingcalculation.impl.StationarySequenceBasedFilter;
import com.sap.sailing.domain.markpassingcalculation.impl.WaypointPositionAndDistanceCache;
import com.sap.sailing.domain.tracking.DynamicGPSFixTrack;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.impl.MarkPassingImpl;
import com.sap.sailing.domain.tracking.impl.TimedComparator;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Timed;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class CandidateChooserImpl
implements CandidateChooser {
    private static final double PENALTY_FOR_LATEST_FINISH_PASSING = 0.95;
    private static final double MAX_REASONABLE_RATIO_BETWEEN_DISTANCE_TRAVELED_AND_LEG_LENGTH = 2.0;
    private static final Duration EARLY_STARTS_CONSIDERED_THIS_MUCH_BEFORE_STARTTIME = Duration.ONE_SECOND.times(30L);
    private static final Duration DELAY_AFTER_WHICH_PROBABILITY_OF_START_HALVES = Duration.ONE_MINUTE.times(5L);
    private static final Speed MINIMUM_REASONABLE_SPEED = new KnotSpeedImpl(3.0);
    private static final Speed MAXIMUM_REASONABLE_SPEED = GPSFixTrack.DEFAULT_MAX_SPEED_FOR_SMOOTHING;
    private static final double MINIMUM_PROBABILITY = Edge.getPenaltyForSkipping();
    private static final Logger logger = Logger.getLogger(CandidateChooserImpl.class.getName());
    private Map<Competitor, Map<Waypoint, MarkPassing>> currentMarkPasses = new HashMap<Competitor, Map<Waypoint, MarkPassing>>();
    private Map<Competitor, Map<Candidate, Set<Edge>>> allEdges = new HashMap<Competitor, Map<Candidate, Set<Edge>>>();
    private final Map<Competitor, NavigableSet<Candidate>> candidates;
    private final Map<Competitor, MostProbableCandidatesInSmallTimeRangeFilter> mostProbableCandidatesInSmallTimeRangeFilters;
    private final Map<Competitor, StationarySequenceBasedFilter> stationarySequenceBasedFilters;
    private final Map<Competitor, NavigableSet<Candidate>> fixedPassings = new HashMap<Competitor, NavigableSet<Candidate>>();
    private final ConcurrentHashMap<Competitor, Integer> suppressedPassings = new ConcurrentHashMap();
    private TimePoint raceStartTime;
    private final WaypointPositionAndDistanceCache waypointPositionAndDistanceCache;
    private final CandidateWithSettableTime start;
    private final CandidateWithSettableWaypointIndex end;
    private final DynamicTrackedRace race;
    private final HashMap<Competitor, NamedReentrantReadWriteLock> perCompetitorLocks;
    private final StartAndEndAwareTimeBasedCandidateComparator CANDIDATE_COMPARATOR = new StartAndEndAwareTimeBasedCandidateComparator();

    public CandidateChooserImpl(DynamicTrackedRace race) {
        this.perCompetitorLocks = new HashMap();
        this.race = race;
        this.waypointPositionAndDistanceCache = new WaypointPositionAndDistanceCache(race, Duration.ONE_MINUTE);
        TimePoint startOfRaceWithoutInference = race.getStartOfRace(false);
        this.raceStartTime = startOfRaceWithoutInference != null ? startOfRaceWithoutInference.minus(EARLY_STARTS_CONSIDERED_THIS_MUCH_BEFORE_STARTTIME) : null;
        this.start = new CandidateWithSettableTime(0, this.raceStartTime, 1.0, null);
        this.end = new CandidateWithSettableWaypointIndex(race.getRace().getCourse().getNumberOfWaypoints() + 1, null, 1.0, null);
        this.candidates = new HashMap<Competitor, NavigableSet<Candidate>>();
        this.mostProbableCandidatesInSmallTimeRangeFilters = new HashMap<Competitor, MostProbableCandidatesInSmallTimeRangeFilter>();
        this.stationarySequenceBasedFilters = new HashMap<Competitor, StationarySequenceBasedFilter>();
        List<Candidate> startAndEnd = Arrays.asList(this.start, this.end);
        for (Competitor c : race.getRace().getCompetitors()) {
            this.perCompetitorLocks.put(c, this.createCompetitorLock(c));
            this.candidates.put(c, Collections.synchronizedNavigableSet(new TreeSet<Candidate>(this.CANDIDATE_COMPARATOR)));
            this.mostProbableCandidatesInSmallTimeRangeFilters.put(c, new MostProbableCandidatesInSmallTimeRangeFilter(this.CANDIDATE_COMPARATOR, this.start, this.end));
            this.stationarySequenceBasedFilters.put(c, new StationarySequenceBasedFilter(this.CANDIDATE_COMPARATOR, (DynamicGPSFixTrack<Competitor, GPSFixMoving>)race.getTrack(c), this.start, this.end));
            HashMap<Waypoint, MarkPassing> currentMarkPassesForCompetitor = new HashMap<Waypoint, MarkPassing>();
            this.currentMarkPasses.put(c, currentMarkPassesForCompetitor);
            for (Waypoint w : race.getRace().getCourse().getWaypoints()) {
                MarkPassing mp = race.getMarkPassing(c, w);
                if (mp == null) continue;
                currentMarkPassesForCompetitor.put(w, mp);
            }
            TreeSet<Candidate> fixedPasses = new TreeSet<Candidate>(new Comparator<Candidate>(){

                @Override
                public int compare(Candidate o1, Candidate o2) {
                    int result = o1 == null ? (o2 == null ? 0 : -1) : (o2 == null ? 1 : o1.getOneBasedIndexOfWaypoint() - o2.getOneBasedIndexOfWaypoint());
                    return result;
                }
            });
            this.fixedPassings.put(c, fixedPasses);
            this.allEdges.put(c, new HashMap());
            fixedPasses.addAll(startAndEnd);
            this.addCandidates(c, startAndEnd);
        }
    }

    public Stats getStats() {
        return new Stats();
    }

    private NamedReentrantReadWriteLock createCompetitorLock(Competitor c) {
        return new NamedReentrantReadWriteLock("Competitor lock for " + c + " in candidate chooser " + this, false);
    }

    @Override
    public void calculateMarkPassDeltas(Competitor c, Iterable<Candidate> newCans, Iterable<Candidate> oldCans) {
        this.calculateMarkPassDeltas(c, Collections.emptySet(), Collections.emptySet(), newCans, oldCans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void calculateMarkPassDeltas(Competitor c, Iterable<GPSFixMoving> newFixes, Iterable<GPSFixMoving> fixesReplacingExistingOnes, Iterable<Candidate> newCans, Iterable<Candidate> oldCans) {
        this.updateStationarySequences(c, newFixes, fixesReplacingExistingOnes);
        TimePoint startOfRace = this.race.getStartOfRace(false);
        if (startOfRace != null) {
            boolean startTimeUpdated;
            CandidateChooserImpl candidateChooserImpl = this;
            synchronized (candidateChooserImpl) {
                if (this.raceStartTime == null || !startOfRace.minus(EARLY_STARTS_CONSIDERED_THIS_MUCH_BEFORE_STARTTIME).equals(this.raceStartTime)) {
                    this.raceStartTime = startOfRace.minus(EARLY_STARTS_CONSIDERED_THIS_MUCH_BEFORE_STARTTIME);
                    startTimeUpdated = true;
                } else {
                    startTimeUpdated = false;
                }
            }
            if (startTimeUpdated) {
                Set<Candidate> startList = Collections.singleton(this.start);
                for (Competitor competitor : this.candidates.keySet()) {
                    this.removeCandidates(competitor, startList);
                }
                this.start.setTimePoint(this.raceStartTime);
                for (Competitor competitor : this.allEdges.keySet()) {
                    this.addCandidates(competitor, startList);
                }
            }
        }
        this.removeCandidates(c, oldCans);
        this.addCandidates(c, newCans);
        this.findShortestPath(c);
    }

    private void updateStationarySequences(Competitor c, Iterable<GPSFixMoving> newFixes, Iterable<GPSFixMoving> fixesReplacingExistingOnes) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.perCompetitorLocks.get(c));
        try {
            this.adjustGraph(c, this.stationarySequenceBasedFilters.get(c).updateFixes(newFixes, fixesReplacingExistingOnes));
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.perCompetitorLocks.get(c));
        }
    }

    @Override
    public void removeWaypoints(Iterable<Waypoint> waypoints) {
        for (Competitor c : this.currentMarkPasses.keySet()) {
            for (Waypoint w : waypoints) {
                this.currentMarkPasses.get(c).remove(w);
            }
        }
    }

    @Override
    public void updateEndProxyNodeWaypointIndex() {
        for (NavigableSet<Candidate> fixedPassingsForCompetitor : this.fixedPassings.values()) {
            fixedPassingsForCompetitor.remove(this.end);
        }
        this.end.setOneBasedWaypointIndex(this.race.getRace().getCourse().getNumberOfWaypoints() + 1);
        for (NavigableSet<Candidate> fixedPassingsForCompetitor : this.fixedPassings.values()) {
            fixedPassingsForCompetitor.add(this.end);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setFixedPassing(Competitor c, Integer zeroBasedIndexOfWaypoint, TimePoint t) {
        NamedReentrantReadWriteLock lock = this.perCompetitorLocks.get(c);
        if (lock == null) return;
        if (zeroBasedIndexOfWaypoint >= 0 && zeroBasedIndexOfWaypoint < this.race.getRace().getCourse().getNumberOfWaypoints()) {
            LockUtil.lockForWrite((NamedReentrantReadWriteLock)lock);
            try {
                CandidateForFixedMarkPassingImpl fixedCan = new CandidateForFixedMarkPassingImpl(zeroBasedIndexOfWaypoint + 1, t, 1.0, (Waypoint)Util.get((Iterable)this.race.getRace().getCourse().getWaypoints(), (int)zeroBasedIndexOfWaypoint));
                NavigableSet<Candidate> fixed = this.fixedPassings.get(c);
                if (fixed == null) return;
                if (!fixed.add(fixedCan)) {
                    Candidate old = fixed.ceiling(fixedCan);
                    fixed.remove(old);
                    this.removeCandidates(c, Collections.singleton(old));
                    fixed.add(fixedCan);
                }
                this.addCandidates(c, Collections.singleton(fixedCan));
                this.findShortestPath(c);
                return;
            }
            finally {
                LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)lock);
            }
        } else {
            logger.warning("Competitor " + c + " has fixed mark passing for non-existing waypoint #" + (zeroBasedIndexOfWaypoint + 1));
        }
    }

    @Override
    public void removeFixedPassing(Competitor c, Integer zeroBasedIndexOfWaypoint) {
        NamedReentrantReadWriteLock lock = this.perCompetitorLocks.get(c);
        if (lock != null) {
            LockUtil.lockForWrite((NamedReentrantReadWriteLock)lock);
            try {
                Candidate toRemove = null;
                for (Candidate can : this.fixedPassings.get(c)) {
                    if (can.getOneBasedIndexOfWaypoint() - 1 != zeroBasedIndexOfWaypoint) continue;
                    toRemove = can;
                    break;
                }
                if (toRemove != null) {
                    this.fixedPassings.get(c).remove(toRemove);
                    this.removeCandidates(c, Arrays.asList(toRemove));
                    this.findShortestPath(c);
                }
            }
            finally {
                LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)lock);
            }
        }
    }

    @Override
    public void suppressMarkPassings(Competitor c, Integer zeroBasedIndexOfWaypoint) {
        this.suppressedPassings.put(c, zeroBasedIndexOfWaypoint);
        this.findShortestPath(c);
    }

    @Override
    public void stopSuppressingMarkPassings(Competitor c) {
        this.suppressedPassings.remove(c);
        this.findShortestPath(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewEdges(Competitor c, Iterable<Candidate> newCandidates) {
        assert (this.perCompetitorLocks.get(c).isWriteLocked());
        Boolean isGateStart = this.race.isGateStart();
        Map<Candidate, Set<Edge>> edgesForCompetitor = this.allEdges.get(c);
        Iterable<Candidate> competitorCandidates = this.getFilteredCandidates(c);
        for (Candidate newCan : newCandidates) {
            Iterable<Candidate> iterable = competitorCandidates;
            synchronized (iterable) {
                for (Candidate oldCan : competitorCandidates) {
                    Supplier<Double> estimatedDistanceProbabilitySupplier;
                    Distance.NullDistance ignoreEdgeDueToProbabilityLowerThanMinimumForSkipping;
                    double estimatedDistanceProbability;
                    double startTimingProbability;
                    Candidate late;
                    Candidate early;
                    if (oldCan.getOneBasedIndexOfWaypoint() < newCan.getOneBasedIndexOfWaypoint()) {
                        early = oldCan;
                        late = newCan;
                    } else {
                        if (oldCan.getOneBasedIndexOfWaypoint() <= newCan.getOneBasedIndexOfWaypoint()) continue;
                        late = oldCan;
                        early = newCan;
                    }
                    if (early == this.start) {
                        if (isGateStart == Boolean.TRUE || this.start.getTimePoint() == null) {
                            startTimingProbability = 1.0;
                            estimatedDistanceProbability = 1.0;
                            ignoreEdgeDueToProbabilityLowerThanMinimumForSkipping = Distance.NULL;
                            estimatedDistanceProbabilitySupplier = null;
                        } else if (late.getWaypoint() != null && late.getWaypoint() == this.race.getRace().getCourse().getFirstWaypoint()) {
                            Duration timeGapBetweenStartOfRaceAndCandidateTimePoint = early.getTimePoint().plus(EARLY_STARTS_CONSIDERED_THIS_MUCH_BEFORE_STARTTIME).until(late.getTimePoint()).abs();
                            startTimingProbability = DELAY_AFTER_WHICH_PROBABILITY_OF_START_HALVES.divide(DELAY_AFTER_WHICH_PROBABILITY_OF_START_HALVES.plus(timeGapBetweenStartOfRaceAndCandidateTimePoint));
                            estimatedDistanceProbability = 1.0;
                            ignoreEdgeDueToProbabilityLowerThanMinimumForSkipping = Distance.NULL;
                            estimatedDistanceProbabilitySupplier = null;
                        } else {
                            startTimingProbability = 1.0;
                            if (late == this.end) {
                                estimatedDistanceProbability = 1.0;
                                ignoreEdgeDueToProbabilityLowerThanMinimumForSkipping = Distance.NULL;
                                estimatedDistanceProbabilitySupplier = null;
                            } else {
                                estimatedDistanceProbability = 0.0;
                                ignoreEdgeDueToProbabilityLowerThanMinimumForSkipping = this.getIgnoreDueToTimingInducedEstimatedSpeeds(c, early, late);
                                estimatedDistanceProbabilitySupplier = () -> this.lambda$0(c, early, late, (Distance)ignoreEdgeDueToProbabilityLowerThanMinimumForSkipping);
                            }
                        }
                    } else {
                        startTimingProbability = 1.0;
                        if (late == this.end) {
                            estimatedDistanceProbability = 1.0;
                            ignoreEdgeDueToProbabilityLowerThanMinimumForSkipping = Distance.NULL;
                            estimatedDistanceProbabilitySupplier = null;
                        } else {
                            estimatedDistanceProbability = 0.0;
                            ignoreEdgeDueToProbabilityLowerThanMinimumForSkipping = this.getIgnoreDueToTimingInducedEstimatedSpeeds(c, early, late);
                            estimatedDistanceProbabilitySupplier = () -> this.lambda$1(c, early, late, (Distance)ignoreEdgeDueToProbabilityLowerThanMinimumForSkipping);
                        }
                    }
                    NavigableSet<Candidate> fixed = this.fixedPassings.get(c);
                    if (!this.travelingForwardInTimeOrUnknown(early, late) || !fixed.contains(early) && !fixed.contains(late) && ignoreEdgeDueToProbabilityLowerThanMinimumForSkipping == null) continue;
                    Edge edge = estimatedDistanceProbabilitySupplier != null ? new Edge(early, late, () -> startTimingProbability * (Double)estimatedDistanceProbabilitySupplier.get(), this.race.getRace().getCourse().getNumberOfWaypoints()) : new Edge(early, late, startTimingProbability * estimatedDistanceProbability, this.race.getRace().getCourse().getNumberOfWaypoints());
                    this.addEdge(edgesForCompetitor, edge);
                }
            }
        }
    }

    private Iterable<Candidate> getFilteredCandidates(Competitor c) {
        return this.stationarySequenceBasedFilters.get(c).getFilteredCandidates();
    }

    private boolean travelingForwardInTimeOrUnknown(Candidate early, Candidate late) {
        return early.getTimePoint() == null || late.getTimePoint() == null || early.getTimePoint().before(late.getTimePoint());
    }

    private void addEdge(Map<Candidate, Set<Edge>> edgesForCompetitor, Edge e) {
        logger.finest(() -> "Adding " + e.toString());
        Set<Edge> edgeSet = edgesForCompetitor.get(e.getStart());
        if (edgeSet == null) {
            edgeSet = new HashSet<Edge>();
            edgesForCompetitor.put(e.getStart(), edgeSet);
        }
        edgeSet.add(e);
    }

    private void findShortestPath(Competitor c) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.perCompetitorLocks.get(c));
        try {
            Map<Candidate, Set<Edge>> allCompetitorEdges = this.allEdges.get(c);
            TreeSet<Candidate> mostLikelyCandidates = new TreeSet<Candidate>();
            NavigableSet<Candidate> fixedPasses = this.fixedPassings.get(c);
            Candidate startOfFixedInterval = (Candidate)fixedPasses.first();
            Candidate endOfFixedInterval = fixedPasses.higher(startOfFixedInterval);
            Integer zeroBasedIndexOfWaypoint = this.suppressedPassings.get(c);
            Integer oneBasedIndexOfSuppressedWaypoint = zeroBasedIndexOfWaypoint != null ? zeroBasedIndexOfWaypoint + 1 : this.end.getOneBasedIndexOfWaypoint();
            while (endOfFixedInterval != null) {
                if (oneBasedIndexOfSuppressedWaypoint <= endOfFixedInterval.getOneBasedIndexOfWaypoint()) {
                    endOfFixedInterval = this.end;
                }
                TreeSet<Util.Pair<Edge, Double>> currentEdgesMoreLikelyFirst = new TreeSet<Util.Pair<Edge, Double>>(new Comparator<Util.Pair<Edge, Double>>(){

                    @Override
                    public int compare(Util.Pair<Edge, Double> o1, Util.Pair<Edge, Double> o2) {
                        int result = ((Double)o2.getB()).compareTo((Double)o1.getB());
                        return result != 0 ? result : ((Edge)o1.getA()).compareTo((Edge)o2.getA());
                    }
                });
                HashMap<Candidate, Util.Pair> candidateWithParentAndHighestTotalProbability = new HashMap<Candidate, Util.Pair>();
                int indexOfEndOfFixedInterval = endOfFixedInterval.getOneBasedIndexOfWaypoint();
                boolean endFound = false;
                currentEdgesMoreLikelyFirst.add((Util.Pair<Edge, Double>)new Util.Pair((Object)new Edge((Candidate)new CandidateImpl(-1, null, 1.0, null), startOfFixedInterval, () -> 1.0, this.race.getRace().getCourse().getNumberOfWaypoints()), (Object)1.0));
                while (!endFound) {
                    Set<Edge> edgesForNewCandidate;
                    Util.Pair mostLikelyEdgeWithProbability = (Util.Pair)currentEdgesMoreLikelyFirst.pollFirst();
                    if (mostLikelyEdgeWithProbability == null) {
                        endFound = true;
                        continue;
                    }
                    Edge currentMostLikelyEdge = (Edge)mostLikelyEdgeWithProbability.getA();
                    Double currentHighestProbability = (Double)mostLikelyEdgeWithProbability.getB();
                    if (candidateWithParentAndHighestTotalProbability.containsKey(currentMostLikelyEdge.getEnd())) continue;
                    candidateWithParentAndHighestTotalProbability.put(currentMostLikelyEdge.getEnd(), new Util.Pair((Object)currentMostLikelyEdge.getStart(), (Object)currentHighestProbability));
                    logger.finest(() -> "Added " + currentMostLikelyEdge + " as most likely edge for " + c);
                    boolean bl = endFound = currentMostLikelyEdge.getEnd() == endOfFixedInterval;
                    if (endFound || (edgesForNewCandidate = allCompetitorEdges.get(currentMostLikelyEdge.getEnd())) == null) continue;
                    for (Edge e : edgesForNewCandidate) {
                        int oneBasedIndexOfEndOfEdge = e.getEnd().getOneBasedIndexOfWaypoint();
                        if (oneBasedIndexOfEndOfEdge > indexOfEndOfFixedInterval || oneBasedIndexOfEndOfEdge >= oneBasedIndexOfSuppressedWaypoint && e.getEnd() != this.end) continue;
                        currentEdgesMoreLikelyFirst.add((Util.Pair<Edge, Double>)new Util.Pair((Object)e, (Object)(currentHighestProbability * e.getProbability())));
                    }
                }
                Util.Pair bestCandidateAndProbabilityForEndOfFixedInterval = (Util.Pair)candidateWithParentAndHighestTotalProbability.get(endOfFixedInterval);
                Candidate marker = bestCandidateAndProbabilityForEndOfFixedInterval == null ? null : (Candidate)bestCandidateAndProbabilityForEndOfFixedInterval.getA();
                while (marker != null && marker.getOneBasedIndexOfWaypoint() > 0) {
                    mostLikelyCandidates.add(marker);
                    marker = (Candidate)((Util.Pair)candidateWithParentAndHighestTotalProbability.get(marker)).getA();
                }
                startOfFixedInterval = endOfFixedInterval;
                if ((endOfFixedInterval = fixedPasses.higher(endOfFixedInterval)) == null || endOfFixedInterval.getOneBasedIndexOfWaypoint() <= this.end.getOneBasedIndexOfWaypoint()) continue;
                logger.warning("In " + this + " the proxy end node's waypoint index " + this.end.getOneBasedIndexOfWaypoint() + " was exceeded by that of the fixed mark passing " + endOfFixedInterval + ". Stopping at " + this.end + " in this round; the end node will be updated soon and another round " + "of calculations will start, then with an up-to-date waypoint index for the end proxy node.");
                endOfFixedInterval = null;
            }
            boolean changed = false;
            Map<Waypoint, MarkPassing> currentPasses = this.currentMarkPasses.get(c);
            if (currentPasses.size() != mostLikelyCandidates.size()) {
                changed = true;
            } else {
                for (Candidate can : mostLikelyCandidates) {
                    MarkPassing currentPassing = currentPasses.get(can.getWaypoint());
                    if (currentPassing != null && currentPassing.getTimePoint().compareTo((Object)can.getTimePoint()) == 0) continue;
                    changed = true;
                    break;
                }
            }
            if (changed) {
                currentPasses.clear();
                ArrayList<MarkPassing> newMarkPassings = new ArrayList<MarkPassing>();
                for (Candidate can : mostLikelyCandidates) {
                    if (can == this.start || can == this.end) continue;
                    MarkPassingImpl newMarkPassing = new MarkPassingImpl(can.getTimePoint(), can.getWaypoint(), c);
                    currentPasses.put(newMarkPassing.getWaypoint(), newMarkPassing);
                    newMarkPassings.add(newMarkPassing);
                }
                logger.fine(() -> "Updating MarkPasses for " + c + " in case " + this.race.getRace().getName());
                this.race.updateMarkPassings(c, newMarkPassings);
            }
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.perCompetitorLocks.get(c));
        }
    }

    private Distance getIgnoreDueToTimingInducedEstimatedSpeeds(Competitor c, Candidate c1, Candidate c2) {
        Distance totalGreatCircleDistance;
        boolean ignore;
        assert (c1.getOneBasedIndexOfWaypoint() < c2.getOneBasedIndexOfWaypoint());
        assert (c2 != this.end);
        if (c1.getTimePoint() == null || c2.getTimePoint() == null) {
            ignore = true;
            totalGreatCircleDistance = null;
        } else {
            Waypoint second;
            MillisecondsTimePoint middleOfc1Andc2 = new MillisecondsTimePoint(c1.getTimePoint().plus(c2.getTimePoint().asMillis()).asMillis() / 2L);
            Waypoint first = this.getFirstWaypoint(c1);
            totalGreatCircleDistance = this.getMinimumTotalGreatCircleDistanceBetweenWaypoints(first, second = c2.getWaypoint(), (TimePoint)middleOfc1Andc2);
            if (totalGreatCircleDistance == null) {
                ignore = true;
            } else {
                Speed estimatedMaxSpeed = totalGreatCircleDistance.scale(2.0).inTime(c1.getTimePoint().until(c2.getTimePoint()));
                double estimatedMinSpeedBasedProbability = Math.max(0.0, estimatedMaxSpeed.divide(MINIMUM_REASONABLE_SPEED));
                double estimatedMaxSpeedBasedProbability = Math.max(0.0, MAXIMUM_REASONABLE_SPEED.divide(estimatedMaxSpeed));
                double estimatedSpeedBasedProbabilityMinimum = Math.min(estimatedMaxSpeedBasedProbability, estimatedMinSpeedBasedProbability);
                ignore = estimatedSpeedBasedProbabilityMinimum < MINIMUM_PROBABILITY;
            }
        }
        return ignore ? null : totalGreatCircleDistance;
    }

    private Waypoint getFirstWaypoint(Candidate candidate) {
        Waypoint first = candidate.getOneBasedIndexOfWaypoint() == 0 ? this.race.getRace().getCourse().getFirstWaypoint() : candidate.getWaypoint();
        return first;
    }

    private double getDistanceEstimationBasedProbability(Competitor c, Candidate c1, Candidate c2, Distance totalGreatCircleDistance) {
        double result;
        assert (c1.getOneBasedIndexOfWaypoint() < c2.getOneBasedIndexOfWaypoint());
        assert (c2 != this.end);
        if (totalGreatCircleDistance == null) {
            result = 0.0;
        } else {
            Distance actualDistanceTraveled = this.race.getTrack(c).getDistanceTraveled(c1.getTimePoint(), c2.getTimePoint());
            double probabilityForMaxReasonableRatioBetweenDistanceTraveledAndLegLength = c2.getWaypoint() == this.race.getRace().getCourse().getLastWaypoint() ? 0.95 : 1.0;
            result = this.getProbabilityOfActualDistanceGivenGreatCircleDistance(totalGreatCircleDistance, actualDistanceTraveled, probabilityForMaxReasonableRatioBetweenDistanceTraveledAndLegLength);
        }
        return result;
    }

    private double getProbabilityOfActualDistanceGivenGreatCircleDistance(Distance totalGreatCircleDistance, Distance actualDistanceTraveled, double probabilityForMaxReasonableRatioBetweenDistanceTraveledAndLegLength) {
        double ratio = actualDistanceTraveled.getMeters() / totalGreatCircleDistance.getMeters();
        double result = ratio <= 1.0 ? ratio : (ratio <= 2.0 ? 1.0 - (1.0 - probabilityForMaxReasonableRatioBetweenDistanceTraveledAndLegLength) * (ratio - 1.0) / 1.0 : probabilityForMaxReasonableRatioBetweenDistanceTraveledAndLegLength / (ratio - 2.0 + 1.0));
        return result;
    }

    private Distance getMinimumTotalGreatCircleDistanceBetweenWaypoints(Waypoint first, Waypoint second, TimePoint timePoint) {
        MeterDistance totalGreatCircleDistance = new MeterDistance(0.0);
        boolean legsAreBetweenCandidates = false;
        for (TrackedLeg leg : this.race.getTrackedLegs()) {
            Waypoint from = leg.getLeg().getFrom();
            if (from == second) break;
            if (from == first) {
                legsAreBetweenCandidates = true;
            }
            if (!legsAreBetweenCandidates) continue;
            Distance minimumDistanceToNextWaypoint = this.waypointPositionAndDistanceCache.getMinimumDistance(from, leg.getLeg().getTo(), timePoint);
            if (minimumDistanceToNextWaypoint == null) {
                totalGreatCircleDistance = null;
                break;
            }
            totalGreatCircleDistance = totalGreatCircleDistance.add(minimumDistanceToNextWaypoint).add(GPSFix.TYPICAL_HDOP.scale(-2.0));
        }
        return totalGreatCircleDistance;
    }

    private void addCandidates(Competitor c, Iterable<Candidate> newCandidates) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.perCompetitorLocks.get(c));
        try {
            for (Candidate can : newCandidates) {
                this.candidates.get(c).add(can);
            }
            this.updateFilteredCandidatesAndAdjustGraph(c, newCandidates, Collections.emptySet());
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.perCompetitorLocks.get(c));
        }
    }

    private void updateFilteredCandidatesAndAdjustGraph(Competitor c, Iterable<Candidate> newCandidates, Iterable<Candidate> removedCandidates) {
        Util.Pair<Iterable<Candidate>, Iterable<Candidate>> filteredCandidatesAddedAndRemoved = this.updateFilteredCandidates(c, newCandidates, removedCandidates);
        this.adjustGraph(c, filteredCandidatesAddedAndRemoved);
    }

    private void adjustGraph(Competitor c, Util.Pair<Iterable<Candidate>, Iterable<Candidate>> filteredCandidatesAddedAndRemoved) {
        Map<Candidate, Set<Edge>> competitorEdges = this.allEdges.get(c);
        for (Candidate candidateRemoved : (Iterable)filteredCandidatesAddedAndRemoved.getB()) {
            logger.finest(() -> "Removing all edges containing " + candidateRemoved + "of " + c);
            this.removeEdgesForCandidate(candidateRemoved, competitorEdges);
        }
        this.createNewEdges(c, (Iterable)filteredCandidatesAddedAndRemoved.getA());
    }

    private Util.Pair<Iterable<Candidate>, Iterable<Candidate>> updateFilteredCandidates(Competitor competitor, Iterable<Candidate> newCandidates, Iterable<Candidate> removedCandidates) {
        NavigableSet<Candidate> competitorCandidates = this.candidates.get(competitor);
        Util.Pair<Set<Candidate>, Set<Candidate>> filteredCandidatesAddedAndRemovedBasedOnMostProbableCandidatesPerSequence = this.mostProbableCandidatesInSmallTimeRangeFilters.get(competitor).updateCandidates(competitorCandidates, newCandidates, removedCandidates);
        Util.Pair<Iterable<Candidate>, Iterable<Candidate>> candidatesOnTheMove = this.stationarySequenceBasedFilters.get(competitor).updateCandidates((Iterable)filteredCandidatesAddedAndRemovedBasedOnMostProbableCandidatesPerSequence.getA(), (Iterable)filteredCandidatesAddedAndRemovedBasedOnMostProbableCandidatesPerSequence.getB());
        return candidatesOnTheMove;
    }

    private void removeCandidates(Competitor c, Iterable<Candidate> wrongCandidates) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.perCompetitorLocks.get(c));
        try {
            for (Candidate can : wrongCandidates) {
                this.candidates.get(c).remove(can);
            }
            this.updateFilteredCandidatesAndAdjustGraph(c, Collections.emptySet(), wrongCandidates);
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.perCompetitorLocks.get(c));
        }
    }

    private void removeEdgesForCandidate(Candidate can, Map<Candidate, Set<Edge>> edges) {
        edges.remove(can);
        for (Set<Edge> set : edges.values()) {
            Iterator<Edge> i = set.iterator();
            while (i.hasNext()) {
                Edge e = i.next();
                if (e.getStart() != can && e.getEnd() != can) continue;
                i.remove();
            }
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" for race ");
        result.append(String.valueOf(this.race.getRace().getName()) + " in regatta " + this.race.getTrackedRegatta().getRegatta().getName());
        result.append(". Filtered vs. original candidate ratio: ");
        long original = 0L;
        long filtered = 0L;
        for (Map.Entry<Competitor, NavigableSet<Candidate>> competitorAndCandidate : this.candidates.entrySet()) {
            original += (long)competitorAndCandidate.getValue().size();
            filtered += (long)Util.size(this.mostProbableCandidatesInSmallTimeRangeFilters.get(competitorAndCandidate.getKey()).getFilteredCandidates());
        }
        result.append(filtered);
        result.append("/");
        result.append(original);
        result.append("=");
        result.append((double)filtered / (double)original);
        return result.toString();
    }

    private /* synthetic */ Double lambda$0(Competitor competitor, Candidate candidate, Candidate candidate2, Distance distance) {
        return this.getDistanceEstimationBasedProbability(competitor, candidate, candidate2, distance);
    }

    private /* synthetic */ Double lambda$1(Competitor competitor, Candidate candidate, Candidate candidate2, Distance distance) {
        return this.getDistanceEstimationBasedProbability(competitor, candidate, candidate2, distance);
    }

    private static class CandidateWithSettableTime
    extends CandidateImpl {
        private static final long serialVersionUID = -1792983349299883266L;
        private TimePoint variableTimePoint;

        public CandidateWithSettableTime(int oneBasedIndexOfWaypoint, TimePoint p, double distanceProbability, Waypoint w) {
            super(oneBasedIndexOfWaypoint, null, distanceProbability, w);
            this.variableTimePoint = p;
        }

        public void setTimePoint(TimePoint t) {
            this.variableTimePoint = t;
        }

        @Override
        public TimePoint getTimePoint() {
            return this.variableTimePoint;
        }
    }

    private static class CandidateWithSettableWaypointIndex
    extends CandidateImpl {
        private static final long serialVersionUID = 5868551535609781722L;
        private int variableOneBasedWaypointIndex;

        public CandidateWithSettableWaypointIndex(int oneBasedIndexOfWaypoint, TimePoint p, double distanceProbability, Waypoint w) {
            super(-1, p, distanceProbability, w);
            this.variableOneBasedWaypointIndex = oneBasedIndexOfWaypoint;
        }

        public void setOneBasedWaypointIndex(int oneBasedWaypointIndex) {
            this.variableOneBasedWaypointIndex = oneBasedWaypointIndex;
        }

        @Override
        public int getOneBasedIndexOfWaypoint() {
            return this.variableOneBasedWaypointIndex;
        }
    }

    private class StartAndEndAwareTimeBasedCandidateComparator
    implements Comparator<Candidate> {
        private final Comparator<Timed> timedComparator = TimedComparator.INSTANCE;

        private StartAndEndAwareTimeBasedCandidateComparator() {
        }

        @Override
        public int compare(Candidate o1, Candidate o2) {
            int result;
            if (o1 == o2) {
                result = 0;
            } else if (o1 == CandidateChooserImpl.this.start || o2 == CandidateChooserImpl.this.end) {
                result = -1;
            } else if (o1 == CandidateChooserImpl.this.end || o2 == CandidateChooserImpl.this.start) {
                result = 1;
            } else {
                result = this.timedComparator.compare(o1, o2);
                if (result == 0 && (result = Integer.compare(o1.getOneBasedIndexOfWaypoint(), o2.getOneBasedIndexOfWaypoint())) == 0 && (result = Double.compare(o1.getProbability(), o2.getProbability())) == 0 && (result = o2.getClass().getSimpleName().compareTo(o1.getClass().getSimpleName())) == 0 && (result = Util.compareToWithNull((Comparable)((Object)(o1.getWaypoint() == null ? null : o1.getWaypoint().getId().toString())), o2.getWaypoint() == null ? null : o2.getWaypoint().getId().toString(), (boolean)true)) == 0) {
                    result = Integer.compare(System.identityHashCode(o1), System.identityHashCode(o2));
                }
            }
            return result;
        }
    }

    public class Stats {
        public int getTotalNumberOfCandidates() {
            int result = 0;
            for (Set competitorCandidates : CandidateChooserImpl.this.candidates.values()) {
                result += competitorCandidates.size();
            }
            return result;
        }

        public int getTotalNumberOfCandidatesAfterHighestProbabilityInShortTimeFilter() {
            int result = 0;
            for (MostProbableCandidatesInSmallTimeRangeFilter competitorCandidates : CandidateChooserImpl.this.mostProbableCandidatesInSmallTimeRangeFilters.values()) {
                result += Util.size(competitorCandidates.getFilteredCandidates());
            }
            return result;
        }

        public int getTotalNumberOfCandidatesAfterBoundingBoxFilter() {
            int result = 0;
            for (StationarySequenceBasedFilter competitorCandidates : CandidateChooserImpl.this.stationarySequenceBasedFilters.values()) {
                result += Util.size(competitorCandidates.getFilteredCandidates());
            }
            return result;
        }

        public int getTotalNumberOfEdges() {
            int result = 0;
            for (Map edgesPerCandidate : CandidateChooserImpl.this.allEdges.values()) {
                for (Set edges : edgesPerCandidate.values()) {
                    result += edges.size();
                }
            }
            return result;
        }

        public Map<Competitor, CompetitorStats> getPerCompetitorStats() {
            HashMap<Competitor, CompetitorStats> result = new HashMap<Competitor, CompetitorStats>();
            for (Map.Entry competitorAndCandidates : CandidateChooserImpl.this.candidates.entrySet()) {
                result.put((Competitor)competitorAndCandidates.getKey(), new CompetitorStats(((NavigableSet)competitorAndCandidates.getValue()).size(), Util.size(((MostProbableCandidatesInSmallTimeRangeFilter)CandidateChooserImpl.this.mostProbableCandidatesInSmallTimeRangeFilters.get(competitorAndCandidates.getKey())).getFilteredCandidates()), Util.size(((StationarySequenceBasedFilter)CandidateChooserImpl.this.stationarySequenceBasedFilters.get(competitorAndCandidates.getKey())).getFilteredCandidates()), this.getNumberOfEdges((Competitor)competitorAndCandidates.getKey())));
            }
            return result;
        }

        private int getNumberOfEdges(Competitor competitor) {
            int result = 0;
            for (Set edgeSet : ((Map)CandidateChooserImpl.this.allEdges.get(competitor)).values()) {
                result += edgeSet.size();
            }
            return result;
        }

        public class CompetitorStats {
            private final int candidates;
            private final int candidatesAfterHighestProbabilityInShortTimeFilter;
            private final int candidatesAfterBoundingBoxFilter;
            private final int edges;

            public CompetitorStats(int candidates, int candidatesAfterHighestProbabilityInShortTimeFilter, int candidatesAfterBoundingBoxFilter, int edges) {
                this.candidates = candidates;
                this.candidatesAfterHighestProbabilityInShortTimeFilter = candidatesAfterHighestProbabilityInShortTimeFilter;
                this.candidatesAfterBoundingBoxFilter = candidatesAfterBoundingBoxFilter;
                this.edges = edges;
            }

            public int getCandidates() {
                return this.candidates;
            }

            public int getCandidatesAfterHighestProbabilityInShortTimeFilter() {
                return this.candidatesAfterHighestProbabilityInShortTimeFilter;
            }

            public int getCandidatesAfterBoundingBoxFilter() {
                return this.candidatesAfterBoundingBoxFilter;
            }

            public int getEdges() {
                return this.edges;
            }
        }
    }
}

