/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.markpassingcalculation;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.markpassingcalculation.Candidate;
import com.sap.sailing.domain.markpassingcalculation.CandidateChooser;
import com.sap.sailing.domain.markpassingcalculation.CandidateFinder;
import com.sap.sailing.domain.markpassingcalculation.MarkPassingCalculator;
import com.sap.sailing.domain.markpassingcalculation.StorePositionUpdateStrategy;
import com.sap.sailing.domain.tracking.AddResult;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.impl.AbstractRaceChangeListener;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.util.IntHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MarkPassingUpdateListener
extends AbstractRaceChangeListener {
    private final MarkPassingCalculator markPassingCalculator;

    public MarkPassingUpdateListener(DynamicTrackedRace race, MarkPassingCalculator markPassingCalculator) {
        this.markPassingCalculator = markPassingCalculator;
        race.addListener(this);
    }

    @Override
    public void competitorPositionChanged(final GPSFixMoving fix, final Competitor competitor, final AddResult addedOrReplaced) {
        this.markPassingCalculator.enqueueUpdate(new StorePositionUpdateStrategy(){

            @Override
            public void storePositionUpdate(Map<Competitor, List<GPSFixMoving>> competitorFixes, Map<Competitor, List<GPSFixMoving>> competitorFixesThatReplacedExistingOnes, Map<Mark, List<GPSFix>> markFixes, List<Waypoint> addedWaypoints, List<Waypoint> removedWaypoints, IntHolder smallestChangedWaypointIndex, List<Util.Triple<Competitor, Integer, TimePoint>> fixedMarkPassings, List<Util.Pair<Competitor, Integer>> removedMarkPassings, List<Util.Pair<Competitor, Integer>> suppressedMarkPassings, List<Competitor> unSuppressedMarkPassings, CandidateFinder candidateFinder, CandidateChooser candidateChooser) {
                List<GPSFixMoving> list = competitorFixes.get(competitor);
                if (list == null) {
                    list = new ArrayList<GPSFixMoving>();
                    competitorFixes.put(competitor, list);
                }
                list.add(fix);
                if (addedOrReplaced == AddResult.REPLACED) {
                    List<GPSFixMoving> listOfReplacingFixes = competitorFixesThatReplacedExistingOnes.get(competitor);
                    if (listOfReplacingFixes == null) {
                        listOfReplacingFixes = new ArrayList<GPSFixMoving>();
                        competitorFixesThatReplacedExistingOnes.put(competitor, listOfReplacingFixes);
                    }
                    listOfReplacingFixes.add(fix);
                }
            }
        });
    }

    @Override
    public void markPositionChanged(final GPSFix fix, final Mark mark, boolean firstInTrack, AddResult addedOrReplaced) {
        this.markPassingCalculator.enqueueUpdate(new StorePositionUpdateStrategy(){

            @Override
            public void storePositionUpdate(Map<Competitor, List<GPSFixMoving>> competitorFixes, Map<Competitor, List<GPSFixMoving>> competitorFixesThatReplacedExistingOnes, Map<Mark, List<GPSFix>> markFixes, List<Waypoint> addedWaypoints, List<Waypoint> removedWaypoints, IntHolder smallestChangedWaypointIndex, List<Util.Triple<Competitor, Integer, TimePoint>> fixedMarkPassings, List<Util.Pair<Competitor, Integer>> removedMarkPassings, List<Util.Pair<Competitor, Integer>> suppressedMarkPassings, List<Competitor> unSuppressedMarkPassings, CandidateFinder candidateFinder, CandidateChooser candidateChooser) {
                List<GPSFix> list = markFixes.get(mark);
                if (list == null) {
                    list = new ArrayList<GPSFix>();
                    markFixes.put(mark, list);
                }
                list.add(fix);
            }
        });
    }

    @Override
    public void waypointAdded(final int zeroBasedIndex, final Waypoint waypointThatGotAdded) {
        this.markPassingCalculator.enqueueUpdate(new StorePositionUpdateStrategy(){

            @Override
            public void storePositionUpdate(Map<Competitor, List<GPSFixMoving>> competitorFixes, Map<Competitor, List<GPSFixMoving>> competitorFixesThatReplacedExistingOnes, Map<Mark, List<GPSFix>> markFixes, List<Waypoint> addedWaypoints, List<Waypoint> removedWaypoints, IntHolder smallestChangedWaypointIndex, List<Util.Triple<Competitor, Integer, TimePoint>> fixedMarkPassings, List<Util.Pair<Competitor, Integer>> removedMarkPassings, List<Util.Pair<Competitor, Integer>> suppressedMarkPassings, List<Competitor> unSuppressedMarkPassings, CandidateFinder candidateFinder, CandidateChooser candidateChooser) {
                addedWaypoints.add(waypointThatGotAdded);
                if (smallestChangedWaypointIndex.value == -1 || smallestChangedWaypointIndex.value > zeroBasedIndex) {
                    smallestChangedWaypointIndex.value = zeroBasedIndex;
                }
            }
        });
    }

    @Override
    public void waypointRemoved(final int zeroBasedIndex, final Waypoint waypointThatGotRemoved) {
        this.markPassingCalculator.enqueueUpdate(new StorePositionUpdateStrategy(){

            @Override
            public void storePositionUpdate(Map<Competitor, List<GPSFixMoving>> competitorFixes, Map<Competitor, List<GPSFixMoving>> competitorFixesThatReplacedExistingOnes, Map<Mark, List<GPSFix>> markFixes, List<Waypoint> addedWaypoints, List<Waypoint> removedWaypoints, IntHolder smallestChangedWaypointIndex, List<Util.Triple<Competitor, Integer, TimePoint>> fixedMarkPassings, List<Util.Pair<Competitor, Integer>> removedMarkPassings, List<Util.Pair<Competitor, Integer>> suppressedMarkPassings, List<Competitor> unSuppressedMarkPassings, CandidateFinder candidateFinder, CandidateChooser candidateChooser) {
                removedWaypoints.add(waypointThatGotRemoved);
                if (smallestChangedWaypointIndex.value == -1 || smallestChangedWaypointIndex.value > zeroBasedIndex) {
                    smallestChangedWaypointIndex.value = zeroBasedIndex;
                }
            }
        });
    }

    public void addFixedPassing(final Competitor c, final Integer zeroBasedIndexOfWaypoint, final TimePoint timePointOfFixedPassing) {
        this.markPassingCalculator.enqueueUpdate(new StorePositionUpdateStrategy(){

            @Override
            public void storePositionUpdate(Map<Competitor, List<GPSFixMoving>> competitorFixes, Map<Competitor, List<GPSFixMoving>> competitorFixesThatReplacedExistingOnes, Map<Mark, List<GPSFix>> markFixes, List<Waypoint> addedWaypoints, List<Waypoint> removedWaypoints, IntHolder smallestChangedWaypointIndex, List<Util.Triple<Competitor, Integer, TimePoint>> fixedMarkPassings, List<Util.Pair<Competitor, Integer>> removedMarkPassings, List<Util.Pair<Competitor, Integer>> suppressedMarkPassings, List<Competitor> unSuppressedMarkPassings, CandidateFinder candidateFinder, CandidateChooser candidateChooser) {
                fixedMarkPassings.add((Util.Triple<Competitor, Integer, TimePoint>)new Util.Triple((Object)c, (Object)zeroBasedIndexOfWaypoint, (Object)timePointOfFixedPassing));
            }
        });
    }

    public void removeFixedPassing(final Competitor c, final Integer zeroBasedIndexOfWaypoint) {
        this.markPassingCalculator.enqueueUpdate(new StorePositionUpdateStrategy(){

            @Override
            public void storePositionUpdate(Map<Competitor, List<GPSFixMoving>> competitorFixes, Map<Competitor, List<GPSFixMoving>> competitorFixesThatReplacedExistingOnes, Map<Mark, List<GPSFix>> markFixes, List<Waypoint> addedWaypoints, List<Waypoint> removedWaypoints, IntHolder smallestChangedWaypointIndex, List<Util.Triple<Competitor, Integer, TimePoint>> fixedMarkPassings, List<Util.Pair<Competitor, Integer>> removedMarkPassings, List<Util.Pair<Competitor, Integer>> suppressedMarkPassings, List<Competitor> unSuppressedMarkPassings, CandidateFinder candidateFinder, CandidateChooser candidateChooser) {
                removedMarkPassings.add((Util.Pair<Competitor, Integer>)new Util.Pair((Object)c, (Object)zeroBasedIndexOfWaypoint));
            }
        });
    }

    public void addSuppressedPassing(final Competitor c, final Integer zeroBasedIndexOfWaypoint) {
        this.markPassingCalculator.enqueueUpdate(new StorePositionUpdateStrategy(){

            @Override
            public void storePositionUpdate(Map<Competitor, List<GPSFixMoving>> competitorFixes, Map<Competitor, List<GPSFixMoving>> competitorFixesThatReplacedExistingOnes, Map<Mark, List<GPSFix>> markFixes, List<Waypoint> addedWaypoints, List<Waypoint> removedWaypoints, IntHolder smallestChangedWaypointIndex, List<Util.Triple<Competitor, Integer, TimePoint>> fixedMarkPassings, List<Util.Pair<Competitor, Integer>> removedMarkPassings, List<Util.Pair<Competitor, Integer>> suppressedMarkPassings, List<Competitor> unSuppressedMarkPassings, CandidateFinder candidateFinder, CandidateChooser candidateChooser) {
                suppressedMarkPassings.add((Util.Pair<Competitor, Integer>)new Util.Pair((Object)c, (Object)zeroBasedIndexOfWaypoint));
            }
        });
    }

    public void removeSuppressedPassing(final Competitor c) {
        this.markPassingCalculator.enqueueUpdate(new StorePositionUpdateStrategy(){

            @Override
            public void storePositionUpdate(Map<Competitor, List<GPSFixMoving>> competitorFixes, Map<Competitor, List<GPSFixMoving>> competitorFixesThatReplacedExistingOnes, Map<Mark, List<GPSFix>> markFixes, List<Waypoint> addedWaypoints, List<Waypoint> removedWaypoints, IntHolder smallestChangedWaypointIndex, List<Util.Triple<Competitor, Integer, TimePoint>> fixedMarkPassings, List<Util.Pair<Competitor, Integer>> removedMarkPassings, List<Util.Pair<Competitor, Integer>> suppressedMarkPassings, List<Competitor> unSuppressedMarkPassings, CandidateFinder candidateFinder, CandidateChooser candidateChooser) {
                unSuppressedMarkPassings.add(c);
            }
        });
    }

    @Override
    public void startOfRaceChanged(TimePoint oldStartOfRace, TimePoint newStartOfRace) {
        this.markPassingCalculator.enqueueUpdate(new StorePositionUpdateStrategy(){

            @Override
            public void storePositionUpdate(Map<Competitor, List<GPSFixMoving>> competitorFixes, Map<Competitor, List<GPSFixMoving>> competitorFixesThatReplacedExistingOnes, Map<Mark, List<GPSFix>> markFixes, List<Waypoint> addedWaypoints, List<Waypoint> removedWaypoints, IntHolder smallestChangedWaypointIndex, List<Util.Triple<Competitor, Integer, TimePoint>> fixedMarkPassings, List<Util.Pair<Competitor, Integer>> removedMarkPassings, List<Util.Pair<Competitor, Integer>> suppressedMarkPassings, List<Competitor> unSuppressedMarkPassings, CandidateFinder candidateFinder, CandidateChooser candidateChooser) {
                Map<Competitor, Util.Pair<Iterable<Candidate>, Iterable<Candidate>>> newAndRemovedCandidatesPerCompetitor = candidateFinder.getCandidateDeltasAfterRaceStartTimeChange();
                for (Map.Entry<Competitor, Util.Pair<Iterable<Candidate>, Iterable<Candidate>>> i : newAndRemovedCandidatesPerCompetitor.entrySet()) {
                    candidateChooser.calculateMarkPassDeltas(i.getKey(), (Iterable)i.getValue().getA(), (Iterable)i.getValue().getB());
                }
            }
        });
    }

    @Override
    public void startOfTrackingChanged(TimePoint oldStartOfTracking, TimePoint newStartOfTracking) {
        this.markPassingCalculator.enqueueUpdate(new StorePositionUpdateStrategy(){

            @Override
            public void storePositionUpdate(Map<Competitor, List<GPSFixMoving>> competitorFixes, Map<Competitor, List<GPSFixMoving>> competitorFixesThatReplacedExistingOnes, Map<Mark, List<GPSFix>> markFixes, List<Waypoint> addedWaypoints, List<Waypoint> removedWaypoints, IntHolder smallestChangedWaypointIndex, List<Util.Triple<Competitor, Integer, TimePoint>> fixedMarkPassings, List<Util.Pair<Competitor, Integer>> removedMarkPassings, List<Util.Pair<Competitor, Integer>> suppressedMarkPassings, List<Competitor> unSuppressedMarkPassings, CandidateFinder candidateFinder, CandidateChooser candidateChooser) {
                Map<Competitor, Util.Pair<Iterable<Candidate>, Iterable<Candidate>>> newAndRemovedCandidatesPerCompetitor = candidateFinder.getCandidateDeltasAfterStartOfTrackingChange();
                for (Map.Entry<Competitor, Util.Pair<Iterable<Candidate>, Iterable<Candidate>>> i : newAndRemovedCandidatesPerCompetitor.entrySet()) {
                    candidateChooser.calculateMarkPassDeltas(i.getKey(), (Iterable)i.getValue().getA(), (Iterable)i.getValue().getB());
                }
            }
        });
    }

    @Override
    public void finishedTimeChanged(final TimePoint oldFinishedTime, final TimePoint newFinishedTime) {
        this.markPassingCalculator.enqueueUpdate(new StorePositionUpdateStrategy(){

            @Override
            public void storePositionUpdate(Map<Competitor, List<GPSFixMoving>> competitorFixes, Map<Competitor, List<GPSFixMoving>> competitorFixesThatReplacedExistingOnes, Map<Mark, List<GPSFix>> markFixes, List<Waypoint> addedWaypoints, List<Waypoint> removedWaypoints, IntHolder smallestChangedWaypointIndex, List<Util.Triple<Competitor, Integer, TimePoint>> fixedMarkPassings, List<Util.Pair<Competitor, Integer>> removedMarkPassings, List<Util.Pair<Competitor, Integer>> suppressedMarkPassings, List<Competitor> unSuppressedMarkPassings, CandidateFinder candidateFinder, CandidateChooser candidateChooser) {
                Map<Competitor, Util.Pair<Iterable<Candidate>, Iterable<Candidate>>> newAndRemovedCandidatesPerCompetitor = candidateFinder.getCandidateDeltasAfterRaceFinishedTimeChange(oldFinishedTime, newFinishedTime);
                for (Map.Entry<Competitor, Util.Pair<Iterable<Candidate>, Iterable<Candidate>>> i : newAndRemovedCandidatesPerCompetitor.entrySet()) {
                    candidateChooser.calculateMarkPassDeltas(i.getKey(), (Iterable)i.getValue().getA(), (Iterable)i.getValue().getB());
                }
            }
        });
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " for " + this.markPassingCalculator;
    }
}

