/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.maneuverdetection.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.BearingChangeAnalyzer;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.NauticalSide;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.maneuverdetection.TrackTimeInfo;
import com.sap.sailing.domain.maneuverdetection.impl.AbstractManeuverDetectorImpl;
import com.sap.sailing.domain.maneuverdetection.impl.ApproximatedFixesCalculatorImpl;
import com.sap.sailing.domain.maneuverdetection.impl.ManeuverCurveBoundaryExtension;
import com.sap.sailing.domain.maneuverdetection.impl.ManeuverMainCurveDetailsWithBearingSteps;
import com.sap.sailing.domain.maneuverdetection.impl.ManeuverSpot;
import com.sap.sailing.domain.maneuverdetection.impl.ManeuverSpotWithTypedManeuvers;
import com.sap.sailing.domain.maneuverdetection.impl.WindMeasurement;
import com.sap.sailing.domain.tracking.CompleteManeuverCurve;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.ManeuverCurveBoundaries;
import com.sap.sailing.domain.tracking.ManeuverLoss;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.SpeedWithBearingStep;
import com.sap.sailing.domain.tracking.SpeedWithBearingStepsIterable;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.impl.CompleteManeuverCurveImpl;
import com.sap.sailing.domain.tracking.impl.ManeuverCurveBoundariesImpl;
import com.sap.sailing.domain.tracking.impl.ManeuverImpl;
import com.sap.sailing.domain.tracking.impl.ManeuverWithMainCurveBoundariesImpl;
import com.sap.sailing.domain.tracking.impl.ManeuverWithStableSpeedAndCourseBoundariesImpl;
import com.sap.sailing.domain.tracking.impl.SpeedWithBearingStepImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Logger;

public class ManeuverDetectorImpl
extends AbstractManeuverDetectorImpl {
    private static final Logger logger = Logger.getLogger(ManeuverDetectorImpl.class.getName());
    private static final double MAX_TURNING_RATE_IN_DEG_PER_SECOND_FOR_STABLE_COURSE_ANALYSIS = 1.0;
    private static final double MIN_ANGULAR_VELOCITY_FOR_MAIN_CURVE_BOUNDARIES_IN_DEGREES_PER_SECOND = 0.2;

    public ManeuverDetectorImpl() {
        super(null, null);
    }

    public ManeuverDetectorImpl(TrackedRace trackedRace, Competitor competitor) {
        super(trackedRace, competitor);
    }

    @Override
    public List<Maneuver> detectManeuvers() {
        return this.getAllManeuversFromManeuverSpots(this.detectManeuverSpots());
    }

    protected List<? extends ManeuverSpot> detectManeuverSpots() {
        TrackTimeInfo startAndEndTimePoints = this.getTrackTimeInfo();
        if (startAndEndTimePoints != null) {
            List<ManeuverSpot> maneuverSpots = this.detectManeuverSpots(startAndEndTimePoints.getTrackStartTimePoint(), startAndEndTimePoints.getTrackEndTimePoint());
            return maneuverSpots;
        }
        return Collections.emptyList();
    }

    public List<ManeuverSpot> detectManeuverSpots(TimePoint earliestManeuverStart, TimePoint latestManeuverEnd) {
        ApproximatedFixesCalculatorImpl approximatedFixesCalculator = new ApproximatedFixesCalculatorImpl(this.trackedRace, this.competitor);
        Iterable<GPSFixMoving> approximatedFixes = approximatedFixesCalculator.approximate(earliestManeuverStart, latestManeuverEnd);
        return this.detectManeuverSpots(approximatedFixes, earliestManeuverStart, latestManeuverEnd);
    }

    protected List<ManeuverSpot> detectManeuverSpots(Iterable<GPSFixMoving> approximatingFixesToAnalyze, TimePoint earliestManeuverStart, TimePoint latestManeuverEnd) {
        ArrayList<ManeuverSpot> result = new ArrayList<ManeuverSpot>();
        if (Util.size(approximatingFixesToAnalyze) > 2) {
            ArrayList<GPSFixMoving> fixesGroupForManeuverSpotAnalysis = new ArrayList<GPSFixMoving>();
            Iterator<GPSFixMoving> approximationPointsIter = approximatingFixesToAnalyze.iterator();
            GPSFixMoving previous = approximationPointsIter.next();
            GPSFixMoving current = approximationPointsIter.next();
            NauticalSide lastCourseChangeDirection = null;
            do {
                GPSFixMoving next = approximationPointsIter.next();
                NauticalSide courseChangeDirectionOnOriginalFixes = this.getCourseChangeDirectionAroundFix(previous.getTimePoint(), current, next.getTimePoint());
                if (!fixesGroupForManeuverSpotAnalysis.isEmpty() && !this.checkDouglasPeuckerFixesGroupable(lastCourseChangeDirection, courseChangeDirectionOnOriginalFixes, previous, current)) {
                    ManeuverSpot maneuverSpot = this.createManeuverSpotWithManeuversFromFixesGroup(fixesGroupForManeuverSpotAnalysis, lastCourseChangeDirection, earliestManeuverStart, latestManeuverEnd);
                    result.add(maneuverSpot);
                    fixesGroupForManeuverSpotAnalysis.clear();
                }
                fixesGroupForManeuverSpotAnalysis.add(current);
                previous = current;
                current = next;
                lastCourseChangeDirection = courseChangeDirectionOnOriginalFixes;
            } while (approximationPointsIter.hasNext());
            if (!fixesGroupForManeuverSpotAnalysis.isEmpty()) {
                ManeuverSpot maneuverSpot = this.createManeuverSpotWithManeuversFromFixesGroup(fixesGroupForManeuverSpotAnalysis, lastCourseChangeDirection, earliestManeuverStart, latestManeuverEnd);
                result.add(maneuverSpot);
            }
        }
        return result;
    }

    protected boolean checkDouglasPeuckerFixesGroupable(NauticalSide lastCourseChangeDirection, NauticalSide newCourseChangeDirection, GPSFixMoving previousFix, GPSFixMoving currentFix) {
        if (lastCourseChangeDirection != newCourseChangeDirection) {
            return false;
        }
        Distance threeHullLengths = this.trackedRace.getRace().getBoatOfCompetitor(this.competitor).getBoatClass().getHullLength().scale(3.0);
        return currentFix.getTimePoint().asMillis() - previousFix.getTimePoint().asMillis() <= this.getApproximateManeuverDuration().asMillis() || currentFix.getPosition().getDistance(previousFix.getPosition()).compareTo((Object)threeHullLengths) <= 0;
    }

    private List<Maneuver> getAllManeuversFromManeuverSpots(List<? extends ManeuverSpot> maneuverSpots) {
        ArrayList<Maneuver> maneuvers = new ArrayList<Maneuver>();
        for (ManeuverSpot maneuverSpot : maneuverSpots) {
            ManeuverSpotWithTypedManeuvers maneuverSpotWithTypedManeuvers = this.createManeuverSpotWithTypedManeuversFromManeuverCurve(maneuverSpot.getDouglasPeuckerFixes(), maneuverSpot.getManeuverSpotDirection(), maneuverSpot.getManeuverCurve());
            for (Maneuver maneuver : maneuverSpotWithTypedManeuvers.getManeuvers()) {
                maneuvers.add(maneuver);
            }
        }
        return maneuvers;
    }

    protected NauticalSide getCourseChangeDirectionAroundFix(TimePoint earliestCourseChangeAnalysisStart, GPSFixMoving fix, TimePoint latestCourseChangeAnalysisEnd) {
        Duration maxDurationForOriginalFixesCourseChangeInvestigation;
        TimePoint fromTimePointForCourseChangeAnalysis = earliestCourseChangeAnalysisStart;
        Duration durationFromEarliestStartToFix = fromTimePointForCourseChangeAnalysis.until(fix.getTimePoint());
        if (durationFromEarliestStartToFix.compareTo((Object)(maxDurationForOriginalFixesCourseChangeInvestigation = this.getApproximateManeuverDuration().divide(2.0))) > 0) {
            fromTimePointForCourseChangeAnalysis = fix.getTimePoint().minus(maxDurationForOriginalFixesCourseChangeInvestigation);
        }
        TimePoint toTimePointForCourseChangeAnalysis = latestCourseChangeAnalysisEnd;
        Duration durationFromFixToLatestEnd = fix.getTimePoint().until(toTimePointForCourseChangeAnalysis);
        if (durationFromFixToLatestEnd.compareTo((Object)maxDurationForOriginalFixesCourseChangeInvestigation) > 0) {
            toTimePointForCourseChangeAnalysis = fix.getTimePoint().plus(maxDurationForOriginalFixesCourseChangeInvestigation);
        }
        Bearing courseChangeOnOriginalFixes = this.getCourseChange(fromTimePointForCourseChangeAnalysis, toTimePointForCourseChangeAnalysis);
        return this.getDirectionOfCourseChange(courseChangeOnOriginalFixes.getDegrees());
    }

    private Bearing getCourseChange(TimePoint startInclusive, TimePoint endInclusive) {
        SpeedWithBearingStepsIterable speedWithBearingSteps = this.getSpeedWithBearingSteps(startInclusive, endInclusive);
        double totalCourseChangeInDegrees = 0.0;
        for (SpeedWithBearingStep step : speedWithBearingSteps) {
            totalCourseChangeInDegrees += step.getCourseChangeInDegrees();
        }
        return new DegreeBearingImpl(totalCourseChangeInDegrees);
    }

    protected ManeuverSpot createManeuverSpotWithManeuversFromFixesGroup(List<GPSFixMoving> douglasPeuckerFixesGroup, NauticalSide maneuverDirection, TimePoint earliestManeuverStart, TimePoint latestManeuverEnd) {
        CompleteManeuverCurve maneuverCurve = this.createCompleteManeuverCurveFromFixesGroup(douglasPeuckerFixesGroup, maneuverDirection, earliestManeuverStart, latestManeuverEnd);
        return new ManeuverSpot(douglasPeuckerFixesGroup, maneuverDirection, maneuverCurve);
    }

    protected ManeuverSpotWithTypedManeuvers createManeuverSpotWithTypedManeuversFromManeuverCurve(List<GPSFixMoving> douglasPeuckerFixesGroup, NauticalSide maneuverDirection, CompleteManeuverCurve maneuverCurve) {
        if (maneuverCurve == null) {
            return new ManeuverSpotWithTypedManeuvers(douglasPeuckerFixesGroup, maneuverDirection, null, new ArrayList<Maneuver>(), null);
        }
        TimePoint maneuverTimePoint = maneuverCurve.getMainCurveBoundaries().getTimePoint();
        Position maneuverPosition = this.track.getEstimatedPosition(maneuverTimePoint, false);
        Wind wind = this.trackedRace.getWind(maneuverPosition, maneuverTimePoint);
        List<Maneuver> maneuvers = this.determineManeuversFromManeuverCurve(maneuverCurve.getMainCurveBoundaries(), maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries(), wind, maneuverCurve.getMarkPassing());
        return new ManeuverSpotWithTypedManeuvers(douglasPeuckerFixesGroup, maneuverDirection, maneuverCurve, maneuvers, new WindMeasurement(maneuverTimePoint, maneuverPosition, wind == null ? null : wind.getBearing()));
    }

    private CompleteManeuverCurve createCompleteManeuverCurveFromFixesGroup(List<GPSFixMoving> douglasPeuckerFixesGroup, NauticalSide maneuverDirection, TimePoint earliestManeuverStart, TimePoint latestManeuverEnd) {
        long durationForDouglasPeuckerExtensionForMainCurveAnalysisInMillis = this.getDurationForDouglasPeuckerExtensionForMainCurveAnalysis(this.getApproximateManeuverDuration()).asMillis();
        TimePoint earliestTimePointBeforeManeuver = Collections.max(Arrays.asList(new MillisecondsTimePoint(douglasPeuckerFixesGroup.get(0).getTimePoint().asMillis() - durationForDouglasPeuckerExtensionForMainCurveAnalysisInMillis), earliestManeuverStart));
        TimePoint latestTimePointAfterManeuver = Collections.min(Arrays.asList(new MillisecondsTimePoint(douglasPeuckerFixesGroup.get(douglasPeuckerFixesGroup.size() - 1).getTimePoint().asMillis() + durationForDouglasPeuckerExtensionForMainCurveAnalysisInMillis), latestManeuverEnd));
        ManeuverMainCurveDetailsWithBearingSteps maneuverMainCurveDetails = this.computeManeuverMainCurveDetails(earliestTimePointBeforeManeuver, latestTimePointAfterManeuver, maneuverDirection);
        if (maneuverMainCurveDetails == null) {
            return null;
        }
        ManeuverCurveBoundaries maneuverUnstableCourseAndSpeedBoundaries = this.computeManeuverUnstableCourseAndSpeedBoundaries(maneuverMainCurveDetails, earliestManeuverStart, latestManeuverEnd);
        MarkPassing markPassing = this.getMarkPassingIfPresent(maneuverMainCurveDetails);
        CompleteManeuverCurveImpl maneuverCurve = new CompleteManeuverCurveImpl(maneuverMainCurveDetails, maneuverUnstableCourseAndSpeedBoundaries, markPassing);
        return maneuverCurve;
    }

    private MarkPassing getMarkPassingIfPresent(ManeuverCurveBoundaries maneuverCurveBoundaries) {
        TrackedLegOfCompetitor legBeforeManeuver = this.trackedRace.getTrackedLeg(this.competitor, maneuverCurveBoundaries.getTimePointBefore());
        TrackedLegOfCompetitor legAfterManeuver = this.trackedRace.getTrackedLeg(this.competitor, maneuverCurveBoundaries.getTimePointAfter());
        MarkPassing markPassing = null;
        if (legBeforeManeuver != legAfterManeuver && legAfterManeuver != null && legAfterManeuver.getLeg().getFrom() != this.trackedRace.getRace().getCourse().getFirstWaypoint()) {
            Waypoint waypointPassed = legAfterManeuver.getLeg().getFrom();
            markPassing = this.trackedRace.getMarkPassing(this.competitor, waypointPassed);
        }
        return markPassing;
    }

    protected List<Maneuver> determineManeuversFromManeuverCurve(ManeuverMainCurveDetailsWithBearingSteps maneuverMainCurveDetails, ManeuverCurveBoundaries maneuverUnstableCourseAndSpeedBoundaries, Wind wind, MarkPassing markPassing) {
        boolean maneuversAlreadyAdded = false;
        int numberOfJibes = this.getNumberOfJibes(maneuverMainCurveDetails, wind);
        int numberOfTacks = this.getNumberOfTacks(maneuverMainCurveDetails, wind);
        ArrayList<Maneuver> maneuvers = new ArrayList<Maneuver>();
        if (numberOfTacks > 0 && numberOfJibes > 0) {
            Util.Pair<ManeuverMainCurveDetailsWithBearingSteps, ManeuverMainCurveDetailsWithBearingSteps> mainCurves;
            if (markPassing != null && markPassing.getTimePoint().after(maneuverMainCurveDetails.getTimePointBefore()) && markPassing.getTimePoint().before(maneuverMainCurveDetails.getTimePointAfter()) && (mainCurves = this.splitManeuverMainCurveByTimePoint(maneuverMainCurveDetails, markPassing.getTimePoint())).getA() != null && mainCurves.getB() != null) {
                Util.Pair<ManeuverCurveBoundaries, ManeuverCurveBoundaries> maneuverUnstableCourseAndSpeedBoundariesPair;
                int numberOfJibesBeforeMarkPassing = this.getNumberOfJibes((ManeuverCurveBoundaries)mainCurves.getA(), wind);
                int numberOfTacksBeforeMarkPassing = this.getNumberOfTacks((ManeuverCurveBoundaries)mainCurves.getA(), wind);
                int numberOfJibesAfterMarkPassing = this.getNumberOfJibes((ManeuverCurveBoundaries)mainCurves.getB(), wind);
                int numberOfTacksAfterMarkPassing = this.getNumberOfTacks((ManeuverCurveBoundaries)mainCurves.getB(), wind);
                if (numberOfJibesBeforeMarkPassing + numberOfTacksBeforeMarkPassing > 0 && numberOfJibesAfterMarkPassing + numberOfTacksAfterMarkPassing > 0 && (maneuverUnstableCourseAndSpeedBoundariesPair = this.splitManeuverCurveWithStableSpeedAndCourseByTimePoint(maneuverUnstableCourseAndSpeedBoundaries, (ManeuverMainCurveDetailsWithBearingSteps)mainCurves.getA(), (ManeuverMainCurveDetailsWithBearingSteps)mainCurves.getB(), markPassing.getTimePoint())) != null) {
                    maneuversAlreadyAdded = true;
                    maneuvers.addAll(this.determineManeuversFromManeuverCurve((ManeuverMainCurveDetailsWithBearingSteps)mainCurves.getA(), (ManeuverCurveBoundaries)maneuverUnstableCourseAndSpeedBoundariesPair.getA(), wind, markPassing));
                    maneuvers.addAll(this.determineManeuversFromManeuverCurve((ManeuverMainCurveDetailsWithBearingSteps)mainCurves.getB(), (ManeuverCurveBoundaries)maneuverUnstableCourseAndSpeedBoundariesPair.getB(), wind, markPassing));
                }
            }
            if (!(maneuversAlreadyAdded || numberOfTacks <= 1 && numberOfJibes <= 1)) {
                TimePoint firstPenaltyCircleCompletedAt = this.getTimePointOfCompletionOfFirstPenaltyCircle(maneuverMainCurveDetails.getTimePointBefore(), maneuverMainCurveDetails.getSpeedWithBearingBefore().getBearing(), maneuverMainCurveDetails.getSpeedWithBearingSteps(), wind);
                if (firstPenaltyCircleCompletedAt == null) {
                    logger.warning("Maneuver detection has failed to process penalty circle maneuver correctly, because getTimePointOfCompletionOfFirstPenaltyCircle() returned null. Race-Id: " + this.trackedRace.getRace().getId() + ", Competitor: " + this.competitor.getName() + ", Time point before maneuver: " + maneuverUnstableCourseAndSpeedBoundaries.getTimePointBefore());
                } else {
                    Util.Pair<ManeuverMainCurveDetailsWithBearingSteps, ManeuverMainCurveDetailsWithBearingSteps> mainCurves2 = this.splitManeuverMainCurveByTimePoint(maneuverMainCurveDetails, firstPenaltyCircleCompletedAt);
                    if (mainCurves2.getA() != null && mainCurves2.getB() != null) {
                        maneuversAlreadyAdded = true;
                        Util.Pair<ManeuverCurveBoundaries, ManeuverCurveBoundaries> maneuverUnstableCourseAndSpeedBoundariesPair = this.splitManeuverCurveWithStableSpeedAndCourseByTimePoint(maneuverUnstableCourseAndSpeedBoundaries, (ManeuverMainCurveDetailsWithBearingSteps)mainCurves2.getA(), (ManeuverMainCurveDetailsWithBearingSteps)mainCurves2.getB(), firstPenaltyCircleCompletedAt);
                        maneuvers.add(this.createManeuverFromManeuverCurveAndWind((ManeuverMainCurveDetailsWithBearingSteps)mainCurves2.getA(), (ManeuverCurveBoundaries)maneuverUnstableCourseAndSpeedBoundariesPair.getA(), wind, markPassing));
                        maneuvers.addAll(this.determineManeuversFromManeuverCurve((ManeuverMainCurveDetailsWithBearingSteps)mainCurves2.getB(), (ManeuverCurveBoundaries)maneuverUnstableCourseAndSpeedBoundariesPair.getB(), wind, markPassing));
                    }
                }
            }
        }
        if (!maneuversAlreadyAdded) {
            maneuvers.add(this.createManeuverFromManeuverCurveAndWind(maneuverMainCurveDetails, maneuverUnstableCourseAndSpeedBoundaries, wind, markPassing));
        }
        return maneuvers;
    }

    private Util.Pair<ManeuverCurveBoundaries, ManeuverCurveBoundaries> splitManeuverCurveWithStableSpeedAndCourseByTimePoint(ManeuverCurveBoundaries maneuverUnstableCourseAndSpeedBoundaries, ManeuverMainCurveDetailsWithBearingSteps firstManeuverMainCurveHalf, ManeuverMainCurveDetailsWithBearingSteps lastManeuverMainCurveHalf, TimePoint timePoint) {
        SpeedWithBearingStepsIterable speedWithBearingSteps = this.getSpeedWithBearingSteps(maneuverUnstableCourseAndSpeedBoundaries.getTimePointBefore(), maneuverUnstableCourseAndSpeedBoundaries.getTimePointAfter());
        Util.Pair<SpeedWithBearingStepsIterable, SpeedWithBearingStepsIterable> splitSteps = this.splitSpeedWithBearingStepsByTimePoint(speedWithBearingSteps, timePoint);
        double courseChangeInDegreesBefore = 0.0;
        SpeedWithBearing lowestSpeedBefore = null;
        SpeedWithBearing highestSpeedBefore = null;
        SpeedWithBearingStep lastStepBefore = null;
        for (SpeedWithBearingStep step : (SpeedWithBearingStepsIterable)splitSteps.getA()) {
            courseChangeInDegreesBefore += step.getCourseChangeInDegrees();
            if (lastStepBefore == null) {
                highestSpeedBefore = lowestSpeedBefore = step.getSpeedWithBearing();
            }
            if (lowestSpeedBefore.compareTo((Object)step.getSpeedWithBearing()) > 0) {
                lowestSpeedBefore = step.getSpeedWithBearing();
            }
            if (highestSpeedBefore.compareTo((Object)step.getSpeedWithBearing()) < 0) {
                highestSpeedBefore = step.getSpeedWithBearing();
            }
            lastStepBefore = step;
        }
        double courseChangeInDegreesAfter = 0.0;
        SpeedWithBearing lowestSpeedAfter = null;
        SpeedWithBearing highestSpeedAfter = null;
        SpeedWithBearingStep firstStepAfter = null;
        if (splitSteps != null) {
            for (SpeedWithBearingStep step : (SpeedWithBearingStepsIterable)splitSteps.getB()) {
                if (firstStepAfter == null) {
                    firstStepAfter = step;
                    highestSpeedAfter = lowestSpeedAfter = step.getSpeedWithBearing();
                }
                courseChangeInDegreesAfter += step.getCourseChangeInDegrees();
                if (lowestSpeedAfter.compareTo((Object)step.getSpeedWithBearing()) > 0) {
                    lowestSpeedAfter = step.getSpeedWithBearing();
                }
                if (highestSpeedAfter.compareTo((Object)step.getSpeedWithBearing()) >= 0) continue;
                highestSpeedAfter = step.getSpeedWithBearing();
            }
        }
        if (lastStepBefore == null || firstStepAfter == null) {
            return null;
        }
        ManeuverCurveBoundariesImpl firstManeuverDetails = new ManeuverCurveBoundariesImpl(maneuverUnstableCourseAndSpeedBoundaries.getTimePointBefore(), lastStepBefore.getTimePoint(), maneuverUnstableCourseAndSpeedBoundaries.getSpeedWithBearingBefore(), lastStepBefore.getSpeedWithBearing(), courseChangeInDegreesBefore, (Speed)lowestSpeedBefore, (Speed)highestSpeedBefore);
        ManeuverCurveBoundariesImpl lastManeuverDetails = new ManeuverCurveBoundariesImpl(firstStepAfter.getTimePoint(), maneuverUnstableCourseAndSpeedBoundaries.getTimePointAfter(), firstStepAfter.getSpeedWithBearing(), maneuverUnstableCourseAndSpeedBoundaries.getSpeedWithBearingAfter(), courseChangeInDegreesAfter, (Speed)lowestSpeedAfter, (Speed)highestSpeedAfter);
        return new Util.Pair((Object)firstManeuverDetails, (Object)lastManeuverDetails);
    }

    private Util.Pair<ManeuverMainCurveDetailsWithBearingSteps, ManeuverMainCurveDetailsWithBearingSteps> splitManeuverMainCurveByTimePoint(ManeuverMainCurveDetailsWithBearingSteps maneuverMainCurveDetails, TimePoint timePoint) {
        Util.Pair<SpeedWithBearingStepsIterable, SpeedWithBearingStepsIterable> splitSteps = this.splitSpeedWithBearingStepsByTimePoint(maneuverMainCurveDetails.getSpeedWithBearingSteps(), timePoint);
        NauticalSide maneuverDirection = this.getDirectionOfCourseChange(maneuverMainCurveDetails.getDirectionChangeInDegrees());
        SpeedWithBearingStepsIterable stepsBeforeIterable = (SpeedWithBearingStepsIterable)splitSteps.getA();
        ManeuverMainCurveDetailsWithBearingSteps mainCurveBefore = stepsBeforeIterable == null ? null : this.computeManeuverMainCurve(stepsBeforeIterable, maneuverDirection);
        SpeedWithBearingStepsIterable stepsAfterIterable = (SpeedWithBearingStepsIterable)splitSteps.getB();
        ManeuverMainCurveDetailsWithBearingSteps mainCurveAfter = stepsAfterIterable == null ? null : this.computeManeuverMainCurve(stepsAfterIterable, maneuverDirection);
        return new Util.Pair((Object)mainCurveBefore, (Object)mainCurveAfter);
    }

    private Util.Pair<SpeedWithBearingStepsIterable, SpeedWithBearingStepsIterable> splitSpeedWithBearingStepsByTimePoint(SpeedWithBearingStepsIterable speedWithBearingSteps, TimePoint timePoint) {
        ArrayList<SpeedWithBearingStep> stepsBefore = new ArrayList<SpeedWithBearingStep>();
        ArrayList<SpeedWithBearingStep> stepsAfter = new ArrayList<SpeedWithBearingStep>();
        SpeedWithBearingStep lastEntry = null;
        for (SpeedWithBearingStep entry : speedWithBearingSteps) {
            if (!entry.getTimePoint().after(timePoint)) {
                stepsBefore.add(entry);
            }
            if (entry.getTimePoint().before(timePoint)) continue;
            if (stepsAfter.isEmpty()) {
                SpeedWithBearing speedWithBearing;
                if (lastEntry != null && lastEntry.getTimePoint().before(timePoint) && (speedWithBearing = this.track.getEstimatedSpeed(timePoint)) != null) {
                    double courseChangeAngleInDegrees = lastEntry.getSpeedWithBearing().getBearing().getDifferenceTo(speedWithBearing.getBearing(), (Bearing)new DegreeBearingImpl(lastEntry.getCourseChangeInDegrees())).getDegrees();
                    double turningRateInDegreesPerSecond = Math.abs(courseChangeAngleInDegrees / lastEntry.getTimePoint().until(timePoint).asSeconds());
                    SpeedWithBearingStepImpl lastStepBefore = new SpeedWithBearingStepImpl(timePoint, speedWithBearing, courseChangeAngleInDegrees, turningRateInDegreesPerSecond);
                    stepsBefore.add(lastStepBefore);
                    SpeedWithBearingStepImpl firstStepAfter = new SpeedWithBearingStepImpl(timePoint, speedWithBearing, 0.0, 0.0);
                    stepsAfter.add(firstStepAfter);
                    courseChangeAngleInDegrees = firstStepAfter.getSpeedWithBearing().getBearing().getDifferenceTo(speedWithBearing.getBearing(), (Bearing)new DegreeBearingImpl(firstStepAfter.getCourseChangeInDegrees())).getDegrees();
                    turningRateInDegreesPerSecond = Math.abs(courseChangeAngleInDegrees / timePoint.until(entry.getTimePoint()).asSeconds());
                    entry = new SpeedWithBearingStepImpl(entry.getTimePoint(), entry.getSpeedWithBearing(), courseChangeAngleInDegrees, turningRateInDegreesPerSecond);
                }
                if (stepsAfter.isEmpty()) {
                    entry = new SpeedWithBearingStepImpl(entry.getTimePoint(), entry.getSpeedWithBearing(), 0.0, 0.0);
                }
            }
            stepsAfter.add(entry);
        }
        return new Util.Pair((Object)(stepsBefore.isEmpty() ? null : new SpeedWithBearingStepsIterable(stepsBefore)), (Object)(stepsAfter.isEmpty() ? null : new SpeedWithBearingStepsIterable(stepsAfter)));
    }

    private Maneuver createManeuverFromManeuverCurveAndWind(ManeuverMainCurveDetailsWithBearingSteps maneuverMainCurveDetails, ManeuverCurveBoundaries maneuverUnstableCourseAndSpeedBoundaries, Wind wind, MarkPassing markPassing) {
        ManeuverImpl maneuver;
        Position positionForNewTack;
        ManeuverType maneuverType;
        Tack tackAfterManeuver = null;
        ManeuverLoss maneuverLoss = null;
        Position maneuverPosition = this.track.getEstimatedPosition(maneuverMainCurveDetails.getTimePoint(), false);
        int numberOfJibes = this.getNumberOfJibes(maneuverMainCurveDetails, wind);
        int numberOfTacks = this.getNumberOfTacks(maneuverMainCurveDetails, wind);
        if (numberOfTacks > 0 && numberOfJibes > 0) {
            maneuverType = ManeuverType.PENALTY_CIRCLE;
        } else if (numberOfTacks > 0 || numberOfJibes > 0) {
            maneuverType = numberOfTacks > 0 ? ManeuverType.TACK : ManeuverType.JIBE;
        } else if (wind != null) {
            Bearing windBearing = wind.getBearing();
            Bearing toWindBeforeManeuver = windBearing.getDifferenceTo(maneuverMainCurveDetails.getSpeedWithBearingBefore().getBearing());
            Bearing toWindAfterManeuver = windBearing.getDifferenceTo(maneuverMainCurveDetails.getSpeedWithBearingAfter().getBearing());
            maneuverType = Math.abs(toWindBeforeManeuver.getDegrees()) < Math.abs(toWindAfterManeuver.getDegrees()) ? ManeuverType.HEAD_UP : ManeuverType.BEAR_AWAY;
        } else {
            maneuverType = ManeuverType.UNKNOWN;
        }
        if (numberOfTacks + numberOfJibes > 0 || wind == null) {
            if (wind != null) {
                try {
                    positionForNewTack = this.track.getEstimatedPosition(maneuverUnstableCourseAndSpeedBoundaries.getTimePointAfter(), false);
                    if (positionForNewTack != null) {
                        tackAfterManeuver = this.trackedRace.getTack(positionForNewTack, maneuverUnstableCourseAndSpeedBoundaries.getTimePointAfter(), maneuverUnstableCourseAndSpeedBoundaries.getSpeedWithBearingAfter().getBearing());
                    }
                }
                catch (NoWindException e) {
                    tackAfterManeuver = null;
                }
            } else {
                tackAfterManeuver = null;
            }
            maneuverLoss = this.getManeuverLoss(maneuverUnstableCourseAndSpeedBoundaries);
            maneuver = new ManeuverWithStableSpeedAndCourseBoundariesImpl(maneuverType, tackAfterManeuver, maneuverPosition, maneuverMainCurveDetails.getTimePoint(), maneuverMainCurveDetails.extractCurveBoundariesOnly(), maneuverUnstableCourseAndSpeedBoundaries, maneuverMainCurveDetails.getMaxTurningRateInDegreesPerSecond(), markPassing, maneuverLoss);
        } else {
            try {
                positionForNewTack = this.track.getEstimatedPosition(maneuverMainCurveDetails.getTimePointAfter(), false);
                if (positionForNewTack != null) {
                    tackAfterManeuver = this.trackedRace.getTack(positionForNewTack, maneuverMainCurveDetails.getTimePointAfter(), maneuverMainCurveDetails.getSpeedWithBearingAfter().getBearing());
                }
            }
            catch (NoWindException e) {
                tackAfterManeuver = null;
            }
            maneuver = new ManeuverWithMainCurveBoundariesImpl(maneuverType, tackAfterManeuver, maneuverPosition, maneuverMainCurveDetails.getTimePoint(), maneuverMainCurveDetails.extractCurveBoundariesOnly(), maneuverUnstableCourseAndSpeedBoundaries, maneuverMainCurveDetails.getMaxTurningRateInDegreesPerSecond(), markPassing, maneuverLoss);
        }
        return maneuver;
    }

    protected ManeuverLoss getManeuverLoss(ManeuverCurveBoundaries maneuverBoundaries) {
        GPSFixTrack<Competitor, GPSFixMoving> track = this.trackedRace.getTrack(this.competitor);
        SpeedWithBearing speedWithBearingWhenSpeedStartedToDrop = maneuverBoundaries.getSpeedWithBearingBefore();
        SpeedWithBearing speedWithBearingAfterManeuver = maneuverBoundaries.getSpeedWithBearingAfter();
        TimePoint timePointWhenSpeedStartedToDrop = maneuverBoundaries.getTimePointBefore();
        TimePoint timePointWhenSpeedLevelledOffAfterManeuver = maneuverBoundaries.getTimePointAfter();
        Duration maneuverDuration = timePointWhenSpeedStartedToDrop.until(timePointWhenSpeedLevelledOffAfterManeuver);
        Bearing middleManeuverAngle = speedWithBearingWhenSpeedStartedToDrop.getBearing().middle(speedWithBearingAfterManeuver.getBearing());
        Position positionWhenSpeedStartedToDrop = track.getEstimatedPosition(timePointWhenSpeedStartedToDrop, false);
        Position extrapolatedPositionAtTimePointOfMaxSpeedAfterManeuver = speedWithBearingWhenSpeedStartedToDrop.travelTo(positionWhenSpeedStartedToDrop, timePointWhenSpeedStartedToDrop, timePointWhenSpeedLevelledOffAfterManeuver);
        Position actualPositionAtTimePointOfMaxSpeedAfterManeuver = track.getEstimatedPosition(timePointWhenSpeedLevelledOffAfterManeuver, false);
        Position projectedExtrapolatedPositionAtTimePointOfMaxSpeedAfterManeuver = extrapolatedPositionAtTimePointOfMaxSpeedAfterManeuver.projectToLineThrough(positionWhenSpeedStartedToDrop, middleManeuverAngle);
        Position projectedActualPositionAtTimePointOfMaxSpeedAfterManeuver = actualPositionAtTimePointOfMaxSpeedAfterManeuver.projectToLineThrough(positionWhenSpeedStartedToDrop, middleManeuverAngle);
        Distance projectedDistanceSailed = positionWhenSpeedStartedToDrop.getDistance(projectedActualPositionAtTimePointOfMaxSpeedAfterManeuver);
        Distance projectedDistanceSailedIfNotManeuvering = positionWhenSpeedStartedToDrop.getDistance(projectedExtrapolatedPositionAtTimePointOfMaxSpeedAfterManeuver);
        return new ManeuverLoss(projectedDistanceSailed, projectedDistanceSailedIfNotManeuvering, positionWhenSpeedStartedToDrop, actualPositionAtTimePointOfMaxSpeedAfterManeuver, maneuverDuration, speedWithBearingWhenSpeedStartedToDrop, middleManeuverAngle);
    }

    protected Duration getDurationForDouglasPeuckerExtensionForMainCurveAnalysis(Duration approximateManeuverDuration) {
        return approximateManeuverDuration.divide(2L);
    }

    private TimePoint getTimePointOfCompletionOfFirstPenaltyCircle(TimePoint timePointBeforeManeuver, Bearing courseBeforeManeuver, SpeedWithBearingStepsIterable maneuverBearingSteps, Wind wind) {
        double totalCourseChangeInDegrees = 0.0;
        double bestTotalCourseChangeInDegrees = 0.0;
        BearingChangeAnalyzer bearingChangeAnalyzer = BearingChangeAnalyzer.INSTANCE;
        Bearing newCourse = courseBeforeManeuver;
        TimePoint result = null;
        boolean firstEntry = true;
        for (SpeedWithBearingStep fixAndCourseChange : maneuverBearingSteps) {
            if (firstEntry) {
                firstEntry = false;
                continue;
            }
            newCourse = newCourse.add((Bearing)new DegreeBearingImpl(fixAndCourseChange.getCourseChangeInDegrees()));
            int numberOfJibes = bearingChangeAnalyzer.didPass(courseBeforeManeuver, totalCourseChangeInDegrees += fixAndCourseChange.getCourseChangeInDegrees(), newCourse, wind.getBearing());
            int numberOfTacks = bearingChangeAnalyzer.didPass(courseBeforeManeuver, totalCourseChangeInDegrees, newCourse, wind.getFrom());
            if (numberOfJibes <= 0 || numberOfTacks <= 0) continue;
            if (numberOfJibes > 1 || numberOfTacks > 1) {
                if (result != null) break;
                result = fixAndCourseChange.getTimePoint();
                break;
            }
            if (!(Math.abs(360.0 - Math.abs(totalCourseChangeInDegrees)) < Math.abs(360.0 - Math.abs(bestTotalCourseChangeInDegrees)))) break;
            bestTotalCourseChangeInDegrees = totalCourseChangeInDegrees;
            result = fixAndCourseChange.getTimePoint();
        }
        return result;
    }

    protected ManeuverMainCurveDetailsWithBearingSteps computeManeuverMainCurveDetails(TimePoint timePointBeforeManeuver, TimePoint timePointAfterManeuver, NauticalSide maneuverDirection) {
        SpeedWithBearingStepsIterable stepsToAnalyze = this.getSpeedWithBearingSteps(timePointBeforeManeuver, timePointAfterManeuver);
        ManeuverMainCurveDetailsWithBearingSteps maneuverMainCurveDetails = this.computeManeuverMainCurve(stepsToAnalyze, maneuverDirection);
        return maneuverMainCurveDetails;
    }

    protected SpeedWithBearingStepsIterable getSpeedWithBearingSteps(TimePoint timePointBeforeManeuver, TimePoint timePointAfterManeuver) {
        SpeedWithBearingStepsIterable stepsToAnalyze = this.track.getSpeedWithBearingSteps(timePointBeforeManeuver, timePointAfterManeuver);
        return stepsToAnalyze;
    }

    private ManeuverCurveBoundaries computeManeuverUnstableCourseAndSpeedBoundaries(ManeuverMainCurveDetailsWithBearingSteps maneuverMainCurveDetails, TimePoint earliestManeuverStart, TimePoint latestManeuverEnd) {
        Speed highestSpeed;
        ManeuverCurveBoundaryExtension beforeManeuverSectionExtension = this.expandBeforeManeuverSectionBySpeedAndBearingTrendAnalysis(maneuverMainCurveDetails, earliestManeuverStart);
        ManeuverCurveBoundaryExtension afterManeuverSectionExtension = this.expandAfterManeuverSectionBySpeedAndBearingTrendAnalysis(maneuverMainCurveDetails, latestManeuverEnd);
        double totalCourseChangeInDegrees = beforeManeuverSectionExtension.getCourseChangeInDegreesWithinExtensionArea() + maneuverMainCurveDetails.getDirectionChangeInDegrees() + afterManeuverSectionExtension.getCourseChangeInDegreesWithinExtensionArea();
        Speed lowestSpeed = maneuverMainCurveDetails.getLowestSpeed();
        if (lowestSpeed == null || beforeManeuverSectionExtension.getLowestSpeedWithinExtensionArea() != null && lowestSpeed.compareTo((Object)beforeManeuverSectionExtension.getLowestSpeedWithinExtensionArea()) > 0) {
            lowestSpeed = beforeManeuverSectionExtension.getLowestSpeedWithinExtensionArea();
        }
        if (lowestSpeed == null || afterManeuverSectionExtension.getLowestSpeedWithinExtensionArea() != null && lowestSpeed.compareTo((Object)afterManeuverSectionExtension.getLowestSpeedWithinExtensionArea()) > 0) {
            lowestSpeed = afterManeuverSectionExtension.getLowestSpeedWithinExtensionArea();
        }
        if ((highestSpeed = maneuverMainCurveDetails.getHighestSpeed()) == null || beforeManeuverSectionExtension.getHighestSpeedWithinExtensionArea() != null && highestSpeed.compareTo((Object)beforeManeuverSectionExtension.getHighestSpeedWithinExtensionArea()) < 0) {
            highestSpeed = beforeManeuverSectionExtension.getHighestSpeedWithinExtensionArea();
        }
        if (highestSpeed == null || afterManeuverSectionExtension.getHighestSpeedWithinExtensionArea() != null && highestSpeed.compareTo((Object)afterManeuverSectionExtension.getHighestSpeedWithinExtensionArea()) < 0) {
            highestSpeed = afterManeuverSectionExtension.getHighestSpeedWithinExtensionArea();
        }
        return new ManeuverCurveBoundariesImpl(beforeManeuverSectionExtension.getExtensionTimePoint(), afterManeuverSectionExtension.getExtensionTimePoint(), beforeManeuverSectionExtension.getSpeedWithBearingAtExtensionTimePoint(), afterManeuverSectionExtension.getSpeedWithBearingAtExtensionTimePoint(), totalCourseChangeInDegrees, lowestSpeed, highestSpeed);
    }

    private ManeuverCurveBoundaryExtension expandBeforeManeuverSectionBySpeedAndBearingTrendAnalysis(ManeuverMainCurveDetailsWithBearingSteps maneuverMainCurveDetails, TimePoint earliestManeuverStart) {
        TimePoint stableBearingAnalysisUntil;
        ManeuverCurveBoundaryExtension stableBearingExtension;
        ManeuverCurveBoundaryExtension mergedExtension;
        Duration approximateManeuverDuration = this.getApproximateManeuverDuration();
        Duration minDurationForSpeedTrendAnalysis = approximateManeuverDuration.divide(8.0);
        Duration maxDurationForSpeedTrendAnalysis = approximateManeuverDuration;
        TimePoint latestTimePointForSpeedTrendAnalysis = maneuverMainCurveDetails.getTimePointBefore();
        TimePoint earliestTimePointForSpeedTrendAnalysis = latestTimePointForSpeedTrendAnalysis.minus(maxDurationForSpeedTrendAnalysis);
        if (earliestTimePointForSpeedTrendAnalysis.before(earliestManeuverStart)) {
            earliestTimePointForSpeedTrendAnalysis = earliestManeuverStart;
        }
        TimePoint timePointSinceGlobalMaximumSearch = latestTimePointForSpeedTrendAnalysis.minus(minDurationForSpeedTrendAnalysis);
        SpeedWithBearingStepsIterable stepsToAnalyze = this.getSpeedWithBearingSteps(earliestTimePointForSpeedTrendAnalysis, latestTimePointForSpeedTrendAnalysis);
        ManeuverCurveBoundaryExtension maneuverStart = this.findSpeedMaximum(stepsToAnalyze, true, timePointSinceGlobalMaximumSearch);
        if (this.isCourseChangeLimitExceededForCurveExtension(maneuverMainCurveDetails, maneuverStart)) {
            maneuverStart = null;
        }
        if (!this.isCourseChangeLimitExceededForCurveExtension(maneuverMainCurveDetails, mergedExtension = this.extendManeuverCurveBoundaryExtension(maneuverStart, stableBearingExtension = this.findStableBearingWithMaxAbsCourseChangeSpeed(stepsToAnalyze = this.getSpeedWithBearingStepsWithinTimeRange(stepsToAnalyze, earliestTimePointForSpeedTrendAnalysis, stableBearingAnalysisUntil = maneuverStart == null ? maneuverMainCurveDetails.getTimePointBefore() : maneuverStart.getExtensionTimePoint()), true, 1.0)))) {
            maneuverStart = mergedExtension;
        }
        return maneuverStart != null ? maneuverStart : new ManeuverCurveBoundaryExtension(maneuverMainCurveDetails.getTimePointBefore(), maneuverMainCurveDetails.getSpeedWithBearingBefore(), 0.0, null, null);
    }

    private ManeuverCurveBoundaryExtension extendManeuverCurveBoundaryExtension(ManeuverCurveBoundaryExtension previousExtension, ManeuverCurveBoundaryExtension newExtension) {
        if (previousExtension == null) {
            return newExtension;
        }
        if (newExtension == null) {
            return previousExtension;
        }
        Speed lowestSpeed = previousExtension.getLowestSpeedWithinExtensionArea().compareTo((Object)newExtension.getLowestSpeedWithinExtensionArea()) > 0 ? newExtension.getLowestSpeedWithinExtensionArea() : previousExtension.getLowestSpeedWithinExtensionArea();
        Speed highestSpeed = previousExtension.getHighestSpeedWithinExtensionArea().compareTo((Object)newExtension.getHighestSpeedWithinExtensionArea()) < 0 ? newExtension.getHighestSpeedWithinExtensionArea() : previousExtension.getHighestSpeedWithinExtensionArea();
        double courseChangeInDegrees = previousExtension.getCourseChangeInDegreesWithinExtensionArea() + newExtension.getCourseChangeInDegreesWithinExtensionArea();
        ManeuverCurveBoundaryExtension mergedExtension = new ManeuverCurveBoundaryExtension(newExtension.getExtensionTimePoint(), newExtension.getSpeedWithBearingAtExtensionTimePoint(), courseChangeInDegrees, lowestSpeed, highestSpeed);
        return mergedExtension;
    }

    private boolean isCourseChangeLimitExceededForCurveExtension(ManeuverMainCurveDetailsWithBearingSteps maneuverMainCurveDetails, ManeuverCurveBoundaryExtension curveBoundaryExtension) {
        if (curveBoundaryExtension == null) {
            return false;
        }
        return Math.abs(maneuverMainCurveDetails.getDirectionChangeInDegrees()) / 2.0 < Math.abs(curveBoundaryExtension.getCourseChangeInDegreesWithinExtensionArea());
    }

    private ManeuverCurveBoundaryExtension expandAfterManeuverSectionBySpeedAndBearingTrendAnalysis(ManeuverMainCurveDetailsWithBearingSteps maneuverMainCurveDetails, TimePoint latestManeuverEnd) {
        TimePoint stableBearingAnalysisFrom;
        ManeuverCurveBoundaryExtension stableBearingExtension;
        ManeuverCurveBoundaryExtension mergedExtension;
        Duration approximateManeuverDuration;
        Duration minDurationForSpeedTrendAnalysis = approximateManeuverDuration = this.getApproximateManeuverDuration();
        Duration maxDurationForSpeedTrendAnalysis = this.getMaxDurationForAfterManeuverSectionExtension(approximateManeuverDuration);
        TimePoint earliestTimePointForSpeedTrendAnalysis = maneuverMainCurveDetails.getTimePointAfter();
        TimePoint latestTimePointForSpeedTrendAnalysis = earliestTimePointForSpeedTrendAnalysis.plus(maxDurationForSpeedTrendAnalysis);
        if (latestTimePointForSpeedTrendAnalysis.after(latestManeuverEnd)) {
            latestTimePointForSpeedTrendAnalysis = latestManeuverEnd;
        }
        TimePoint timePointBeforeLocalMaximumSearch = earliestTimePointForSpeedTrendAnalysis.plus(minDurationForSpeedTrendAnalysis);
        SpeedWithBearingStepsIterable stepsToAnalyze = this.getSpeedWithBearingSteps(earliestTimePointForSpeedTrendAnalysis, latestTimePointForSpeedTrendAnalysis);
        ManeuverCurveBoundaryExtension maneuverEnd = this.findSpeedMaximum(stepsToAnalyze, false, timePointBeforeLocalMaximumSearch);
        if (this.isCourseChangeLimitExceededForCurveExtension(maneuverMainCurveDetails, maneuverEnd)) {
            maneuverEnd = null;
        }
        if (!this.isCourseChangeLimitExceededForCurveExtension(maneuverMainCurveDetails, mergedExtension = this.extendManeuverCurveBoundaryExtension(maneuverEnd, stableBearingExtension = this.findStableBearingWithMaxAbsCourseChangeSpeed(stepsToAnalyze = this.getSpeedWithBearingStepsWithinTimeRange(stepsToAnalyze, stableBearingAnalysisFrom = maneuverEnd == null ? maneuverMainCurveDetails.getTimePointAfter() : maneuverEnd.getExtensionTimePoint(), latestTimePointForSpeedTrendAnalysis), false, 1.0)))) {
            maneuverEnd = mergedExtension;
        }
        return maneuverEnd != null ? maneuverEnd : new ManeuverCurveBoundaryExtension(maneuverMainCurveDetails.getTimePointAfter(), maneuverMainCurveDetails.getSpeedWithBearingAfter(), 0.0, null, null);
    }

    protected Duration getMaxDurationForAfterManeuverSectionExtension(Duration approximateManeuverDuration) {
        return approximateManeuverDuration.times(3.0);
    }

    public ManeuverCurveBoundaryExtension findSpeedMaximum(SpeedWithBearingStepsIterable stepsToAnalyze, boolean timeBackwardSearch, TimePoint globalMaximumSearchUntilTimePoint) {
        Predicate<SpeedWithBearingStep> localMaximumSearch;
        Iterable<SpeedWithBearingStep> finalStepsToAnalyze;
        if (timeBackwardSearch) {
            finalStepsToAnalyze = this.cloneAndReverseIterable(stepsToAnalyze);
            localMaximumSearch = step -> globalMaximumSearchUntilTimePoint == null ? false : step.getTimePoint().before(globalMaximumSearchUntilTimePoint);
        } else {
            finalStepsToAnalyze = stepsToAnalyze;
            localMaximumSearch = step -> globalMaximumSearchUntilTimePoint == null ? false : step.getTimePoint().after(globalMaximumSearchUntilTimePoint);
        }
        double previousSpeedInKnots = 0.0;
        double maxSpeedInKnots = 0.0;
        SpeedWithBearingStep stepWithMaxSpeed = null;
        double courseChangeSinceMainCurveBeforeSpeedMaximumInDegrees = 0.0;
        double courseChangeAfterStepWithSpeedMaximum = 0.0;
        SpeedWithBearing lowestSpeed = null;
        SpeedWithBearing highestSpeed = null;
        for (SpeedWithBearingStep speedWithBearingStep : finalStepsToAnalyze) {
            courseChangeAfterStepWithSpeedMaximum += speedWithBearingStep.getCourseChangeInDegrees();
            double speedInKnots = speedWithBearingStep.getSpeedWithBearing().getKnots();
            if (localMaximumSearch.test(speedWithBearingStep) && previousSpeedInKnots > speedInKnots) break;
            if (maxSpeedInKnots < speedInKnots) {
                maxSpeedInKnots = speedInKnots;
                stepWithMaxSpeed = speedWithBearingStep;
                courseChangeSinceMainCurveBeforeSpeedMaximumInDegrees += courseChangeAfterStepWithSpeedMaximum;
                courseChangeAfterStepWithSpeedMaximum = 0.0;
            }
            if (lowestSpeed == null || lowestSpeed.compareTo((Object)speedWithBearingStep.getSpeedWithBearing()) > 0) {
                lowestSpeed = speedWithBearingStep.getSpeedWithBearing();
            }
            if (highestSpeed == null || highestSpeed.compareTo((Object)speedWithBearingStep.getSpeedWithBearing()) < 0) {
                highestSpeed = speedWithBearingStep.getSpeedWithBearing();
            }
            previousSpeedInKnots = speedInKnots;
        }
        if (timeBackwardSearch && stepWithMaxSpeed != null) {
            courseChangeSinceMainCurveBeforeSpeedMaximumInDegrees -= stepWithMaxSpeed.getCourseChangeInDegrees();
        }
        return stepWithMaxSpeed == null ? null : new ManeuverCurveBoundaryExtension(stepWithMaxSpeed.getTimePoint(), stepWithMaxSpeed.getSpeedWithBearing(), courseChangeSinceMainCurveBeforeSpeedMaximumInDegrees, (Speed)lowestSpeed, (Speed)highestSpeed);
    }

    private Iterable<SpeedWithBearingStep> cloneAndReverseIterable(SpeedWithBearingStepsIterable stepsToAnalyze) {
        ArrayList<SpeedWithBearingStep> tempSteps = new ArrayList<SpeedWithBearingStep>();
        for (SpeedWithBearingStep step : stepsToAnalyze) {
            tempSteps.add(step);
        }
        Collections.reverse(tempSteps);
        return tempSteps;
    }

    public ManeuverCurveBoundaryExtension findStableBearingWithMaxAbsCourseChangeSpeed(SpeedWithBearingStepsIterable stepsToAnalyze, boolean timeBackwardSearch, double maxCourseChangeInDegreesPerSecond) {
        Iterable<SpeedWithBearingStep> finalStepsToAnalyze = timeBackwardSearch ? this.cloneAndReverseIterable(stepsToAnalyze) : stepsToAnalyze;
        SpeedWithBearingStep previousStep = null;
        SpeedWithBearingStep stepUntilStableBearing = null;
        double courseChangeUntilStepWithStableBearingInDegrees = 0.0;
        SpeedWithBearing lowestSpeed = null;
        SpeedWithBearing highestSpeed = null;
        for (SpeedWithBearingStep currentStep : finalStepsToAnalyze) {
            double courseChangePerSecondInDegrees;
            if (previousStep != null && (courseChangePerSecondInDegrees = Math.abs(currentStep.getCourseChangeInDegrees() / previousStep.getTimePoint().until(currentStep.getTimePoint()).asSeconds())) <= maxCourseChangeInDegreesPerSecond) {
                stepUntilStableBearing = timeBackwardSearch ? currentStep : previousStep;
                break;
            }
            if (lowestSpeed == null || lowestSpeed.compareTo((Object)currentStep.getSpeedWithBearing()) > 0) {
                lowestSpeed = currentStep.getSpeedWithBearing();
            }
            if (highestSpeed == null || highestSpeed.compareTo((Object)currentStep.getSpeedWithBearing()) < 0) {
                highestSpeed = currentStep.getSpeedWithBearing();
            }
            courseChangeUntilStepWithStableBearingInDegrees += currentStep.getCourseChangeInDegrees();
            previousStep = currentStep;
        }
        if (stepUntilStableBearing == null) {
            stepUntilStableBearing = previousStep;
        }
        return stepUntilStableBearing == null ? null : new ManeuverCurveBoundaryExtension(stepUntilStableBearing.getTimePoint(), stepUntilStableBearing.getSpeedWithBearing(), courseChangeUntilStepWithStableBearingInDegrees, (Speed)lowestSpeed, (Speed)highestSpeed);
    }

    public ManeuverMainCurveDetailsWithBearingSteps computeManeuverMainCurve(SpeedWithBearingStepsIterable bearingStepsToAnalyze, NauticalSide maneuverDirection) {
        double totalCourseChangeSignum = maneuverDirection == NauticalSide.PORT ? -1 : 1;
        double maxCourseChangeInDegrees = 0.0;
        double currentCourseChangeInDegrees = 0.0;
        double maxTurningRateInDegreesPerSecond = 0.0;
        double maxTurningRateInDegreesPerSecondCandidate = 0.0;
        Speed lowestSpeed = null;
        SpeedWithBearing lowestSpeedCandidate = null;
        Speed highestSpeed = null;
        SpeedWithBearing highestSpeedCandidate = null;
        TimePoint maneuverTimePoint = null;
        TimePoint maneuverTimePointCandidate = null;
        TimePoint previousTimePoint = null;
        TimePoint refinedTimePointBeforeManeuver = null;
        SpeedWithBearing refinedSpeedWithBearingBeforeManeuver = null;
        TimePoint refinedTimePointAfterManeuver = null;
        SpeedWithBearing refinedSpeedWithBearingAfterManeuver = null;
        boolean turningRateMinimumReachedAtMainCurveBeginning = false;
        ManeuverCurveBoundariesImpl bestBoundariesBeforeReset = null;
        for (SpeedWithBearingStep entry : bearingStepsToAnalyze) {
            TimePoint timePoint = entry.getTimePoint();
            if (0.0 >= (currentCourseChangeInDegrees += entry.getCourseChangeInDegrees()) * totalCourseChangeSignum || !turningRateMinimumReachedAtMainCurveBeginning && entry.getTurningRateInDegreesPerSecond() < 0.2) {
                if (maxCourseChangeInDegrees * totalCourseChangeSignum >= 0.2 && (bestBoundariesBeforeReset == null || bestBoundariesBeforeReset.getDirectionChangeInDegrees() * totalCourseChangeSignum < maxCourseChangeInDegrees)) {
                    bestBoundariesBeforeReset = new ManeuverMainCurveDetailsWithBearingSteps(refinedTimePointBeforeManeuver, refinedTimePointAfterManeuver, maneuverTimePoint, refinedSpeedWithBearingBeforeManeuver, refinedSpeedWithBearingAfterManeuver, maxCourseChangeInDegrees, maxTurningRateInDegreesPerSecond, lowestSpeed, highestSpeed, null);
                }
                currentCourseChangeInDegrees = 0.0;
                maxCourseChangeInDegrees = 0.0;
                refinedTimePointBeforeManeuver = timePoint;
                refinedSpeedWithBearingBeforeManeuver = entry.getSpeedWithBearing();
                refinedTimePointAfterManeuver = null;
                refinedSpeedWithBearingAfterManeuver = null;
                turningRateMinimumReachedAtMainCurveBeginning = false;
                maneuverTimePointCandidate = null;
                maneuverTimePoint = null;
                maxTurningRateInDegreesPerSecondCandidate = 0.0;
                maxTurningRateInDegreesPerSecond = 0.0;
                lowestSpeedCandidate = entry.getSpeedWithBearing();
                lowestSpeed = lowestSpeedCandidate;
                highestSpeedCandidate = lowestSpeedCandidate;
                highestSpeed = lowestSpeedCandidate;
            } else {
                turningRateMinimumReachedAtMainCurveBeginning = true;
            }
            if (lowestSpeedCandidate == null || lowestSpeedCandidate.compareTo((Object)entry.getSpeedWithBearing()) > 0) {
                lowestSpeedCandidate = entry.getSpeedWithBearing();
            }
            if (highestSpeedCandidate == null || highestSpeedCandidate.compareTo((Object)entry.getSpeedWithBearing()) < 0) {
                highestSpeedCandidate = entry.getSpeedWithBearing();
            }
            if (0.0 < currentCourseChangeInDegrees * totalCourseChangeSignum && maxTurningRateInDegreesPerSecondCandidate < entry.getTurningRateInDegreesPerSecond()) {
                maxTurningRateInDegreesPerSecondCandidate = entry.getTurningRateInDegreesPerSecond();
                Duration durationFromPreviousStep = previousTimePoint.until(timePoint);
                maneuverTimePointCandidate = previousTimePoint.plus(durationFromPreviousStep.divide(2.0));
            }
            if (maxCourseChangeInDegrees * totalCourseChangeSignum < currentCourseChangeInDegrees * totalCourseChangeSignum && entry.getTurningRateInDegreesPerSecond() >= 0.2) {
                maxCourseChangeInDegrees = currentCourseChangeInDegrees;
                refinedTimePointAfterManeuver = timePoint;
                refinedSpeedWithBearingAfterManeuver = entry.getSpeedWithBearing();
                maxTurningRateInDegreesPerSecond = maxTurningRateInDegreesPerSecondCandidate;
                maneuverTimePoint = maneuverTimePointCandidate;
                lowestSpeed = lowestSpeedCandidate;
                highestSpeed = highestSpeedCandidate;
            }
            previousTimePoint = timePoint;
        }
        if (bestBoundariesBeforeReset != null && bestBoundariesBeforeReset.getDirectionChangeInDegrees() * totalCourseChangeSignum >= maxCourseChangeInDegrees * totalCourseChangeSignum) {
            refinedTimePointBeforeManeuver = bestBoundariesBeforeReset.getTimePointBefore();
            refinedTimePointAfterManeuver = bestBoundariesBeforeReset.getTimePointAfter();
            refinedSpeedWithBearingBeforeManeuver = bestBoundariesBeforeReset.getSpeedWithBearingBefore();
            refinedSpeedWithBearingAfterManeuver = bestBoundariesBeforeReset.getSpeedWithBearingAfter();
            maneuverTimePoint = ((ManeuverMainCurveDetailsWithBearingSteps)bestBoundariesBeforeReset).getTimePoint();
            maxCourseChangeInDegrees = bestBoundariesBeforeReset.getDirectionChangeInDegrees();
            maxTurningRateInDegreesPerSecond = ((ManeuverMainCurveDetailsWithBearingSteps)bestBoundariesBeforeReset).getMaxTurningRateInDegreesPerSecond();
            lowestSpeed = bestBoundariesBeforeReset.getLowestSpeed();
            highestSpeed = bestBoundariesBeforeReset.getHighestSpeed();
        }
        if (refinedTimePointBeforeManeuver == null) {
            return null;
        }
        if (refinedSpeedWithBearingAfterManeuver == null) {
            return null;
        }
        SpeedWithBearingStepsIterable maneuverMainCurveSpeedWithBearingSteps = this.getSpeedWithBearingStepsWithinTimeRange(bearingStepsToAnalyze, refinedTimePointBeforeManeuver, refinedTimePointAfterManeuver);
        ManeuverMainCurveDetailsWithBearingSteps mainCurveDetails = new ManeuverMainCurveDetailsWithBearingSteps(refinedTimePointBeforeManeuver, refinedTimePointAfterManeuver, maneuverTimePoint, refinedSpeedWithBearingBeforeManeuver, refinedSpeedWithBearingAfterManeuver, maxCourseChangeInDegrees, maxTurningRateInDegreesPerSecond, lowestSpeed, highestSpeed, maneuverMainCurveSpeedWithBearingSteps);
        return mainCurveDetails;
    }

    public SpeedWithBearingStepsIterable getSpeedWithBearingStepsWithinTimeRange(SpeedWithBearingStepsIterable bearingStepsToAnalyze, TimePoint timePointBefore, TimePoint timePointAfter) {
        ArrayList<SpeedWithBearingStep> maneuverBearingSteps = new ArrayList<SpeedWithBearingStep>();
        for (SpeedWithBearingStep entry : bearingStepsToAnalyze) {
            if (entry.getTimePoint().after(timePointAfter)) break;
            if (entry.getTimePoint().before(timePointBefore)) continue;
            if (maneuverBearingSteps.isEmpty()) {
                entry = new SpeedWithBearingStepImpl(entry.getTimePoint(), entry.getSpeedWithBearing(), 0.0, 0.0);
            }
            maneuverBearingSteps.add(entry);
        }
        return new SpeedWithBearingStepsIterable(maneuverBearingSteps);
    }
}

