/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.maneuverdetection.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.maneuverdetection.IncrementalApproximatedFixesCalculator;
import com.sap.sailing.domain.maneuverdetection.impl.ApproximatedFixesCalculatorImpl;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.impl.TimedComparator;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.shared.util.impl.ArrayListNavigableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NavigableSet;

public class IncrementalApproximatedFixesCalculatorImpl
extends ApproximatedFixesCalculatorImpl
implements IncrementalApproximatedFixesCalculator {
    private volatile FixesApproximationResult lastFixesApproximationResult = null;
    private GPSFixTrack<Competitor, GPSFixMoving> track;
    private final Duration minDurationFromLastFixToPreviousMarkPassingToReusePreviousLegFixes;

    public IncrementalApproximatedFixesCalculatorImpl(TrackedRace trackedRace, Competitor competitor) {
        super(trackedRace, competitor);
        this.track = trackedRace.getTrack(competitor);
        this.minDurationFromLastFixToPreviousMarkPassingToReusePreviousLegFixes = trackedRace.getRace().getBoatOfCompetitor(competitor).getBoatClass().getApproximateManeuverDuration().times(10.0);
    }

    @Override
    public Iterable<GPSFixMoving> approximate(TimePoint earliestStart, TimePoint latestEnd) {
        Iterable<GPSFixMoving> result;
        int alreadyApproximatedLegsCount;
        GPSFixMoving latestFix = (GPSFixMoving)this.track.getLastFixAtOrBefore(latestEnd);
        if (latestFix == null || !earliestStart.before(latestEnd)) {
            return Collections.emptyList();
        }
        FixesApproximationResult lastFixesApproximationResult = this.lastFixesApproximationResult;
        int n = alreadyApproximatedLegsCount = lastFixesApproximationResult == null ? 0 : Util.size(lastFixesApproximationResult.getLegFixesList());
        if (alreadyApproximatedLegsCount < 2) {
            result = super.approximate(earliestStart, latestEnd);
            this.storeLastFixesApproximationResult(earliestStart, latestEnd, latestFix, result);
        } else {
            boolean recalculateFixesAtEnd;
            LegFixes legFixesToReuse;
            boolean recalculateFixesAtBeginning;
            ArrayList<LegFixes> legFixesListToReuse = new ArrayList<LegFixes>();
            ListIterator<LegFixes> existingLegFixesIterator = lastFixesApproximationResult.getLegFixesList().listIterator();
            if (!earliestStart.equals(lastFixesApproximationResult.getEarliestStart())) {
                recalculateFixesAtBeginning = true;
                GPSFixMoving earliestFix = (GPSFixMoving)this.track.getFirstFixAtOrAfter(earliestStart);
                int legNumberOfEarliestFix = earliestFix != null ? this.getLegNumberAt(earliestFix.getTimePoint()) : 0;
                existingLegFixesIterator.next();
                while (existingLegFixesIterator.hasNext()) {
                    legFixesToReuse = existingLegFixesIterator.next();
                    if (earliestFix == null || !this.checkIfLegBeginningFarEnoughFromEarliestFixToReuse(earliestFix, legNumberOfEarliestFix, legFixesToReuse)) continue;
                    existingLegFixesIterator.previous();
                    if (earliestFix.getTimePoint().equals(legFixesToReuse.getFirstApproximatedFix().getTimePoint())) {
                        recalculateFixesAtBeginning = false;
                    }
                    break;
                }
            } else {
                recalculateFixesAtBeginning = false;
            }
            if (lastFixesApproximationResult.getLatestEnd().equals(latestEnd) && latestFix.getTimePoint().equals(lastFixesApproximationResult.getLatestFix().getTimePoint())) {
                recalculateFixesAtEnd = false;
                while (existingLegFixesIterator.hasNext()) {
                    legFixesListToReuse.add(existingLegFixesIterator.next());
                }
            } else {
                recalculateFixesAtEnd = true;
                if (latestEnd != null) {
                    int legNumberOfLatestFix = this.getLegNumberAt(latestFix.getTimePoint());
                    while (existingLegFixesIterator.hasNext()) {
                        legFixesToReuse = existingLegFixesIterator.next();
                        if (!this.checkIfLegEndFarEnoughFromLatestFixToReuse(latestFix, legNumberOfLatestFix, legFixesToReuse)) break;
                        if (!existingLegFixesIterator.hasNext() && !latestFix.getTimePoint().equals(legFixesToReuse.getLastApproximatedFix().getTimePoint())) continue;
                        legFixesListToReuse.add(legFixesToReuse);
                        if (existingLegFixesIterator.hasNext()) continue;
                        recalculateFixesAtEnd = false;
                        break;
                    }
                }
            }
            if (legFixesListToReuse.isEmpty()) {
                result = super.approximate(earliestStart, latestEnd);
                this.storeLastFixesApproximationResult(earliestStart, latestEnd, latestFix, result);
            } else {
                LegFixes lastReusedLegFixes;
                Iterable<GPSFixMoving> newApproximatedFixesAfter;
                Iterator<GPSFixMoving> newApproximatedFixesAfterIterator;
                LegFixes firstLegFixesToReuse;
                Object newApproximatedFixesBefore;
                Iterator newApproximatedFixesBeforeIterator;
                ArrayList<GPSFixMoving> resultList = new ArrayList<GPSFixMoving>();
                result = resultList;
                if (recalculateFixesAtBeginning && (newApproximatedFixesBeforeIterator = (newApproximatedFixesBefore = super.approximate(earliestStart, this.getTimePointToEndTheCalculation(firstLegFixesToReuse = (LegFixes)legFixesListToReuse.get(0), lastFixesApproximationResult))).iterator()).hasNext()) {
                    this.storeNewFixesBeforeExistingFixes((Iterable<GPSFixMoving>)newApproximatedFixesBefore, earliestStart);
                    TimePoint timePointOfFirstFixToReuse = firstLegFixesToReuse.getFirstApproximatedFix().getTimePoint();
                    while (newApproximatedFixesBeforeIterator.hasNext()) {
                        GPSFixMoving fix = (GPSFixMoving)newApproximatedFixesBeforeIterator.next();
                        if (!fix.getTimePoint().before(timePointOfFirstFixToReuse)) break;
                        resultList.add(fix);
                    }
                }
                for (LegFixes legFixes : legFixesListToReuse) {
                    Util.addAll(legFixes.getApproximatedFixes(), resultList);
                }
                if (recalculateFixesAtEnd && (newApproximatedFixesAfterIterator = (newApproximatedFixesAfter = super.approximate(this.getTimePointToStartTheCalculationFrom(lastReusedLegFixes = (LegFixes)legFixesListToReuse.get(legFixesListToReuse.size() - 1), lastFixesApproximationResult), latestEnd)).iterator()).hasNext()) {
                    this.storeNewFixesAfterExistingFixes(newApproximatedFixesAfter, latestFix, latestEnd);
                    TimePoint timePointOfLatestFixToReuse = lastReusedLegFixes.getLastApproximatedFix().getTimePoint();
                    while (newApproximatedFixesAfterIterator.hasNext()) {
                        GPSFixMoving gpsFixMoving = newApproximatedFixesAfterIterator.next();
                        if (!gpsFixMoving.getTimePoint().after(timePointOfLatestFixToReuse)) continue;
                        resultList.add(gpsFixMoving);
                    }
                }
            }
        }
        return result;
    }

    private TimePoint getTimePointToStartTheCalculationFrom(LegFixes reusedLastLegFixes, FixesApproximationResult lastFixesApproximationResult) {
        Duration durationFromMarkPassingTillNextExistingFix;
        Duration durationFromLastFixOfReusedLegToMarkPassing;
        TimePoint timePointOfNextMarkPassing;
        LegFixes nextExistingLeg = this.getExistingLegFixesByLegNumber(reusedLastLegFixes.getLegNumber() + 1, lastFixesApproximationResult);
        TimePoint result = reusedLastLegFixes.getLastApproximatedFix().getTimePoint();
        if (nextExistingLeg != null && !nextExistingLeg.getFirstApproximatedFix().equals(nextExistingLeg.getLastApproximatedFix()) && (timePointOfNextMarkPassing = reusedLastLegFixes.getTimePointOfNextMarkPassing()) != null && (durationFromLastFixOfReusedLegToMarkPassing = reusedLastLegFixes.getLastApproximatedFix().getTimePoint().until(timePointOfNextMarkPassing)).compareTo((Object)(durationFromMarkPassingTillNextExistingFix = timePointOfNextMarkPassing.until(nextExistingLeg.getFirstApproximatedFix().getTimePoint()))) > 0) {
            result = nextExistingLeg.getFirstApproximatedFix().getTimePoint();
        }
        return result;
    }

    private TimePoint getTimePointToEndTheCalculation(LegFixes reusedFirstLegFixes, FixesApproximationResult lastFixesApproximationResult) {
        Duration durationFromPreviousExistingFixToMarkPassing;
        Duration durationFromMarkPassingToFirstFixOfReusedLeg;
        TimePoint timePointOfPreviousMarkPassing;
        LegFixes previousExistingLeg = this.getExistingLegFixesByLegNumber(reusedFirstLegFixes.getLegNumber() - 1, lastFixesApproximationResult);
        TimePoint result = reusedFirstLegFixes.getLastApproximatedFix().getTimePoint();
        if (previousExistingLeg != null && !previousExistingLeg.getFirstApproximatedFix().equals(previousExistingLeg.getLastApproximatedFix()) && (timePointOfPreviousMarkPassing = previousExistingLeg.getTimePointOfNextMarkPassing()) != null && (durationFromMarkPassingToFirstFixOfReusedLeg = timePointOfPreviousMarkPassing.until(reusedFirstLegFixes.getFirstApproximatedFix().getTimePoint())).compareTo((Object)(durationFromPreviousExistingFixToMarkPassing = previousExistingLeg.getLastApproximatedFix().getTimePoint().until(timePointOfPreviousMarkPassing))) > 0) {
            result = previousExistingLeg.getLastApproximatedFix().getTimePoint();
        }
        return result;
    }

    private LegFixes getExistingLegFixesByLegNumber(int legNumber, FixesApproximationResult lastFixesApproximationResult) {
        LegFixes matchedLegFixes = null;
        for (LegFixes legFixes : lastFixesApproximationResult.getLegFixesList()) {
            if (legFixes.getLegNumber() != legNumber) continue;
            matchedLegFixes = legFixes;
            break;
        }
        return matchedLegFixes;
    }

    private boolean checkIfLegEndFarEnoughFromLatestFixToReuse(GPSFixMoving latestFix, int legNumberOfLatestFix, LegFixes legFixesToReuse) {
        GPSFixMoving lastExistingFixOfLeg = legFixesToReuse.getLastApproximatedFix();
        return latestFix.getTimePoint().equals(lastExistingFixOfLeg.getTimePoint()) || latestFix.getTimePoint().asMillis() - lastExistingFixOfLeg.getTimePoint().asMillis() > this.minDurationFromLastFixToPreviousMarkPassingToReusePreviousLegFixes.asMillis() && legFixesToReuse.getLegNumber() < legNumberOfLatestFix;
    }

    private boolean checkIfLegBeginningFarEnoughFromEarliestFixToReuse(GPSFixMoving earliestFix, int legNumberOfEarliestFix, LegFixes legFixesToReuse) {
        GPSFixMoving firstExistingFixOfLeg = legFixesToReuse.getFirstApproximatedFix();
        return earliestFix.getTimePoint().equals(firstExistingFixOfLeg.getTimePoint()) || firstExistingFixOfLeg.getTimePoint().asMillis() - earliestFix.getTimePoint().asMillis() > this.minDurationFromLastFixToPreviousMarkPassingToReusePreviousLegFixes.asMillis() && legFixesToReuse.getLegNumber() > legNumberOfEarliestFix;
    }

    private void storeNewFixesAfterExistingFixes(Iterable<GPSFixMoving> newApproximatedFixesAfter, GPSFixMoving latestFix, TimePoint latestEnd) {
        FixesApproximationResult lastFixesApproximationResult = this.lastFixesApproximationResult;
        if (lastFixesApproximationResult != null) {
            List<LegFixes> newLegFixesListAfter;
            GPSFixMoving lastFix;
            List<LegFixes> existingLegFixesList = lastFixesApproximationResult.getLegFixesList();
            LegFixes lastExistingLegFixes = existingLegFixesList.get(existingLegFixesList.size() - 1);
            Iterator<GPSFixMoving> newFixesIterator = newApproximatedFixesAfter.iterator();
            do {
                lastFix = newFixesIterator.next();
            } while (newFixesIterator.hasNext());
            if (lastExistingLegFixes.getLastApproximatedFix().getTimePoint().before(lastFix.getTimePoint()) && !(newLegFixesListAfter = this.groupApproximatedFixesToLegFixes(newApproximatedFixesAfter)).isEmpty()) {
                TimePoint timePointOfFirstNewFix = newLegFixesListAfter.get(0).getFirstApproximatedFix().getTimePoint();
                ArrayList<LegFixes> newExistingLegFixesList = new ArrayList<LegFixes>();
                for (LegFixes legFixes : existingLegFixesList) {
                    if (legFixes.getLastApproximatedFix().getTimePoint().after(timePointOfFirstNewFix)) break;
                    newExistingLegFixesList.add(legFixes);
                }
                if (!newExistingLegFixesList.isEmpty()) {
                    TimePoint timePointOfLastReusedFix = ((LegFixes)newExistingLegFixesList.get(newExistingLegFixesList.size() - 1)).getLastApproximatedFix().getTimePoint();
                    for (LegFixes legFixes : newLegFixesListAfter) {
                        if (!legFixes.getFirstApproximatedFix().getTimePoint().after(timePointOfLastReusedFix)) continue;
                        newExistingLegFixesList.add(legFixes);
                    }
                    this.lastFixesApproximationResult = new FixesApproximationResult(lastFixesApproximationResult.getEarliestStart(), latestEnd, latestFix, newExistingLegFixesList);
                }
            }
        }
    }

    private void storeNewFixesBeforeExistingFixes(Iterable<GPSFixMoving> newApproximatedFixesBefore, TimePoint earliestStart) {
        FixesApproximationResult lastFixesApproximationResult = this.lastFixesApproximationResult;
        if (lastFixesApproximationResult != null) {
            List<LegFixes> newLegFixesListBefore;
            List<LegFixes> existingLegFixesList = lastFixesApproximationResult.getLegFixesList();
            LegFixes firstExistingLegFixes = existingLegFixesList.get(0);
            GPSFixMoving firstNewFix = newApproximatedFixesBefore.iterator().next();
            if (firstExistingLegFixes.getFirstApproximatedFix().getTimePoint().after(firstNewFix.getTimePoint()) && !(newLegFixesListBefore = this.groupApproximatedFixesToLegFixes(newApproximatedFixesBefore)).isEmpty()) {
                ArrayList<LegFixes> newExistingLegFixesList = new ArrayList<LegFixes>();
                TimePoint timePointOfLastNewFix = newLegFixesListBefore.get(newLegFixesListBefore.size() - 1).getLastApproximatedFix().getTimePoint();
                for (LegFixes legFixes : existingLegFixesList) {
                    if (legFixes.getFirstApproximatedFix().getTimePoint().before(timePointOfLastNewFix)) continue;
                    newExistingLegFixesList.add(legFixes);
                }
                if (!newExistingLegFixesList.isEmpty()) {
                    TimePoint timePointOfFirstReusedFix = ((LegFixes)newExistingLegFixesList.get(0)).getFirstApproximatedFix().getTimePoint();
                    ArrayList<LegFixes> extendedExistingNewLegFixesList = new ArrayList<LegFixes>();
                    for (LegFixes legFixes : newLegFixesListBefore) {
                        if (!legFixes.getLastApproximatedFix().getTimePoint().before(timePointOfFirstReusedFix)) break;
                        extendedExistingNewLegFixesList.add(legFixes);
                    }
                    extendedExistingNewLegFixesList.addAll(newExistingLegFixesList);
                    this.lastFixesApproximationResult = new FixesApproximationResult(earliestStart, lastFixesApproximationResult.getLatestEnd(), lastFixesApproximationResult.getLatestFix(), extendedExistingNewLegFixesList);
                }
            }
        }
    }

    private void storeLastFixesApproximationResult(TimePoint earliestStart, TimePoint latestEnd, GPSFixMoving latestFix, Iterable<GPSFixMoving> approximatedFixes) {
        FixesApproximationResult lastFixesApproximationResult = this.lastFixesApproximationResult;
        List<LegFixes> legFixesList = this.groupApproximatedFixesToLegFixes(approximatedFixes);
        if (!(legFixesList.isEmpty() || lastFixesApproximationResult != null && legFixesList.size() < lastFixesApproximationResult.getLegFixesList().size())) {
            this.lastFixesApproximationResult = new FixesApproximationResult(earliestStart, latestEnd, latestFix, legFixesList);
        }
    }

    private List<LegFixes> groupApproximatedFixesToLegFixes(Iterable<GPSFixMoving> approximatedFixes) {
        ArrayList<LegFixes> result = new ArrayList<LegFixes>();
        Iterator<GPSFixMoving> approximatedFixesIterator = approximatedFixes == null ? null : approximatedFixes.iterator();
        NavigableSet<MarkPassing> roundings = this.trackedRace.getMarkPassings(this.competitor);
        if (approximatedFixesIterator != null && approximatedFixesIterator.hasNext()) {
            if (roundings != null) {
                ArrayListNavigableSet localRoundings = null;
                this.trackedRace.lockForRead(roundings);
                try {
                    localRoundings = new ArrayListNavigableSet(roundings.size(), (Comparator)new TimedComparator());
                    localRoundings.addAll(roundings);
                }
                finally {
                    this.trackedRace.unlockAfterRead(roundings);
                }
                int legNumber = 0;
                ArrayList<Object> legFixes = new ArrayList<GPSFixMoving>();
                GPSFixMoving approximatedFix = approximatedFixesIterator.next();
                for (MarkPassing rounding : localRoundings) {
                    while (approximatedFix.getTimePoint().before(rounding.getTimePoint())) {
                        legFixes.add(approximatedFix);
                        approximatedFix = approximatedFixesIterator.hasNext() ? approximatedFixesIterator.next() : null;
                        if (approximatedFix != null) continue;
                    }
                    if (!legFixes.isEmpty()) {
                        result.add(new LegFixes(legNumber, rounding.getTimePoint(), legFixes));
                    }
                    ++legNumber;
                    legFixes = new ArrayList();
                    if (!approximatedFixesIterator.hasNext()) break;
                }
                while (approximatedFix != null) {
                    legFixes.add(approximatedFix);
                    GPSFixMoving gPSFixMoving = approximatedFix = approximatedFixesIterator.hasNext() ? approximatedFixesIterator.next() : null;
                }
                if (!legFixes.isEmpty()) {
                    result.add(new LegFixes(legNumber, null, legFixes));
                }
            } else {
                result.add(new LegFixes(0, null, approximatedFixes));
            }
        }
        return result;
    }

    private int getLegNumberAt(TimePoint timePoint) {
        int legNumber = 0;
        NavigableSet<MarkPassing> roundings = this.trackedRace.getMarkPassings(this.competitor);
        if (roundings != null) {
            ArrayListNavigableSet localRoundings = null;
            this.trackedRace.lockForRead(roundings);
            try {
                localRoundings = new ArrayListNavigableSet(roundings.size(), (Comparator)new TimedComparator());
                localRoundings.addAll(roundings);
            }
            finally {
                this.trackedRace.unlockAfterRead(roundings);
            }
            for (MarkPassing rounding : localRoundings) {
                if (!rounding.getTimePoint().before(timePoint)) break;
                ++legNumber;
            }
        }
        return legNumber;
    }

    @Override
    public void clearState() {
        this.lastFixesApproximationResult = null;
    }

    public static class FixesApproximationResult {
        private final TimePoint earliestStart;
        private final TimePoint latestEnd;
        private final GPSFixMoving latestFix;
        private final List<LegFixes> legFixesList;

        public FixesApproximationResult(TimePoint earliestStart, TimePoint latestEnd, GPSFixMoving latestFix, List<LegFixes> legFixesList) {
            this.earliestStart = earliestStart;
            this.latestEnd = latestEnd;
            this.latestFix = latestFix;
            this.legFixesList = legFixesList;
        }

        public TimePoint getEarliestStart() {
            return this.earliestStart;
        }

        public TimePoint getLatestEnd() {
            return this.latestEnd;
        }

        public GPSFixMoving getLatestFix() {
            return this.latestFix;
        }

        public List<LegFixes> getLegFixesList() {
            return this.legFixesList;
        }
    }

    public static class LegFixes {
        private final int legNumber;
        private final Iterable<GPSFixMoving> approximatedFixes;
        private final GPSFixMoving firstApproximatedFix;
        private final GPSFixMoving lastApproximatedFix;
        private final TimePoint timePointOfNextMarkPassing;

        public LegFixes(int legNumber, TimePoint timePointOfNextMarkPassing, Iterable<GPSFixMoving> approximatedFixes) {
            GPSFixMoving lastFix;
            this.legNumber = legNumber;
            this.approximatedFixes = approximatedFixes;
            this.timePointOfNextMarkPassing = timePointOfNextMarkPassing;
            Iterator<GPSFixMoving> iterator = approximatedFixes.iterator();
            this.firstApproximatedFix = lastFix = iterator.next();
            while (iterator.hasNext()) {
                lastFix = iterator.next();
            }
            this.lastApproximatedFix = lastFix;
        }

        public int getLegNumber() {
            return this.legNumber;
        }

        public Iterable<GPSFixMoving> getApproximatedFixes() {
            return this.approximatedFixes;
        }

        public GPSFixMoving getFirstApproximatedFix() {
            return this.firstApproximatedFix;
        }

        public GPSFixMoving getLastApproximatedFix() {
            return this.lastApproximatedFix;
        }

        public TimePoint getTimePointOfNextMarkPassing() {
            return this.timePointOfNextMarkPassing;
        }
    }
}

