/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.NumberOfCompetitorsInLeaderboardFetcher;
import com.sap.sailing.domain.leaderboard.impl.LowPoint;
import com.sap.sse.common.TimePoint;
import java.util.function.Supplier;

public class LowPointWithAutomaticRDG
extends LowPoint {
    private static final long serialVersionUID = -6609749761795712461L;

    @Override
    public Double getPenaltyScore(RaceColumn raceColumn, Competitor competitor, MaxPointsReason maxPointsReason, Integer numberOfCompetitorsInRace, NumberOfCompetitorsInLeaderboardFetcher numberOfCompetitorsInLeaderboardFetcher, TimePoint timePoint, Leaderboard leaderboard, Supplier<Double> uncorrectedScoreProvider) {
        Double result;
        if (maxPointsReason == MaxPointsReason.RDG || maxPointsReason == MaxPointsReason.SCA) {
            double scoreSum = 0.0;
            int numberOfScores = 0;
            for (RaceColumn rc : leaderboard.getRaceColumns()) {
                Double totalPointsInRC;
                if (rc == raceColumn && maxPointsReason == MaxPointsReason.SCA) break;
                if (rc == raceColumn || leaderboard.getMaxPointsReason(competitor, rc, timePoint) == MaxPointsReason.RDG || leaderboard.getMaxPointsReason(competitor, rc, timePoint) == MaxPointsReason.SCA || (totalPointsInRC = leaderboard.getTotalPoints(competitor, rc, timePoint)) == null) continue;
                scoreSum += totalPointsInRC.doubleValue();
                ++numberOfScores;
            }
            result = numberOfScores == 0 ? null : Double.valueOf(scoreSum / (double)numberOfScores);
        } else {
            result = super.getPenaltyScore(raceColumn, competitor, maxPointsReason, numberOfCompetitorsInRace, numberOfCompetitorsInLeaderboardFetcher, timePoint, leaderboard, uncorrectedScoreProvider);
        }
        return result;
    }

    @Override
    public ScoringSchemeType getType() {
        return ScoringSchemeType.LOW_POINT_WITH_AUTOMATIC_RDG;
    }
}

