/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.NumberOfCompetitorsInLeaderboardFetcher;
import com.sap.sailing.domain.leaderboard.impl.HighPoint;
import com.sap.sse.common.TimePoint;
import java.util.concurrent.Callable;

public abstract class HighPointFirstGetsFixedScore
extends HighPoint {
    private static final long serialVersionUID = -2767385186133743330L;
    private final double scoreForRaceWinner;
    private final double minimumScoreFromRank;

    public HighPointFirstGetsFixedScore(double scoreForRaceWinner) {
        this(scoreForRaceWinner, 1.0);
    }

    protected HighPointFirstGetsFixedScore(double scoreForRaceWinner, double minimumScoreFromRank) {
        this.scoreForRaceWinner = scoreForRaceWinner;
        this.minimumScoreFromRank = minimumScoreFromRank;
    }

    double getScoreForRaceWinner() {
        return this.scoreForRaceWinner;
    }

    double getMinimumScoreFromRank() {
        return this.minimumScoreFromRank;
    }

    @Override
    public Double getScoreForRank(Leaderboard leaderboard, RaceColumn raceColumn, Competitor competitor, int rank, Callable<Integer> numberOfCompetitorsInRaceFetcher, NumberOfCompetitorsInLeaderboardFetcher numberOfCompetitorsInLeaderboardFetcher, TimePoint timePoint) {
        int effectiveRank = this.getEffectiveRank(raceColumn, competitor, rank);
        Double result = effectiveRank == 0 ? null : Double.valueOf(Math.max(this.getMinimumScoreFromRank(), this.getScoreForRaceWinner() - (double)effectiveRank + 1.0));
        return result;
    }

    protected int getEffectiveRank(RaceColumn raceColumn, Competitor competitor, int rank) {
        int effectiveRank;
        if (rank == 0) {
            effectiveRank = 0;
        } else {
            int competitorFleetOrdering;
            Fleet fleetOfCompetitor = raceColumn.getFleetOfCompetitor(competitor);
            if (fleetOfCompetitor != null && raceColumn.hasSplitFleetContiguousScoring() && (competitorFleetOrdering = fleetOfCompetitor.getOrdering()) != 0) {
                int numberOfCompetitorsInBetterFleets = this.getNumberOfCompetitorsInBetterFleets(raceColumn, competitorFleetOrdering);
                effectiveRank = rank + numberOfCompetitorsInBetterFleets;
            } else {
                effectiveRank = rank;
            }
        }
        return effectiveRank;
    }
}

