/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.NumberOfCompetitorsInLeaderboardFetcher;
import com.sap.sailing.domain.leaderboard.ScoringScheme;
import com.sap.sailing.domain.leaderboard.caching.LeaderboardDTOCalculationReuseCache;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sse.common.TimePoint;
import java.io.Serializable;
import java.util.concurrent.Callable;

public interface ScoreCorrection
extends Serializable {
    default public Result getCorrectedScore(Callable<Integer> trackedRankProvider, Competitor competitor, RaceColumn raceColumn, Leaderboard leaderboard, TimePoint timePoint, NumberOfCompetitorsInLeaderboardFetcher numberOfCompetitorsFetcher, ScoringScheme scoringScheme) {
        return this.getCorrectedScore(trackedRankProvider, competitor, raceColumn, leaderboard, timePoint, numberOfCompetitorsFetcher, scoringScheme, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    public Result getCorrectedScore(Callable<Integer> var1, Competitor var2, RaceColumn var3, Leaderboard var4, TimePoint var5, NumberOfCompetitorsInLeaderboardFetcher var6, ScoringScheme var7, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var8);

    public MaxPointsReason getMaxPointsReason(Competitor var1, RaceColumn var2, TimePoint var3);

    public boolean isScoreCorrected(Competitor var1, RaceColumn var2, TimePoint var3);

    public boolean isScoreCorrectedIncrementally(Competitor var1, RaceColumn var2, TimePoint var3);

    public Double getIncementalScoreCorrectionInPoints(Competitor var1, RaceColumn var2);

    public boolean hasCorrectionFor(RaceColumn var1);

    public boolean hasCorrectionForNonTrackedFleet(RaceColumn var1);

    public Iterable<RaceColumn> getRaceColumnsThatHaveCorrections();

    public Iterable<Competitor> getCompetitorsThatHaveCorrectionsIn(RaceColumn var1);

    public TimePoint getTimePointOfLastCorrectionsValidity();

    public String getComment();

    public static interface Result {
        public Double getCorrectedScore();

        public Double getUncorrectedScore();

        public MaxPointsReason getMaxPointsReason();

        public Double getIncrementalScoreCorrectionInPoints();

        public boolean isCorrected();

        public boolean isCorrectedIncrementally();

        public TimePoint getTimePoint();
    }
}

